/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.layers.recurrent.config;

import java.util.LinkedHashMap;
import java.util.Map;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.linalg.util.ArrayUtil;

public class LSTMBlockCellConfiguration {
    private boolean peepHole;
    private double forgetBias;
    private double clippingCellValue;
    private SDVariable xt;
    private SDVariable cLast;
    private SDVariable yLast;
    private SDVariable W;
    private SDVariable Wci;
    private SDVariable Wcf;
    private SDVariable Wco;
    private SDVariable b;

    public Map<String, Object> toProperties() {
        LinkedHashMap<String, Object> ret = new LinkedHashMap<String, Object>();
        ret.put("peepHole", this.peepHole);
        ret.put("clippingCellValue", this.clippingCellValue);
        ret.put("forgetBias", this.forgetBias);
        return ret;
    }

    public SDVariable[] args() {
        return new SDVariable[]{this.xt, this.cLast, this.yLast, this.W, this.Wci, this.Wcf, this.Wco, this.b};
    }

    public int[] iArgs() {
        return new int[]{ArrayUtil.fromBoolean((boolean)this.peepHole)};
    }

    public double[] tArgs() {
        return new double[]{this.forgetBias, this.clippingCellValue};
    }

    LSTMBlockCellConfiguration(boolean peepHole, double forgetBias, double clippingCellValue, SDVariable xt, SDVariable cLast, SDVariable yLast, SDVariable W, SDVariable Wci, SDVariable Wcf, SDVariable Wco, SDVariable b) {
        this.peepHole = peepHole;
        this.forgetBias = forgetBias;
        this.clippingCellValue = clippingCellValue;
        this.xt = xt;
        this.cLast = cLast;
        this.yLast = yLast;
        this.W = W;
        this.Wci = Wci;
        this.Wcf = Wcf;
        this.Wco = Wco;
        this.b = b;
    }

    public static LSTMBlockCellConfigurationBuilder builder() {
        return new LSTMBlockCellConfigurationBuilder();
    }

    public boolean isPeepHole() {
        return this.peepHole;
    }

    public double getForgetBias() {
        return this.forgetBias;
    }

    public double getClippingCellValue() {
        return this.clippingCellValue;
    }

    public SDVariable getXt() {
        return this.xt;
    }

    public SDVariable getCLast() {
        return this.cLast;
    }

    public SDVariable getYLast() {
        return this.yLast;
    }

    public SDVariable getW() {
        return this.W;
    }

    public SDVariable getWci() {
        return this.Wci;
    }

    public SDVariable getWcf() {
        return this.Wcf;
    }

    public SDVariable getWco() {
        return this.Wco;
    }

    public SDVariable getB() {
        return this.b;
    }

    public void setPeepHole(boolean peepHole) {
        this.peepHole = peepHole;
    }

    public void setForgetBias(double forgetBias) {
        this.forgetBias = forgetBias;
    }

    public void setClippingCellValue(double clippingCellValue) {
        this.clippingCellValue = clippingCellValue;
    }

    public void setXt(SDVariable xt) {
        this.xt = xt;
    }

    public void setCLast(SDVariable cLast) {
        this.cLast = cLast;
    }

    public void setYLast(SDVariable yLast) {
        this.yLast = yLast;
    }

    public void setW(SDVariable W) {
        this.W = W;
    }

    public void setWci(SDVariable Wci) {
        this.Wci = Wci;
    }

    public void setWcf(SDVariable Wcf) {
        this.Wcf = Wcf;
    }

    public void setWco(SDVariable Wco) {
        this.Wco = Wco;
    }

    public void setB(SDVariable b) {
        this.b = b;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LSTMBlockCellConfiguration)) {
            return false;
        }
        LSTMBlockCellConfiguration other = (LSTMBlockCellConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isPeepHole() != other.isPeepHole()) {
            return false;
        }
        if (Double.compare(this.getForgetBias(), other.getForgetBias()) != 0) {
            return false;
        }
        if (Double.compare(this.getClippingCellValue(), other.getClippingCellValue()) != 0) {
            return false;
        }
        SDVariable this$xt = this.getXt();
        SDVariable other$xt = other.getXt();
        if (this$xt == null ? other$xt != null : !((Object)this$xt).equals(other$xt)) {
            return false;
        }
        SDVariable this$cLast = this.getCLast();
        SDVariable other$cLast = other.getCLast();
        if (this$cLast == null ? other$cLast != null : !((Object)this$cLast).equals(other$cLast)) {
            return false;
        }
        SDVariable this$yLast = this.getYLast();
        SDVariable other$yLast = other.getYLast();
        if (this$yLast == null ? other$yLast != null : !((Object)this$yLast).equals(other$yLast)) {
            return false;
        }
        SDVariable this$W = this.getW();
        SDVariable other$W = other.getW();
        if (this$W == null ? other$W != null : !((Object)this$W).equals(other$W)) {
            return false;
        }
        SDVariable this$Wci = this.getWci();
        SDVariable other$Wci = other.getWci();
        if (this$Wci == null ? other$Wci != null : !((Object)this$Wci).equals(other$Wci)) {
            return false;
        }
        SDVariable this$Wcf = this.getWcf();
        SDVariable other$Wcf = other.getWcf();
        if (this$Wcf == null ? other$Wcf != null : !((Object)this$Wcf).equals(other$Wcf)) {
            return false;
        }
        SDVariable this$Wco = this.getWco();
        SDVariable other$Wco = other.getWco();
        if (this$Wco == null ? other$Wco != null : !((Object)this$Wco).equals(other$Wco)) {
            return false;
        }
        SDVariable this$b = this.getB();
        SDVariable other$b = other.getB();
        return !(this$b == null ? other$b != null : !((Object)this$b).equals(other$b));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LSTMBlockCellConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isPeepHole() ? 79 : 97);
        long $forgetBias = Double.doubleToLongBits(this.getForgetBias());
        result = result * 59 + (int)($forgetBias >>> 32 ^ $forgetBias);
        long $clippingCellValue = Double.doubleToLongBits(this.getClippingCellValue());
        result = result * 59 + (int)($clippingCellValue >>> 32 ^ $clippingCellValue);
        SDVariable $xt = this.getXt();
        result = result * 59 + ($xt == null ? 43 : ((Object)$xt).hashCode());
        SDVariable $cLast = this.getCLast();
        result = result * 59 + ($cLast == null ? 43 : ((Object)$cLast).hashCode());
        SDVariable $yLast = this.getYLast();
        result = result * 59 + ($yLast == null ? 43 : ((Object)$yLast).hashCode());
        SDVariable $W = this.getW();
        result = result * 59 + ($W == null ? 43 : ((Object)$W).hashCode());
        SDVariable $Wci = this.getWci();
        result = result * 59 + ($Wci == null ? 43 : ((Object)$Wci).hashCode());
        SDVariable $Wcf = this.getWcf();
        result = result * 59 + ($Wcf == null ? 43 : ((Object)$Wcf).hashCode());
        SDVariable $Wco = this.getWco();
        result = result * 59 + ($Wco == null ? 43 : ((Object)$Wco).hashCode());
        SDVariable $b = this.getB();
        result = result * 59 + ($b == null ? 43 : ((Object)$b).hashCode());
        return result;
    }

    public String toString() {
        return "LSTMBlockCellConfiguration(peepHole=" + this.isPeepHole() + ", forgetBias=" + this.getForgetBias() + ", clippingCellValue=" + this.getClippingCellValue() + ", xt=" + this.getXt() + ", cLast=" + this.getCLast() + ", yLast=" + this.getYLast() + ", W=" + this.getW() + ", Wci=" + this.getWci() + ", Wcf=" + this.getWcf() + ", Wco=" + this.getWco() + ", b=" + this.getB() + ")";
    }

    public static class LSTMBlockCellConfigurationBuilder {
        private boolean peepHole;
        private double forgetBias;
        private double clippingCellValue;
        private SDVariable xt;
        private SDVariable cLast;
        private SDVariable yLast;
        private SDVariable W;
        private SDVariable Wci;
        private SDVariable Wcf;
        private SDVariable Wco;
        private SDVariable b;

        LSTMBlockCellConfigurationBuilder() {
        }

        public LSTMBlockCellConfigurationBuilder peepHole(boolean peepHole) {
            this.peepHole = peepHole;
            return this;
        }

        public LSTMBlockCellConfigurationBuilder forgetBias(double forgetBias) {
            this.forgetBias = forgetBias;
            return this;
        }

        public LSTMBlockCellConfigurationBuilder clippingCellValue(double clippingCellValue) {
            this.clippingCellValue = clippingCellValue;
            return this;
        }

        public LSTMBlockCellConfigurationBuilder xt(SDVariable xt) {
            this.xt = xt;
            return this;
        }

        public LSTMBlockCellConfigurationBuilder cLast(SDVariable cLast) {
            this.cLast = cLast;
            return this;
        }

        public LSTMBlockCellConfigurationBuilder yLast(SDVariable yLast) {
            this.yLast = yLast;
            return this;
        }

        public LSTMBlockCellConfigurationBuilder W(SDVariable W) {
            this.W = W;
            return this;
        }

        public LSTMBlockCellConfigurationBuilder Wci(SDVariable Wci) {
            this.Wci = Wci;
            return this;
        }

        public LSTMBlockCellConfigurationBuilder Wcf(SDVariable Wcf) {
            this.Wcf = Wcf;
            return this;
        }

        public LSTMBlockCellConfigurationBuilder Wco(SDVariable Wco) {
            this.Wco = Wco;
            return this;
        }

        public LSTMBlockCellConfigurationBuilder b(SDVariable b) {
            this.b = b;
            return this;
        }

        public LSTMBlockCellConfiguration build() {
            return new LSTMBlockCellConfiguration(this.peepHole, this.forgetBias, this.clippingCellValue, this.xt, this.cLast, this.yLast, this.W, this.Wci, this.Wcf, this.Wco, this.b);
        }

        public String toString() {
            return "LSTMBlockCellConfiguration.LSTMBlockCellConfigurationBuilder(peepHole=" + this.peepHole + ", forgetBias=" + this.forgetBias + ", clippingCellValue=" + this.clippingCellValue + ", xt=" + this.xt + ", cLast=" + this.cLast + ", yLast=" + this.yLast + ", W=" + this.W + ", Wci=" + this.Wci + ", Wcf=" + this.Wcf + ", Wco=" + this.Wco + ", b=" + this.b + ")";
        }
    }
}

