/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops;

import com.google.common.primitives.Ints;
import java.util.List;
import java.util.Map;
import onnx.OnnxProto3;
import org.nd4j.autodiff.functions.DifferentialFunction;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.imports.graphmapper.onnx.OnnxGraphMapper;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseOp;
import org.nd4j.linalg.api.ops.ReduceOp;
import org.nd4j.linalg.api.shape.LongShapeDescriptor;
import org.nd4j.linalg.api.shape.Shape;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tensorflow.framework.AttrValue;
import org.tensorflow.framework.GraphDef;
import org.tensorflow.framework.NodeDef;

public abstract class BaseReduceOp
extends BaseOp
implements ReduceOp {
    private static final Logger log = LoggerFactory.getLogger(BaseReduceOp.class);
    protected boolean keepDims = false;
    protected boolean isComplex = false;

    public BaseReduceOp(SameDiff sameDiff, SDVariable i_v, int[] dimensions, boolean keepDims) {
        super(sameDiff, new Object[]{dimensions});
        if (i_v != null) {
            if (dimensions == null || dimensions.length < 1) {
                dimensions = new int[]{Integer.MAX_VALUE};
            }
            this.dimensions = dimensions;
            this.f().validateDifferentialFunctionsameDiff(i_v);
            this.keepDims = keepDims;
            this.xVertexId = i_v.getVarName();
            sameDiff.addArgsFor(new String[]{this.xVertexId}, (DifferentialFunction)this);
            if (Shape.isPlaceholderShape(i_v.getShape())) {
                sameDiff.addPropertyToResolve(this, i_v.getVarName());
            }
        } else {
            throw new IllegalArgumentException("Input not null variable.");
        }
        this.defineDimensions(dimensions);
    }

    public BaseReduceOp(SameDiff sameDiff, SDVariable i_v, SDVariable i_v2, int[] dimensions, boolean keepDims) {
        super(sameDiff, new Object[]{dimensions});
        if (i_v != null) {
            if (dimensions == null || dimensions.length < 1) {
                dimensions = new int[]{Integer.MAX_VALUE};
            }
        } else {
            throw new IllegalArgumentException("Input not null variable.");
        }
        this.dimensions = dimensions;
        this.xVertexId = i_v.getVarName();
        this.yVertexId = i_v2.getVarName();
        this.f().validateDifferentialFunctionsameDiff(i_v);
        this.f().validateDifferentialFunctionsameDiff(i_v2);
        this.keepDims = keepDims;
        sameDiff.addArgsFor(new String[]{this.xVertexId, this.yVertexId}, (DifferentialFunction)this);
        this.defineDimensions(dimensions);
    }

    public BaseReduceOp(SameDiff sameDiff, SDVariable i_v) {
        this(sameDiff, i_v, null, false);
    }

    public BaseReduceOp(SameDiff sameDiff, SDVariable i_v, int[] dimensions) {
        this(sameDiff, i_v, dimensions, false);
    }

    public BaseReduceOp(SameDiff sameDiff, SDVariable i_v, SDVariable i_v2, int[] dimensions) {
        this(sameDiff, i_v, i_v2, dimensions, false);
    }

    public BaseReduceOp() {
    }

    public BaseReduceOp(INDArray x, INDArray y, INDArray z, boolean keepDims, int[] dimensions) {
        super(x, y, z);
        this.keepDims = keepDims;
        this.dimensions = dimensions;
        this.defineDimensions(dimensions);
    }

    public BaseReduceOp(INDArray x, int ... dimensions) {
        this(x, null, dimensions);
    }

    public BaseReduceOp(INDArray x, INDArray y, int ... dimensions) {
        this(x, y, null, dimensions);
    }

    public BaseReduceOp(INDArray x, INDArray y, INDArray z, int ... dimensions) {
        this(x, y, z, false, dimensions);
    }

    public BaseReduceOp(SameDiff sameDiff) {
        this.sameDiff = sameDiff;
    }

    @Override
    public INDArray noOp() {
        if (this.z != null && this.x != this.z) {
            return this.z().assign(this.x);
        }
        return this.x().dup(this.x().ordering());
    }

    @Override
    public boolean isKeepDims() {
        return this.keepDims;
    }

    @Override
    public abstract List<LongShapeDescriptor> calculateOutputShape();

    @Override
    public void initFromTensorFlow(NodeDef nodeDef, SameDiff initWith, Map<String, AttrValue> attributesForNode, GraphDef graph) {
        if (!attributesForNode.containsKey("axis") && !this.hasReductionIndices(nodeDef)) {
            this.dimensions = new int[]{Integer.MAX_VALUE};
        }
        if (attributesForNode.containsKey("keep_dims")) {
            boolean keepDims;
            this.keepDims = keepDims = attributesForNode.get("keep_dims").getB();
        }
        this.defineDimensions(this.dimensions);
    }

    protected boolean hasReductionIndices(NodeDef nodeDef) {
        for (int i = 0; i < nodeDef.getInputCount(); ++i) {
            if (!nodeDef.getInput(i).contains("reduction_indices")) continue;
            return true;
        }
        return false;
    }

    @Override
    public void initFromOnnx(OnnxProto3.NodeProto node, SameDiff initWith, Map<String, OnnxProto3.AttributeProto> attributesForNode, OnnxProto3.GraphProto graph) {
        if (!attributesForNode.containsKey("axes")) {
            this.dimensions = new int[]{Integer.MAX_VALUE};
        } else {
            Map<String, OnnxProto3.AttributeProto> map = OnnxGraphMapper.getInstance().getAttrMap(node);
            int[] dims = Ints.toArray(map.get("axes").getIntsList());
            this.dimensions = dims;
        }
    }

    @Override
    public boolean isComplexAccumulation() {
        return this.isComplex;
    }

    @Override
    public void setDimensions(int ... dimensions) {
        this.dimensions = dimensions;
        this.defineDimensions(dimensions);
    }

    public void setKeepDims(boolean keepDims) {
        this.keepDims = keepDims;
    }
}

