/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.imports.graphmapper;

import com.github.os72.protobuf351.Message;
import com.github.os72.protobuf351.TextFormat;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.nd4j.autodiff.functions.DifferentialFunction;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.autodiff.samediff.VariableType;
import org.nd4j.autodiff.samediff.internal.SameDiffOp;
import org.nd4j.autodiff.samediff.internal.Variable;
import org.nd4j.base.Preconditions;
import org.nd4j.imports.NoOpNameFoundException;
import org.nd4j.imports.descriptors.properties.PropertyMapping;
import org.nd4j.imports.graphmapper.GraphMapper;
import org.nd4j.imports.graphmapper.ImportState;
import org.nd4j.imports.graphmapper.OpImportFilter;
import org.nd4j.imports.graphmapper.OpImportOverride;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.exception.ND4JIllegalStateException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseGraphMapper<GRAPH_TYPE, NODE_TYPE, ATTR_TYPE, TENSOR_TYPE>
implements GraphMapper<GRAPH_TYPE, NODE_TYPE, ATTR_TYPE, TENSOR_TYPE> {
    private static final Logger log = LoggerFactory.getLogger(BaseGraphMapper.class);

    @Override
    public Op.Type opTypeForNode(NODE_TYPE nodeDef) {
        DifferentialFunction opWithTensorflowName = this.getMappedOp(this.getOpType(nodeDef));
        if (opWithTensorflowName == null) {
            throw new NoOpNameFoundException("No op found with name " + this.getOpType(nodeDef));
        }
        Op.Type type = opWithTensorflowName.opType();
        return type;
    }

    @Override
    public void mapProperties(DifferentialFunction on, NODE_TYPE node, GRAPH_TYPE graph, SameDiff sameDiff, Map<String, Map<String, PropertyMapping>> propertyMappings) {
        Map<String, PropertyMapping> mappings = propertyMappings.get(this.getOpType(node));
        if (mappings == null || mappings.isEmpty()) {
            return;
        }
        for (Map.Entry<String, PropertyMapping> entry : mappings.entrySet()) {
            this.mapProperty(entry.getKey(), on, node, graph, sameDiff, propertyMappings);
        }
    }

    @Override
    public SameDiff importGraph(InputStream inputStream) {
        return this.importGraph((GRAPH_TYPE)inputStream, (Map<String, ? extends OpImportOverride<GRAPH_TYPE, NODE_TYPE, ATTR_TYPE>>)Collections.emptyMap(), null);
    }

    @Override
    public SameDiff importGraph(InputStream inputStream, Map<String, ? extends OpImportOverride<GRAPH_TYPE, NODE_TYPE, ATTR_TYPE>> opImportOverrides, OpImportFilter<GRAPH_TYPE, NODE_TYPE, ATTR_TYPE> opFilter) {
        GRAPH_TYPE def = this.readGraph(inputStream, opImportOverrides);
        return this.importGraph(def, opImportOverrides, opFilter);
    }

    protected GRAPH_TYPE readGraph(InputStream inputStream, Map<String, ? extends OpImportOverride<GRAPH_TYPE, NODE_TYPE, ATTR_TYPE>> opImportOverrides) {
        byte[] bytes = null;
        Message def = null;
        try {
            bytes = IOUtils.toByteArray((InputStream)inputStream);
            def = (Message)this.parseGraphFrom(bytes);
        }
        catch (IOException e) {
            try (BufferedInputStream bis2 = new BufferedInputStream(new ByteArrayInputStream(bytes));
                 BufferedReader reader = new BufferedReader(new InputStreamReader(bis2));){
                Message.Builder builder = this.getNewGraphBuilder();
                StringBuilder str = new StringBuilder();
                String line = null;
                while ((line = reader.readLine()) != null) {
                    str.append(line);
                }
                TextFormat.getParser().merge((CharSequence)str.toString(), builder);
                def = builder.build();
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        return (GRAPH_TYPE)def;
    }

    @Override
    public SameDiff importGraph(File graphFile) {
        return this.importGraph((GRAPH_TYPE)graphFile, (Map<String, ? extends OpImportOverride<GRAPH_TYPE, NODE_TYPE, ATTR_TYPE>>)Collections.emptyMap(), null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SameDiff importGraph(File graphFile, Map<String, ? extends OpImportOverride<GRAPH_TYPE, NODE_TYPE, ATTR_TYPE>> opImportOverrides, OpImportFilter<GRAPH_TYPE, NODE_TYPE, ATTR_TYPE> opFilter) {
        Object def = null;
        try (FileInputStream fis = new FileInputStream(graphFile);){
            SameDiff sameDiff = this.importGraph((GRAPH_TYPE)fis, opImportOverrides, opFilter);
            return sameDiff;
        }
        catch (Exception e) {
            throw new ND4JIllegalStateException("Error encountered loading graph file: " + graphFile.getAbsolutePath(), e);
        }
    }

    @Override
    public Map<String, NODE_TYPE> nameIndexForGraph(GRAPH_TYPE graph) {
        List nodes = this.getNodeList(graph);
        HashMap ret = new HashMap();
        for (Object node : nodes) {
            ret.put(this.getName(node), node);
        }
        return ret;
    }

    @Override
    public Map<String, NODE_TYPE> nodesByName(GRAPH_TYPE graph) {
        List nodeTypes = this.getNodeList(graph);
        LinkedHashMap ret = new LinkedHashMap();
        for (int i = 0; i < nodeTypes.size(); ++i) {
            ret.put(this.getName(nodeTypes.get(i)), nodeTypes.get(i));
        }
        return ret;
    }

    @Override
    public SameDiff importGraph(GRAPH_TYPE tfGraph) {
        return this.importGraph(tfGraph, Collections.emptyMap(), null);
    }

    @Override
    public SameDiff importGraph(GRAPH_TYPE tfGraph, Map<String, ? extends OpImportOverride<GRAPH_TYPE, NODE_TYPE, ATTR_TYPE>> opImportOverrides, OpImportFilter<GRAPH_TYPE, NODE_TYPE, ATTR_TYPE> opFilter) {
        boolean bl;
        Iterator<String> opName;
        SameDiff diff = SameDiff.create();
        ImportState importState = new ImportState();
        importState.setSameDiff(diff);
        importState.setGraph(tfGraph);
        Map variablesForGraph = this.variablesForGraph(tfGraph);
        importState.setVariables(variablesForGraph);
        HashMap stringNodes = new HashMap();
        for (Map.Entry entry : variablesForGraph.entrySet()) {
            List<String> controlDependencies;
            long[] shape;
            if (this.shouldSkip(entry.getValue())) continue;
            Object TENSOR_TYPE = entry.getValue();
            String string = this.getOpType(TENSOR_TYPE);
            opName = this.getName(TENSOR_TYPE);
            if (opFilter != null && opFilter.skipOp(TENSOR_TYPE, importState.getSameDiff(), null, importState.getGraph())) {
                log.info("Skipping variables for op: {} (name: {})", (Object)string, (Object)opName);
                continue;
            }
            if (opImportOverrides != null && opImportOverrides.containsKey(string)) {
                log.info("Skipping variables for op due to presence of OpImportOverride: {} (name: {})", (Object)string, (Object)opName);
                continue;
            }
            DataType dt = this.dataTypeForTensor(entry.getValue(), 0);
            INDArray arr = this.getNDArrayFromTensor(entry.getKey(), entry.getValue(), tfGraph);
            long[] lArray = shape = this.hasShape(entry.getValue()) ? this.getShape(entry.getValue()) : null;
            if (dt == DataType.UNKNOWN) {
                dt = null;
            }
            if (this.isPlaceHolder(entry.getValue())) {
                diff.placeHolder(entry.getKey(), dt, shape);
            } else if (this.isConstant(entry.getValue())) {
                Preconditions.checkNotNull((Object)arr, (String)"Array is null for placeholder variable %s", (Object)entry.getKey());
                diff.constant(entry.getKey(), arr);
            } else {
                SDVariable v = shape == null ? diff.var(entry.getKey(), VariableType.ARRAY, null, dt, (long[])null) : diff.var(entry.getKey(), dt, shape);
                if (arr != null) {
                    diff.associateArrayWithVariable(arr, v);
                }
            }
            if ((controlDependencies = this.getControlDependencies(TENSOR_TYPE)) == null) continue;
            Variable v = diff.getVariables().get(entry.getKey());
            v.setControlDeps(controlDependencies);
        }
        List tfNodesList = this.getNodeList(tfGraph);
        for (Object NODE_TYPE : tfNodesList) {
            String string = this.getOpType(NODE_TYPE);
            OpImportOverride<GRAPH_TYPE, NODE_TYPE, ATTR_TYPE> importOverride = null;
            if (opImportOverrides != null) {
                importOverride = opImportOverrides.get(string);
            }
            if (opFilter != null && opFilter.skipOp(NODE_TYPE, importState.getSameDiff(), null, null)) {
                String opName2 = this.getName(NODE_TYPE);
                log.info("Skipping op due to op filter: {}", (Object)string, (Object)opName2);
                continue;
            }
            if (this.opsToIgnore().contains(string) && !this.isOpIgnoreException(NODE_TYPE)) continue;
            this.mapNodeType(NODE_TYPE, importState, importOverride, opFilter);
        }
        for (Variable variable : diff.getVariables().values()) {
            if (variable.getVariable().isPlaceHolder() || variable.getVariable().isConstant()) continue;
            String string = variable.getName();
            opName = string;
            if (variable.getName().matches(".*:\\d+")) {
                int idx = string.lastIndexOf(58);
                opName = string.substring(0, idx);
            }
            if (!diff.getOps().containsKey(opName)) continue;
            variable.setOutputOfOp((String)((Object)opName));
            if (variable.getVariable().getVariableType() == VariableType.ARRAY) continue;
            variable.getVariable().setVariableType(VariableType.ARRAY);
        }
        for (SameDiffOp sameDiffOp : diff.getOps().values()) {
            DifferentialFunction differentialFunction = sameDiffOp.getOp();
            this.initOutputVariables(diff, differentialFunction);
        }
        for (Map.Entry<String, Variable> entry : diff.getVariables().entrySet()) {
            Variable variable = entry.getValue();
            if (variable.getControlDeps() == null) continue;
            for (String s : variable.getControlDeps()) {
                Variable v2 = diff.getVariables().get(s);
                if (v2.getControlDepsForVar() == null) {
                    v2.setControlDepsForVar(new ArrayList<String>());
                }
                if (v2.getControlDepsForVar().contains(entry.getKey())) continue;
                v2.getControlDepsForVar().add(entry.getKey());
            }
        }
        for (Map.Entry<String, SameDiffOp> entry : diff.getOps().entrySet()) {
            SameDiffOp sameDiffOp = entry.getValue();
            if (sameDiffOp.getControlDeps() == null) continue;
            for (String s : sameDiffOp.getControlDeps()) {
                Variable v = diff.getVariables().get(s);
                if (v.getControlDepsForOp() == null) {
                    v.setControlDepsForOp(new ArrayList<String>());
                }
                if (v.getControlDepsForOp().contains(entry.getKey())) continue;
                v.getControlDepsForOp().add(entry.getKey());
            }
        }
        boolean bl2 = false;
        for (SDVariable sDVariable : diff.variables()) {
            if (sDVariable.dataType() != null) continue;
            bl = true;
        }
        if (bl) {
            Map<String, DataType> map = diff.calculateOutputDataTypes();
            for (SDVariable v : diff.variables()) {
                if (v.dataType() != null) continue;
                v.setDataType(map.get(v.getVarName()));
            }
        }
        this.validateGraphStructure(diff);
        return diff;
    }

    protected void initOutputVariables(SameDiff sd, DifferentialFunction df) {
        String[] outNames = sd.getOutputsForFunction(df);
        if (outNames == null) {
            SDVariable[] outVars = sd.generateOutputVariableForOp(df, df.getOwnName() != null ? df.getOwnName() : df.opName(), true);
            outNames = new String[outVars.length];
            for (int i = 0; i < outVars.length; ++i) {
                outNames[i] = outVars[i].getVarName();
            }
            sd.getOps().get(df.getOwnName()).setOutputsOfOp(Arrays.asList(outNames));
        }
        for (String s : outNames) {
            sd.getVariables().get(s).setOutputOfOp(df.getOwnName());
        }
    }

    @Override
    public boolean validTensorDataType(TENSOR_TYPE tensorType) {
        return this.dataTypeForTensor(tensorType, 0) != DataType.UNKNOWN;
    }

    public void validateGraphStructure(SameDiff sameDiff) {
        for (SDVariable v : sameDiff.variables()) {
            String name = v.getVarName();
            if (!sameDiff.isPlaceHolder(name)) continue;
            String string = sameDiff.getVariables().get(name).getOutputOfOp();
        }
        for (SameDiffOp op : sameDiff.getOps().values()) {
            List<String> inputs = op.getInputsToOp();
            if (inputs == null) continue;
            for (String s : inputs) {
                if (sameDiff.getVariable(s) != null) continue;
                throw new IllegalStateException("Import validation failed: op \"" + op.getName() + "\" of type " + op.getOp().getClass().getSimpleName() + " has input \"" + s + "\" that does not have a corresponding variable in the graph");
            }
        }
    }
}

