/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.dataset.api.preprocessor;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.dataset.api.preprocessor.AbstractMultiDataSetNormalizer;
import org.nd4j.linalg.dataset.api.preprocessor.StandardizeStrategy;
import org.nd4j.linalg.dataset.api.preprocessor.serializer.NormalizerType;
import org.nd4j.linalg.dataset.api.preprocessor.stats.DistributionStats;
import org.nd4j.linalg.dataset.api.preprocessor.stats.NormalizerStats;

public class MultiNormalizerStandardize
extends AbstractMultiDataSetNormalizer<DistributionStats> {
    public MultiNormalizerStandardize() {
        super(new StandardizeStrategy());
    }

    @Override
    protected NormalizerStats.Builder newBuilder() {
        return new DistributionStats.Builder();
    }

    public INDArray getFeatureMean(int input) {
        return ((DistributionStats)this.getFeatureStats(input)).getMean();
    }

    public INDArray getLabelMean(int output) {
        return ((DistributionStats)this.getLabelStats(output)).getMean();
    }

    public INDArray getFeatureStd(int input) {
        return ((DistributionStats)this.getFeatureStats(input)).getStd();
    }

    public INDArray getLabelStd(int output) {
        return ((DistributionStats)this.getLabelStats(output)).getStd();
    }

    public void load(@NonNull List<File> featureFiles, @NonNull List<File> labelFiles) throws IOException {
        if (featureFiles == null) {
            throw new NullPointerException("featureFiles is marked @NonNull but is null");
        }
        if (labelFiles == null) {
            throw new NullPointerException("labelFiles is marked @NonNull but is null");
        }
        this.setFeatureStats(this.load(featureFiles));
        if (this.isFitLabel()) {
            this.setLabelStats(this.load(labelFiles));
        }
    }

    private List<DistributionStats> load(List<File> files) throws IOException {
        ArrayList<DistributionStats> stats = new ArrayList<DistributionStats>(files.size() / 2);
        for (int i = 0; i < files.size() / 2; ++i) {
            stats.add(DistributionStats.load(files.get(i * 2), files.get(i * 2 + 1)));
        }
        return stats;
    }

    public void save(@NonNull List<File> featureFiles, @NonNull List<File> labelFiles) throws IOException {
        if (featureFiles == null) {
            throw new NullPointerException("featureFiles is marked @NonNull but is null");
        }
        if (labelFiles == null) {
            throw new NullPointerException("labelFiles is marked @NonNull but is null");
        }
        this.saveStats(this.getFeatureStats(), featureFiles);
        if (this.isFitLabel()) {
            this.saveStats(this.getLabelStats(), labelFiles);
        }
    }

    private void saveStats(List<DistributionStats> stats, List<File> files) throws IOException {
        int requiredFiles = stats.size() * 2;
        if (requiredFiles != files.size()) {
            throw new RuntimeException(String.format("Need twice as many files as inputs / outputs (%d), got %d", requiredFiles, files.size()));
        }
        for (int i = 0; i < stats.size(); ++i) {
            stats.get(i).save(files.get(i * 2), files.get(i * 2 + 1));
        }
    }

    @Override
    public NormalizerType getType() {
        return NormalizerType.MULTI_STANDARDIZE;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MultiNormalizerStandardize)) {
            return false;
        }
        MultiNormalizerStandardize other = (MultiNormalizerStandardize)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof MultiNormalizerStandardize;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

