/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.shape;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.imports.NoOpNameFoundException;
import org.nd4j.imports.descriptors.properties.PropertyMapping;
import org.nd4j.imports.graphmapper.tf.TFGraphMapper;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.exception.ND4JIllegalStateException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tensorflow.framework.AttrValue;
import org.tensorflow.framework.GraphDef;
import org.tensorflow.framework.NodeDef;

public class Slice
extends DynamicCustomOp {
    private static final Logger log = LoggerFactory.getLogger(Slice.class);
    private int[] begin;
    private int[] size;

    public Slice() {
    }

    public Slice(SameDiff sameDiff, @NonNull SDVariable input, @NonNull int[] begin, @NonNull int[] size) {
        super(null, sameDiff, new SDVariable[]{input});
        if (input == null) {
            throw new NullPointerException("input is marked @NonNull but is null");
        }
        if (begin == null) {
            throw new NullPointerException("begin is marked @NonNull but is null");
        }
        if (size == null) {
            throw new NullPointerException("size is marked @NonNull but is null");
        }
        this.begin = begin;
        this.size = size;
        this.addIArgument(begin);
        this.addIArgument(size);
    }

    @Override
    public String opName() {
        return "slice";
    }

    @Override
    public String onnxName() {
        throw new NoOpNameFoundException("No onnx opName found for " + this.opName());
    }

    @Override
    public String tensorflowName() {
        return "Slice";
    }

    @Override
    public void assertValidForExecution() {
        if (this.numInputArguments() != 1 && this.numInputArguments() != 3 && this.numInputArguments() != 4) {
            throw new ND4JIllegalStateException("Num input arguments must be 1 3 or 4.");
        }
    }

    @Override
    public void initFromTensorFlow(NodeDef nodeDef, SameDiff initWith, Map<String, AttrValue> attributesForNode, GraphDef graph) {
        String inputBegin = nodeDef.getInput(1);
        String inputEnd = nodeDef.getInput(2);
        NodeDef beginNode = null;
        NodeDef endNode = null;
        for (int i = 0; i < graph.getNodeCount(); ++i) {
            if (graph.getNode(i).getName().equals(inputBegin)) {
                beginNode = graph.getNode(i);
            }
            if (!graph.getNode(i).getName().equals(inputEnd)) continue;
            endNode = graph.getNode(i);
        }
        INDArray beginArr = TFGraphMapper.getInstance().getNDArrayFromTensor("value", beginNode, graph);
        INDArray endArr = TFGraphMapper.getInstance().getNDArrayFromTensor("value", endNode, graph);
        if (beginArr != null && endArr != null) {
            int e = 0;
            while ((long)e < beginArr.length()) {
                this.addIArgument(beginArr.getInt(e++));
            }
            e = 0;
            while ((long)e < endArr.length()) {
                this.addIArgument(endArr.getInt(e++));
            }
        }
    }

    @Override
    public Map<String, Map<String, PropertyMapping>> mappingsForFunction() {
        HashMap<String, Map<String, PropertyMapping>> ret = new HashMap<String, Map<String, PropertyMapping>>();
        HashMap<String, PropertyMapping> map = new HashMap<String, PropertyMapping>();
        PropertyMapping beginMapping = PropertyMapping.builder().tfInputPosition(1).propertyNames(new String[]{"begin"}).build();
        PropertyMapping size = PropertyMapping.builder().tfInputPosition(2).propertyNames(new String[]{"size"}).build();
        map.put("begin", beginMapping);
        map.put("size", size);
        ret.put(this.tensorflowName(), map);
        return ret;
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> grad) {
        return Collections.singletonList(this.f().sliceBp(this.arg(), grad.get(0), this.begin, this.size));
    }
}

