/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.grid;

import org.bytedeco.javacpp.Pointer;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseOp;
import org.nd4j.linalg.api.ops.Op;

public class GridPointers {
    private Op.Type type;
    private int opNum;
    private DataBuffer.Type dtype;
    private INDArray opX;
    private INDArray opY;
    private INDArray opZ;
    private Pointer x;
    private Pointer y;
    private Pointer z;
    private long xStride = -1L;
    private long yStride = -1L;
    private long zStride = -1L;
    private long xLength = 0L;
    private long yLength = 0L;
    private long zLength = 0L;
    private char xOrder;
    private char yOrder;
    private char zOrder;
    private Pointer xShapeInfo;
    private Pointer yShapeInfo;
    private Pointer zShapeInfo;
    private Pointer dimensions;
    private int dimensionsLength = 0;
    private Pointer tadShape;
    private Pointer tadOffsets;
    private Pointer extraArgs;

    public GridPointers(Op op, int ... dimensions) {
        this.type = BaseOp.getOpType(op);
        this.dtype = op.x().data().dataType();
        this.opNum = op.opNum();
        this.opX = op.x();
        this.opZ = op.z();
        this.xLength = op.x().length();
        this.zLength = op.z().length();
        this.xOrder = op.x().ordering();
        this.zOrder = op.z().ordering();
        this.xStride = op.x().elementWiseStride();
        this.zStride = op.z().elementWiseStride();
        if (op.y() != null) {
            this.yStride = op.y().elementWiseStride();
            this.yLength = op.y().length();
            this.yOrder = op.y().ordering();
            this.opY = op.y();
        }
        if (dimensions != null) {
            this.dimensionsLength = dimensions.length;
        }
    }

    public Op.Type getType() {
        return this.type;
    }

    public int getOpNum() {
        return this.opNum;
    }

    public DataBuffer.Type getDtype() {
        return this.dtype;
    }

    public INDArray getOpX() {
        return this.opX;
    }

    public INDArray getOpY() {
        return this.opY;
    }

    public INDArray getOpZ() {
        return this.opZ;
    }

    public Pointer getX() {
        return this.x;
    }

    public Pointer getY() {
        return this.y;
    }

    public Pointer getZ() {
        return this.z;
    }

    public long getXStride() {
        return this.xStride;
    }

    public long getYStride() {
        return this.yStride;
    }

    public long getZStride() {
        return this.zStride;
    }

    public long getXLength() {
        return this.xLength;
    }

    public long getYLength() {
        return this.yLength;
    }

    public long getZLength() {
        return this.zLength;
    }

    public char getXOrder() {
        return this.xOrder;
    }

    public char getYOrder() {
        return this.yOrder;
    }

    public char getZOrder() {
        return this.zOrder;
    }

    public Pointer getXShapeInfo() {
        return this.xShapeInfo;
    }

    public Pointer getYShapeInfo() {
        return this.yShapeInfo;
    }

    public Pointer getZShapeInfo() {
        return this.zShapeInfo;
    }

    public Pointer getDimensions() {
        return this.dimensions;
    }

    public int getDimensionsLength() {
        return this.dimensionsLength;
    }

    public Pointer getTadShape() {
        return this.tadShape;
    }

    public Pointer getTadOffsets() {
        return this.tadOffsets;
    }

    public Pointer getExtraArgs() {
        return this.extraArgs;
    }

    public void setType(Op.Type type) {
        this.type = type;
    }

    public void setOpNum(int opNum) {
        this.opNum = opNum;
    }

    public void setDtype(DataBuffer.Type dtype) {
        this.dtype = dtype;
    }

    public void setOpX(INDArray opX) {
        this.opX = opX;
    }

    public void setOpY(INDArray opY) {
        this.opY = opY;
    }

    public void setOpZ(INDArray opZ) {
        this.opZ = opZ;
    }

    public void setX(Pointer x) {
        this.x = x;
    }

    public void setY(Pointer y) {
        this.y = y;
    }

    public void setZ(Pointer z) {
        this.z = z;
    }

    public void setXStride(long xStride) {
        this.xStride = xStride;
    }

    public void setYStride(long yStride) {
        this.yStride = yStride;
    }

    public void setZStride(long zStride) {
        this.zStride = zStride;
    }

    public void setXLength(long xLength) {
        this.xLength = xLength;
    }

    public void setYLength(long yLength) {
        this.yLength = yLength;
    }

    public void setZLength(long zLength) {
        this.zLength = zLength;
    }

    public void setXOrder(char xOrder) {
        this.xOrder = xOrder;
    }

    public void setYOrder(char yOrder) {
        this.yOrder = yOrder;
    }

    public void setZOrder(char zOrder) {
        this.zOrder = zOrder;
    }

    public void setXShapeInfo(Pointer xShapeInfo) {
        this.xShapeInfo = xShapeInfo;
    }

    public void setYShapeInfo(Pointer yShapeInfo) {
        this.yShapeInfo = yShapeInfo;
    }

    public void setZShapeInfo(Pointer zShapeInfo) {
        this.zShapeInfo = zShapeInfo;
    }

    public void setDimensions(Pointer dimensions) {
        this.dimensions = dimensions;
    }

    public void setDimensionsLength(int dimensionsLength) {
        this.dimensionsLength = dimensionsLength;
    }

    public void setTadShape(Pointer tadShape) {
        this.tadShape = tadShape;
    }

    public void setTadOffsets(Pointer tadOffsets) {
        this.tadOffsets = tadOffsets;
    }

    public void setExtraArgs(Pointer extraArgs) {
        this.extraArgs = extraArgs;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GridPointers)) {
            return false;
        }
        GridPointers other = (GridPointers)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Op.Type this$type = this.getType();
        Op.Type other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        if (this.getOpNum() != other.getOpNum()) {
            return false;
        }
        DataBuffer.Type this$dtype = this.getDtype();
        DataBuffer.Type other$dtype = other.getDtype();
        if (this$dtype == null ? other$dtype != null : !this$dtype.equals(other$dtype)) {
            return false;
        }
        INDArray this$opX = this.getOpX();
        INDArray other$opX = other.getOpX();
        if (this$opX == null ? other$opX != null : !this$opX.equals(other$opX)) {
            return false;
        }
        INDArray this$opY = this.getOpY();
        INDArray other$opY = other.getOpY();
        if (this$opY == null ? other$opY != null : !this$opY.equals(other$opY)) {
            return false;
        }
        INDArray this$opZ = this.getOpZ();
        INDArray other$opZ = other.getOpZ();
        if (this$opZ == null ? other$opZ != null : !this$opZ.equals(other$opZ)) {
            return false;
        }
        Pointer this$x = this.getX();
        Pointer other$x = other.getX();
        if (this$x == null ? other$x != null : !this$x.equals(other$x)) {
            return false;
        }
        Pointer this$y = this.getY();
        Pointer other$y = other.getY();
        if (this$y == null ? other$y != null : !this$y.equals(other$y)) {
            return false;
        }
        Pointer this$z = this.getZ();
        Pointer other$z = other.getZ();
        if (this$z == null ? other$z != null : !this$z.equals(other$z)) {
            return false;
        }
        if (this.getXStride() != other.getXStride()) {
            return false;
        }
        if (this.getYStride() != other.getYStride()) {
            return false;
        }
        if (this.getZStride() != other.getZStride()) {
            return false;
        }
        if (this.getXLength() != other.getXLength()) {
            return false;
        }
        if (this.getYLength() != other.getYLength()) {
            return false;
        }
        if (this.getZLength() != other.getZLength()) {
            return false;
        }
        if (this.getXOrder() != other.getXOrder()) {
            return false;
        }
        if (this.getYOrder() != other.getYOrder()) {
            return false;
        }
        if (this.getZOrder() != other.getZOrder()) {
            return false;
        }
        Pointer this$xShapeInfo = this.getXShapeInfo();
        Pointer other$xShapeInfo = other.getXShapeInfo();
        if (this$xShapeInfo == null ? other$xShapeInfo != null : !this$xShapeInfo.equals(other$xShapeInfo)) {
            return false;
        }
        Pointer this$yShapeInfo = this.getYShapeInfo();
        Pointer other$yShapeInfo = other.getYShapeInfo();
        if (this$yShapeInfo == null ? other$yShapeInfo != null : !this$yShapeInfo.equals(other$yShapeInfo)) {
            return false;
        }
        Pointer this$zShapeInfo = this.getZShapeInfo();
        Pointer other$zShapeInfo = other.getZShapeInfo();
        if (this$zShapeInfo == null ? other$zShapeInfo != null : !this$zShapeInfo.equals(other$zShapeInfo)) {
            return false;
        }
        Pointer this$dimensions = this.getDimensions();
        Pointer other$dimensions = other.getDimensions();
        if (this$dimensions == null ? other$dimensions != null : !this$dimensions.equals(other$dimensions)) {
            return false;
        }
        if (this.getDimensionsLength() != other.getDimensionsLength()) {
            return false;
        }
        Pointer this$tadShape = this.getTadShape();
        Pointer other$tadShape = other.getTadShape();
        if (this$tadShape == null ? other$tadShape != null : !this$tadShape.equals(other$tadShape)) {
            return false;
        }
        Pointer this$tadOffsets = this.getTadOffsets();
        Pointer other$tadOffsets = other.getTadOffsets();
        if (this$tadOffsets == null ? other$tadOffsets != null : !this$tadOffsets.equals(other$tadOffsets)) {
            return false;
        }
        Pointer this$extraArgs = this.getExtraArgs();
        Pointer other$extraArgs = other.getExtraArgs();
        return !(this$extraArgs == null ? other$extraArgs != null : !this$extraArgs.equals(other$extraArgs));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GridPointers;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Op.Type $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        result = result * 59 + this.getOpNum();
        DataBuffer.Type $dtype = this.getDtype();
        result = result * 59 + ($dtype == null ? 43 : $dtype.hashCode());
        INDArray $opX = this.getOpX();
        result = result * 59 + ($opX == null ? 43 : $opX.hashCode());
        INDArray $opY = this.getOpY();
        result = result * 59 + ($opY == null ? 43 : $opY.hashCode());
        INDArray $opZ = this.getOpZ();
        result = result * 59 + ($opZ == null ? 43 : $opZ.hashCode());
        Pointer $x = this.getX();
        result = result * 59 + ($x == null ? 43 : $x.hashCode());
        Pointer $y = this.getY();
        result = result * 59 + ($y == null ? 43 : $y.hashCode());
        Pointer $z = this.getZ();
        result = result * 59 + ($z == null ? 43 : $z.hashCode());
        long $xStride = this.getXStride();
        result = result * 59 + (int)($xStride >>> 32 ^ $xStride);
        long $yStride = this.getYStride();
        result = result * 59 + (int)($yStride >>> 32 ^ $yStride);
        long $zStride = this.getZStride();
        result = result * 59 + (int)($zStride >>> 32 ^ $zStride);
        long $xLength = this.getXLength();
        result = result * 59 + (int)($xLength >>> 32 ^ $xLength);
        long $yLength = this.getYLength();
        result = result * 59 + (int)($yLength >>> 32 ^ $yLength);
        long $zLength = this.getZLength();
        result = result * 59 + (int)($zLength >>> 32 ^ $zLength);
        result = result * 59 + this.getXOrder();
        result = result * 59 + this.getYOrder();
        result = result * 59 + this.getZOrder();
        Pointer $xShapeInfo = this.getXShapeInfo();
        result = result * 59 + ($xShapeInfo == null ? 43 : $xShapeInfo.hashCode());
        Pointer $yShapeInfo = this.getYShapeInfo();
        result = result * 59 + ($yShapeInfo == null ? 43 : $yShapeInfo.hashCode());
        Pointer $zShapeInfo = this.getZShapeInfo();
        result = result * 59 + ($zShapeInfo == null ? 43 : $zShapeInfo.hashCode());
        Pointer $dimensions = this.getDimensions();
        result = result * 59 + ($dimensions == null ? 43 : $dimensions.hashCode());
        result = result * 59 + this.getDimensionsLength();
        Pointer $tadShape = this.getTadShape();
        result = result * 59 + ($tadShape == null ? 43 : $tadShape.hashCode());
        Pointer $tadOffsets = this.getTadOffsets();
        result = result * 59 + ($tadOffsets == null ? 43 : $tadOffsets.hashCode());
        Pointer $extraArgs = this.getExtraArgs();
        result = result * 59 + ($extraArgs == null ? 43 : $extraArgs.hashCode());
        return result;
    }

    public String toString() {
        return "GridPointers(type=" + (Object)((Object)this.getType()) + ", opNum=" + this.getOpNum() + ", dtype=" + this.getDtype() + ", opX=" + this.getOpX() + ", opY=" + this.getOpY() + ", opZ=" + this.getOpZ() + ", x=" + this.getX() + ", y=" + this.getY() + ", z=" + this.getZ() + ", xStride=" + this.getXStride() + ", yStride=" + this.getYStride() + ", zStride=" + this.getZStride() + ", xLength=" + this.getXLength() + ", yLength=" + this.getYLength() + ", zLength=" + this.getZLength() + ", xOrder=" + this.getXOrder() + ", yOrder=" + this.getYOrder() + ", zOrder=" + this.getZOrder() + ", xShapeInfo=" + this.getXShapeInfo() + ", yShapeInfo=" + this.getYShapeInfo() + ", zShapeInfo=" + this.getZShapeInfo() + ", dimensions=" + this.getDimensions() + ", dimensionsLength=" + this.getDimensionsLength() + ", tadShape=" + this.getTadShape() + ", tadOffsets=" + this.getTadOffsets() + ", extraArgs=" + this.getExtraArgs() + ")";
    }

    public GridPointers() {
    }

    public GridPointers(Op.Type type, int opNum, DataBuffer.Type dtype, INDArray opX, INDArray opY, INDArray opZ, Pointer x, Pointer y, Pointer z, long xStride, long yStride, long zStride, long xLength, long yLength, long zLength, char xOrder, char yOrder, char zOrder, Pointer xShapeInfo, Pointer yShapeInfo, Pointer zShapeInfo, Pointer dimensions, int dimensionsLength, Pointer tadShape, Pointer tadOffsets, Pointer extraArgs) {
        this.type = type;
        this.opNum = opNum;
        this.dtype = dtype;
        this.opX = opX;
        this.opY = opY;
        this.opZ = opZ;
        this.x = x;
        this.y = y;
        this.z = z;
        this.xStride = xStride;
        this.yStride = yStride;
        this.zStride = zStride;
        this.xLength = xLength;
        this.yLength = yLength;
        this.zLength = zLength;
        this.xOrder = xOrder;
        this.yOrder = yOrder;
        this.zOrder = zOrder;
        this.xShapeInfo = xShapeInfo;
        this.yShapeInfo = yShapeInfo;
        this.zShapeInfo = zShapeInfo;
        this.dimensions = dimensions;
        this.dimensionsLength = dimensionsLength;
        this.tadShape = tadShape;
        this.tadOffsets = tadOffsets;
        this.extraArgs = extraArgs;
    }
}

