/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.executioner;

import java.util.Arrays;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.CustomOp;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.api.ops.executioner.OpExecutioner;
import org.nd4j.linalg.api.ops.impl.accum.MatchCondition;
import org.nd4j.linalg.exception.ND4JIllegalStateException;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.indexing.conditions.Conditions;
import org.nd4j.linalg.util.ArrayUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpExecutionerUtil {
    private static final Logger log = LoggerFactory.getLogger(OpExecutionerUtil.class);

    private OpExecutionerUtil() {
    }

    public static boolean canDoOpDirectly(INDArray x) {
        long dl1;
        if (x.elementWiseStride() < 1) {
            return false;
        }
        if (x.isVector()) {
            return true;
        }
        long l1 = x.lengthLong();
        if (l1 == (dl1 = x.data().length())) {
            return true;
        }
        long[] shape1 = x.shape();
        long[] stridesAsInit = x.ordering() == 'c' ? ArrayUtil.calcStrides((long[])shape1) : ArrayUtil.calcStridesFortran((long[])shape1);
        boolean stridesSameAsInit = Arrays.equals(x.stride(), stridesAsInit);
        return stridesSameAsInit;
    }

    public static void checkForNaN(INDArray z) {
        if (Nd4j.getExecutioner().getProfilingMode() != OpExecutioner.ProfilingMode.NAN_PANIC && Nd4j.getExecutioner().getProfilingMode() != OpExecutioner.ProfilingMode.ANY_PANIC) {
            return;
        }
        if (z.isEmpty()) {
            return;
        }
        int match = 0;
        if (!z.isScalar()) {
            MatchCondition condition = new MatchCondition(z, Conditions.isNan());
            match = Nd4j.getExecutioner().exec(condition, Integer.MAX_VALUE).getInt(0);
        } else if (z.data().dataType() == DataBuffer.Type.DOUBLE) {
            if (Double.isNaN(z.getDouble(0L))) {
                match = 1;
            }
        } else if (Float.isNaN(z.getFloat(0L))) {
            match = 1;
        }
        if (match > 0) {
            throw new ND4JIllegalStateException("P.A.N.I.C.! Op.Z() contains " + match + " NaN value(s): ");
        }
    }

    public static void checkForAny(INDArray z) {
        OpExecutionerUtil.checkForNaN(z);
        OpExecutionerUtil.checkForInf(z);
    }

    public static void checkForInf(INDArray z) {
        if (Nd4j.getExecutioner().getProfilingMode() != OpExecutioner.ProfilingMode.INF_PANIC && Nd4j.getExecutioner().getProfilingMode() != OpExecutioner.ProfilingMode.ANY_PANIC) {
            return;
        }
        if (z.isEmpty()) {
            return;
        }
        int match = 0;
        if (!z.isScalar()) {
            MatchCondition condition = new MatchCondition(z, Conditions.isInfinite());
            match = Nd4j.getExecutioner().exec(condition, Integer.MAX_VALUE).getInt(0);
        } else if (z.data().dataType() == DataBuffer.Type.DOUBLE) {
            if (Double.isInfinite(z.getDouble(0L))) {
                match = 1;
            }
        } else if (Float.isInfinite(z.getFloat(0L))) {
            match = 1;
        }
        if (match > 0) {
            throw new ND4JIllegalStateException("P.A.N.I.C.! Op.Z() contains " + match + " Inf value(s)");
        }
    }

    public static void checkForNaN(Op op) {
        if (Nd4j.getExecutioner().getProfilingMode() != OpExecutioner.ProfilingMode.NAN_PANIC && Nd4j.getExecutioner().getProfilingMode() != OpExecutioner.ProfilingMode.ANY_PANIC) {
            return;
        }
        if (op.z() != null && !(op instanceof MatchCondition)) {
            OpExecutionerUtil.checkForNaN(op.z());
        }
    }

    public static void checkForInf(Op op) {
        if (Nd4j.getExecutioner().getProfilingMode() != OpExecutioner.ProfilingMode.INF_PANIC && Nd4j.getExecutioner().getProfilingMode() != OpExecutioner.ProfilingMode.ANY_PANIC) {
            return;
        }
        if (op.z() != null && !(op instanceof MatchCondition)) {
            OpExecutionerUtil.checkForInf(op.z());
        }
    }

    public static void checkForInf(CustomOp op) {
        if (Nd4j.getExecutioner().getProfilingMode() != OpExecutioner.ProfilingMode.INF_PANIC && Nd4j.getExecutioner().getProfilingMode() != OpExecutioner.ProfilingMode.ANY_PANIC) {
            return;
        }
        for (INDArray input : op.inputArguments()) {
            OpExecutionerUtil.checkForInf(input);
        }
        for (INDArray output : op.outputArguments()) {
            OpExecutionerUtil.checkForInf(output);
        }
    }

    public static void checkForNaN(CustomOp op) {
        if (Nd4j.getExecutioner().getProfilingMode() != OpExecutioner.ProfilingMode.NAN_PANIC && Nd4j.getExecutioner().getProfilingMode() != OpExecutioner.ProfilingMode.ANY_PANIC) {
            return;
        }
        for (INDArray input : op.inputArguments()) {
            OpExecutionerUtil.checkForNaN(input);
        }
        for (INDArray output : op.outputArguments()) {
            OpExecutionerUtil.checkForNaN(output);
        }
    }
}

