/*
 * Decompiled with CFR 0.152.
 */
package org.mineskin;

import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;

public class RequestQueue {
    private final Queue<Supplier<CompletableFuture<?>>> queue = new LinkedList();
    private final AtomicInteger running = new AtomicInteger(0);
    private long nextRequest = 0L;

    public RequestQueue(ScheduledExecutorService executor, int interval, int concurrency) {
        executor.scheduleAtFixedRate(() -> {
            if (System.currentTimeMillis() < this.nextRequest) {
                return;
            }
            if (this.running.get() >= concurrency) {
                return;
            }
            Supplier<CompletableFuture<?>> supplier = this.queue.poll();
            if (supplier != null) {
                this.running.incrementAndGet();
                supplier.get();
            }
        }, 0L, interval, TimeUnit.MILLISECONDS);
    }

    public void setNextRequest(long nextRequest) {
        this.nextRequest = nextRequest;
    }

    public long getNextRequest() {
        return this.nextRequest;
    }

    public int getRunning() {
        return this.running.get();
    }

    public <T> CompletableFuture<T> submit(Supplier<CompletableFuture<T>> supplier) {
        CompletableFuture future = new CompletableFuture();
        this.queue.add(() -> ((CompletableFuture)supplier.get()).whenComplete((result, throwable) -> {
            this.running.decrementAndGet();
            if (throwable != null) {
                future.completeExceptionally((Throwable)throwable);
            } else {
                future.complete(result);
            }
        }));
        return future;
    }

    public <T> CompletableFuture<T> submit(Supplier<T> supplier, Executor executor) {
        return this.submit(() -> CompletableFuture.supplyAsync(supplier, executor));
    }
}

