/*
 * @(#)StringResourcesFrench.java        6.0.0    2024-05-19
 *
 * MathParser.org-mXparser DUAL LICENSE AGREEMENT as of date 2024-05-19
 * The most up-to-date license is available at the below link:
 * - https://mathparser.org/mxparser-license
 *
 * AUTHOR: Copyright 2010 - 2024 Mariusz Gromada - All rights reserved
 * PUBLISHER: INFIMA - https://payhip.com/infima
 *
 * SOFTWARE means source code and/or binary form and/or documentation.
 * PRODUCT: MathParser.org-mXparser SOFTWARE
 * LICENSE: DUAL LICENSE AGREEMENT
 *
 * BY INSTALLING, COPYING, OR OTHERWISE USING THE PRODUCT, YOU AGREE TO BE
 * BOUND BY ALL OF THE TERMS AND CONDITIONS OF THE DUAL LICENSE AGREEMENT.
 *
 * The AUTHOR & PUBLISHER provide the PRODUCT under the DUAL LICENSE AGREEMENT
 * model designed to meet the needs of both non-commercial use and commercial
 * use.
 *
 * NON-COMMERCIAL USE means any use or activity where a fee is not charged
 * and the purpose is not the sale of a good or service, and the use or
 * activity is not intended to produce a profit. Examples of NON-COMMERCIAL USE
 * include:
 *
 * 1. Non-commercial open-source software.
 * 2. Non-commercial mobile applications.
 * 3. Non-commercial desktop software.
 * 4. Non-commercial web applications/solutions.
 * 5. Non-commercial use in research, scholarly and educational context.
 *
 * The above list is non-exhaustive and illustrative only.
 *
 * COMMERCIAL USE means any use or activity where a fee is charged or the
 * purpose is the sale of a good or service, or the use or activity is
 * intended to produce a profit. COMMERCIAL USE examples:
 *
 * 1. OEMs (Original Equipment Manufacturers).
 * 2. ISVs (Independent Software Vendors).
 * 3. VARs (Value Added Resellers).
 * 4. Other distributors that combine and distribute commercially licensed
 *    software.
 *
 * The above list is non-exhaustive and illustrative only.
 *
 * IN CASE YOU WANT TO USE THE PRODUCT COMMERCIALLY, YOU MUST PURCHASE THE
 * APPROPRIATE LICENSE FROM "INFIMA" ONLINE STORE, STORE ADDRESS:
 *
 * 1. https://mathparser.org/order-commercial-license
 * 2. https://payhip.com/infima
 *
 * NON-COMMERCIAL LICENSE
 *
 * Redistribution and use of the PRODUCT in source and/or binary forms,
 * with or without modification, are permitted provided that the following
 * conditions are met:
 *
 * 1. Redistributions of source code must retain the unmodified content of
 *    the entire MathParser.org-mXparser DUAL LICENSE AGREEMENT, including
 *    the definition of NON-COMMERCIAL USE, the definition of COMMERCIAL USE,
 *    the NON-COMMERCIAL LICENSE conditions, the COMMERCIAL LICENSE conditions,
 *    and the following DISCLAIMER.
 * 2. Redistributions in binary form must reproduce the entire content of
 *    MathParser.org-mXparser DUAL LICENSE AGREEMENT in the documentation
 *    and/or other materials provided with the distribution, including the
 *    definition of NON-COMMERCIAL USE, the definition of COMMERCIAL USE, the
 *    NON-COMMERCIAL LICENSE conditions, the COMMERCIAL LICENSE conditions,
 *    and the following DISCLAIMER.
 * 3. Any form of redistribution requires confirmation and signature of
 *    the NON-COMMERCIAL USE by successfully calling the method:
 *       License.iConfirmNonCommercialUse(...)
 *    The method call is used only internally for logging purposes, and
 *    there is no connection with other external services, and no data is
 *    sent or collected. The lack of a method call (or its successful call)
 *    does not affect the operation of the PRODUCT in any way. Please see
 *    the API documentation.
 *
 * COMMERCIAL LICENSE
 *
 *  1. Before purchasing a commercial license, the AUTHOR & PUBLISHER allow
 *     you to download, install, and use up to three copies of the PRODUCT to
 *     perform integration tests, confirm the quality of the PRODUCT, and
 *     its suitability. The testing period should be limited to fourteen
 *     days. Tests should be performed under the test environments conditions
 *     and not for profit generation.
 *  2. Provided that you purchased a license from "INFIMA" online store
 *     (store address: https://mathparser.org/order-commercial-license or
 *     https://payhip.com/infima), and you comply with all terms and
 *     conditions below, and you have acknowledged and understood the
 *     following DISCLAIMER, the AUTHOR & PUBLISHER grant you a nonexclusive
 *     license with the following rights:
 *  3. The license is granted only to you, the person or entity that made
 *     the purchase, identified and confirmed by the data provided during
 *     the purchase.
 *  4. If you purchased a license in the "ONE-TIME PURCHASE" model, the
 *     license is granted only for the PRODUCT version specified in the
 *     purchase. The upgrade policy gives you additional rights, described
 *     in the dedicated section below.
 *  5. If you purchased a license in the "SUBSCRIPTION" model, you may
 *     install and use any version of the PRODUCT during the subscription
 *     validity period.
 *  6. If you purchased a "SINGLE LICENSE" you may install and use the
 *     PRODUCT on/from one workstation that is located/accessible at/from
 *     any of your premises.
 *  7. Additional copies of the PRODUCT may be installed and used on/from
 *     more than one workstation, limited to the number of workstations
 *     purchased per order.
 *  8. If you purchased a "SITE LICENSE", the PRODUCT may be installed
 *     and used on/from all workstations located/accessible at/from any
 *     of your premises.
 *  9. You may incorporate the unmodified PRODUCT into your own products
 *     and software.
 * 10. If you purchased a license with the "SOURCE CODE" option, you may
 *     modify the PRODUCT's source code and incorporate the modified source
 *     code into your own products and/or software.
 * 11. Provided that the license validity period has not expired, you may
 *     distribute your product and/or software with the incorporated
 *     PRODUCT royalty-free.
 * 12. You may make copies of the PRODUCT for backup and archival purposes.
 * 13. Any form of redistribution requires confirmation and signature of
 *     the COMMERCIAL USE by successfully calling the method:
 *        License.iConfirmCommercialUse(...)
 *     The method call is used only internally for logging purposes, and
 *     there is no connection with other external services, and no data is
 *     sent or collected. The lack of a method call (or its successful call)
 *     does not affect the operation of the PRODUCT in any way. Please see
 *     the API documentation.
 * 14. The AUTHOR & PUBLISHER reserve all rights not expressly granted to
 *     you in this agreement.
 *
 * ADDITIONAL CLARIFICATION ON WORKSTATION
 *
 * A workstation is a device, a remote device, or a virtual device, used by
 * you, your employees, or other entities to whom you have commissioned
 * tasks. For example, the number of workstations may refer to the number
 * of software developers, engineers, architects, scientists, and other
 * professionals who use the PRODUCT on your behalf. The number of
 * workstations is not the number of copies of your end-product that you
 * distribute to your end-users.
 *
 * By purchasing the COMMERCIAL LICENSE, you only pay for the number of
 * workstations, while the number of copies/users of your final product
 * (delivered to your end-users) is not limited.
 *
 * Below are some examples to help you select the right license size:
 *
 * Example 1: Single Workstation License
 * Only one developer works on the development of your application. You do
 * not use separate environments for testing, meaning you design, create,
 * test, and compile your final application on one environment. In this
 * case, you need a license for a single workstation.
 *
 * Example 2: Up to 5 Workstations License
 * Two developers are working on the development of your application.
 * Additionally, one tester conducts tests in a separate environment.
 * You use three workstations in total, so you need a license for up to
 * five workstations.
 *
 * Example 3: Up to 20 Workstations License
 * Ten developers are working on the development of your application.
 * Additionally, five testers conduct tests in separate environments.
 * You use fifteen workstations in total, so you need a license for
 * up to twenty workstations.
 *
 * Example 4: Site License
 * Several dozen developers and testers work on the development of your
 * application using multiple environments. You have a large,
 * multi-disciplinary team involved in creating your solution. As your team
 * is growing and you want to avoid licensing limitations, the best choice
 * would be a site license.
 *
 * UPGRADE POLICY
 *
 * The PRODUCT is versioned according to the following convention:
 *
 *    [MAJOR].[MINOR].[PATCH]
 *
 * 1. COMMERCIAL LICENSE holders can install and use the updated version
 *    for bug fixes free of charge, i.e. if you have purchased a license
 *    for the [MAJOR].[MINOR] version (e.g., 5.0), you can freely install
 *    all releases specified in the [PATCH] version (e.g., 5.0.2).
 *    The license terms remain unchanged after the update.
 * 2. COMMERCIAL LICENSE holders for the [MAJOR].[MINOR] version (e.g., 5.0)
 *    can install and use the updated version [MAJOR].[MINOR + 1] free of
 *    charge, i.e., plus one release in the [MINOR] range (e.g., 5.1). The
 *    license terms remain unchanged after the update.
 * 3. COMMERCIAL LICENSE holders who wish to upgrade their version, but are
 *    not eligible for the free upgrade, can claim a discount when
 *    purchasing the upgrade. For this purpose, please contact us via e-mail.
 *
 * DISCLAIMER
 *
 * THIS PRODUCT IS PROVIDED BY THE AUTHOR & PUBLISHER "AS IS" AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL AUTHOR OR PUBLISHER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS PRODUCT, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 *
 * THE VIEWS AND CONCLUSIONS CONTAINED IN THE PRODUCT AND DOCUMENTATION ARE
 * THOSE OF THE AUTHORS AND SHOULD NOT BE INTERPRETED AS REPRESENTING
 * OFFICIAL POLICIES, EITHER EXPRESSED OR IMPLIED, OF THE AUTHOR OR PUBLISHER.
 *
 * CONTACT
 *
 * - e-mail: info@mathparser.org
 * - website: https://mathparser.org
 * - source code: https://github.com/mariuszgromada/MathParser.org-mXparser
 * - online store: https://mathparser.org/order-commercial-license
 * - online store: https://payhip.com/infima
 */
package org.mariuszgromada.math.mxparser;

/**
 * A class containing definition of French user language
 *
 * @author         <b>Mariusz Gromada</b><br>
 *                 <a href="https://mathparser.org" target="_blank">MathParser.org - mXparser project page</a><br>
 *                 <a href="https://github.com/mariuszgromada/MathParser.org-mXparser" target="_blank">mXparser on GitHub</a><br>
 *                 <a href="https://payhip.com/INFIMA" target="_blank">INFIMA place to purchase a commercial MathParser.org-mXparser software license</a><br>
 *                 <a href="mailto:info@mathparser.org">info@mathparser.org</a><br>
 *                 <a href="https://scalarmath.org/" target="_blank">ScalarMath.org - a powerful math engine and math scripting language</a><br>
 *                 <a href="https://play.google.com/store/apps/details?id=org.mathparser.scalar.lite" target="_blank">Scalar Lite</a><br>
 *                 <a href="https://play.google.com/store/apps/details?id=org.mathparser.scalar.pro" target="_blank">Scalar Pro</a><br>
 *                 <a href="https://mathspace.pl" target="_blank">MathSpace.pl</a><br>
 *
 * @version        6.0.0
 *
 * @see StringResources
 * @see StringModel
 * @see StringModel#setStringResources(StringResources)
 * @see StringModel#getStringResources()
 */
class StringResourcesFrench extends StringResources {
    StringResourcesFrench() {
        USER_LANGUAGE = "Français";
        // -------------------------------------------------
        STARTING_SYNTAX_CHECK = "Début de la vérification de la syntaxe...";
        NO_ERRORS_DETECTED = "Aucune erreur détectée.";
        NO_ERRORS_DETECTED_IN_ARGUMENT_DEFINITION = "Aucune erreur détectée dans la définition de l'argument.";
        NO_ERRORS_DETECTED_IN_RECURSIVE_ARGUMENT_DEFINITION = "Aucune erreur détectée dans la définition récursive de l'argument.";
        NO_ERRORS_DETECTED_IN_FUNCTION_DEFINITION = "Aucune erreur détectée dans la définition de la fonction.";
        NO_ERRORS_DETECTED_IN_CONSTANT_DEFINITION = "Aucune erreur détectée dans la définition de la constante.";
        LEXICAL_ERROR_HAS_BEEN_FOUND = "Une erreur lexicale a été trouvée.";
        ERRORS_HAVE_BEEN_FOUND = "Des erreurs ont été trouvées.";
        ALREADY_CHECKED_NO_ERRORS = "La syntaxe a déjà été vérifiée - aucune erreur détectée.";
        SYNTAX_STATUS_UNKNOWN = "Le statut de la syntaxe est inconnu.";
        PROBLEM_WITH_EXPRESSION_SYNTAX = "Il y a un problème avec la syntaxe de l'expression.";
        // -------------------------------------------------
        ENCOUNTERED = "Rencontré";
        AT_INDEX = "à l'indice";
        WAS_EXPECTING = "Attendu";
        WAS_EXPECTING_ONE_OF = "L'un des suivants était attendu";
        UNEXPECTED_EXCEPTION_WAS_ENCOUNTERED = "Une exception inattendue a été rencontrée. Probablement une erreur de parsing - veuillez le signaler.";
        UNEXPECTED_TOKEN_MANAGER_ERROR_WAS_ENCOUNTERED = "Une erreur inattendue du gestionnaire de jetons a été rencontrée. Probablement une erreur de parsing - veuillez le signaler.";
        // -------------------------------------------------
        EXPRESSION_STRING_IS_EMPTY = "La chaîne d'expression est vide.";
        EXPRESSION_DOES_NOT_CONTAIN_ANY_TOKENS = "L'expression ne contient aucun jeton.";
        DUPLICATED_KEYWORD = "Des mots-clés dupliqués ont été détecté. Vérifiez les éléments définis par l'utilisateur. Envisagez d'utiliser l'option pour remplacer les tokens intégrés.";
        ELEMENT = "Élément";
        ERROR = "Erreur";
        EXCEPTION = "Exception";
        TOKEN = "Jeton";
        INDEX = "indice";
        INVALID_TOKEN = "Jeton invalide.";
        INVALID_TOKEN_POSSIBLY_MISSING_MULTIPLICATION_OPERATOR = "Jeton invalide, opérateur de multiplication probablement manquant - essayez le mode de multiplication implicite.";
        EXPRESSION_TOKENS = "Jetons de l'expression";
        NULL_TOKENS_LIST = "Liste de jetons nulle";
        // -------------------------------------------------
        FUNCTION_WITH_EXTENDED_BODY_NO_ERRORS = "Fonction définie par l'utilisateur avec un corps étendu - aucune erreur par hypothèse.";
        ARGUMENT_WITH_EXTENDED_BODY_NO_ERRORS = "Argument défini par l'utilisateur avec un corps étendu - aucune erreur par hypothèse.";
        PROVIDED_EXTENSION_IS_NULL = "L'extension fournie est nulle.";
        PROVIDED_STRING_IS_NULL = "La chaîne fournie est nulle.";
        PROVIDED_ELEMENTS_ARE_NULL = "Les éléments fournis sont nuls.";
        MULTIPLICATION_OPERATOR_MISSING_TRY_IMPLIED_MULTIPLICATION_MODE = "Opérateur de multiplication probablement manquant - testez le mode de multiplication implicite.";
        // -------------------------------------------------
        STARTING_SYNTAX_CHECK_DEPENDENT_ARGUMENT = "Début de la vérification de syntaxe de l'argument dépendant défini par l'utilisateur.";
        STARTING_SYNTAX_CHECK_RECURSIVE_ARGUMENT = "Début de la vérification de syntaxe de l'argument récursif défini par l'utilisateur.";
        STARTING_SYNTAX_CHECK_USER_DEFINED_FUNCTION = "Début de la vérification de syntaxe de la fonction définie par l'utilisateur.";
        STARTING_SYNTAX_CHECK_VARIADIC_USER_DEFINED_FUNCTION = "Début de la vérification de syntaxe de la fonction variadique définie par l'utilisateur.";
        // -------------------------------------------------
        ARGUMENT_WAS_EXPECTED = "Un argument défini par l'utilisateur était attendu.";
        RECURSIVE_ARGUMENT_EXPECTING_1_PARAMETER = "Un argument récursif défini par l'utilisateur nécessite un paramètre.";
        // -------------------------------------------------
        INCORRECT_NUMBER_OF_PARAMETERS_IN_USER_DEFINED_FUNCTION = "Nombre incorrect de paramètres dans la fonction définie par l'utilisateur.";
        // -------------------------------------------------
        INCORRECT_NUMBER_OF_FUNCTION_PARAMETERS = "Nombre incorrect de paramètres de fonction.";
        EXPECTED = "Attendu";
        PROVIDED = "Fourni";
        USER_DEFINED_FUNCTION_EXPECTING_AT_LEAST_ONE_ARGUMENT = "Nombre incorrect de paramètres dans la fonction définie par l'utilisateur - au moins un argument est attendu.";
        EXPECTED_EVEN_NUMBER_OF_ARGUMENTS = "Un nombre pair d'arguments était attendu.";
        // -------------------------------------------------
        INVALID_FUNCTION_NAME = "Nom de fonction invalide.";
        INVALID_ARGUMENT_NAME = "Nom d'argument invalide.";
        INVALID_CONSTANT_NAME = "Nom de constante invalide.";
        INVALID_FUNCTION_DEFINITION = "Définition de fonction invalide.";
        INVALID_ARGUMENT_DEFINITION = "Définition d'argument invalide.";
        INVALID_CONSTANT_DEFINITION = "Définition de constante invalide.";
        PATTERN_DOES_NOT_MATCH = "Le motif ne correspond pas.";
        PATTERN_EXAMPLES = "Exemples de motif";
        // -------------------------------------------------
        CONSTANT_WAS_EXPECTED = "Une valeur constante était attendue.";
        USER_CONSTANT_WAS_EXPECTED = "Une constante définie par l'utilisateur était attendue.";
        // -------------------------------------------------
        UNARY_FUNCTION_EXPECTS_1_PARAMETER = "Une fonction unaire attend 1 paramètre.";
        BINARY_FUNCTION_EXPECTS_2_PARAMETERS = "Une fonction binaire attend 2 paramètres.";
        TERNARY_FUNCTION_EXPECTS_3_PARAMETERS = "Une fonction ternaire attend 3 paramètres.";
        // -------------------------------------------------
        DERIVATIVE_OPERATOR_EXPECTS_2_OR_3_OR_4_OR_5_CALCULUS_PARAMETERS = "L'opérateur de dérivation attend 2, 3, 4 ou 5 paramètres de calcul.";
        ARGUMENT_WAS_EXPECTED_IN_A_DERIVATIVE_OPERATOR_INVOCATION = "Un argument était attendu dans une invocation de l'opérateur de dérivation.";
        DUPLICATED_KEYWORDS_WERE_FOUND_IN_THE_CALCULUS_OPERATOR_INVOCATION = "Des mots-clés dupliqués ont été trouvés dans l'invocation de l'opérateur de calcul, vérifiez les paramètres de calcul.";
        ONE_TOKEN_WAS_EXPECTED_IN_THE_CALCULUS_OPERATOR_INVOCATION = "Un jeton (argument ou inconnu) était attendu dans l'invocation de l'opérateur de calcul.";
        NTH_ORDER_DERIVATIVE_OPERATOR_EXPECTS_3_OR_5_CALCULUS_PARAMETERS = "L'opérateur de dérivation d'ordre N attend 3 ou 5 paramètres de calcul.";
        INTEGRAL_SOLVE_OPERATOR_EXPECTS_4_CALCULUS_PARAMETERS = "L'opérateur d'intégrale/solution attend 4 paramètres de calcul.";
        ITERATED_OPERATOR_EXPECTS_4_OR_5_CALCULUS_PARAMETERS = "L'opérateur itéré attend 4 ou 5 paramètres de calcul.";
        FORWARD_BACKWARD_DIFFERENCE_EXPECTS_2_OR_3_PARAMETERS = "L'opérateur de différence avant/arrière attend 2 ou 3 paramètres de calcul.";
        FORWARD_BACKWARD_DIFFERENCE_ARGUMENT_WAS_EXPECTED = "Un argument était attendu dans l'invocation de l'opérateur de différence avant/arrière.";
        AT_LEAST_ONE_ARGUMENT_WAS_EXPECTED = "Au moins un argument était attendu.";
        // -------------------------------------------------
        ERROR_WHILE_EXECUTING_THE_CALCULATE = "Erreur lors de l'exécution du calcul.";
        RECURSION_CALLS_COUNTER_EXCEEDED = "Le compteur d'appels récursifs a été dépassé.";
        RECURSION_CALLS_COUNTER = "Compteur d'appels récursifs";
        STARTING_CALCULATION_LOOP = "Début de la boucle de calcul.";
        CANCEL_REQUEST_FINISHING = "Demande d'annulation rencontrée - finalisation.";
        INTERNAL_ERROR_STRANGE_TOKEN_LEVEL_FINISHING = "Erreur interne/niveau de jeton étrange - finalisation. Probablement une erreur de parsing - veuillez le signaler.";
        FATAL_ERROR_DO_NOT_KNOW_WHAT_TO_DO_WITH_THE_ENCOUNTERED_TOKEN = "Erreur fatale, on ne sait pas quoi faire avec le jeton rencontré. Probablement une erreur de parsing - veuillez le signaler.";
        MAXIMUM_ERROR_MESSAGE_LENGTH_EXCEEDED = "La longueur maximale du message d'erreur a été dépassée.";
        // -------------------------------------------------
        STARTING = "Début...";
        PARSING = "Analyse";
        FULLY_COMPILED = "Entièrement compilé";
        CALCULATED_VALUE = "Valeur calculée";
        EXITING = "Sortie.";
        DONE = "terminé.";
        // -------------------------------------------------
        KEYWORD = "Mot-clé";
        SYNTAX = "Syntaxe";
        NUMBER = "Nombre";
        NUMBER_LITERAL = "Littéral numérique";
        TYPE = "Type";
        SINCE = "Depuis";
        DESCRIPTION = "Description";
        // -------------------------------------------------
        CALC_STEPS_REGISTER_IS_EMPTY = "Le registre des étapes de calcul est vide.";
        CALC_STEPS_REGISTER_FOR = "Registre des étapes de calcul pour";
        ARGUMENT = "Argument";
        FUNCTION = "Fonction";
        EXPRESSION = "Expression";
        RESULT = "résultat";
        COMPUTING_TIME = "Temps de calcul";
        GROUP_SHORT = "groupe";
        NUMBER_SHORT = "n°";
        FIRST = "premier";
        LAST = "dernier";
        DESCRIPTION_SHORT = "descr.";
        STEP = "étape";
        // -------------------------------------------------
        SERIALIZATION_PERFORMED = "La sérialisation a été effectuée :";
        DESERIALIZATION_PERFORMED = "La désérialisation a été effectuée :";
        NULL_OBJECT_PROVIDED = "Un objet nul a été fourni.";
        NULL_FILE_PATH_PROVIDED = "Un chemin de fichier nul a été fourni.";
        FILE_PATH_ZERO_LENGTH_PROVIDED = "Le chemin du fichier ne contient aucun caractère.";
        FILE_PATH_IS_NOT_A_FILE = "Le chemin du fichier n'est pas un fichier :";
        FILE_PATH_NOT_EXISTS = "Le chemin du fichier n'existe pas :";
        NULL_DATA_PROVIDED = "Des données nulles ont été fournies.";
        BINARY_SERIALIZATION_ENABLED = "La sérialisation binaire est activée. Utilisez-la uniquement de manière consciente et limitée.";
        BINARY_SERIALIZATION_DISABLED = "La sérialisation binaire est désactivée. Vous pouvez l'activer si vous êtes conscient des risques de sécurité.";
        // -------------------------------------------------
        USER_DEFINED_EXPRESSION = "Expression définie par l'utilisateur";
        USER_DEFINED_ARGUMENT = "Argument défini par l'utilisateur";
        USER_DEFINED_CONSTANT = "Constante définie par l'utilisateur";
        USER_DEFINED_FUNCTION = "Fonction définie par l'utilisateur";
        USER_DEFINED_RECURSIVE_ARGUMENT = "Argument récursif défini par l'utilisateur";
        // -------------------------------------------------
        HELP_CONTENT_LIMITED_TO_QUERY = "Contenu d'aide limité à la requête";
        ALL_HELP_CONTENT = "Tout le contenu d'aide.";
        CAPTION = "Légende";
        // -------------------------------------------------
        WARNING_BINARY_SERIALIZATION_SECURITY_RISKS = "AVERTISSEMENT DE SÉCURITÉ:" + StringInvariant.NEW_LINE
                + "La désérialisation des données provenant d'une source non fiable peut introduire des vulnérabilités" + StringInvariant.NEW_LINE
                + "de sécurité dans votre application. En fonction des paramètres utilisés lors de la désérialisation," + StringInvariant.NEW_LINE
                + "les données non fiables peuvent être en mesure d'exécuter du code arbitraire ou de provoquer une" + StringInvariant.NEW_LINE
                + "attaque par déni de service. Les données non fiables peuvent provenir du réseau à partir" + StringInvariant.NEW_LINE
                + "d'une source non fiable (par exemple, n'importe quel client du réseau), ou elles peuvent être" + StringInvariant.NEW_LINE
                + "manipulées/altérées par un intermédiaire pendant leur transit sur une connexion non authentifiée," + StringInvariant.NEW_LINE
                + "ou à partir d'un stockage local où elles peuvent avoir été compromises/altérées, ou de" + StringInvariant.NEW_LINE
                + "nombreuses autres sources. MathParser.org-mXparser n'offre aucun moyen d'authentifier les données" + StringInvariant.NEW_LINE
                + "ou de les sécuriser contre la falsification. Utilisez une méthode d'authentification des données" + StringInvariant.NEW_LINE
                + "appropriée avant la désérialisation. Soyez très conscient de ces scénarios d'attaque ; de nombreux" + StringInvariant.NEW_LINE
                + "projets et entreprises et utilisateurs de bibliothèques de sérialisation en général ont été mordus" + StringInvariant.NEW_LINE
                + "par la désérialisation non fiable des données utilisateur par le passé." + StringInvariant.NEW_LINE
        ;
        // -------------------------------------------------
        BINARY_RELATION = "Relation binaire";
        BITWISE_OPERATOR = "Opérateur bit à bit";
        BOOLEAN_OPERATOR = "Opérateur booléen";
        CALCULUS_OPERATOR = "Opérateur de calcul";
        CONSTANT_VALUE = "Valeur constante";
        FUNCTION_1_ARG = "Fonction unaire";
        FUNCTION_2_ARG = "Fonction binaire";
        FUNCTION_3_ARG = "Fonction ternaire";
        FUNCTION_VARIADIC = "Fonction variadique";
        OPERATOR = "Opérateur";
        PARSER_SYMBOL = "Symbole de l'analyseur";
        RANDOM_VARIABLE = "Variable aléatoire";
        UNIT = "Unité";
        DIMENSIONLESS_UNIT = "Unité sans dimension";
        ITERATED_OPERATOR = "Opérateur itéré";
        // -------------------------------------------------
        RATIO_FRACTION = "Ratio / Fraction";
        METRIC_PREFIX = "Préfixe métrique";
        UNIT_OF_LENGTH = "Unité de longueur";
        UNIT_OF_AREA = "Unité de surface";
        UNIT_OF_VOLUME = "Unité de volume";
        UNIT_OF_TIME = "Unité de temps";
        UNIT_OF_MASS = "Unité de masse";
        UNIT_OF_INFORMATION = "Unité d'information";
        UNIT_OF_ENERGY = "Unité d'énergie";
        UNIT_OF_SPEED = "Unité de vitesse";
        UNIT_OF_ACCELERATION = "Unité d'accélération";
        UNIT_OF_ANGLE = "Unité d'angle";
        // -------------------------------------------------
        PHYSICAL_CONSTANT = "Constante physique";
        ASTRONOMICAL_CONSTANT = "Constante astronomique";
        MATHEMATICAL_CONSTANT = "Constante mathématique";
        // -------------------------------------------------
        PROBABILITY_DISTRIBUTION_FUNCTION = "Fonction de distribution de probabilité";
        CUMULATIVE_DISTRIBUTION_FUNCTION = "Fonction de distribution cumulative";
        QUANTILE_FUNCTION = "Fonction quantile (fonction inverse de distribution cumulative)";
        // -------------------------------------------------
        STUDENTS_T_DISTRIBUTION = "Distribution t de Student";
        CHI_SQUARED_DISTRIBUTION = "Distribution du khi carré";
        SNEDECORS_F_DISTRIBUTION = "Distribution F de Snedecor (distribution F ou rapport F, également connue sous le nom de distribution de Fisher-Snedecor)";
        UNIFORM_CONTINUOUS_DISTRIBUTION = "Distribution continue uniforme";
        UNIFORM_DISCRETE_DISTRIBUTION = "Distribution discrète uniforme";
        NORMAL_DISTRIBUTION = "Distribution normale";
        // -------------------------------------------------
        RANDOM_INTEGER = "Entier aléatoire";
        RANDOM_NATURAL_NUMBER = "Nombre naturel aléatoire";
        RANDOM_NATURAL_NUMBER_INCLUDING_0 = "Nombre naturel aléatoire incluant 0";
        // -------------------------------------------------
        SPECIAL_FUNCTION = "Fonction spéciale";
        // -------------------------------------------------
        SEMI_MAJOR_AXIS = "Demi-grand axe";
        // -------------------------------------------------
        BINARY_RELATION_EQ = "Égalité";
        BINARY_RELATION_NEQ = "Inéquation";
        BINARY_RELATION_LT = "Inférieur à";
        BINARY_RELATION_GT = "Supérieur à";
        BINARY_RELATION_LEQ = "Inférieur ou égal à";
        BINARY_RELATION_GEQ = "Supérieur ou égal à";
        // -------------------------------------------------
        BITWISE_OPERATOR_COMPL = "Complément unaire bit à bit (NOT)";
        BITWISE_OPERATOR_AND = "Et bit à bit (AND)";
        BITWISE_OPERATOR_XOR = "Ou exclusif bit à bit (XOR)";
        BITWISE_OPERATOR_OR = "Ou inclusif bit à bit (OR)";
        BITWISE_OPERATOR_LEFT_SHIFT = "Décalage à gauche signé bit à bit";
        BITWISE_OPERATOR_RIGHT_SHIFT = "Décalage à droite signé bit à bit";
        BITWISE_OPERATOR_NAND = "Non et bit à bit (NAND)";
        BITWISE_OPERATOR_NOR = "Non ou bit à bit (NOR)";
        BITWISE_OPERATOR_XNOR = "Non exclusif ou bit à bit (XNOR)";
        // -------------------------------------------------
        BOOLEAN_OPERATOR_AND = "Conjonction logique";
        BOOLEAN_OPERATOR_OR = "Disjonction logique";
        BOOLEAN_OPERATOR_NEG = "Négation";
        BOOLEAN_OPERATOR_NAND = "Fonction NAND";
        BOOLEAN_OPERATOR_NOR = "Non ou logique (dénégation conjointe)";
        BOOLEAN_OPERATOR_XOR = "Ou exclusif";
        BOOLEAN_OPERATOR_IMP = "Implication";
        BOOLEAN_OPERATOR_CIMP = "Implication converse";
        BOOLEAN_OPERATOR_NIMP = "Non-implication matérielle";
        BOOLEAN_OPERATOR_CNIMP = "Non-implication converse";
        BOOLEAN_OPERATOR_EQV = "Biconditionnel logique";
        // -------------------------------------------------
        CALCULUS_OPERATOR_SUM = "Somme SIGMA";
        CALCULUS_OPERATOR_PROD = "Produit PI";
        CALCULUS_OPERATOR_INT = "Intégrale définie";
        CALCULUS_OPERATOR_DER = "Dérivée";
        CALCULUS_OPERATOR_DER_LEFT = "Dérivée à gauche";
        CALCULUS_OPERATOR_DER_RIGHT = "Dérivée à droite";
        CALCULUS_OPERATOR_DERN = "n-ième dérivée";
        CALCULUS_OPERATOR_FORW_DIFF = "Différence avant";
        CALCULUS_OPERATOR_BACKW_DIFF = "Différence arrière";
        CALCULUS_OPERATOR_AVG = "Moyenne";
        CALCULUS_OPERATOR_VAR = "Variance échantillonnale corrigée";
        CALCULUS_OPERATOR_STD = "Écart type échantillonnal corrigé";
        CALCULUS_OPERATOR_MIN = "Valeur minimale";
        CALCULUS_OPERATOR_MAX = "Valeur maximale";
        CALCULUS_OPERATOR_SOLVE = "Résolution d'équation (recherche de racine)";
        // -------------------------------------------------
        CONSTANT_VALUE_PI = "Pi, nombre d'Archimède ou de Ludolph";
        CONSTANT_VALUE_EULER = "Nombre de Napier ou d'Euler (base du logarithme naturel)";
        CONSTANT_VALUE_EULER_MASCHERONI = "Constante d'Euler-Mascheroni";
        CONSTANT_VALUE_GOLDEN_RATIO = "Ratio doré";
        CONSTANT_VALUE_PLASTIC = "Constante plastique";
        CONSTANT_VALUE_EMBREE_TREFETHEN = "Constante d'Embree-Trefethen";
        CONSTANT_VALUE_FEIGENBAUM_DELTA = "Constante delta de Feigenbaum";
        CONSTANT_VALUE_FEIGENBAUM_ALPHA = "Constante alpha de Feigenbaum";
        CONSTANT_VALUE_TWIN_PRIME = "Constante des nombres premiers jumeaux";
        CONSTANT_VALUE_MEISSEL_MERTEENS = "Constante de Meissel-Mertens";
        CONSTANT_VALUE_BRAUN_TWIN_PRIME = "Constante de Brun pour les nombres premiers jumeaux";
        CONSTANT_VALUE_BRAUN_PRIME_QUADR = "Constante de Brun pour les quadruplets premiers";
        CONSTANT_VALUE_BRUIJN_NEWMAN = "Constante de de Bruijn-Newman";
        CONSTANT_VALUE_CATALAN = "Constante de Catalan";
        CONSTANT_VALUE_LANDAU_RAMANUJAN = "Constante de Landau-Ramanujan";
        CONSTANT_VALUE_VISWANATH = "Constante de Viswanath";
        CONSTANT_VALUE_LEGENDRE = "Constante de Legendre";
        CONSTANT_VALUE_RAMANUJAN_SOLDNER = "Constante de Ramanujan-Soldner";
        CONSTANT_VALUE_ERDOS_BORWEIN = "Constante de Erdos-Borwein";
        CONSTANT_VALUE_BERNSTEIN = "Constante de Bernstein";
        CONSTANT_VALUE_GAUSS_KUZMIN_WIRSING = "Constante de Gauss-Kuzmin-Wirsing";
        CONSTANT_VALUE_HAFNER_SARNAK_MCCURLEY = "Constante de Hafner-Sarnak-McCurley";
        CONSTANT_VALUE_GOLOMB_DICKMAN = "Constante de Golomb-Dickman";
        CONSTANT_VALUE_CAHEN = "Constante de Cahen";
        CONSTANT_VALUE_LAPLACE_LIMIT = "Constante de limite de Laplace";
        CONSTANT_VALUE_ALLADI_GRINSTEAD = "Constante de Alladi-Grinstead";
        CONSTANT_VALUE_LENGYEL = "Constante de Lengyel";
        CONSTANT_VALUE_LEVY = "Constante de Levy";
        CONSTANT_VALUE_APERY = "Constante d'Apery";
        CONSTANT_VALUE_MILLS = "Constante de Mills";
        CONSTANT_VALUE_BACKHOUSE = "Constante de Backhouse";
        CONSTANT_VALUE_PORTER = "Constante de Porter";
        CONSTANT_VALUE_LIEB_QUARE_ICE = "Constante de glace carrée de Lieb";
        CONSTANT_VALUE_NIVEN = "Constante de Niven";
        CONSTANT_VALUE_SIERPINSKI = "Constante de Sierpinski";
        CONSTANT_VALUE_KHINCHIN = "Constante de Khinchin";
        CONSTANT_VALUE_FRANSEN_ROBINSON = "Constante de Fransen-Robinson";
        CONSTANT_VALUE_LANDAU = "Constante de Landau";
        CONSTANT_VALUE_PARABOLIC = "Constante parabolique";
        CONSTANT_VALUE_OMEGA = "Constante Omega";
        CONSTANT_VALUE_MRB = "Constante MRB";
        CONSTANT_VALUE_LI2 = "Intégrale logarithmique au point 2";
        CONSTANT_VALUE_GOMPERTZ = "Constante de Gompertz";
        CONSTANT_VALUE_LIGHT_SPEED = "Vitesse de la lumière dans le vide";
        CONSTANT_VALUE_GRAVITATIONAL_CONSTANT = "Constante gravitationnelle";
        CONSTANT_VALUE_GRAVIT_ACC_EARTH = "Accélération due à la gravité sur Terre";
        CONSTANT_VALUE_PLANCK_CONSTANT = "Constante de Planck";
        CONSTANT_VALUE_PLANCK_CONSTANT_REDUCED = "Constante de Planck réduite (constante de Dirac)";
        CONSTANT_VALUE_PLANCK_LENGTH = "Longueur de Planck";
        CONSTANT_VALUE_PLANCK_MASS = "Masse de Planck";
        CONSTANT_VALUE_PLANCK_TIME = "Temps de Planck";
        CONSTANT_VALUE_LIGHT_YEAR = "Année-lumière";
        CONSTANT_VALUE_ASTRONOMICAL_UNIT = "Unité astronomique";
        CONSTANT_VALUE_PARSEC = "Parsec";
        CONSTANT_VALUE_KILOPARSEC = "Kiloparsec";
        CONSTANT_VALUE_EARTH_RADIUS_EQUATORIAL = "Rayon équatorial de la Terre";
        CONSTANT_VALUE_EARTH_RADIUS_POLAR = "Rayon polaire de la Terre";
        CONSTANT_VALUE_EARTH_RADIUS_MEAN = "Rayon moyen de la Terre";
        CONSTANT_VALUE_EARTH_MASS = "Masse de la Terre";
        CONSTANT_VALUE_EARTH_SEMI_MAJOR_AXIS = "Distance Terre-Soleil";
        CONSTANT_VALUE_MOON_RADIUS_MEAN = "Rayon moyen de la Lune";
        CONSTANT_VALUE_MOON_MASS = "Masse de la Lune";
        CONSTANT_VALUE_MOON_SEMI_MAJOR_AXIS = "Distance Lune-Terre";
        CONSTANT_VALUE_SOLAR_RADIUS = "Rayon moyen du Soleil";
        CONSTANT_VALUE_SOLAR_MASS = "Masse solaire";
        CONSTANT_VALUE_MERCURY_RADIUS_MEAN = "Rayon moyen de Mercure";
        CONSTANT_VALUE_MERCURY_MASS = "Masse de Mercure";
        CONSTANT_VALUE_MERCURY_SEMI_MAJOR_AXIS = "Distance Mercure-Soleil";
        CONSTANT_VALUE_VENUS_RADIUS_MEAN = "Rayon moyen de Vénus";
        CONSTANT_VALUE_VENUS_MASS = "Masse de Vénus";
        CONSTANT_VALUE_VENUS_SEMI_MAJOR_AXIS = "Distance Vénus-Soleil";
        CONSTANT_VALUE_MARS_RADIUS_MEAN = "Rayon moyen de Mars";
        CONSTANT_VALUE_MARS_MASS = "Masse de Mars";
        CONSTANT_VALUE_MARS_SEMI_MAJOR_AXIS = "Distance Mars-Soleil";
        CONSTANT_VALUE_JUPITER_RADIUS_MEAN = "Rayon moyen de Jupiter";
        CONSTANT_VALUE_JUPITER_MASS = "Masse de Jupiter";
        CONSTANT_VALUE_JUPITER_SEMI_MAJOR_AXIS = "Distance Jupiter-Soleil";
        CONSTANT_VALUE_SATURN_RADIUS_MEAN = "Rayon moyen de Saturne";
        CONSTANT_VALUE_SATURN_MASS = "Masse de Saturne";
        CONSTANT_VALUE_SATURN_SEMI_MAJOR_AXIS = "Distance Saturne-Soleil";
        CONSTANT_VALUE_URANUS_RADIUS_MEAN = "Rayon moyen d'Uranus";
        CONSTANT_VALUE_URANUS_MASS = "Masse d'Uranus";
        CONSTANT_VALUE_URANUS_SEMI_MAJOR_AXIS = "Distance Uranus-Soleil";
        CONSTANT_VALUE_NEPTUNE_RADIUS_MEAN = "Rayon moyen de Neptune";
        CONSTANT_VALUE_NEPTUNE_MASS = "Masse de Neptune";
        CONSTANT_VALUE_NEPTUNE_SEMI_MAJOR_AXIS = "Distance Neptune-Soleil";
        CONSTANT_VALUE_TRUE = "Booléen Vrai représenté par 1";
        CONSTANT_VALUE_FALSE = "Booléen Faux représenté par 1";
        CONSTANT_VALUE_NPAR = "Constante générée automatiquement pour les fonctions définies par l'utilisateur, renvoie le nombre de paramètres de la fonction donnée";
        CONSTANT_VALUE_NAN = "Non-un-Nombre";
        // -------------------------------------------------
        FUNCTION_1_ARG_SIN = "Sinus trigonométrique";
        FUNCTION_1_ARG_COS = "Cosinus trigonométrique";
        FUNCTION_1_ARG_TAN = "Tangente trigonométrique";
        FUNCTION_1_ARG_CTAN = "Cotangente trigonométrique";
        FUNCTION_1_ARG_SEC = "Sécante trigonométrique";
        FUNCTION_1_ARG_COSEC = "Cosecante trigonométrique";
        FUNCTION_1_ARG_ASIN = "Sinus inverse trigonométrique";
        FUNCTION_1_ARG_ACOS = "Cosinus inverse trigonométrique";
        FUNCTION_1_ARG_ATAN = "Tangente inverse trigonométrique";
        FUNCTION_1_ARG_ACTAN = "Cotangente inverse trigonométrique";
        FUNCTION_1_ARG_LN = "Logarithme naturel (base e)";
        FUNCTION_1_ARG_LOG2 = "Logarithme binaire (base 2)";
        FUNCTION_1_ARG_LOG10 = "Logarithme commun (base 10)";
        FUNCTION_1_ARG_RAD = "Degrés à radians";
        FUNCTION_1_ARG_EXP = "Exponentielle";
        FUNCTION_1_ARG_SQRT = "Racine carrée";
        FUNCTION_1_ARG_SINH = "Sinus hyperbolique";
        FUNCTION_1_ARG_COSH = "Cosinus hyperbolique";
        FUNCTION_1_ARG_TANH = "Tangente hyperbolique";
        FUNCTION_1_ARG_COTH = "Cotangente hyperbolique";
        FUNCTION_1_ARG_SECH = "Sécante hyperbolique";
        FUNCTION_1_ARG_CSCH = "Cosecante hyperbolique";
        FUNCTION_1_ARG_DEG = "Radians à degrés";
        FUNCTION_1_ARG_ABS = "Valeur absolue";
        FUNCTION_1_ARG_SGN = "Signum";
        FUNCTION_1_ARG_FLOOR = "Plancher";
        FUNCTION_1_ARG_CEIL = "Plafond";
        FUNCTION_1_ARG_NOT = "Négation";
        FUNCTION_1_ARG_ARSINH = "Sinus hyperbolique inverse";
        FUNCTION_1_ARG_ARCOSH = "Cosinus hyperbolique inverse";
        FUNCTION_1_ARG_ARTANH = "Tangente hyperbolique inverse";
        FUNCTION_1_ARG_ARCOTH = "Cotangente hyperbolique inverse";
        FUNCTION_1_ARG_ARSECH = "Sécante hyperbolique inverse";
        FUNCTION_1_ARG_ARCSCH = "Cosecante hyperbolique inverse";
        FUNCTION_1_ARG_SA = "Sinc (normalisé)";
        FUNCTION_1_ARG_SINC = "Sinc (non normalisé)";
        FUNCTION_1_ARG_BELL_NUMBER = "Nombre de Bell";
        FUNCTION_1_ARG_LUCAS_NUMBER = "Nombre de Lucas";
        FUNCTION_1_ARG_FIBONACCI_NUMBER = "Nombre de Fibonacci";
        FUNCTION_1_ARG_HARMONIC_NUMBER = "Nombre harmonique";
        FUNCTION_1_ARG_IS_PRIME = "Test de nombre premier (le nombre est-il premier ?)";
        FUNCTION_1_ARG_PRIME_COUNT = "Comptage des nombres premiers";
        FUNCTION_1_ARG_EXP_INT = "Intégrale exponentielle";
        FUNCTION_1_ARG_LOG_INT = "Intégrale logarithmique";
        FUNCTION_1_ARG_OFF_LOG_INT = "Intégrale logarithmique décalée";
        FUNCTION_1_ARG_GAUSS_ERF = "Erreur de Gauss";
        FUNCTION_1_ARG_GAUSS_ERFC = "Erreur complémentaire de Gauss";
        FUNCTION_1_ARG_GAUSS_ERF_INV = "Erreur inverse de Gauss";
        FUNCTION_1_ARG_GAUSS_ERFC_INV = "Erreur complémentaire inverse de Gauss";
        FUNCTION_1_ARG_ULP = "Unité en dernier lieu";
        FUNCTION_1_ARG_ISNAN = "Renvoie vrai si la valeur est Non-un-Nombre (NaN), faux sinon";
        FUNCTION_1_ARG_NDIG10 = "Nombre de chiffres dans un système numérique de base 10";
        FUNCTION_1_ARG_NFACT = "Décomposition en facteurs premiers - nombre de facteurs premiers distincts";
        FUNCTION_1_ARG_ARCSEC = "Sécante trigonométrique inverse";
        FUNCTION_1_ARG_ARCCSC = "Cosecante trigonométrique inverse";
        FUNCTION_1_ARG_GAMMA = "Gamma";
        FUNCTION_1_ARG_LAMBERT_W0 = "Lambert-W, branche principale 0, également appelée logarithme omega ou produit";
        FUNCTION_1_ARG_LAMBERT_W1 = "Lambert-W, branche -1, également appelée logarithme omega ou produit";
        FUNCTION_1_ARG_SGN_GAMMA = "Signum de Gamma";
        FUNCTION_1_ARG_LOG_GAMMA = "Log Gamma";
        FUNCTION_1_ARG_DI_GAMMA = "Digamma comme dérivée logarithmique de Gamma";
        FUNCTION_1_ARG_PARAM = "Fonction générée automatiquement pour les fonctions définies par l'utilisateur, renvoie la valeur du paramètre de la fonction à l'indice 'i'";
        // -------------------------------------------------
        FUNCTION_2_ARG_LOG = "Logarithme";
        FUNCTION_2_ARG_MOD = "Modulo";
        FUNCTION_2_ARG_BINOM_COEFF = "Coefficient binomial, nombre de combinaisons de k qui peuvent être tirées d'un ensemble de n éléments";
        FUNCTION_2_ARG_BERNOULLI_NUMBER = "Nombres de Bernoulli";
        FUNCTION_2_ARG_STIRLING1_NUMBER = "Nombres de Stirling de première espèce";
        FUNCTION_2_ARG_STIRLING2_NUMBER = "Nombres de Stirling de deuxième espèce";
        FUNCTION_2_ARG_WORPITZKY_NUMBER = "Nombre de Worpitzky";
        FUNCTION_2_ARG_EULER_NUMBER = "Nombre d'Euler";
        FUNCTION_2_ARG_KRONECKER_DELTA = "Delta de Kronecker";
        FUNCTION_2_ARG_EULER_POLYNOMIAL = "Polynôme d'Euler";
        FUNCTION_2_ARG_HARMONIC_NUMBER = "Nombre harmonique";
        FUNCTION_2_ARG_ROUND = "Arrondissement à la moitié supérieure";
        FUNCTION_2_ARG_NDIG = "Nombre de chiffres représentant le nombre dans le système numérique de base donnée";
        FUNCTION_2_ARG_DIGIT10 = "Chiffre à la position 1 ... n (gauche -> droite) ou 0 ... -(n-1) (droite -> gauche) - système numérique de base 10";
        FUNCTION_2_ARG_FACTVAL = "Décomposition en facteurs premiers - valeur du facteur à la position entre 1 ... nfact(n) - ordre croissant par valeur du facteur";
        FUNCTION_2_ARG_FACTEXP = "Décomposition en facteurs premiers - exposant / multiplicité du facteur à la position entre 1 ... nfact(n) - ordre croissant par valeur du facteur";
        FUNCTION_2_ARG_ROOT = "Racine d'ordre N d'un nombre";
        FUNCTION_2_ARG_INC_GAMMA_LOWER = "Gamma incomplet inférieur";
        FUNCTION_2_ARG_INC_GAMMA_UPPER = "Gamma incomplet supérieur";
        FUNCTION_2_ARG_REG_GAMMA_LOWER = "P gamma régularisé inférieur";
        FUNCTION_2_ARG_REG_GAMMA_UPPER = "Q Gamma régularisé supérieur";
        FUNCTION_2_ARG_PERMUTATIONS = "Nombre de k-permutations qui peuvent être tirées d'un ensemble de n éléments";
        FUNCTION_2_ARG_BETA = "La Beta, également appelée intégrale d'Euler du premier genre";
        FUNCTION_2_ARG_LOG_BETA = "Le Log Beta, également appelé l'intégrale logarithmique d'Euler du premier genre";
        // -------------------------------------------------
        FUNCTION_3_ARG_IF = "Si";
        FUNCTION_3_ARG_CHI = "Fonction caractéristique pour x dans (a,b)";
        FUNCTION_3_ARG_CHI_LR = "Fonction caractéristique pour x dans [a,b]";
        FUNCTION_3_ARG_CHI_L = "Fonction caractéristique pour x dans [a,b)";
        FUNCTION_3_ARG_CHI_R = "Fonction caractéristique pour x dans (a,b]";
        FUNCTION_3_ARG_DIGIT = "Chiffre à la position 1 ... n (gauche -> droite) ou 0 ... -(n-1) (droite -> gauche) - système numérique de base donnée";
        FUNCTION_3_ARG_INC_BETA = "Beta incomplète, également appelée intégrale d'Euler incomplète du premier genre";
        FUNCTION_3_ARG_REG_BETA = "Beta incomplète régularisée (ou beta régularisée), également appelée intégrale d'Euler incomplète régularisée du premier genre";
        // -------------------------------------------------
        FUNCTION_VARIADIC_IFF = "Fonction Si";
        FUNCTION_VARIADIC_MIN = "Minimum";
        FUNCTION_VARIADIC_MAX = "Maximum";
        FUNCTION_VARIADIC_CONT_FRAC = "Fraction continue";
        FUNCTION_VARIADIC_CONT_POL = "Polynôme continu";
        FUNCTION_VARIADIC_GCD = "Plus grand commun diviseur";
        FUNCTION_VARIADIC_LCM = "Plus petit commun multiple";
        FUNCTION_VARIADIC_SUM = "Somme";
        FUNCTION_VARIADIC_PROD = "Multiplication";
        FUNCTION_VARIADIC_AVG = "Moyenne / valeur moyenne";
        FUNCTION_VARIADIC_VAR = "Variance d'échantillon corrigée";
        FUNCTION_VARIADIC_STD = "Écart type d'échantillon corrigé";
        FUNCTION_VARIADIC_RND_LIST = "Nombre aléatoire à partir d'une liste donnée de nombres";
        FUNCTION_VARIADIC_COALESCE = "Renvoie la première valeur non-NaN";
        FUNCTION_VARIADIC_OR = "Disjonction logique (OU) - variadic";
        FUNCTION_VARIADIC_AND = "Conjonction logique (ET) - variadic";
        FUNCTION_VARIADIC_XOR = "Ou exclusif (XOR) - variadic";
        FUNCTION_VARIADIC_ARGMIN = "Arguments / indices des minima";
        FUNCTION_VARIADIC_ARGMAX = "Arguments / indices des maxima";
        FUNCTION_VARIADIC_MEDIAN = "La médiane de l'échantillon";
        FUNCTION_VARIADIC_MODE = "Mode - la valeur qui apparaît le plus souvent";
        FUNCTION_VARIADIC_BASE = "Renvoie le nombre dans la base du système numérique donnée représentée par une liste de chiffres";
        FUNCTION_VARIADIC_NDIST = "Nombre de valeurs distinctes";
        // -------------------------------------------------
        OPERATOR_PLUS = "Addition";
        OPERATOR_MINUS = "Soustraction";
        OPERATOR_MULTIPLY = "Multiplication";
        OPERATOR_DIVIDE = "Division";
        OPERATOR_DIVIDE_QUOTIENT = "Division entière (quotient)";
        OPERATOR_POWER = "Exponentiation";
        OPERATOR_FACT = "Factorielle";
        OPERATOR_MOD = "Modulo";
        OPERATOR_PERC = "Pourcentage";
        OPERATOR_TETRATION = "Tétration (hyper-4, tour de puissance, tour exponentielle)";
        OPERATOR_SQUARE_ROOT = "Racine carrée";
        OPERATOR_CUBE_ROOT = "Racine cubique";
        OPERATOR_FOURTH_ROOT = "Quatrième racine";
        // -------------------------------------------------
        PARSER_SYMBOL_LEFT_PARENTHESES = "Parenthèse gauche";
        PARSER_SYMBOL_RIGHT_PARENTHESES = "Parenthèse droite";
        PARSER_SYMBOL_COMMA = "Virgule (paramètres de fonction)";
        PARSER_SYMBOL_SEMI = "Point-virgule (paramètres de fonction)";
        PARSER_SYMBOL_BLANK = "Caractère blanc (espace)";
        PARSER_SYMBOL_NUMBER_INTEGER = "Entier";
        PARSER_SYMBOL_NUMBER_DECIMAL = "Décimal";
        PARSER_SYMBOL_NUMBER_LEADING_ZERO = "Zéro initial";
        PARSER_SYMBOL_NUMBER_SCI_NOTATION = "Notation scientifique";
        PARSER_SYMBOL_NUMBER_NO_LEADING_ZERO = "Pas de zéro initial";
        PARSER_SYMBOL_NUMBER_FRACTIONS = "Fractions";
        PARSER_SYMBOL_NUMBER_OTHER_NUMERAL_SYSTEMS = "Autres systèmes numéraux";
        PARSER_SYMBOL_UNICODE_MATH = " - Symbole mathématique Unicode";
        // -------------------------------------------------
        DIMENSIONLESS_UNIT_PERC = "Pourcentage";
        DIMENSIONLESS_UNIT_PERM = "Pour mille";
        DIMENSIONLESS_UNIT_YOTTA = "Septillion / Yotta";
        DIMENSIONLESS_UNIT_ZETTA = "Sextillion / Zetta";
        DIMENSIONLESS_UNIT_EXA = "Quintillion / Exa";
        DIMENSIONLESS_UNIT_PETA = "Quadrillion / Peta";
        DIMENSIONLESS_UNIT_TERA = "Trillion / Tera";
        DIMENSIONLESS_UNIT_GIGA = "Milliard / Giga";
        DIMENSIONLESS_UNIT_MEGA = "Million / Mega";
        DIMENSIONLESS_UNIT_KILO = "Mille / Kilo";
        DIMENSIONLESS_UNIT_HECTO = "Cent / Hecto";
        DIMENSIONLESS_UNIT_DECA = "Dix / Deca";
        DIMENSIONLESS_UNIT_DECI = "Dixième / Deci";
        DIMENSIONLESS_UNIT_CENTI = "Centième / Centi";
        DIMENSIONLESS_UNIT_MILLI = "Millième / Milli";
        DIMENSIONLESS_UNIT_MICRO = "Millionième / Micro";
        DIMENSIONLESS_UNIT_NANO = "Milliardième / Nano";
        DIMENSIONLESS_UNIT_PICO = "Billionième / Pico";
        DIMENSIONLESS_UNIT_FEMTO = "Quadrillionième / Femto";
        DIMENSIONLESS_UNIT_ATTO = "Quintillionième / Atto";
        DIMENSIONLESS_UNIT_ZEPTO = "Sextillionième / Zepto";
        DIMENSIONLESS_UNIT_YOCTO = "Septillionième / Yocto";
        // -------------------------------------------------
        UNIT_METRE = "Mètre";
        UNIT_KILOMETRE = "Kilomètre";
        UNIT_CENTIMETRE = "Centimètre";
        UNIT_MILLIMETRE = "Millimètre";
        UNIT_INCH = "Pouce";
        UNIT_YARD = "Yard";
        UNIT_FEET = "Pied";
        UNIT_MILE = "Mile";
        UNIT_NAUTICAL_MILE = "Mille nautique";
        UNIT_METRE2 = "Mètre carré";
        UNIT_CENTIMETRE2 = "Centimètre carré";
        UNIT_MILLIMETRE2 = "Millimètre carré";
        UNIT_ARE = "Are";
        UNIT_HECTARE = "Hectare";
        UNIT_ACRE = "Acre";
        UNIT_KILOMETRE2 = "Kilomètre carré";
        UNIT_MILLIMETRE3 = "Millimètre cube";
        UNIT_CENTIMETRE3 = "Centimètre cube";
        UNIT_METRE3 = "Mètre cube";
        UNIT_KILOMETRE3 = "Kilomètre cube";
        UNIT_MILLILITRE = "Millilitre";
        UNIT_LITRE = "Litre";
        UNIT_GALLON = "Gallon";
        UNIT_PINT = "Pinte";
        UNIT_SECOND = "Seconde";
        UNIT_MILLISECOND = "Milliseconde";
        UNIT_MINUTE = "Minute";
        UNIT_HOUR = "Heure";
        UNIT_DAY = "Jour";
        UNIT_WEEK = "Semaine";
        UNIT_JULIAN_YEAR = "Année julienne = 365.25 jours";
        UNIT_KILOGRAM = "Kilogramme";
        UNIT_GRAM = "Gramme";
        UNIT_MILLIGRAM = "Milligramme";
        UNIT_DECAGRAM = "Décagramme";
        UNIT_TONNE = "Tonne";
        UNIT_OUNCE = "Once";
        UNIT_POUND = "Livre";
        UNIT_BIT = "Bit";
        UNIT_KILOBIT = "Kilobit";
        UNIT_MEGABIT = "Mégabit";
        UNIT_GIGABIT = "Gigabit";
        UNIT_TERABIT = "Térabit";
        UNIT_PETABIT = "Pétabit";
        UNIT_EXABIT = "Exabit";
        UNIT_ZETTABIT = "Zettabit";
        UNIT_YOTTABIT = "Yottabit";
        UNIT_BYTE = "Octet";
        UNIT_KILOBYTE = "Kilooctet";
        UNIT_MEGABYTE = "Mégaoctet";
        UNIT_GIGABYTE = "Gigaoctet";
        UNIT_TERABYTE = "Téraoctet";
        UNIT_PETABYTE = "Pétaoctet";
        UNIT_EXABYTE = "Exaoctet";
        UNIT_ZETTABYTE = "Zettaoctet";
        UNIT_YOTTABYTE = "Yottaoctet";
        UNIT_JOULE = "Joule";
        UNIT_ELECTRONO_VOLT = "Électronovolt";
        UNIT_KILO_ELECTRONO_VOLT = "Kiloélectronovolt";
        UNIT_MEGA_ELECTRONO_VOLT = "Mégaelectronovolt";
        UNIT_GIGA_ELECTRONO_VOLT = "Gigaelectronovolt";
        UNIT_TERA_ELECTRONO_VOLT = "Téraelectronovolt";
        UNIT_METRE_PER_SECOND = "Mètre par seconde";
        UNIT_KILOMETRE_PER_HOUR = "Kilomètre par heure";
        UNIT_MILE_PER_HOUR = "Mile par heure";
        UNIT_KNOT = "Nœud";
        UNIT_METRE_PER_SECOND2 = "Mètre par seconde carrée";
        UNIT_KILOMETRE_PER_HOUR2 = "Kilomètre par heure carrée";
        UNIT_MILE_PER_HOUR2 = "Mile par heure carrée";
        UNIT_RADIAN_ARC = "Radian";
        UNIT_DEGREE_ARC = "Degré d'arc";
        UNIT_MINUTE_ARC = "Minute d'arc";
        UNIT_SECOND_ARC = "Seconde d'arc";
    }
}