/*
 * Decompiled with CFR 0.152.
 */
package org.mariuszgromada.math.mxparser;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.mariuszgromada.math.mxparser.Argument;
import org.mariuszgromada.math.mxparser.CalcStepRecord;
import org.mariuszgromada.math.mxparser.Expression;
import org.mariuszgromada.math.mxparser.Function;
import org.mariuszgromada.math.mxparser.SerializationUtils;
import org.mariuszgromada.math.mxparser.StringInvariant;
import org.mariuszgromada.math.mxparser.StringModel;
import org.mariuszgromada.math.mxparser.mXparser;

public class CalcStepsRegister
implements Serializable {
    private static final int serialClassID = 8;
    private static final long serialVersionUID = SerializationUtils.getSerialVersionUID(8);
    public List<CalcStepRecord> calcStepRecords = new ArrayList<CalcStepRecord>();
    public String argumentNameStart = "";
    public String functionNameStart = "";
    public String expressionStringStart = "";
    public double result = Double.NaN;
    public double computingTime = Double.NaN;
    public String errorMessage = "";
    boolean isStartSet = false;
    int stepNumberGroup = 0;
    CalcStepRecord.StepType stepType = CalcStepRecord.StepType.Expression;

    public void consolePrint() {
        CalcStepsRegister.consolePrint(this);
    }

    private static void consolePrint(CalcStepsRegister calcStepsRegister) {
        if (calcStepsRegister.calcStepRecords.size() == 0) {
            mXparser.consolePrintln(StringModel.STRING_RESOURCES.CALC_STEPS_REGISTER_IS_EMPTY);
            return;
        }
        mXparser.consolePrint(StringModel.STRING_RESOURCES.CALC_STEPS_REGISTER_FOR + " ");
        boolean toPrintEq = false;
        if (calcStepsRegister.argumentNameStart.length() > 0) {
            mXparser.consolePrint(StringModel.STRING_RESOURCES.ARGUMENT + " " + calcStepsRegister.argumentNameStart);
            toPrintEq = true;
        }
        if (calcStepsRegister.functionNameStart.length() > 0) {
            mXparser.consolePrint(StringModel.STRING_RESOURCES.FUNCTION + " " + calcStepsRegister.functionNameStart);
            toPrintEq = true;
        }
        if (toPrintEq) {
            mXparser.consolePrint(" = ");
        } else {
            mXparser.consolePrint(StringModel.STRING_RESOURCES.EXPRESSION + " ");
        }
        mXparser.consolePrintln(calcStepsRegister.expressionStringStart + ", " + StringModel.STRING_RESOURCES.RESULT + " = " + calcStepsRegister.result);
        for (CalcStepRecord stepRecord : calcStepsRegister.calcStepRecords) {
            mXparser.consolePrintln(StringModel.STRING_RESOURCES.GROUP_SHORT + " = " + stepRecord.numberGroup + ", " + StringModel.STRING_RESOURCES.NUMBER_SHORT + " = " + stepRecord.numberGroupWithin + ", " + StringModel.STRING_RESOURCES.FIRST + " = " + stepRecord.firstInGroup + ", " + StringModel.STRING_RESOURCES.LAST + " = " + stepRecord.lastInGroup + ", " + StringModel.STRING_RESOURCES.TYPE + " = " + (Object)((Object)stepRecord.type) + ", " + StringModel.STRING_RESOURCES.DESCRIPTION_SHORT + " = " + stepRecord.description + ", " + StringModel.STRING_RESOURCES.STEP + " = " + stepRecord.content);
        }
        mXparser.consolePrintln(StringModel.STRING_RESOURCES.COMPUTING_TIME + " = " + calcStepsRegister.computingTime + " s.");
    }

    public String toString() {
        return CalcStepsRegister.toString(this);
    }

    private static String toString(CalcStepsRegister calcStepsRegister) {
        if (calcStepsRegister.calcStepRecords.size() == 0) {
            return StringModel.STRING_RESOURCES.CALC_STEPS_REGISTER_IS_EMPTY;
        }
        StringBuilder output = new StringBuilder();
        output.append(StringModel.STRING_RESOURCES.CALC_STEPS_REGISTER_FOR);
        output.append(" ");
        boolean toPrintEq = false;
        if (calcStepsRegister.argumentNameStart.length() > 0) {
            output.append(StringModel.STRING_RESOURCES.ARGUMENT);
            output.append(" ");
            output.append(calcStepsRegister.argumentNameStart);
            toPrintEq = true;
        }
        if (calcStepsRegister.functionNameStart.length() > 0) {
            output.append(StringModel.STRING_RESOURCES.FUNCTION);
            output.append(" ");
            output.append(calcStepsRegister.functionNameStart);
            toPrintEq = true;
        }
        if (toPrintEq) {
            output.append(" = ");
        } else {
            output.append(StringModel.STRING_RESOURCES.EXPRESSION);
            output.append(" ");
        }
        output.append(calcStepsRegister.expressionStringStart);
        output.append(", ");
        output.append(StringModel.STRING_RESOURCES.RESULT);
        output.append(" = ");
        output.append(calcStepsRegister.result);
        for (CalcStepRecord stepRecord : calcStepsRegister.calcStepRecords) {
            output.append(StringInvariant.NEW_LINE);
            output.append(StringModel.STRING_RESOURCES.GROUP_SHORT);
            output.append(" = ");
            output.append(stepRecord.numberGroup);
            output.append(", ");
            output.append(StringModel.STRING_RESOURCES.NUMBER_SHORT);
            output.append(" = ");
            output.append(stepRecord.numberGroupWithin);
            output.append(", ");
            output.append(StringModel.STRING_RESOURCES.FIRST);
            output.append(" = ");
            output.append(stepRecord.firstInGroup);
            output.append(", ");
            output.append(StringModel.STRING_RESOURCES.LAST);
            output.append(" = ");
            output.append(stepRecord.lastInGroup);
            output.append(", ");
            output.append(StringModel.STRING_RESOURCES.TYPE);
            output.append(" = ");
            output.append((Object)stepRecord.type);
            output.append(", ");
            output.append(StringModel.STRING_RESOURCES.DESCRIPTION_SHORT);
            output.append(" = ");
            output.append(stepRecord.description);
            output.append(", ");
            output.append(StringModel.STRING_RESOURCES.STEP);
            output.append(" = ");
            output.append(stepRecord.content);
        }
        return output.toString();
    }

    void stepTypeSetExpression() {
        this.stepType = CalcStepRecord.StepType.Expression;
    }

    void stepTypeSetUserArgument() {
        this.stepType = CalcStepRecord.StepType.Argument;
    }

    void stepTypeSetUserFunction() {
        this.stepType = CalcStepRecord.StepType.Function;
    }

    static void stepTypeSetExpression(CalcStepsRegister calcStepsRegister) {
        if (calcStepsRegister == null) {
            return;
        }
        calcStepsRegister.stepTypeSetExpression();
    }

    static void setUserArgument(CalcStepsRegister calcStepsRegister, Argument argument) {
        if (calcStepsRegister == null) {
            return;
        }
        calcStepsRegister.stepTypeSetUserArgument();
        if (calcStepsRegister.isStartSet) {
            return;
        }
        calcStepsRegister.argumentNameStart = argument.getArgumentName();
        calcStepsRegister.expressionStringStart = argument.getArgumentExpressionString().trim();
        calcStepsRegister.isStartSet = true;
    }

    static void setUserFunction(CalcStepsRegister calcStepsRegister, Function function) {
        if (calcStepsRegister == null) {
            return;
        }
        calcStepsRegister.stepTypeSetUserFunction();
        if (calcStepsRegister.isStartSet) {
            return;
        }
        calcStepsRegister.functionNameStart = function.getFunctionName();
        calcStepsRegister.expressionStringStart = function.getFunctionExpressionString().trim();
        calcStepsRegister.isStartSet = true;
    }

    static void stepNumberGroupIncrease(CalcStepsRegister calcStepsRegister, Expression expression) {
        if (calcStepsRegister == null) {
            return;
        }
        ++calcStepsRegister.stepNumberGroup;
        if (calcStepsRegister.isStartSet) {
            return;
        }
        calcStepsRegister.expressionStringStart = expression.getExpressionString().trim();
        calcStepsRegister.isStartSet = true;
    }
}

