/*
 * Decompiled with CFR 0.152.
 */
package org.mariuszgromada.math.mxparser.mathcollection;

import java.util.Random;
import org.mariuszgromada.math.mxparser.Constant;
import org.mariuszgromada.math.mxparser.Expression;
import org.mariuszgromada.math.mxparser.PrimitiveElement;
import org.mariuszgromada.math.mxparser.mXparser;
import org.mariuszgromada.math.mxparser.mathcollection.BinaryRelations;
import org.mariuszgromada.math.mxparser.mathcollection.MathConstants;
import org.mariuszgromada.math.mxparser.mathcollection.MathFunctions;
import org.mariuszgromada.math.mxparser.mathcollection.SpecialFunctions;

public final class ProbabilityDistributions {
    public static Random randomGenerator = new Random();
    private static Constant pp = new Constant("p", 1.0);
    private static Constant vv = new Constant("v", 1.0);
    private static Expression qntSolveStud = new Expression("solve( cStud(x, v) - p, x, -100000000000000.0, 100000000000000.0)", new PrimitiveElement[]{pp, vv}){
        {
            this.checkSyntax();
        }
    };

    public static double rndUniformContinuous(double a, double b, Random rnd) {
        if (Double.isNaN(a)) {
            return Double.NaN;
        }
        if (Double.isNaN(b)) {
            return Double.NaN;
        }
        if (b < a) {
            return Double.NaN;
        }
        if (a == b) {
            return a;
        }
        double r = a + rnd.nextDouble() * (b - a);
        return r;
    }

    public static double rndUniformContinuous(double a, double b) {
        return ProbabilityDistributions.rndUniformContinuous(a, b, randomGenerator);
    }

    public static double rndUniformContinuous(Random rnd) {
        return rnd.nextDouble();
    }

    public static double randomUniformContinuous() {
        return ProbabilityDistributions.rndUniformContinuous(randomGenerator);
    }

    public static double pdfUniformContinuous(double x, double a, double b) {
        if (Double.isNaN(x)) {
            return Double.NaN;
        }
        if (Double.isNaN(a)) {
            return Double.NaN;
        }
        if (Double.isNaN(b)) {
            return Double.NaN;
        }
        if (b < a) {
            return Double.NaN;
        }
        if (a == b) {
            if (x == a) {
                return 1.0;
            }
            return 0.0;
        }
        if (x < a || x > b) {
            return 0.0;
        }
        if (x == Double.NEGATIVE_INFINITY) {
            return 0.0;
        }
        if (x == Double.POSITIVE_INFINITY) {
            return 0.0;
        }
        return 1.0 / (b - a);
    }

    public static double cdfUniformContinuous(double x, double a, double b) {
        if (Double.isNaN(x)) {
            return Double.NaN;
        }
        if (Double.isNaN(a)) {
            return Double.NaN;
        }
        if (Double.isNaN(b)) {
            return Double.NaN;
        }
        if (b < a) {
            return Double.NaN;
        }
        if (a == b) {
            if (x < a) {
                return 0.0;
            }
            return 1.0;
        }
        if (x < a) {
            return 0.0;
        }
        if (x >= b) {
            return 1.0;
        }
        if (x == Double.NEGATIVE_INFINITY) {
            return 0.0;
        }
        if (x == Double.POSITIVE_INFINITY) {
            return 1.0;
        }
        return (x - a) / (b - a);
    }

    public static double qntUniformContinuous(double q, double a, double b) {
        if (Double.isNaN(q)) {
            return Double.NaN;
        }
        if (Double.isNaN(a)) {
            return Double.NaN;
        }
        if (Double.isNaN(b)) {
            return Double.NaN;
        }
        if (q < 0.0 || q > 1.0) {
            return Double.NaN;
        }
        if (b < a) {
            return Double.NaN;
        }
        if (a == b) {
            if (q == 1.0) {
                return b;
            }
            return Double.NaN;
        }
        if (q == 0.0) {
            return a;
        }
        if (q == 1.0) {
            return b;
        }
        return a + q * (b - a);
    }

    public static double rndInteger(int a, int b, Random rnd) {
        if (Double.isNaN(a)) {
            return Double.NaN;
        }
        if (Double.isNaN(b)) {
            return Double.NaN;
        }
        if (b < a) {
            return Double.NaN;
        }
        if (a == b) {
            return a;
        }
        int n = b - a + 1;
        int r = a + rnd.nextInt(n);
        return r;
    }

    public static double rndInteger(int a, int b) {
        return ProbabilityDistributions.rndInteger(a, b, randomGenerator);
    }

    public static int rndInteger(Random rnd) {
        return rnd.nextInt();
    }

    public static int rndIndex(int n, Random rnd) {
        if (n < 0) {
            return -1;
        }
        return rnd.nextInt(n);
    }

    public static int rndIndex(int n) {
        if (n < 0) {
            return -1;
        }
        return randomGenerator.nextInt(n);
    }

    public static int rndInteger() {
        return ProbabilityDistributions.rndInteger(randomGenerator);
    }

    public static double rndNormal(double mean, double stddev, Random rnd) {
        double x;
        boolean polarTransform;
        if (Double.isNaN(mean)) {
            return Double.NaN;
        }
        if (Double.isNaN(stddev)) {
            return Double.NaN;
        }
        if (rnd == null) {
            return Double.NaN;
        }
        if (stddev < 0.0) {
            return Double.NaN;
        }
        if (stddev == 0.0) {
            return mean;
        }
        do {
            double b;
            double v2;
            if (mXparser.isCurrentCalculationCancelled()) {
                return Double.NaN;
            }
            double a = rnd.nextDouble();
            double v1 = 2.0 * a - 1.0;
            double r = v1 * v1 + (v2 = 2.0 * (b = rnd.nextDouble()) - 1.0) * v2;
            if (r >= 1.0 || r == 0.0) {
                x = 0.0;
                polarTransform = false;
                continue;
            }
            double fac = MathFunctions.sqrt(-2.0 * MathFunctions.ln(r) / r);
            x = v1 * fac;
            polarTransform = true;
        } while (!polarTransform);
        return mean + stddev * x;
    }

    public static double rndNormal(double mean, double stddev) {
        return ProbabilityDistributions.rndNormal(mean, stddev, randomGenerator);
    }

    public static double pdfNormal(double x, double mean, double stddev) {
        if (Double.isNaN(x)) {
            return Double.NaN;
        }
        if (Double.isNaN(mean)) {
            return Double.NaN;
        }
        if (Double.isNaN(stddev)) {
            return Double.NaN;
        }
        if (stddev < 0.0) {
            return Double.NaN;
        }
        if (stddev == 0.0) {
            if (x == mean) {
                return 1.0;
            }
            return 0.0;
        }
        if (x == Double.NEGATIVE_INFINITY) {
            return 0.0;
        }
        if (x == Double.POSITIVE_INFINITY) {
            return 0.0;
        }
        double d = (x - mean) / stddev;
        return MathFunctions.exp(-0.5 * d * d) / (2.5066282746310007 * stddev);
    }

    public static double cdfNormal(double x, double mean, double stddev) {
        if (Double.isNaN(x)) {
            return Double.NaN;
        }
        if (Double.isNaN(mean)) {
            return Double.NaN;
        }
        if (Double.isNaN(stddev)) {
            return Double.NaN;
        }
        if (stddev < 0.0) {
            return Double.NaN;
        }
        if (stddev == 0.0) {
            if (x < mean) {
                return 0.0;
            }
            return 1.0;
        }
        if (x == Double.NEGATIVE_INFINITY) {
            return 0.0;
        }
        if (x == Double.POSITIVE_INFINITY) {
            return 1.0;
        }
        return 0.5 * SpecialFunctions.erfc((mean - x) / (stddev * MathConstants.SQRT2));
    }

    public static double qntNormal(double q, double mean, double stddev) {
        if (Double.isNaN(q)) {
            return Double.NaN;
        }
        if (Double.isNaN(mean)) {
            return Double.NaN;
        }
        if (Double.isNaN(stddev)) {
            return Double.NaN;
        }
        if (q < 0.0 || q > 1.0) {
            return Double.NaN;
        }
        if (stddev < 0.0) {
            return Double.NaN;
        }
        if (stddev == 0.0) {
            if (q == 1.0) {
                return mean;
            }
            return Double.NaN;
        }
        if (q == 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        if (q == 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        return mean - stddev * MathConstants.SQRT2 * SpecialFunctions.erfcInv(2.0 * q);
    }

    public static double pdfStudentT(double x, double v) {
        if (Double.isNaN(x)) {
            return Double.NaN;
        }
        if (Double.isNaN(v)) {
            return Double.NaN;
        }
        if (v <= 0.0) {
            return Double.NaN;
        }
        if (x == Double.NEGATIVE_INFINITY) {
            return 0.0;
        }
        if (x == Double.POSITIVE_INFINITY) {
            return 0.0;
        }
        if (BinaryRelations.isEqualOrAlmost(v, 1.0)) {
            return 1.0 / (Math.PI * (1.0 + x * x));
        }
        if (BinaryRelations.isEqualOrAlmost(v, 2.0)) {
            return 1.0 / (2.0 * MathConstants.SQRT2 * Math.pow(1.0 + x * x / 2.0, 1.5));
        }
        if (BinaryRelations.isEqualOrAlmost(v, 3.0)) {
            return 2.0 / (Math.PI * MathConstants.SQRT3 * Math.pow(1.0 + x * x / 3.0, 2.0));
        }
        if (BinaryRelations.isEqualOrAlmost(v, 4.0)) {
            return 3.0 / (8.0 * Math.pow(1.0 + x * x / 4.0, 2.5));
        }
        if (BinaryRelations.isEqualOrAlmost(v, 5.0)) {
            return 8.0 / (Math.PI * 3 * MathConstants.SQRT5 * Math.pow(1.0 + x * x / 5.0, 3.0));
        }
        if (v == Double.POSITIVE_INFINITY) {
            return 0.39894228040143265 * Math.exp(-x * x / 2.0);
        }
        return SpecialFunctions.gamma((v + 1.0) / 2.0) / (Math.sqrt(v * Math.PI) * SpecialFunctions.gamma(v / 2.0)) * Math.pow(1.0 + x * x / v, -((v + 1.0) / 2.0));
    }

    private static double cdfStudentTPositiveX(double x, double v) {
        if (BinaryRelations.isEqualOrAlmost(v, 1.0)) {
            return 0.5 + 0.3183098861837907 * Math.atan(x);
        }
        if (BinaryRelations.isEqualOrAlmost(v, 2.0)) {
            return 0.5 + x / (2.0 * MathConstants.SQRT2 * Math.sqrt(1.0 + x * x / 2.0));
        }
        if (BinaryRelations.isEqualOrAlmost(v, 3.0)) {
            return 0.5 + 0.3183098861837907 * (1.0 / MathConstants.SQRT3 * x / (1.0 + x * x / 3.0) + Math.atan(x / MathConstants.SQRT3));
        }
        if (BinaryRelations.isEqualOrAlmost(v, 4.0)) {
            return 0.5 + 0.375 * x / Math.sqrt(1.0 + x * x / 4.0) * (1.0 - 0.08333333333333333 * x * x / (1.0 + x * x / 4.0));
        }
        if (BinaryRelations.isEqualOrAlmost(v, 5.0)) {
            return 0.5 + 0.3183098861837907 * (x / (MathConstants.SQRT5 * (1.0 + x * x / 5.0)) * (1.0 + 2.0 / (3.0 * (1.0 + x * x / 5.0))) + Math.atan(x / MathConstants.SQRT5));
        }
        if (v == Double.POSITIVE_INFINITY) {
            return 0.5 * (1.0 + SpecialFunctions.erf(x / MathConstants.SQRT2));
        }
        return 0.5 + x * SpecialFunctions.gamma((v + 1.0) / 2.0) * SpecialFunctions.hypergeometricF(0.5, (v + 1.0) / 2.0, 1.5, -Math.pow(x, 2.0) / v, 300.0, 1.0E-14) / (Math.sqrt(Math.PI * v) * SpecialFunctions.gamma(v / 2.0));
    }

    public static double cdfStudentT(double x, double v) {
        if (Double.isNaN(x)) {
            return Double.NaN;
        }
        if (Double.isNaN(v)) {
            return Double.NaN;
        }
        if (v <= 0.0) {
            return Double.NaN;
        }
        if (x == Double.NEGATIVE_INFINITY) {
            return 0.0;
        }
        if (x == Double.POSITIVE_INFINITY) {
            return 1.0;
        }
        if (BinaryRelations.isEqualOrAlmost(x, 0.0)) {
            return 0.5;
        }
        if (x > 0.0) {
            return ProbabilityDistributions.cdfStudentTPositiveX(x, v);
        }
        return 1.0 - ProbabilityDistributions.cdfStudentTPositiveX(-x, v);
    }

    public static double qntStudentT(double p, double v) {
        double x;
        if (Double.isNaN(p)) {
            return Double.NaN;
        }
        if (Double.isNaN(v)) {
            return Double.NaN;
        }
        if (v <= 0.0) {
            return Double.NaN;
        }
        if (BinaryRelations.isEqualOrAlmost(p, 0.0)) {
            return Double.NEGATIVE_INFINITY;
        }
        if (BinaryRelations.isEqualOrAlmost(p, 1.0)) {
            return Double.POSITIVE_INFINITY;
        }
        if (p < 0.0 || p > 1.0) {
            return Double.NaN;
        }
        if (BinaryRelations.isEqualOrAlmost(p, 0.5)) {
            return 0.0;
        }
        if (BinaryRelations.isEqualOrAlmost(v, 1.0)) {
            return Math.tan(Math.PI * (p - 0.5));
        }
        if (BinaryRelations.isEqualOrAlmost(v, 2.0)) {
            double a = 4.0 * p * (1.0 - p);
            return (2.0 * p - 1.0) * Math.sqrt(2.0 / a);
        }
        if (BinaryRelations.isEqualOrAlmost(v, 4.0)) {
            double a = 4.0 * p * (1.0 - p);
            double q = Math.cos(0.3333333333333333 * Math.acos(Math.sqrt(a))) / Math.sqrt(a);
            return Math.signum(p - 0.5) * 2.0 * Math.sqrt(q - 1.0);
        }
        if (v == Double.POSITIVE_INFINITY) {
            x = MathConstants.SQRT2 * SpecialFunctions.erfInv(2.0 * Math.max(p, 1.0 - p) - 1.0);
        } else {
            x = SpecialFunctions.inverseRegularizedBeta(0.5 * v, 0.5, 2.0 * Math.min(p, 1.0 - p));
            x = Math.sqrt(v * (1.0 - x) / x);
        }
        if (Double.isNaN(x)) {
            x = BinaryRelations.isEqualOrAlmost(v % 2.0, 0.0) ? ProbabilityDistributions.qntChengFuStudentTAlgorithm(p, v) : ProbabilityDistributions.qntHillsAlgorithm396(p, v);
        }
        if (Double.isNaN(x)) {
            pp.setConstantValue(Math.max(p, 1.0 - p));
            vv.setConstantValue(v);
            x = qntSolveStud.calculate();
        }
        return p >= 0.5 ? x : -x;
    }

    public static double rndStudentT(double v) {
        if (Double.isNaN(v)) {
            return Double.NaN;
        }
        if (v <= 0.0) {
            return Double.NaN;
        }
        return ProbabilityDistributions.qntStudentT(randomGenerator.nextDouble(), v);
    }

    private static double qntChengFuStudentTAlgorithm(double p, double v) {
        double q;
        if (Double.isNaN(p)) {
            return Double.NaN;
        }
        if (Double.isNaN(v)) {
            return Double.NaN;
        }
        if (v <= 0.0) {
            return Double.NaN;
        }
        if (p < 0.0 || p > 1.0) {
            return Double.NaN;
        }
        double k = Math.ceil(v / 2.0);
        double a = 1.0 - p;
        if (a != 0.5) {
            double qi = Math.sqrt(2.0 * Math.pow(1.0 - 2.0 * a, 2.0) / (1.0 - Math.pow(1.0 - 2.0 * a, 2.0)));
            for (double i = 0.0; i < 20.0; i += 1.0) {
                double qip1;
                if (mXparser.isCurrentCalculationCancelled()) {
                    return Double.NaN;
                }
                double gy = 0.0;
                for (double j = 0.0; j <= k - 1.0; j += 1.0) {
                    if (mXparser.isCurrentCalculationCancelled()) {
                        return Double.NaN;
                    }
                    gy += MathFunctions.factorial(2.0 * j) / Math.pow(2.0, 2.0 * j) / Math.pow(MathFunctions.factorial(j), 2.0) * Math.pow(1.0 + Math.pow(qi, 2.0) / (2.0 * k), -j);
                }
                qi = qip1 = 1.0 / Math.sqrt(1.0 / (2.0 * k) * (Math.pow(gy / (1.0 - 2.0 * a), 2.0) - 1.0));
            }
            q = a > 0.5 ? -qi : qi;
        } else {
            q = 0.0;
        }
        return q;
    }

    private static double qntHillsAlgorithm396(double p, double v) {
        double z;
        boolean negate;
        if (Double.isNaN(p)) {
            return Double.NaN;
        }
        if (Double.isNaN(v)) {
            return Double.NaN;
        }
        if (v <= 0.0) {
            return Double.NaN;
        }
        if (p < 0.0 || p > 1.0) {
            return Double.NaN;
        }
        if (p > 0.5) {
            negate = false;
            z = 2.0 * (1.0 - p);
        } else {
            negate = true;
            z = 2.0 * p;
        }
        double a = 1.0 / (v - 0.5);
        double b = 48.0 / (a * a);
        double c = ((20700.0 * a / b - 98.0) * a - 16.0) * a + 96.36;
        double d = ((94.5 / (b + c) - 3.0) / b + 1.0) * Math.sqrt(a * 1.5707963267948966) * v;
        double x = z * d;
        double y = Math.pow(x, 2.0 / v);
        if (y > 0.05 + a) {
            x = ProbabilityDistributions.qntNormal(z * 0.5, 0.0, 1.0);
            y = x * x;
            if (v < 5.0) {
                c += 0.3 * (v - 4.5) * (x + 0.6);
            }
            c = c + (((0.05 * d * x - 5.0) * x - 7.0) * x - 2.0) * x + b;
            y = (((((0.4 * y + 6.3) * y + 36.0) * y + 94.5) / c - y - 3.0) / b + 1.0) * x;
            y = (y = a * y * y) > 0.002 ? Math.exp(y) - 1.0 : (y += 0.5 * y * y);
        } else {
            y = ((1.0 / (((v + 6.0) / (v * y) - 0.089 * d - 0.822) * (v + 2.0) * 3.0) + 0.5 / (v + 4.0)) * y - 1.0) * (v + 1.0) / (v + 2.0) + 1.0 / y;
        }
        double q = Math.sqrt(v * y);
        if (negate) {
            q = -q;
        }
        return q;
    }

    public static double pdfChiSquared(double x, double k) {
        if (Double.isNaN(x)) {
            return Double.NaN;
        }
        if (Double.isNaN(k)) {
            return Double.NaN;
        }
        if ((k = (double)Math.round(k)) < 1.0) {
            return Double.NaN;
        }
        if (x < 0.0) {
            return 0.0;
        }
        if (BinaryRelations.isEqualOrAlmost(x, 0.0)) {
            return 0.0;
        }
        return Math.pow(x, k / 2.0 - 1.0) * Math.exp(-x / 2.0) / (Math.pow(2.0, k / 2.0) * SpecialFunctions.gamma(k / 2.0));
    }

    public static double cdfChiSquared(double x, double k) {
        if (Double.isNaN(x)) {
            return Double.NaN;
        }
        if (Double.isNaN(k)) {
            return Double.NaN;
        }
        if ((k = (double)Math.round(k)) < 1.0) {
            return Double.NaN;
        }
        if (x < 0.0) {
            return 0.0;
        }
        if (BinaryRelations.isEqualOrAlmost(x, 0.0)) {
            return 0.0;
        }
        return SpecialFunctions.regularizedGammaLowerP(k / 2.0, x / 2.0);
    }

    public static double qntChiSquared(double p, double k) {
        if (Double.isNaN(p)) {
            return Double.NaN;
        }
        if (Double.isNaN(k)) {
            return Double.NaN;
        }
        if (BinaryRelations.isEqualOrAlmost(p, 0.0)) {
            return 0.0;
        }
        if (BinaryRelations.isEqualOrAlmost(p, 1.0)) {
            return Double.POSITIVE_INFINITY;
        }
        if (p < 0.0 || p > 1.0) {
            return Double.NaN;
        }
        if ((k = (double)Math.round(k)) < 1.0) {
            return Double.NaN;
        }
        return 2.0 * SpecialFunctions.inverseRegularizedGammaLowerP(k / 2.0, p);
    }

    public static double rndChiSquared(double k) {
        if (Double.isNaN(k)) {
            return Double.NaN;
        }
        if ((k = (double)Math.round(k)) < 1.0) {
            return Double.NaN;
        }
        return ProbabilityDistributions.qntChiSquared(randomGenerator.nextDouble(), k);
    }

    public static double pdfSnedecordF(double x, double d1, double d2) {
        if (Double.isNaN(x)) {
            return Double.NaN;
        }
        if (Double.isNaN(d1)) {
            return Double.NaN;
        }
        if (Double.isNaN(d2)) {
            return Double.NaN;
        }
        if (Double.isInfinite(d1)) {
            return Double.NaN;
        }
        if (Double.isInfinite(d2)) {
            return Double.NaN;
        }
        if (d1 < 0.0) {
            return Double.NaN;
        }
        if (d2 < 0.0) {
            return Double.NaN;
        }
        if (BinaryRelations.isEqualOrAlmost(d1, 0.0)) {
            return Double.NaN;
        }
        if (BinaryRelations.isEqualOrAlmost(d2, 0.0)) {
            return Double.NaN;
        }
        if (x == Double.POSITIVE_INFINITY) {
            return 0.0;
        }
        if (x == Double.NEGATIVE_INFINITY) {
            return 0.0;
        }
        if (x < 0.0) {
            return 0.0;
        }
        if (BinaryRelations.isEqualOrAlmost(x, 0.0)) {
            return 0.0;
        }
        double d1div2 = d1 / 2.0;
        double d2div2 = d2 / 2.0;
        return Math.pow(d1 * x, d1div2) * Math.pow(d2, d2div2) / Math.pow(d1 * x + d2, d1div2 + d2div2) / (x * SpecialFunctions.beta(d1div2, d2div2));
    }

    public static double cdfSnedecordF(double x, double d1, double d2) {
        if (Double.isNaN(x)) {
            return Double.NaN;
        }
        if (Double.isNaN(d1)) {
            return Double.NaN;
        }
        if (Double.isNaN(d2)) {
            return Double.NaN;
        }
        if (Double.isInfinite(d1)) {
            return Double.NaN;
        }
        if (Double.isInfinite(d2)) {
            return Double.NaN;
        }
        if (d1 < 0.0) {
            return Double.NaN;
        }
        if (d2 < 0.0) {
            return Double.NaN;
        }
        if (BinaryRelations.isEqualOrAlmost(d1, 0.0)) {
            return Double.NaN;
        }
        if (BinaryRelations.isEqualOrAlmost(d2, 0.0)) {
            return Double.NaN;
        }
        if (x == Double.POSITIVE_INFINITY) {
            return 1.0;
        }
        if (x == Double.NEGATIVE_INFINITY) {
            return 0.0;
        }
        if (x < 0.0) {
            return 0.0;
        }
        if (BinaryRelations.isEqualOrAlmost(x, 0.0)) {
            return 0.0;
        }
        return SpecialFunctions.regularizedBeta(d1 / 2.0, d2 / 2.0, d1 * x / (d1 * x + d2));
    }

    public static double qntSnedecordF(double p, double d1, double d2) {
        if (Double.isNaN(p)) {
            return Double.NaN;
        }
        if (Double.isNaN(d1)) {
            return Double.NaN;
        }
        if (Double.isNaN(d2)) {
            return Double.NaN;
        }
        if (Double.isInfinite(d1)) {
            return Double.NaN;
        }
        if (Double.isInfinite(d2)) {
            return Double.NaN;
        }
        if (d1 < 0.0) {
            return Double.NaN;
        }
        if (d2 < 0.0) {
            return Double.NaN;
        }
        if (BinaryRelations.isEqualOrAlmost(d1, 0.0)) {
            return Double.NaN;
        }
        if (BinaryRelations.isEqualOrAlmost(d2, 0.0)) {
            return Double.NaN;
        }
        if (BinaryRelations.isEqualOrAlmost(p, 0.0)) {
            return 0.0;
        }
        if (BinaryRelations.isEqualOrAlmost(p, 1.0)) {
            return Double.POSITIVE_INFINITY;
        }
        if (p < 0.0) {
            return Double.NaN;
        }
        if (p > 1.0) {
            return Double.NaN;
        }
        double regBetaInv = SpecialFunctions.inverseRegularizedBeta(d1 / 2.0, d2 / 2.0, p);
        return d2 * regBetaInv / (d1 * (1.0 - regBetaInv));
    }

    public static double rndSnedecordF(double d1, double d2) {
        if (Double.isNaN(d1)) {
            return Double.NaN;
        }
        if (Double.isNaN(d2)) {
            return Double.NaN;
        }
        if (Double.isInfinite(d1)) {
            return Double.NaN;
        }
        if (Double.isInfinite(d2)) {
            return Double.NaN;
        }
        if (d1 < 0.0) {
            return Double.NaN;
        }
        if (d2 < 0.0) {
            return Double.NaN;
        }
        if (BinaryRelations.isEqualOrAlmost(d1, 0.0)) {
            return Double.NaN;
        }
        if (BinaryRelations.isEqualOrAlmost(d2, 0.0)) {
            return Double.NaN;
        }
        return ProbabilityDistributions.qntSnedecordF(randomGenerator.nextDouble(), d1, d2);
    }
}

