/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.io.nio;

import java.io.EOFException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlinx.io.core.BuffersKt;
import kotlinx.io.core.BytePacketBuilder;
import kotlinx.io.core.ByteReadPacket;
import kotlinx.io.core.IoBuffer;
import kotlinx.io.core.PacketJVMKt;
import kotlinx.io.core.internal.RequireFailureCapture;
import kotlinx.io.internal.jvm.ErrorsKt;
import kotlinx.io.pool.ObjectPool;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000@\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0012\u0010\u0005\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b\u001a\u0012\u0010\t\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b\u001a\u0012\u0010\n\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b\u001a\u001c\u0010\u000b\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\bH\u0002\u001a\u0012\u0010\u000e\u001a\u00020\u0001*\u00020\u000f2\u0006\u0010\u0003\u001a\u00020\u0004\u001a%\u0010\u0010\u001a\u0004\u0018\u00010\u0006*\u00020\u000f2\u0017\u0010\u0011\u001a\u0013\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012\u00a2\u0006\u0002\b\u0015\u001a\u0012\u0010\u0010\u001a\u00020\u0016*\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0006\u00a8\u0006\u0018"}, d2={"read", "", "Ljava/nio/channels/ReadableByteChannel;", "buffer", "Lkotlinx/io/core/IoBuffer;", "readPacketAtLeast", "Lkotlinx/io/core/ByteReadPacket;", "n", "", "readPacketAtMost", "readPacketExact", "readPacketImpl", "min", "max", "write", "Ljava/nio/channels/WritableByteChannel;", "writePacket", "builder", "Lkotlin/Function1;", "Lkotlinx/io/core/BytePacketBuilder;", "", "Lkotlin/ExtensionFunctionType;", "", "p", "kotlinx-io"})
public final class ChannelsKt {
    @Nullable
    public static final ByteReadPacket writePacket(@NotNull WritableByteChannel $receiver, @NotNull Function1<? super BytePacketBuilder, Unit> builder) {
        ByteReadPacket byteReadPacket;
        ByteReadPacket byteReadPacket2;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull(builder, (String)"builder");
        int headerSizeHint$iv = 0;
        boolean $i$f$buildPacket = false;
        BytePacketBuilder builder$iv = PacketJVMKt.BytePacketBuilder(headerSizeHint$iv);
        try {
            builder.invoke((Object)builder$iv);
            byteReadPacket2 = builder$iv.build();
        }
        catch (Throwable t$iv) {
            builder$iv.release();
            throw t$iv;
        }
        ByteReadPacket p = byteReadPacket2;
        try {
            byteReadPacket = ChannelsKt.writePacket($receiver, p) ? null : p;
        }
        catch (Throwable t) {
            p.release();
            throw t;
        }
        return byteReadPacket;
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean writePacket(@NotNull WritableByteChannel $receiver, @NotNull ByteReadPacket p) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)p, (String)"p");
        try {
            int rc;
            do {
                IoBuffer buffer$iv$iv;
                IoBuffer ioBuffer;
                void this_$iv$iv;
                rc = 0;
                ByteReadPacket this_$iv = p;
                boolean $i$f$read = false;
                ByteReadPacket byteReadPacket = this_$iv;
                int n$iv$iv = 1;
                boolean $i$f$read2 = false;
                IoBuffer head$iv$iv = this_$iv$iv.getHead();
                int before$iv$iv = head$iv$iv.getReadRemaining();
                if (before$iv$iv < n$iv$iv) {
                    IoBuffer ioBuffer2;
                    IoBuffer it$iv$iv = ioBuffer2 = this_$iv$iv.prepareRead(n$iv$iv, head$iv$iv);
                    boolean bl = false;
                    IoBuffer ioBuffer3 = it$iv$iv;
                    before$iv$iv = ioBuffer3 != null ? ioBuffer3.getReadRemaining() : 0;
                    ioBuffer = ioBuffer2;
                } else {
                    ioBuffer = buffer$iv$iv = head$iv$iv;
                }
                if (buffer$iv$iv != null) {
                    IoBuffer node = buffer$iv$iv;
                    boolean bl = false;
                    IoBuffer this_$iv2 = node;
                    boolean $i$f$readDirect = false;
                    ByteBuffer bb$iv = this_$iv2.readBuffer;
                    int positionBefore$iv = bb$iv.position();
                    int limit$iv = bb$iv.limit();
                    ByteBuffer it = bb$iv;
                    boolean bl2 = false;
                    rc = $receiver.write(it);
                    int delta$iv = bb$iv.position() - positionBefore$iv;
                    if (delta$iv < 0) {
                        Void void_ = ErrorsKt.negativeShiftError(delta$iv);
                        throw null;
                    }
                    if (bb$iv.limit() != limit$iv) {
                        Void void_ = ErrorsKt.limitChangeError();
                        throw null;
                    }
                    int after$iv$iv = buffer$iv$iv.getReadRemaining();
                    int delta$iv$iv = before$iv$iv - after$iv$iv;
                    if (delta$iv$iv > 0) {
                        void v4 = this_$iv$iv;
                        v4.setHeadRemaining(v4.getHeadRemaining() - delta$iv$iv);
                    }
                    if (after$iv$iv == 0) {
                        this_$iv$iv.ensureNext(buffer$iv$iv);
                    }
                }
                if (!p.isEmpty()) continue;
                return true;
            } while (rc != 0);
            return false;
        }
        catch (Throwable t) {
            p.release();
            throw t;
        }
    }

    @NotNull
    public static final ByteReadPacket readPacketExact(@NotNull ReadableByteChannel $receiver, long n) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return ChannelsKt.readPacketImpl($receiver, n, n);
    }

    @NotNull
    public static final ByteReadPacket readPacketAtLeast(@NotNull ReadableByteChannel $receiver, long n) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return ChannelsKt.readPacketImpl($receiver, n, Long.MAX_VALUE);
    }

    @NotNull
    public static final ByteReadPacket readPacketAtMost(@NotNull ReadableByteChannel $receiver, long n) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return ChannelsKt.readPacketImpl($receiver, 1L, n);
    }

    /*
     * WARNING - void declaration
     */
    private static final ByteReadPacket readPacketImpl(@NotNull ReadableByteChannel $receiver, long min, long max) {
        IoBuffer empty;
        boolean bl;
        boolean bl2 = bl = min >= 0L;
        if (!bl) {
            boolean bl3 = false;
            String string = "min shouldn't be negative: " + min;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        boolean bl4 = bl = min <= max;
        if (!bl) {
            boolean bl5 = false;
            String string = "min shouldn't be greater than max: " + min + " > " + max;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        if (max == 0L) {
            return ByteReadPacket.Companion.getEmpty();
        }
        ObjectPool<IoBuffer> pool = IoBuffer.Companion.getPool();
        IoBuffer head = empty = IoBuffer.Companion.getEmpty();
        IoBuffer tail = empty;
        try {
            int rc;
            for (long read = 0L; read < min || read == min && min == 0L; read += (long)rc) {
                void this_$iv$iv$iv;
                void this_$iv;
                IoBuffer part;
                int n;
                IoBuffer ioBuffer;
                int remInt = (int)RangesKt.coerceAtMost((long)(max - read), (long)Integer.MAX_VALUE);
                IoBuffer it = ioBuffer = tail;
                boolean bl6 = false;
                int it2 = n = it.getWriteRemaining();
                boolean bl7 = false;
                IoBuffer ioBuffer2 = it2 > 200 || it2 >= remInt ? ioBuffer : null;
                if (ioBuffer2 == null) {
                    it = ioBuffer = pool.borrow();
                    boolean bl8 = false;
                    if (head == empty) {
                        head = it;
                        tail = it;
                    }
                    ioBuffer2 = part = ioBuffer;
                }
                if (tail != part) {
                    tail.setNext(part);
                    tail = part;
                }
                ioBuffer = part;
                int size$iv = 1;
                boolean $i$f$writeDirect = false;
                int rem$iv = this_$iv.getWriteRemaining();
                boolean condition$iv$iv = size$iv <= rem$iv;
                boolean $i$f$require = false;
                if (!condition$iv$iv) {
                    RequireFailureCapture m$iv$iv = new RequireFailureCapture(size$iv, rem$iv){
                        final /* synthetic */ int $size$inlined;
                        final /* synthetic */ int $rem$inlined;
                        {
                            this.$size$inlined = n;
                            this.$rem$inlined = n2;
                        }

                        @NotNull
                        public Void doFail() {
                            String string;
                            boolean bl = false;
                            String string2 = string = "size " + this.$size$inlined + " is greater than buffer's remaining capacity " + this.$rem$inlined;
                            throw (Throwable)new IllegalArgumentException(string2);
                        }
                    };
                    Void void_ = m$iv$iv.doFail();
                    throw null;
                }
                ByteBuffer buffer$iv = this_$iv.writeBuffer;
                int positionBefore$iv = buffer$iv.position();
                ByteBuffer bb = buffer$iv;
                boolean bl9 = false;
                int l = bb.limit();
                if (bb.remaining() > remInt) {
                    bb.limit(bb.position() + remInt);
                }
                if ((rc = $receiver.read(bb)) == -1) {
                    throw (Throwable)new EOFException("Premature end of stream: was read " + read + " bytes of " + min);
                }
                bb.limit(l);
                int delta$iv = buffer$iv.position() - positionBefore$iv;
                if (delta$iv < 0 || delta$iv > rem$iv) {
                    Void void_ = ErrorsKt.wrongBufferPositionChangeError(delta$iv, size$iv);
                    throw null;
                }
                void this_$iv$iv = this_$iv;
                boolean $i$f$afterWrite = false;
                void var24_32 = this_$iv$iv;
                ByteBuffer byteBuffer = this_$iv$iv.readBuffer;
                boolean $i$f$getWritePosition = false;
                int n2 = this_$iv$iv$iv.writeBuffer.position();
                byteBuffer.limit(n2);
            }
        }
        catch (Throwable t) {
            BuffersKt.releaseAll(head, pool);
            throw t;
        }
        return new ByteReadPacket(head, pool);
    }

    /*
     * WARNING - void declaration
     */
    public static final int read(@NotNull ReadableByteChannel $receiver, @NotNull IoBuffer buffer) {
        void this_$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)buffer, (String)"buffer");
        if (buffer.getWriteRemaining() == 0) {
            return 0;
        }
        int rc = $receiver.read(buffer.writeBuffer);
        IoBuffer this_$iv = buffer;
        boolean $i$f$afterWrite = false;
        IoBuffer ioBuffer = this_$iv;
        ByteBuffer byteBuffer = this_$iv.readBuffer;
        boolean $i$f$getWritePosition = false;
        int n = this_$iv$iv.writeBuffer.position();
        byteBuffer.limit(n);
        return rc;
    }

    public static final int write(@NotNull WritableByteChannel $receiver, @NotNull IoBuffer buffer) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)buffer, (String)"buffer");
        return $receiver.write(buffer.readBuffer);
    }
}

