/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.diagnostics;

import com.intellij.lang.LighterASTNode;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.analysis.checkers.SourceHelpersKt;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtTokens;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\n\u001a\u001e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\nH\u0002\u001a<\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\n2\b\b\u0002\u0010\u0011\u001a\u00020\b\u001aB\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\n2\u0006\u0010\u0011\u001a\u00020\b\u001a<\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\n2\u0006\u0010\u0011\u001a\u00020\b\u001a\f\u0010\u0016\u001a\u00020\u0006*\u00020\bH\u0000\u001a\u001a\u0010\u0017\u001a\u00020\b*\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\nH\u0002\u001a\u001a\u0010\u0018\u001a\u00020\b*\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\nH\u0000\"\u001c\u0010\u0000\u001a\u0010\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001c\u0010\u0004\u001a\u0010\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"DOC_AND_COMMENT_TOKENS", "", "Lcom/intellij/psi/tree/IElementType;", "kotlin.jvm.PlatformType", "FILLER_TOKENS", "hasSyntaxErrors", "", "node", "Lcom/intellij/lang/LighterASTNode;", "tree", "Lcom/intellij/util/diff/FlyweightCapableTreeStructure;", "markElement", "", "Lcom/intellij/openapi/util/TextRange;", "startOffset", "", "endOffset", "originalNode", "markRange", "from", "to", "markSingleElement", "isFiller", "nonFillerFirstChildOrSelf", "nonFillerLastChildOrSelf", "checkers"})
public final class LightTreePositioningStrategyKt {
    @NotNull
    private static final Set<IElementType> DOC_AND_COMMENT_TOKENS;
    @NotNull
    private static final Set<IElementType> FILLER_TOKENS;

    @NotNull
    public static final List<TextRange> markElement(@NotNull LighterASTNode node, int startOffset, int endOffset, @NotNull FlyweightCapableTreeStructure<LighterASTNode> tree, @NotNull LighterASTNode originalNode) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter(tree, (String)"tree");
        Intrinsics.checkNotNullParameter((Object)originalNode, (String)"originalNode");
        return LightTreePositioningStrategyKt.markRange(node, node, startOffset, endOffset, tree, originalNode);
    }

    public static /* synthetic */ List markElement$default(LighterASTNode lighterASTNode2, int n, int n2, FlyweightCapableTreeStructure flyweightCapableTreeStructure, LighterASTNode lighterASTNode3, int n3, Object object) {
        if ((n3 & 0x10) != 0) {
            lighterASTNode3 = lighterASTNode2;
        }
        return LightTreePositioningStrategyKt.markElement(lighterASTNode2, n, n2, flyweightCapableTreeStructure, lighterASTNode3);
    }

    @NotNull
    public static final List<TextRange> markRange(@NotNull LighterASTNode from2, @NotNull LighterASTNode to, int startOffset, int endOffset, @NotNull FlyweightCapableTreeStructure<LighterASTNode> tree, @NotNull LighterASTNode originalNode) {
        Intrinsics.checkNotNullParameter((Object)from2, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        Intrinsics.checkNotNullParameter(tree, (String)"tree");
        Intrinsics.checkNotNullParameter((Object)originalNode, (String)"originalNode");
        return CollectionsKt.listOf((Object)LightTreePositioningStrategyKt.markSingleElement(from2, to, startOffset, endOffset, tree, originalNode));
    }

    @NotNull
    public static final TextRange markSingleElement(@NotNull LighterASTNode from2, @NotNull LighterASTNode to, int startOffset, int endOffset, @NotNull FlyweightCapableTreeStructure<LighterASTNode> tree, @NotNull LighterASTNode originalNode) {
        Intrinsics.checkNotNullParameter((Object)from2, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        Intrinsics.checkNotNullParameter(tree, (String)"tree");
        Intrinsics.checkNotNullParameter((Object)originalNode, (String)"originalNode");
        LighterASTNode betterFrom = LightTreePositioningStrategyKt.nonFillerFirstChildOrSelf(from2, tree);
        LighterASTNode betterTo = LightTreePositioningStrategyKt.nonFillerLastChildOrSelf(to, tree);
        int startDelta = tree.getStartOffset(betterFrom) - tree.getStartOffset(originalNode);
        int endDelta = tree.getEndOffset(betterTo) - tree.getEndOffset(originalNode);
        return new TextRange(startDelta + startOffset, endDelta + endOffset);
    }

    private static final LighterASTNode nonFillerFirstChildOrSelf(LighterASTNode $this$nonFillerFirstChildOrSelf, FlyweightCapableTreeStructure<LighterASTNode> tree) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = SourceHelpersKt.getChildren($this$nonFillerFirstChildOrSelf, tree);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                LighterASTNode it = (LighterASTNode)element$iv;
                boolean bl = false;
                if (!(it != null && !LightTreePositioningStrategyKt.isFiller(it))) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        LighterASTNode lighterASTNode2 = v0;
        return lighterASTNode2 == null ? $this$nonFillerFirstChildOrSelf : lighterASTNode2;
    }

    @NotNull
    public static final LighterASTNode nonFillerLastChildOrSelf(@NotNull LighterASTNode $this$nonFillerLastChildOrSelf, @NotNull FlyweightCapableTreeStructure<LighterASTNode> tree) {
        LighterASTNode lighterASTNode2;
        block1: {
            Intrinsics.checkNotNullParameter((Object)$this$nonFillerLastChildOrSelf, (String)"<this>");
            Intrinsics.checkNotNullParameter(tree, (String)"tree");
            List<LighterASTNode> $this$lastOrNull$iv = SourceHelpersKt.getChildren($this$nonFillerLastChildOrSelf, tree);
            boolean $i$f$lastOrNull = false;
            ListIterator<LighterASTNode> iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
            while (iterator$iv.hasPrevious()) {
                LighterASTNode element$iv;
                LighterASTNode it = element$iv = iterator$iv.previous();
                boolean bl = false;
                if (!(it != null && !LightTreePositioningStrategyKt.isFiller(it))) continue;
                lighterASTNode2 = element$iv;
                break block1;
            }
            lighterASTNode2 = null;
        }
        LighterASTNode lighterASTNode3 = lighterASTNode2;
        return lighterASTNode3 == null ? $this$nonFillerLastChildOrSelf : lighterASTNode3;
    }

    public static final boolean isFiller(@NotNull LighterASTNode $this$isFiller) {
        Intrinsics.checkNotNullParameter((Object)$this$isFiller, (String)"<this>");
        return FILLER_TOKENS.contains($this$isFiller.getTokenType());
    }

    private static final boolean hasSyntaxErrors(LighterASTNode node, FlyweightCapableTreeStructure<LighterASTNode> tree) {
        boolean bl;
        Object v0;
        Object object;
        block5: {
            if (Intrinsics.areEqual((Object)node.getTokenType(), (Object)TokenType.ERROR_ELEMENT)) {
                return true;
            }
            Ref<T[]> childrenRef = new Ref<T[]>();
            tree.getChildren(node, childrenRef);
            object = (LighterASTNode[])childrenRef.get();
            if (object == null) {
                return false;
            }
            Object[] children2 = object;
            List $this$lastOrNull$iv = ArraysKt.filterNotNull((Object[])children2);
            boolean $i$f$lastOrNull = false;
            ListIterator iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
            while (iterator$iv.hasPrevious()) {
                Object element$iv = iterator$iv.previous();
                LighterASTNode it = (LighterASTNode)element$iv;
                boolean bl2 = false;
                IElementType tokenType = it.getTokenType();
                if (!(!(tokenType instanceof KtSingleValueToken) && !DOC_AND_COMMENT_TOKENS.contains(tokenType))) continue;
                v0 = element$iv;
                break block5;
            }
            v0 = null;
        }
        object = v0;
        if (object == null) {
            bl = false;
        } else {
            Object object2;
            Object it = object2 = object;
            boolean bl3 = false;
            bl = LightTreePositioningStrategyKt.hasSyntaxErrors((LighterASTNode)it, tree);
        }
        return bl;
    }

    public static final /* synthetic */ boolean access$hasSyntaxErrors(LighterASTNode node, FlyweightCapableTreeStructure tree) {
        return LightTreePositioningStrategyKt.hasSyntaxErrors(node, tree);
    }

    static {
        Object[] objectArray = new IElementType[]{KtTokens.WHITE_SPACE, KtTokens.IDENTIFIER, KtTokens.EOL_COMMENT, KtTokens.BLOCK_COMMENT, KtTokens.SHEBANG_COMMENT, KtTokens.DOC_COMMENT};
        DOC_AND_COMMENT_TOKENS = SetsKt.setOf((Object[])objectArray);
        objectArray = new IElementType[]{KtTokens.WHITE_SPACE, KtTokens.EOL_COMMENT, KtTokens.BLOCK_COMMENT, KtTokens.SHEBANG_COMMENT, KtTokens.DOC_COMMENT};
        FILLER_TOKENS = SetsKt.setOf((Object[])objectArray);
    }
}

