/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.syntax;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.analysis.FirSourceUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.syntax.FirExpressionSyntaxChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporterKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.expressions.FirWhenBranch;
import org.jetbrains.kotlin.fir.expressions.FirWhenExpression;
import org.jetbrains.kotlin.fir.expressions.impl.FirElseIfTrueCondition;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtTokens;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J(\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/syntax/FirCommaInWhenConditionChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/syntax/FirExpressionSyntaxChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirWhenExpression;", "Lcom/intellij/psi/PsiElement;", "()V", "checkCommaInBranchCondition", "", "branch", "Lorg/jetbrains/kotlin/fir/expressions/FirWhenBranch;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "checkLightTree", "element", "source", "Lorg/jetbrains/kotlin/fir/FirSourceElement;", "isApplicable", "", "checkers"})
public final class FirCommaInWhenConditionChecker
extends FirExpressionSyntaxChecker<FirWhenExpression, PsiElement> {
    @NotNull
    public static final FirCommaInWhenConditionChecker INSTANCE = new FirCommaInWhenConditionChecker();

    private FirCommaInWhenConditionChecker() {
    }

    @Override
    public boolean isApplicable(@NotNull FirWhenExpression element, @NotNull FirSourceElement source) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return element.getSubject() == null;
    }

    @Override
    public void checkLightTree(@NotNull FirWhenExpression element, @NotNull FirSourceElement source, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        for (FirWhenBranch branch : element.getBranches()) {
            if (branch.getCondition() instanceof FirElseIfTrueCondition) continue;
            this.checkCommaInBranchCondition(branch, context2, reporter);
        }
    }

    private final void checkCommaInBranchCondition(FirWhenBranch branch, CheckerContext context2, DiagnosticReporter reporter) {
        FirSourceElement source = branch.getSource();
        FirSourceElement firSourceElement = source;
        if (Intrinsics.areEqual((Object)(firSourceElement == null ? null : firSourceElement.getElementType()), (Object)KtNodeTypes.WHEN_ENTRY)) {
            FirSourceElement firSourceElement2;
            firSourceElement = source;
            if (firSourceElement == null) {
                firSourceElement2 = null;
            } else {
                KtSingleValueToken ktSingleValueToken = KtTokens.COMMA;
                Intrinsics.checkNotNullExpressionValue((Object)ktSingleValueToken, (String)"COMMA");
                firSourceElement2 = FirSourceUtilsKt.getChild$default(firSourceElement, ktSingleValueToken, 0, 1, 2, null);
            }
            if (firSourceElement2 != null) {
                DiagnosticReporterKt.reportOn$default(reporter, source, FirErrors.INSTANCE.getCOMMA_IN_WHEN_CONDITION_WITHOUT_ARGUMENT(), context2, null, 8, null);
            }
        }
    }
}

