/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.kotlin.datetime;

import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlinx.datetime.ConvertersKt;
import kotlinx.datetime.Instant;
import kotlinx.datetime.TimeZone;
import kotlinx.datetime.TimeZoneKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.sql.ColumnType;
import org.jetbrains.exposed.sql.IDateColumnType;
import org.jetbrains.exposed.sql.kotlin.datetime.KotlinDateColumnTypeKt;
import org.jetbrains.exposed.sql.vendors.DatabaseDialect;
import org.jetbrains.exposed.sql.vendors.DatabaseDialectKt;
import org.jetbrains.exposed.sql.vendors.H2Dialect;
import org.jetbrains.exposed.sql.vendors.H2Kt;
import org.jetbrains.exposed.sql.vendors.OracleDialect;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0005\u0018\u0000 \u00132\u00020\u00012\u00020\u0002:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0011\u001a\u00020\rH\u0016J\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/exposed/sql/kotlin/datetime/KotlinLocalTimeColumnType;", "Lorg/jetbrains/exposed/sql/ColumnType;", "Lorg/jetbrains/exposed/sql/IDateColumnType;", "()V", "hasTimePart", "", "getHasTimePart", "()Z", "longToLocalTime", "Lkotlinx/datetime/LocalTime;", "millis", "", "nonNullValueToString", "", "value", "", "notNullValueToDB", "sqlType", "valueFromDB", "Companion", "exposed-kotlin-datetime"})
public final class KotlinLocalTimeColumnType
extends ColumnType
implements IDateColumnType {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean hasTimePart;
    @NotNull
    private static final KotlinLocalTimeColumnType INSTANCE = new KotlinLocalTimeColumnType();

    public KotlinLocalTimeColumnType() {
        super(false, 1, null);
        this.hasTimePart = true;
    }

    public boolean getHasTimePart() {
        return this.hasTimePart;
    }

    @NotNull
    public String sqlType() {
        return DatabaseDialectKt.getCurrentDialect().getDataTypeProvider().timeType();
    }

    @NotNull
    public String nonNullValueToString(@NotNull Object value) {
        Comparable<LocalTime> comparable;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        DateTimeFormatter formatter = DatabaseDialectKt.getCurrentDialect() instanceof OracleDialect || H2Kt.getH2Mode((DatabaseDialect)DatabaseDialectKt.getCurrentDialect()) == H2Dialect.H2CompatibilityMode.Oracle ? KotlinDateColumnTypeKt.access$getORACLE_TIME_STRING_FORMATTER() : KotlinDateColumnTypeKt.access$getDEFAULT_TIME_STRING_FORMATTER();
        Object object = value;
        if (object instanceof String) {
            return (String)value;
        }
        if (object instanceof kotlinx.datetime.LocalTime) {
            comparable = ConvertersKt.toJavaLocalTime((kotlinx.datetime.LocalTime)((kotlinx.datetime.LocalTime)value));
        } else if (object instanceof Time) {
            comparable = ConvertersKt.toJavaInstant((Instant)Instant.Companion.fromEpochMilliseconds(((Time)value).getTime()));
        } else if (object instanceof Timestamp) {
            comparable = ConvertersKt.toJavaInstant((Instant)Instant.Companion.fromEpochSeconds(((Timestamp)value).getTime() / (long)1000, (long)((Timestamp)value).getNanos()));
        } else {
            throw new IllegalStateException(("Unexpected value: " + value + " of " + Reflection.getOrCreateKotlinClass(value.getClass()).getQualifiedName()).toString());
        }
        LocalTime instant = comparable;
        return '\'' + formatter.format(instant) + '\'';
    }

    @NotNull
    public kotlinx.datetime.LocalTime valueFromDB(@NotNull Object value) {
        kotlinx.datetime.LocalTime localTime;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Object object = value;
        if (object instanceof kotlinx.datetime.LocalTime) {
            localTime = (kotlinx.datetime.LocalTime)value;
        } else if (object instanceof Time) {
            LocalTime localTime2 = ((Time)value).toLocalTime();
            Intrinsics.checkNotNullExpressionValue((Object)localTime2, (String)"toLocalTime(...)");
            localTime = ConvertersKt.toKotlinLocalTime((LocalTime)localTime2);
        } else if (object instanceof Timestamp) {
            LocalTime localTime3 = ((Timestamp)value).toLocalDateTime().toLocalTime();
            Intrinsics.checkNotNullExpressionValue((Object)localTime3, (String)"toLocalTime(...)");
            localTime = ConvertersKt.toKotlinLocalTime((LocalTime)localTime3);
        } else if (object instanceof Integer) {
            localTime = this.longToLocalTime(((Number)value).intValue());
        } else if (object instanceof Long) {
            localTime = this.longToLocalTime(((Number)value).longValue());
        } else if (object instanceof String) {
            DateTimeFormatter formatter = DatabaseDialectKt.getCurrentDialect() instanceof OracleDialect || H2Kt.getH2Mode((DatabaseDialect)DatabaseDialectKt.getCurrentDialect()) == H2Dialect.H2CompatibilityMode.Oracle ? KotlinDateColumnTypeKt.access$formatterForDateString((String)value) : KotlinDateColumnTypeKt.access$getDEFAULT_TIME_STRING_FORMATTER();
            LocalTime localTime4 = LocalTime.parse((CharSequence)value, formatter);
            Intrinsics.checkNotNullExpressionValue((Object)localTime4, (String)"parse(...)");
            localTime = ConvertersKt.toKotlinLocalTime((LocalTime)localTime4);
        } else {
            localTime = this.valueFromDB(value.toString());
        }
        return localTime;
    }

    @NotNull
    public Object notNullValueToDB(@NotNull Object value) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (value instanceof kotlinx.datetime.LocalTime) {
            Time time = Time.valueOf(ConvertersKt.toJavaLocalTime((kotlinx.datetime.LocalTime)((kotlinx.datetime.LocalTime)value)));
            object = time;
            Intrinsics.checkNotNullExpressionValue((Object)time, (String)"valueOf(...)");
        } else {
            object = value;
        }
        return object;
    }

    private final kotlinx.datetime.LocalTime longToLocalTime(long millis) {
        return TimeZoneKt.toLocalDateTime((Instant)Instant.Companion.fromEpochMilliseconds(millis), (TimeZone)KotlinDateColumnTypeKt.access$getDEFAULT_TIME_ZONE()).getTime();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/exposed/sql/kotlin/datetime/KotlinLocalTimeColumnType$Companion;", "", "()V", "INSTANCE", "Lorg/jetbrains/exposed/sql/kotlin/datetime/KotlinLocalTimeColumnType;", "getINSTANCE$exposed_kotlin_datetime", "()Lorg/jetbrains/exposed/sql/kotlin/datetime/KotlinLocalTimeColumnType;", "exposed-kotlin-datetime"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KotlinLocalTimeColumnType getINSTANCE$exposed_kotlin_datetime() {
            return INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

