/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.kotlin.datetime;

import java.sql.Date;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.datetime.ConvertersKt;
import kotlinx.datetime.TimeZone;
import kotlinx.datetime.TimeZoneKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.ColumnType;
import org.jetbrains.exposed.sql.IDateColumnType;
import org.jetbrains.exposed.sql.kotlin.datetime.KotlinDateColumnTypeKt;
import org.jetbrains.exposed.sql.vendors.DatabaseDialect;
import org.jetbrains.exposed.sql.vendors.DatabaseDialectKt;
import org.jetbrains.exposed.sql.vendors.H2Dialect;
import org.jetbrains.exposed.sql.vendors.H2Kt;
import org.jetbrains.exposed.sql.vendors.OracleDialect;
import org.jetbrains.exposed.sql.vendors.SQLiteDialect;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u0000 \u001a2\u00020\u00012\u00020\u0002:\u0001\u001aB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000bH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u000fH\u0016J\u0010\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/exposed/sql/kotlin/datetime/KotlinLocalDateTimeColumnType;", "Lorg/jetbrains/exposed/sql/ColumnType;", "Lorg/jetbrains/exposed/sql/IDateColumnType;", "()V", "hasTimePart", "", "getHasTimePart", "()Z", "longToLocalDateTime", "Lkotlinx/datetime/LocalDateTime;", "millis", "", "seconds", "nanos", "nonNullValueToString", "", "value", "", "notNullValueToDB", "readObject", "rs", "Ljava/sql/ResultSet;", "index", "", "sqlType", "valueFromDB", "Companion", "exposed-kotlin-datetime"})
@SourceDebugExtension(value={"SMAP\nKotlinDateColumnType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinDateColumnType.kt\norg/jetbrains/exposed/sql/kotlin/datetime/KotlinLocalDateTimeColumnType\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,457:1\n1#2:458\n*E\n"})
public final class KotlinLocalDateTimeColumnType
extends ColumnType
implements IDateColumnType {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean hasTimePart;
    @NotNull
    private static final KotlinLocalDateTimeColumnType INSTANCE = new KotlinLocalDateTimeColumnType();

    public KotlinLocalDateTimeColumnType() {
        super(false, 1, null);
        this.hasTimePart = true;
    }

    public boolean getHasTimePart() {
        return this.hasTimePart;
    }

    @NotNull
    public String sqlType() {
        return DatabaseDialectKt.getCurrentDialect().getDataTypeProvider().dateTimeType();
    }

    @NotNull
    public String nonNullValueToString(@NotNull Object value) {
        kotlinx.datetime.Instant instant;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Object object = value;
        if (object instanceof String) {
            return (String)value;
        }
        if (object instanceof kotlinx.datetime.LocalDateTime) {
            instant = TimeZoneKt.toInstant((kotlinx.datetime.LocalDateTime)((kotlinx.datetime.LocalDateTime)value), (TimeZone)KotlinDateColumnTypeKt.access$getDEFAULT_TIME_ZONE());
        } else if (object instanceof Date) {
            instant = kotlinx.datetime.Instant.Companion.fromEpochMilliseconds(((Date)value).getTime());
        } else if (object instanceof Timestamp) {
            instant = kotlinx.datetime.Instant.Companion.fromEpochSeconds(((Timestamp)value).getTime() / (long)1000, (long)((Timestamp)value).getNanos());
        } else {
            throw new IllegalStateException(("Unexpected value: " + value + " of " + Reflection.getOrCreateKotlinClass(value.getClass()).getQualifiedName()).toString());
        }
        kotlinx.datetime.Instant instant2 = instant;
        DatabaseDialect dialect = DatabaseDialectKt.getCurrentDialect();
        return dialect instanceof SQLiteDialect ? '\'' + KotlinDateColumnTypeKt.access$getSQLITE_AND_ORACLE_DATE_TIME_STRING_FORMATTER().format(ConvertersKt.toJavaInstant((kotlinx.datetime.Instant)instant2)) + '\'' : (dialect instanceof OracleDialect || H2Kt.getH2Mode((DatabaseDialect)dialect) == H2Dialect.H2CompatibilityMode.Oracle ? '\'' + KotlinDateColumnTypeKt.access$getSQLITE_AND_ORACLE_DATE_TIME_STRING_FORMATTER().format(ConvertersKt.toJavaInstant((kotlinx.datetime.Instant)instant2)) + '\'' : '\'' + KotlinDateColumnTypeKt.access$getDEFAULT_DATE_TIME_STRING_FORMATTER().format(ConvertersKt.toJavaInstant((kotlinx.datetime.Instant)instant2)) + '\'');
    }

    @NotNull
    public Object valueFromDB(@NotNull Object value) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Object object2 = value;
        if (object2 instanceof kotlinx.datetime.LocalDateTime) {
            object = value;
        } else if (object2 instanceof Date) {
            object = this.longToLocalDateTime(((Date)value).getTime());
        } else if (object2 instanceof Timestamp) {
            object = this.longToLocalDateTime(((Timestamp)value).getTime() / (long)1000, ((Timestamp)value).getNanos());
        } else if (object2 instanceof Integer) {
            object = this.longToLocalDateTime(((Number)value).intValue());
        } else if (object2 instanceof Long) {
            object = this.longToLocalDateTime(((Number)value).longValue());
        } else if (object2 instanceof LocalDateTime) {
            object = ConvertersKt.toKotlinLocalDateTime((LocalDateTime)((LocalDateTime)value));
        } else if (object2 instanceof String) {
            LocalDateTime localDateTime = LocalDateTime.parse((CharSequence)value, KotlinDateColumnTypeKt.access$formatterForDateString((String)value));
            Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"parse(...)");
            object = ConvertersKt.toKotlinLocalDateTime((LocalDateTime)localDateTime);
        } else if (object2 instanceof OffsetDateTime) {
            LocalDateTime localDateTime = ((OffsetDateTime)value).toLocalDateTime();
            Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"toLocalDateTime(...)");
            object = ConvertersKt.toKotlinLocalDateTime((LocalDateTime)localDateTime);
        } else {
            object = this.valueFromDB(value.toString());
        }
        return object;
    }

    @NotNull
    public Object notNullValueToDB(@NotNull Object value) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (value instanceof kotlinx.datetime.LocalDateTime && DatabaseDialectKt.getCurrentDialect() instanceof SQLiteDialect) {
            String string = KotlinDateColumnTypeKt.access$getSQLITE_AND_ORACLE_DATE_TIME_STRING_FORMATTER().format(ConvertersKt.toJavaLocalDateTime((kotlinx.datetime.LocalDateTime)((kotlinx.datetime.LocalDateTime)value)).atZone(ZoneId.systemDefault()));
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        } else if (value instanceof kotlinx.datetime.LocalDateTime) {
            Timestamp timestamp;
            Instant instant = ConvertersKt.toJavaLocalDateTime((kotlinx.datetime.LocalDateTime)((kotlinx.datetime.LocalDateTime)value)).atZone(ZoneId.systemDefault()).toInstant();
            Timestamp $this$notNullValueToDB_u24lambda_u240 = timestamp = new Timestamp(instant.toEpochMilli());
            boolean bl = false;
            $this$notNullValueToDB_u24lambda_u240.setNanos(instant.getNano());
            object = timestamp;
        } else {
            object = value;
        }
        return object;
    }

    @Nullable
    public Object readObject(@NotNull ResultSet rs, int index) {
        Intrinsics.checkNotNullParameter((Object)rs, (String)"rs");
        return DatabaseDialectKt.getCurrentDialect() instanceof OracleDialect ? rs.getObject(index, Timestamp.class) : super.readObject(rs, index);
    }

    private final kotlinx.datetime.LocalDateTime longToLocalDateTime(long millis) {
        return TimeZoneKt.toLocalDateTime((kotlinx.datetime.Instant)kotlinx.datetime.Instant.Companion.fromEpochMilliseconds(millis), (TimeZone)KotlinDateColumnTypeKt.access$getDEFAULT_TIME_ZONE());
    }

    private final kotlinx.datetime.LocalDateTime longToLocalDateTime(long seconds, long nanos) {
        return TimeZoneKt.toLocalDateTime((kotlinx.datetime.Instant)kotlinx.datetime.Instant.Companion.fromEpochSeconds(seconds, nanos), (TimeZone)KotlinDateColumnTypeKt.access$getDEFAULT_TIME_ZONE());
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/exposed/sql/kotlin/datetime/KotlinLocalDateTimeColumnType$Companion;", "", "()V", "INSTANCE", "Lorg/jetbrains/exposed/sql/kotlin/datetime/KotlinLocalDateTimeColumnType;", "getINSTANCE$exposed_kotlin_datetime", "()Lorg/jetbrains/exposed/sql/kotlin/datetime/KotlinLocalDateTimeColumnType;", "exposed-kotlin-datetime"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KotlinLocalDateTimeColumnType getINSTANCE$exposed_kotlin_datetime() {
            return INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

