/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.kotlin.datetime;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlinx.datetime.ConvertersKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.ColumnType;
import org.jetbrains.exposed.sql.IDateColumnType;
import org.jetbrains.exposed.sql.kotlin.datetime.KotlinDateColumnTypeKt;
import org.jetbrains.exposed.sql.vendors.DatabaseDialect;
import org.jetbrains.exposed.sql.vendors.DatabaseDialectKt;
import org.jetbrains.exposed.sql.vendors.H2Dialect;
import org.jetbrains.exposed.sql.vendors.H2Kt;
import org.jetbrains.exposed.sql.vendors.OracleDialect;
import org.jetbrains.exposed.sql.vendors.SQLiteDialect;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u00012\u00020\u0002:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001a\u0010\r\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\tH\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/exposed/sql/kotlin/datetime/KotlinInstantColumnType;", "Lorg/jetbrains/exposed/sql/ColumnType;", "Lorg/jetbrains/exposed/sql/IDateColumnType;", "()V", "hasTimePart", "", "getHasTimePart", "()Z", "nonNullValueToString", "", "value", "", "notNullValueToDB", "readObject", "rs", "Ljava/sql/ResultSet;", "index", "", "sqlType", "valueFromDB", "Lkotlinx/datetime/Instant;", "Companion", "exposed-kotlin-datetime"})
public final class KotlinInstantColumnType
extends ColumnType
implements IDateColumnType {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean hasTimePart;
    @NotNull
    private static final KotlinInstantColumnType INSTANCE = new KotlinInstantColumnType();

    public KotlinInstantColumnType() {
        super(false, 1, null);
        this.hasTimePart = true;
    }

    public boolean getHasTimePart() {
        return this.hasTimePart;
    }

    @NotNull
    public String sqlType() {
        return DatabaseDialectKt.getCurrentDialect().getDataTypeProvider().dateTimeType();
    }

    @NotNull
    public String nonNullValueToString(@NotNull Object value) {
        Instant instant;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Object object = value;
        if (object instanceof String) {
            return (String)value;
        }
        if (object instanceof kotlinx.datetime.Instant) {
            instant = ConvertersKt.toJavaInstant((kotlinx.datetime.Instant)((kotlinx.datetime.Instant)value));
        } else if (object instanceof Timestamp) {
            instant = ((Timestamp)value).toInstant();
        } else {
            throw new IllegalStateException(("Unexpected value: " + value + " of " + Reflection.getOrCreateKotlinClass(value.getClass()).getQualifiedName()).toString());
        }
        Instant instant2 = instant;
        return DatabaseDialectKt.getCurrentDialect() instanceof OracleDialect || H2Kt.getH2Mode((DatabaseDialect)DatabaseDialectKt.getCurrentDialect()) == H2Dialect.H2CompatibilityMode.Oracle ? '\'' + KotlinDateColumnTypeKt.access$getSQLITE_AND_ORACLE_DATE_TIME_STRING_FORMATTER().format(instant2) + '\'' : '\'' + KotlinDateColumnTypeKt.access$getDEFAULT_DATE_TIME_STRING_FORMATTER().format(instant2) + '\'';
    }

    @NotNull
    public kotlinx.datetime.Instant valueFromDB(@NotNull Object value) {
        kotlinx.datetime.Instant instant;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Object object = value;
        if (object instanceof Timestamp) {
            Instant instant2 = ((Timestamp)value).toInstant();
            Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"toInstant(...)");
            instant = ConvertersKt.toKotlinInstant((Instant)instant2);
        } else {
            instant = object instanceof String ? kotlinx.datetime.Instant.Companion.parse((String)value) : this.valueFromDB(value.toString());
        }
        return instant;
    }

    @Nullable
    public Object readObject(@NotNull ResultSet rs, int index) {
        Intrinsics.checkNotNullParameter((Object)rs, (String)"rs");
        return rs.getTimestamp(index);
    }

    @NotNull
    public Object notNullValueToDB(@NotNull Object value) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (value instanceof kotlinx.datetime.Instant && DatabaseDialectKt.getCurrentDialect() instanceof SQLiteDialect) {
            String string = KotlinDateColumnTypeKt.access$getSQLITE_AND_ORACLE_DATE_TIME_STRING_FORMATTER().format(ConvertersKt.toJavaInstant((kotlinx.datetime.Instant)((kotlinx.datetime.Instant)value)));
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        } else if (value instanceof kotlinx.datetime.Instant) {
            Timestamp timestamp = Timestamp.from(ConvertersKt.toJavaInstant((kotlinx.datetime.Instant)((kotlinx.datetime.Instant)value)));
            object = timestamp;
            Intrinsics.checkNotNullExpressionValue((Object)timestamp, (String)"from(...)");
        } else {
            object = value;
        }
        return object;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/exposed/sql/kotlin/datetime/KotlinInstantColumnType$Companion;", "", "()V", "INSTANCE", "Lorg/jetbrains/exposed/sql/kotlin/datetime/KotlinInstantColumnType;", "getINSTANCE$exposed_kotlin_datetime", "()Lorg/jetbrains/exposed/sql/kotlin/datetime/KotlinInstantColumnType;", "exposed-kotlin-datetime"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KotlinInstantColumnType getINSTANCE$exposed_kotlin_datetime() {
            return INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

