/*
 * Decompiled with CFR 0.152.
 */
package org.incendo.cloud.processors.requirements.annotation;

import java.lang.annotation.Annotation;
import java.util.Objects;
import java.util.function.Function;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.common.returnsreceiver.qual.This;
import org.incendo.cloud.annotations.AnnotationParser;
import org.incendo.cloud.annotations.BuilderModifier;
import org.incendo.cloud.key.CloudKey;
import org.incendo.cloud.processors.requirements.Requirement;
import org.incendo.cloud.processors.requirements.Requirements;
import org.incendo.cloud.processors.requirements.annotation.RequirementBindings;

@API(status=API.Status.INTERNAL, consumers={"org.incendo.cloud.requirement.annotations.*"}, since="1.0.0")
final class RequirementBindingsImpl<C, R extends Requirement<C, R>>
implements RequirementBindings<C, R> {
    private final AnnotationParser<C> annotationParser;
    private final CloudKey<Requirements<C, R>> requirementKey;

    RequirementBindingsImpl(@NonNull AnnotationParser<C> annotationParser, @NonNull CloudKey<Requirements<C, R>> requirementKey) {
        this.annotationParser = Objects.requireNonNull(annotationParser, "annotationParser");
        this.requirementKey = Objects.requireNonNull(requirementKey, "requirementKey");
    }

    @Override
    public <A extends Annotation> @This @NonNull RequirementBindings<C, R> register(@NonNull Class<A> annotation, @NonNull Function<A, R> requirement) {
        Objects.requireNonNull(annotation, "annotation");
        Objects.requireNonNull(requirement, "requirement");
        this.annotationParser.registerBuilderModifier(annotation, new RequirementBuilderModifier<A>(requirement));
        return this;
    }

    @API(status=API.Status.INTERNAL, consumers={"org.incendo.cloud.requirement.annotations.*"}, since="1.0.0")
    private final class RequirementBuilderModifier<A extends Annotation>
    implements BuilderModifier<A, C> {
        private final Function<A, R> requirementFunction;

        private RequirementBuilderModifier(Function<A, R> requirementFunction) {
            this.requirementFunction = Objects.requireNonNull(requirementFunction, "requirementFunction");
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
         @NonNull Command.Builder<? extends C> modifyBuilder(@NonNull A annotation, // Could not load outer class - annotation placement on inner may be incorrect
         @NonNull Command.Builder<C> builder) {
            Requirements requirements = (Requirements)builder.meta().getOrDefault(RequirementBindingsImpl.this.requirementKey, Requirements.empty());
            return builder.meta(RequirementBindingsImpl.this.requirementKey, requirements.with((Requirement)this.requirementFunction.apply(annotation)));
        }
    }
}

