/*
 * Decompiled with CFR 0.152.
 */
package org.incendo.cloud.processors.requirements;

import java.util.Objects;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.incendo.cloud.execution.postprocessor.CommandPostprocessingContext;
import org.incendo.cloud.execution.postprocessor.CommandPostprocessor;
import org.incendo.cloud.key.CloudKey;
import org.incendo.cloud.processors.requirements.Requirement;
import org.incendo.cloud.processors.requirements.RequirementFailureHandler;
import org.incendo.cloud.processors.requirements.Requirements;
import org.incendo.cloud.services.type.ConsumerService;

@API(status=API.Status.STABLE, since="1.0.0")
public final class RequirementPostprocessor<C, R extends Requirement<C, R>>
implements CommandPostprocessor<C> {
    private final CloudKey<Requirements<C, R>> requirementKey;
    private final RequirementFailureHandler<C, R> failureHandler;

    public static <C, R extends Requirement<C, R>> RequirementPostprocessor<C, R> of(@NonNull CloudKey<Requirements<C, R>> requirementKey, @NonNull RequirementFailureHandler<C, R> failureHandler) {
        return new RequirementPostprocessor<C, R>(requirementKey, failureHandler);
    }

    private RequirementPostprocessor(@NonNull CloudKey<Requirements<C, R>> requirementKey, @NonNull RequirementFailureHandler<C, R> failureHandler) {
        this.requirementKey = Objects.requireNonNull(requirementKey, "requirementKey");
        this.failureHandler = Objects.requireNonNull(failureHandler, "failureHandler");
    }

    public void accept(@NonNull CommandPostprocessingContext<C> context) {
        Requirements requirements = (Requirements)context.command().commandMeta().getOrDefault(this.requirementKey, null);
        if (requirements == null) {
            return;
        }
        for (Requirement requirement : requirements) {
            if (requirement.evaluateRequirement(context.commandContext())) continue;
            this.failureHandler.handleFailure(context.commandContext(), requirement);
            ConsumerService.interrupt();
        }
    }
}

