/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.processor.annotation;

import javax.lang.model.element.ExecutableElement;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hibernate.processor.annotation.AbstractAnnotatedMethod;
import org.hibernate.processor.annotation.AnnotationMetaEntity;

public class LifecycleMethod
extends AbstractAnnotatedMethod {
    private final @UnknownKeyFor @NonNull @Initialized String entity;
    private final @UnknownKeyFor @NonNull @Initialized String methodName;
    private final @UnknownKeyFor @NonNull @Initialized String parameterName;
    private final @UnknownKeyFor @NonNull @Initialized String operationName;
    private final @UnknownKeyFor @NonNull @Initialized boolean addNonnullAnnotation;
    private final @UnknownKeyFor @NonNull @Initialized boolean iterateParameter;
    private final @UnknownKeyFor @NonNull @Initialized boolean returnArgument;
    private final @UnknownKeyFor @NonNull @Initialized boolean hasGeneratedId;

    public LifecycleMethod(@UnknownKeyFor @NonNull @Initialized AnnotationMetaEntity annotationMetaEntity, @UnknownKeyFor @NonNull @Initialized ExecutableElement method, @UnknownKeyFor @NonNull @Initialized String entity, @UnknownKeyFor @NonNull @Initialized String methodName, @UnknownKeyFor @NonNull @Initialized String parameterName, @UnknownKeyFor @NonNull @Initialized String sessionName, @UnknownKeyFor @NonNull @Initialized String sessionType, @UnknownKeyFor @NonNull @Initialized String operationName, @UnknownKeyFor @NonNull @Initialized boolean addNonnullAnnotation, @UnknownKeyFor @NonNull @Initialized boolean iterateParameter, @UnknownKeyFor @NonNull @Initialized boolean returnArgument, @UnknownKeyFor @NonNull @Initialized boolean hasGeneratedId) {
        super(annotationMetaEntity, method, sessionName, sessionType);
        this.entity = entity;
        this.methodName = methodName;
        this.parameterName = parameterName;
        this.operationName = operationName;
        this.addNonnullAnnotation = addNonnullAnnotation;
        this.iterateParameter = iterateParameter;
        this.returnArgument = returnArgument;
        this.hasGeneratedId = hasGeneratedId;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean hasTypedAttribute() {
        return true;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean hasStringAttribute() {
        return false;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getAttributeDeclarationString() {
        StringBuilder declaration = new StringBuilder();
        this.preamble(declaration);
        this.nullCheck(declaration);
        declaration.append("\ttry {\n");
        this.delegateCall(declaration);
        this.returnArgument(declaration);
        declaration.append("\t}\n");
        if (this.operationName.equals("insert")) {
            this.convertException(declaration, "org.hibernate.exception.ConstraintViolationException", "jakarta.data.exceptions.EntityExistsException");
        } else {
            this.convertException(declaration, "org.hibernate.StaleStateException", "jakarta.data.exceptions.OptimisticLockingFailureException");
        }
        this.convertException(declaration, "jakarta.persistence.PersistenceException", "jakarta.data.exceptions.DataException");
        declaration.append("}");
        return declaration.toString();
    }

    private void returnArgument(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration) {
        if (this.returnArgument) {
            if (this.isReactive()) {
                declaration.append(".replaceWith(").append(this.parameterName).append(")");
            } else {
                declaration.append("\t\treturn ").append(this.parameterName);
            }
            declaration.append(";\n");
        } else if (this.isReactive()) {
            declaration.append(";\n");
        }
    }

    private void delegateCall(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration) {
        if (this.isReactive()) {
            declaration.append("\t\treturn ").append(this.sessionName);
            if (this.isReactiveSessionAccess()) {
                declaration.append(".chain(").append(this.localSessionName()).append(" -> ").append(this.localSessionName());
            }
            declaration.append('.').append(this.operationName).append('(').append(this.parameterName).append(')');
            if (this.isReactiveSessionAccess()) {
                declaration.append(')');
            }
        } else {
            if (this.iterateParameter) {
                declaration.append("\t\tfor (var _entity : ").append(this.parameterName).append(") {\n\t");
            }
            if ("upsert".equals(this.operationName) && this.hasGeneratedId) {
                declaration.append("\t\tif (").append(this.sessionName).append(".getIdentifier(").append(this.iterateParameter ? "_entity" : this.parameterName).append(") == null)\n").append("\t\t\t").append(this.sessionName).append('.').append("insert").append('(').append(this.iterateParameter ? "_entity" : this.parameterName).append(')').append(";\n").append("\t\telse\n\t");
            }
            declaration.append("\t\t").append(this.sessionName).append('.').append(this.operationName).append('(').append(this.iterateParameter ? "_entity" : this.parameterName).append(')').append(";\n");
            if (this.iterateParameter) {
                declaration.append("\t\t}\n");
            }
        }
    }

    private void preamble(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration) {
        declaration.append("\n@Override\npublic ").append(this.returnType()).append(' ').append(this.methodName).append('(');
        this.notNull(declaration);
        declaration.append(this.annotationMetaEntity.importType(this.entity)).append(' ').append(this.parameterName).append(')').append(" {\n");
    }

    private @UnknownKeyFor @NonNull @Initialized String returnType() {
        String entityType = this.annotationMetaEntity.importType(this.entity);
        if (this.isReactive()) {
            return this.annotationMetaEntity.importType("io.smallrye.mutiny.Uni") + "<" + (this.returnArgument ? entityType : "Void") + ">";
        }
        return this.returnArgument ? entityType : "void";
    }

    private void nullCheck(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration) {
        declaration.append("\tif (").append(this.parameterName).append(" == null) throw new IllegalArgumentException(\"Null ").append(this.parameterName).append("\");\n");
    }

    private void convertException(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration, @UnknownKeyFor @NonNull @Initialized String exception, @UnknownKeyFor @NonNull @Initialized String convertedException) {
        declaration.append("\tcatch (").append(this.annotationMetaEntity.importType(exception)).append(" exception) {\n").append("\t\tthrow new ").append(this.annotationMetaEntity.importType(convertedException)).append("(exception.getMessage(), exception);\n").append("\t}\n");
    }

    private void notNull(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration) {
        if (this.addNonnullAnnotation) {
            declaration.append('@').append(this.annotationMetaEntity.importType("jakarta.annotation.Nonnull")).append(' ');
        }
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getAttributeNameDeclarationString() {
        throw new UnsupportedOperationException("operation not supported");
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getMetaType() {
        throw new UnsupportedOperationException("operation not supported");
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getPropertyName() {
        return this.methodName;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getTypeDeclaration() {
        return this.entity;
    }
}

