/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.jcache.access;

import org.hibernate.cache.CacheException;
import org.hibernate.cache.internal.DefaultCacheKeysFactory;
import org.hibernate.cache.jcache.JCacheEntityRegion;
import org.hibernate.cache.jcache.access.JCacheRegionAccessStrategy;
import org.hibernate.cache.spi.access.EntityRegionAccessStrategy;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.persister.entity.EntityPersister;

public class NonStrictEntityRegionAccessStrategy
extends JCacheRegionAccessStrategy<JCacheEntityRegion>
implements EntityRegionAccessStrategy {
    public NonStrictEntityRegionAccessStrategy(JCacheEntityRegion jCacheEntityRegion) {
        super(jCacheEntityRegion);
    }

    public boolean insert(SharedSessionContractImplementor session, Object key, Object value, Object version) throws CacheException {
        return false;
    }

    public boolean afterInsert(SharedSessionContractImplementor session, Object key, Object value, Object version) throws CacheException {
        ((JCacheEntityRegion)this.getRegion()).put(key, value);
        return true;
    }

    public boolean update(SharedSessionContractImplementor session, Object key, Object value, Object currentVersion, Object previousVersion) throws CacheException {
        ((JCacheEntityRegion)this.getRegion()).remove(key);
        return false;
    }

    public boolean afterUpdate(SharedSessionContractImplementor session, Object key, Object value, Object currentVersion, Object previousVersion, SoftLock lock) throws CacheException {
        ((JCacheEntityRegion)this.getRegion()).remove(key);
        return false;
    }

    public Object generateCacheKey(Object id, EntityPersister persister, SessionFactoryImplementor factory, String tenantIdentifier) {
        return DefaultCacheKeysFactory.createEntityKey((Object)id, (EntityPersister)persister, (SessionFactoryImplementor)factory, (String)tenantIdentifier);
    }

    public Object getCacheKeyId(Object cacheKey) {
        return DefaultCacheKeysFactory.getEntityId((Object)cacheKey);
    }

    @Override
    public void remove(SharedSessionContractImplementor session, Object key) throws CacheException {
        this.evict(key);
    }
}

