/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.build.gradle.publish.auth.maven;

import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.publish.maven.tasks.PublishToMavenRepository;
import org.hibernate.build.gradle.publish.auth.maven.Credentials;
import org.hibernate.build.gradle.publish.auth.maven.CredentialsProvider;
import org.hibernate.build.gradle.publish.auth.maven.CredentialsProviderRegistry;

public class PublishingAuthenticationHandler
implements Action<PublishToMavenRepository> {
    private final CredentialsProviderRegistry credentialsProviderRegistry;

    public PublishingAuthenticationHandler(CredentialsProviderRegistry credentialsProviderRegistry) {
        this.credentialsProviderRegistry = credentialsProviderRegistry;
    }

    public void applyTo(Project project) {
        final PublishingAuthenticationHandler authAction = this;
        project.getTasks().withType(PublishToMavenRepository.class).all((Action)new Action<PublishToMavenRepository>(){

            public void execute(PublishToMavenRepository task) {
                task.doFirst(authAction);
            }
        });
    }

    public void execute(PublishToMavenRepository publishToMavenRepository) {
        MavenArtifactRepository mavenRepo = publishToMavenRepository.getRepository();
        String id = mavenRepo.getName();
        Credentials credentials = this.locateAuthenticationCredentials(id);
        if (credentials == null) {
            return;
        }
        publishToMavenRepository.getRepository().getCredentials().setUsername(credentials.getUserName());
        publishToMavenRepository.getRepository().getCredentials().setPassword(credentials.getPassword());
    }

    private Credentials locateAuthenticationCredentials(String repositoryId) {
        for (CredentialsProvider provider : this.credentialsProviderRegistry.providers()) {
            Credentials authentication = provider.determineAuthentication(repositoryId);
            if (authentication == null) continue;
            return authentication;
        }
        return null;
    }
}

