/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.build.gradle.publish.auth.maven;

import java.lang.reflect.Method;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.maven.MavenDeployer;
import org.gradle.api.tasks.Upload;
import org.hibernate.build.gradle.publish.auth.maven.Credentials;
import org.hibernate.build.gradle.publish.auth.maven.CredentialsProvider;
import org.hibernate.build.gradle.publish.auth.maven.CredentialsProviderRegistry;

public class LegacyAuthenticationHandler
implements Action<Upload> {
    private final CredentialsProviderRegistry credentialsProviderRegistry;

    public LegacyAuthenticationHandler(CredentialsProviderRegistry credentialsProviderRegistry) {
        this.credentialsProviderRegistry = credentialsProviderRegistry;
    }

    public void applyTo(Project project) {
        final LegacyAuthenticationHandler authAction = this;
        project.getTasks().withType(Upload.class).all((Action)new Action<Upload>(){

            public void execute(Upload uploadTask) {
                if (!uploadTask.getRepositories().withType(MavenDeployer.class).isEmpty()) {
                    uploadTask.doFirst(authAction);
                }
            }
        });
    }

    public void execute(Upload upload) {
        upload.getRepositories().withType(MavenDeployer.class).all((Action)new Action<MavenDeployer>(){

            public void execute(MavenDeployer deployer) {
                Repository snapshotRepository;
                Credentials authentication;
                Object snapshotRepositoryDelegate;
                Repository repository;
                Credentials authentication2;
                Object repositoryDelegate = deployer.getRepository();
                if (repositoryDelegate != null && (authentication2 = LegacyAuthenticationHandler.this.locateAuthenticationDetails(repository = new Repository(repositoryDelegate, deployer.getClass().getClassLoader()))) != null) {
                    repository.addAuthentication(authentication2);
                }
                if ((snapshotRepositoryDelegate = deployer.getSnapshotRepository()) != null && (authentication = LegacyAuthenticationHandler.this.locateAuthenticationDetails(snapshotRepository = new Repository(snapshotRepositoryDelegate, deployer.getClass().getClassLoader()))) != null) {
                    snapshotRepository.addAuthentication(authentication);
                }
            }
        });
    }

    private Credentials locateAuthenticationDetails(Repository repository) {
        String repositoryId = repository.getId();
        for (CredentialsProvider provider : this.credentialsProviderRegistry.providers()) {
            Credentials authentication = provider.determineAuthentication(repositoryId);
            if (authentication == null) continue;
            return authentication;
        }
        return null;
    }

    public static class ReflectionException
    extends RuntimeException {
        public ReflectionException(String message) {
            super(message);
        }

        public ReflectionException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static class Repository {
        private final Object delegate;
        private final ClassLoader classLoader;
        private Method idGetterMethod;
        private Method urlGetterMethod;
        private Method addAuthenticationMethod;
        private static final String REMOTE_REPO_CLASS_NAME = "org.apache.maven.artifact.ant.RemoteRepository";
        private Class remoteRepoClass;
        private Method userNameSetterMethod;
        private Method passwordSetterMethod;
        private Method privateKeySetterMethod;
        private Method passphraseSetterMethod;
        private static final String AUTH_CLASS_NAME = "org.apache.maven.artifact.ant.Authentication";
        private Class authClass;

        public Repository(Object delegate, ClassLoader classLoader) {
            this.delegate = delegate;
            this.classLoader = classLoader;
        }

        public String getId() {
            try {
                return (String)this.idGetterMethod().invoke(this.delegate, new Object[0]);
            }
            catch (Exception e) {
                throw new ReflectionException("Unable to invoke getId method", e);
            }
        }

        public String getUrl() {
            try {
                return (String)this.urlGetterMethod().invoke(this.delegate, new Object[0]);
            }
            catch (Exception e) {
                throw new ReflectionException("Unable to invoke getUrl method", e);
            }
        }

        public void addAuthentication(Credentials authentication) {
            try {
                this.authenticationAdderMethod().invoke(this.delegate, this.getDelegate(authentication));
            }
            catch (Exception e) {
                throw new ReflectionException("Unable to invoke addAuthentication method", e);
            }
        }

        private Object getDelegate(Credentials authentication) {
            Object delegate;
            try {
                delegate = this.getAuthClass().newInstance();
            }
            catch (Exception e) {
                throw new ReflectionException("Unable to instantiate org.apache.maven.artifact.ant.Authentication", e);
            }
            this.setUserName(authentication.getUserName(), delegate);
            this.setPassword(authentication.getPassword(), delegate);
            this.setPrivateKey(authentication.getPrivateKey(), delegate);
            this.setPassphrase(authentication.getPassphrase(), delegate);
            return delegate;
        }

        private void setUserName(String username, Object delegate) {
            try {
                this.getUserNameSetter().invoke(delegate, username);
            }
            catch (Exception e) {
                throw new ReflectionException("Unable to invoke setUserName method", e);
            }
        }

        private void setPassword(String password, Object delegate) {
            try {
                this.getPasswordSetter().invoke(delegate, password);
            }
            catch (Exception e) {
                throw new ReflectionException("Unable to invoke setPassword method", e);
            }
        }

        private void setPrivateKey(String privateKey, Object delegate) {
            try {
                this.getPrivateKeySetter().invoke(delegate, privateKey);
            }
            catch (Exception e) {
                throw new ReflectionException("Unable to invoke setPrivateKey method", e);
            }
        }

        private void setPassphrase(String passphrase, Object delegate) {
            try {
                this.getPassphraseSetter().invoke(delegate, passphrase);
            }
            catch (Exception e) {
                throw new ReflectionException("Unable to invoke setPassphrase method", e);
            }
        }

        public Method idGetterMethod() {
            if (this.idGetterMethod == null) {
                this.idGetterMethod = this.locateIdGetterMethod();
            }
            return this.idGetterMethod;
        }

        private Method locateIdGetterMethod() {
            try {
                return this.getRemoteRepositoryClass().getMethod("getId", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new ReflectionException("Could not locate getId method", e);
            }
        }

        public Method urlGetterMethod() {
            if (this.urlGetterMethod == null) {
                this.urlGetterMethod = this.locateUrlGetterMethod();
            }
            return this.urlGetterMethod;
        }

        private Method locateUrlGetterMethod() {
            try {
                return this.getRemoteRepositoryClass().getMethod("getUrl", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new ReflectionException("Could not locate getUrl method", e);
            }
        }

        private Method authenticationAdderMethod() {
            if (this.addAuthenticationMethod == null) {
                this.addAuthenticationMethod = this.locateAuthenticationAdderMethod();
            }
            return this.addAuthenticationMethod;
        }

        private Method locateAuthenticationAdderMethod() {
            try {
                return this.getRemoteRepositoryClass().getMethod("addAuthentication", this.getAuthClass());
            }
            catch (NoSuchMethodException e) {
                throw new ReflectionException("Could not locate addAuthentication method", e);
            }
        }

        public Class getRemoteRepositoryClass() {
            if (this.remoteRepoClass == null) {
                this.remoteRepoClass = this.locateRemoteRepositoryClass();
            }
            return this.remoteRepoClass;
        }

        private Class locateRemoteRepositoryClass() {
            try {
                return this.classLoader.loadClass(REMOTE_REPO_CLASS_NAME);
            }
            catch (ClassNotFoundException e) {
                throw new ReflectionException("Unable to locate class [org.apache.maven.artifact.ant.RemoteRepository]", e);
            }
        }

        private Method getUserNameSetter() {
            if (this.userNameSetterMethod == null) {
                this.userNameSetterMethod = this.locateUserNameSetter();
            }
            return this.userNameSetterMethod;
        }

        private Method locateUserNameSetter() {
            try {
                return this.getAuthClass().getMethod("setUserName", String.class);
            }
            catch (NoSuchMethodException e) {
                throw new ReflectionException("Could not locate setUserName method", e);
            }
        }

        private Method getPasswordSetter() {
            if (this.passwordSetterMethod == null) {
                this.passwordSetterMethod = this.locatePasswordSetter();
            }
            return this.passwordSetterMethod;
        }

        private Method locatePasswordSetter() {
            try {
                return this.getAuthClass().getMethod("setPassword", String.class);
            }
            catch (NoSuchMethodException e) {
                throw new ReflectionException("Could not locate setPassword method", e);
            }
        }

        private Method getPrivateKeySetter() {
            if (this.privateKeySetterMethod == null) {
                this.privateKeySetterMethod = this.locatePrivateKeySetter();
            }
            return this.privateKeySetterMethod;
        }

        private Method locatePrivateKeySetter() {
            try {
                return this.getAuthClass().getMethod("setPrivateKey", String.class);
            }
            catch (NoSuchMethodException e) {
                throw new ReflectionException("Could not locate setPrivateKey method", e);
            }
        }

        private Method getPassphraseSetter() {
            if (this.passphraseSetterMethod == null) {
                this.passphraseSetterMethod = this.locatePassphraseSetter();
            }
            return this.passphraseSetterMethod;
        }

        private Method locatePassphraseSetter() {
            try {
                return this.getAuthClass().getMethod("setPassphrase", String.class);
            }
            catch (NoSuchMethodException e) {
                throw new ReflectionException("Could not locate setPassphrase method", e);
            }
        }

        public Class getAuthClass() {
            if (this.authClass == null) {
                this.authClass = this.locateAuthClass();
            }
            return this.authClass;
        }

        private Class locateAuthClass() {
            try {
                return this.classLoader.loadClass(AUTH_CLASS_NAME);
            }
            catch (ClassNotFoundException e) {
                throw new ReflectionException("Unable to locate class [org.apache.maven.artifact.ant.Authentication]", e);
            }
        }
    }
}

