/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec.db.oracle;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.LinearRing;
import org.geolatte.geom.Polygon;
import org.geolatte.geom.Position;
import org.geolatte.geom.codec.db.oracle.AbstractSDODecoder;
import org.geolatte.geom.codec.db.oracle.Element;
import org.geolatte.geom.codec.db.oracle.SDOGType;
import org.geolatte.geom.codec.db.oracle.SDOGeometry;
import org.geolatte.geom.codec.db.oracle.SdoGeometryType;
import org.geolatte.geom.crs.CoordinateReferenceSystem;

public class PolygonSdoDecoder
extends AbstractSDODecoder {
    @Override
    public boolean accepts(SDOGeometry nativeGeom) {
        return nativeGeom.getGType().getTypeGeometry() == SdoGeometryType.POLYGON;
    }

    @Override
    Geometry<?> internalDecode() {
        return this.decode(this.nativeGeom.getGType(), this.nativeGeom.getElements(), this.nativeGeom.getCoordinateReferenceSystem());
    }

    @Override
    protected <P extends Position> Geometry<P> decode(SDOGType gtype, List<Element> elements, CoordinateReferenceSystem<P> crs) {
        LinearRing[] rings = new LinearRing[elements.size()];
        int idx = 1;
        for (Element element : elements) {
            if (element.getElementType().isInteriorRing()) {
                rings[idx++] = new LinearRing<P>(element.linearizedPositions(gtype, crs), crs);
                continue;
            }
            rings[0] = new LinearRing<P>(element.linearizedPositions(gtype, crs), crs);
        }
        if (!Arrays.stream(rings).allMatch(Objects::nonNull)) {
            throw new IllegalStateException("Invalid null ring found when attempting to construct polygon");
        }
        return new Polygon(rings);
    }
}

