/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec;

import org.geolatte.geom.codec.WktDecodeException;
import org.geolatte.geom.codec.WktNumberToken;
import org.geolatte.geom.codec.WktTextToken;
import org.geolatte.geom.codec.WktToken;
import org.geolatte.geom.codec.WktVariant;

class CrsWktTokenizer {
    protected final CharSequence wkt;
    protected final WktVariant variant;
    protected int currentPos = 0;

    CrsWktTokenizer(CharSequence wkt, WktVariant variant) {
        this.wkt = wkt;
        this.variant = variant;
    }

    boolean moreTokens() {
        this.skipWhitespace();
        return this.currentPos < this.wkt.length();
    }

    WktToken nextToken() {
        return this.inner();
    }

    private WktToken inner() {
        if (!this.moreTokens()) {
            return this.variant.end();
        }
        if (this.wkt.charAt(this.currentPos) == this.variant.getOpenListChar()) {
            ++this.currentPos;
            return this.variant.getOpenList();
        }
        if (this.wkt.charAt(this.currentPos) == this.variant.getCloseListChar()) {
            ++this.currentPos;
            return this.variant.getCloseList();
        }
        if (this.wkt.charAt(this.currentPos) == '\"') {
            return this.readText();
        }
        if (Character.isLetter(this.wkt.charAt(this.currentPos))) {
            return this.readToken();
        }
        if (Character.isDigit(this.wkt.charAt(this.currentPos)) || this.wkt.charAt(this.currentPos) == '.' || this.wkt.charAt(this.currentPos) == '-') {
            return this.numericToken();
        }
        if (this.wkt.charAt(this.currentPos) == this.variant.getElemSepChar()) {
            ++this.currentPos;
            return this.variant.getElementSeparator();
        }
        throw new WktDecodeException(String.format("Illegal Character at pos %d in Wkt text: %s", this.currentPos, this.wkt));
    }

    protected WktToken numericToken() {
        return this.readNumberToken();
    }

    protected double readNumber() {
        this.skipWhitespace();
        StringBuilder stb = new StringBuilder();
        char c = this.wkt.charAt(this.currentPos);
        if (c == '-') {
            stb.append(c);
            c = this.wkt.charAt(++this.currentPos);
        }
        if ((c = this.readDigits(stb, c)) == '.') {
            stb.append(c);
            c = this.wkt.charAt(++this.currentPos);
            this.readDigits(stb, c);
        }
        return Double.parseDouble(stb.toString());
    }

    private char readDigits(StringBuilder stb, char c) {
        while (Character.isDigit(c)) {
            stb.append(c);
            c = this.wkt.charAt(++this.currentPos);
        }
        return c;
    }

    protected WktToken readNumberToken() {
        double d = this.readNumber();
        return new WktNumberToken(d);
    }

    protected WktToken readText() {
        StringBuilder builder = new StringBuilder();
        char c = this.wkt.charAt(++this.currentPos);
        while (c != '\"') {
            builder.append(c);
            c = this.wkt.charAt(++this.currentPos);
        }
        ++this.currentPos;
        return new WktTextToken(builder.toString());
    }

    protected void skipWhitespace() {
        while (this.currentPos < this.wkt.length() && Character.isWhitespace(this.wkt.charAt(this.currentPos))) {
            ++this.currentPos;
        }
    }

    protected WktToken readToken() {
        int endPos;
        for (endPos = this.currentPos; endPos < this.wkt.length() && this.isWordChar(this.wkt.charAt(endPos)); ++endPos) {
        }
        WktToken nextToken = this.matchKeyword(this.currentPos, endPos);
        this.currentPos = endPos;
        return nextToken;
    }

    protected boolean isWordChar(char c) {
        return Character.isLetter(c) || Character.isDigit(c) || c == '_';
    }

    protected WktToken matchKeyword(int currentPos, int endPos) {
        return this.variant.matchKeyword(this.wkt, currentPos, endPos);
    }

    public int position() {
        return this.currentPos;
    }
}

