/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.parser;

import java.nio.ByteBuffer;
import org.eclipse.jetty.http2.frames.PriorityFrame;
import org.eclipse.jetty.io.ByteBufferPool;

public class HeaderBlockFragments {
    private final ByteBufferPool byteBufferPool;
    private final int maxCapacity;
    private PriorityFrame priorityFrame;
    private int streamId;
    private boolean endStream;
    private ByteBuffer storage;

    @Deprecated
    public HeaderBlockFragments(ByteBufferPool byteBufferPool) {
        this(byteBufferPool, 8192);
    }

    public HeaderBlockFragments(ByteBufferPool byteBufferPool, int maxCapacity) {
        this.byteBufferPool = byteBufferPool;
        this.maxCapacity = maxCapacity;
    }

    public ByteBufferPool getByteBufferPool() {
        return this.byteBufferPool;
    }

    void reset() {
        this.priorityFrame = null;
        this.streamId = 0;
        this.endStream = false;
        this.storage = null;
    }

    public boolean storeFragment(ByteBuffer fragment, int length, boolean last) {
        if (this.storage == null) {
            if (length > this.maxCapacity) {
                return false;
            }
            int capacity = last ? length : length * 2;
            this.storage = this.byteBufferPool.acquire(capacity, fragment.isDirect());
            this.storage.clear();
        }
        if (this.storage.remaining() < length) {
            if (this.storage.position() + length > this.maxCapacity) {
                return false;
            }
            int space = last ? length : length * 2;
            int capacity = this.storage.position() + space;
            ByteBuffer newStorage = this.byteBufferPool.acquire(capacity, this.storage.isDirect());
            newStorage.clear();
            this.storage.flip();
            newStorage.put(this.storage);
            this.byteBufferPool.release(this.storage);
            this.storage = newStorage;
        }
        int limit = fragment.limit();
        fragment.limit(fragment.position() + length);
        this.storage.put(fragment);
        fragment.limit(limit);
        return true;
    }

    public PriorityFrame getPriorityFrame() {
        return this.priorityFrame;
    }

    public void setPriorityFrame(PriorityFrame priorityFrame) {
        this.priorityFrame = priorityFrame;
    }

    public boolean isEndStream() {
        return this.endStream;
    }

    public void setEndStream(boolean endStream) {
        this.endStream = endStream;
    }

    public ByteBuffer complete() {
        this.storage.flip();
        return this.storage;
    }

    public int getStreamId() {
        return this.streamId;
    }

    public void setStreamId(int streamId) {
        this.streamId = streamId;
    }
}

