/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.mvstore.compat.v1.mvstore.util;

import java.util.UUID;

public final class Bits {
    public static int compareNotNull(char[] var0, char[] var1) {
        if (var0 == var1) {
            return 0;
        }
        int var2 = Math.min(var0.length, var1.length);
        for (int var3 = 0; var3 < var2; ++var3) {
            char var4 = var0[var3];
            char var5 = var1[var3];
            if (var4 == var5) continue;
            return var4 > var5 ? 1 : -1;
        }
        return Integer.signum(var0.length - var1.length);
    }

    public static int compareNotNullSigned(byte[] var0, byte[] var1) {
        if (var0 == var1) {
            return 0;
        }
        int var2 = Math.min(var0.length, var1.length);
        for (int var3 = 0; var3 < var2; ++var3) {
            byte var4 = var0[var3];
            byte var5 = var1[var3];
            if (var4 == var5) continue;
            return var4 > var5 ? 1 : -1;
        }
        return Integer.signum(var0.length - var1.length);
    }

    public static int compareNotNullUnsigned(byte[] var0, byte[] var1) {
        if (var0 == var1) {
            return 0;
        }
        int var2 = Math.min(var0.length, var1.length);
        for (int var3 = 0; var3 < var2; ++var3) {
            int var4 = var0[var3] & 0xFF;
            int var5 = var1[var3] & 0xFF;
            if (var4 == var5) continue;
            return var4 > var5 ? 1 : -1;
        }
        return Integer.signum(var0.length - var1.length);
    }

    public static int readInt(byte[] var0, int var1) {
        return (var0[var1++] << 24) + ((var0[var1++] & 0xFF) << 16) + ((var0[var1++] & 0xFF) << 8) + (var0[var1] & 0xFF);
    }

    public static int readIntLE(byte[] var0, int var1) {
        return (var0[var1++] & 0xFF) + ((var0[var1++] & 0xFF) << 8) + ((var0[var1++] & 0xFF) << 16) + (var0[var1] << 24);
    }

    public static long readLong(byte[] var0, int var1) {
        return ((long)Bits.readInt(var0, var1) << 32) + ((long)Bits.readInt(var0, var1 + 4) & 0xFFFFFFFFL);
    }

    public static long readLongLE(byte[] var0, int var1) {
        return ((long)Bits.readIntLE(var0, var1) & 0xFFFFFFFFL) + ((long)Bits.readIntLE(var0, var1 + 4) << 32);
    }

    public static double readDouble(byte[] var0, int var1) {
        return Double.longBitsToDouble(Bits.readLong(var0, var1));
    }

    public static double readDoubleLE(byte[] var0, int var1) {
        return Double.longBitsToDouble(Bits.readLongLE(var0, var1));
    }

    public static byte[] uuidToBytes(long var0, long var2) {
        byte[] var4 = new byte[16];
        for (int var5 = 0; var5 < 8; ++var5) {
            var4[var5] = (byte)(var0 >> 8 * (7 - var5) & 0xFFL);
            var4[8 + var5] = (byte)(var2 >> 8 * (7 - var5) & 0xFFL);
        }
        return var4;
    }

    public static byte[] uuidToBytes(UUID var0) {
        return Bits.uuidToBytes(var0.getMostSignificantBits(), var0.getLeastSignificantBits());
    }

    public static void writeInt(byte[] var0, int var1, int var2) {
        var0[var1++] = (byte)(var2 >> 24);
        var0[var1++] = (byte)(var2 >> 16);
        var0[var1++] = (byte)(var2 >> 8);
        var0[var1] = (byte)var2;
    }

    public static void writeIntLE(byte[] var0, int var1, int var2) {
        var0[var1++] = (byte)var2;
        var0[var1++] = (byte)(var2 >> 8);
        var0[var1++] = (byte)(var2 >> 16);
        var0[var1] = (byte)(var2 >> 24);
    }

    public static void writeLong(byte[] var0, int var1, long var2) {
        Bits.writeInt(var0, var1, (int)(var2 >> 32));
        Bits.writeInt(var0, var1 + 4, (int)var2);
    }

    public static void writeLongLE(byte[] var0, int var1, long var2) {
        Bits.writeIntLE(var0, var1, (int)var2);
        Bits.writeIntLE(var0, var1 + 4, (int)(var2 >> 32));
    }

    public static void writeDouble(byte[] var0, int var1, double var2) {
        Bits.writeLong(var0, var1, Double.doubleToRawLongBits(var2));
    }

    public static void writeDoubleLE(byte[] var0, int var1, double var2) {
        Bits.writeLongLE(var0, var1, Double.doubleToRawLongBits(var2));
    }

    private Bits() {
    }
}

