/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.mvstore.compat.v1.mvstore.compress;

import java.nio.ByteBuffer;
import org.dizitart.no2.mvstore.compat.v1.mvstore.compress.Compressor;

public final class CompressLZF
implements Compressor {
    private int[] cachedHashTable;

    @Override
    public void setOptions(String var1) {
    }

    private static int first(byte[] var0, int var1) {
        return var0[var1] << 8 | var0[var1 + 1] & 0xFF;
    }

    private static int first(ByteBuffer var0, int var1) {
        return var0.get(var1) << 8 | var0.get(var1 + 1) & 0xFF;
    }

    private static int next(int var0, byte[] var1, int var2) {
        return var0 << 8 | var1[var2 + 2] & 0xFF;
    }

    private static int next(int var0, ByteBuffer var1, int var2) {
        return var0 << 8 | var1.get(var2 + 2) & 0xFF;
    }

    private static int hash(int var0) {
        return var0 * 2777 >> 9 & 0x3FFF;
    }

    @Override
    public int compress(byte[] var1, int var2, byte[] var3, int var4) {
        int var5 = 0;
        if (this.cachedHashTable == null) {
            this.cachedHashTable = new int[16384];
        }
        int[] var6 = this.cachedHashTable;
        int var7 = 0;
        ++var4;
        int var8 = CompressLZF.first(var1, 0);
        while (var5 < var2 - 4) {
            byte var9 = var1[var5 + 2];
            var8 = (var8 << 8) + (var9 & 0xFF);
            int var10 = CompressLZF.hash(var8);
            int var11 = var6[var10];
            var6[var10] = var5;
            if (var11 < var5 && var11 > 0 && (var10 = var5 - var11 - 1) < 8192 && var1[var11 + 2] == var9 && var1[var11 + 1] == (byte)(var8 >> 8) && var1[var11] == (byte)(var8 >> 16)) {
                int var13;
                int var12 = var2 - var5 - 2;
                if (var12 > 264) {
                    var12 = 264;
                }
                if (var7 == 0) {
                    --var4;
                } else {
                    var3[var4 - var7 - 1] = (byte)(var7 - 1);
                    var7 = 0;
                }
                for (var13 = 3; var13 < var12 && var1[var11 + var13] == var1[var5 + var13]; ++var13) {
                }
                if ((var13 -= 2) < 7) {
                    var3[var4++] = (byte)((var10 >> 8) + (var13 << 5));
                } else {
                    var3[var4++] = (byte)((var10 >> 8) + 224);
                    var3[var4++] = (byte)(var13 - 7);
                }
                var3[var4++] = (byte)var10;
                ++var4;
                var8 = CompressLZF.first(var1, var5 += var13);
                var8 = CompressLZF.next(var8, var1, var5);
                var6[CompressLZF.hash((int)var8)] = var5++;
                var8 = CompressLZF.next(var8, var1, var5);
                var6[CompressLZF.hash((int)var8)] = var5++;
                continue;
            }
            var3[var4++] = var1[var5++];
            if (++var7 != 32) continue;
            var3[var4 - var7 - 1] = (byte)(var7 - 1);
            var7 = 0;
            ++var4;
        }
        while (var5 < var2) {
            var3[var4++] = var1[var5++];
            if (++var7 != 32) continue;
            var3[var4 - var7 - 1] = (byte)(var7 - 1);
            var7 = 0;
            ++var4;
        }
        var3[var4 - var7 - 1] = (byte)(var7 - 1);
        if (var7 == 0) {
            --var4;
        }
        return var4;
    }

    public int compress(ByteBuffer var1, int var2, byte[] var3, int var4) {
        int var5 = var1.capacity() - var2;
        if (this.cachedHashTable == null) {
            this.cachedHashTable = new int[16384];
        }
        int[] var6 = this.cachedHashTable;
        int var7 = 0;
        ++var4;
        int var8 = CompressLZF.first(var1, 0);
        while (var2 < var5 - 4) {
            byte var9 = var1.get(var2 + 2);
            var8 = (var8 << 8) + (var9 & 0xFF);
            int var10 = CompressLZF.hash(var8);
            int var11 = var6[var10];
            var6[var10] = var2;
            if (var11 < var2 && var11 > 0 && (var10 = var2 - var11 - 1) < 8192 && var1.get(var11 + 2) == var9 && var1.get(var11 + 1) == (byte)(var8 >> 8) && var1.get(var11) == (byte)(var8 >> 16)) {
                int var13;
                int var12 = var5 - var2 - 2;
                if (var12 > 264) {
                    var12 = 264;
                }
                if (var7 == 0) {
                    --var4;
                } else {
                    var3[var4 - var7 - 1] = (byte)(var7 - 1);
                    var7 = 0;
                }
                for (var13 = 3; var13 < var12 && var1.get(var11 + var13) == var1.get(var2 + var13); ++var13) {
                }
                if ((var13 -= 2) < 7) {
                    var3[var4++] = (byte)((var10 >> 8) + (var13 << 5));
                } else {
                    var3[var4++] = (byte)((var10 >> 8) + 224);
                    var3[var4++] = (byte)(var13 - 7);
                }
                var3[var4++] = (byte)var10;
                ++var4;
                var8 = CompressLZF.first(var1, var2 += var13);
                var8 = CompressLZF.next(var8, var1, var2);
                var6[CompressLZF.hash((int)var8)] = var2++;
                var8 = CompressLZF.next(var8, var1, var2);
                var6[CompressLZF.hash((int)var8)] = var2++;
                continue;
            }
            var3[var4++] = var1.get(var2++);
            if (++var7 != 32) continue;
            var3[var4 - var7 - 1] = (byte)(var7 - 1);
            var7 = 0;
            ++var4;
        }
        while (var2 < var5) {
            var3[var4++] = var1.get(var2++);
            if (++var7 != 32) continue;
            var3[var4 - var7 - 1] = (byte)(var7 - 1);
            var7 = 0;
            ++var4;
        }
        var3[var4 - var7 - 1] = (byte)(var7 - 1);
        if (var7 == 0) {
            --var4;
        }
        return var4;
    }

    @Override
    public void expand(byte[] var1, int var2, int var3, byte[] var4, int var5, int var6) {
        if (var2 >= 0 && var5 >= 0 && var6 >= 0) {
            do {
                int var7;
                if ((var7 = var1[var2++] & 0xFF) < 32) {
                    System.arraycopy(var1, var2, var4, var5, ++var7);
                    var5 += var7;
                    var2 += var7;
                    continue;
                }
                int var8 = var7 >> 5;
                if (var8 == 7) {
                    var8 += var1[var2++] & 0xFF;
                }
                var7 = -((var7 & 0x1F) << 8) - 1;
                var7 -= var1[var2++] & 0xFF;
                var7 += var5;
                if (var5 + (var8 += 2) >= var4.length) {
                    throw new ArrayIndexOutOfBoundsException();
                }
                for (int var9 = 0; var9 < var8; ++var9) {
                    var4[var5++] = var4[var7++];
                }
            } while (var5 < var6);
        } else {
            throw new IllegalArgumentException();
        }
    }

    public static void expand(ByteBuffer var0, ByteBuffer var1) {
        do {
            int var3;
            int var2;
            if ((var2 = var0.get() & 0xFF) < 32) {
                ++var2;
                for (var3 = 0; var3 < var2; ++var3) {
                    var1.put(var0.get());
                }
            } else {
                var3 = var2 >> 5;
                if (var3 == 7) {
                    var3 += var0.get() & 0xFF;
                }
                var3 += 2;
                var2 = -((var2 & 0x1F) << 8) - 1;
                var2 -= var0.get() & 0xFF;
                var2 += var1.position();
                for (int var4 = 0; var4 < var3; ++var4) {
                    var1.put(var1.get(var2++));
                }
            }
        } while (var1.position() < var1.capacity());
    }

    @Override
    public int getAlgorithm() {
        return 1;
    }
}

