/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.mvstore;

import java.io.File;
import java.util.Map;
import lombok.Generated;
import org.dizitart.no2.common.util.StringUtils;
import org.dizitart.no2.exceptions.InvalidOperationException;
import org.dizitart.no2.exceptions.NitriteIOException;
import org.dizitart.no2.mvstore.MVStoreConfig;
import org.dizitart.no2.mvstore.Recovery;
import org.dizitart.no2.mvstore.compat.v1.UpgradeUtil;
import org.h2.mvstore.MVStore;
import org.h2.mvstore.MVStoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MVStoreUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger((String)"nitrite-mvstore");
    private static final String OLD_DATABASE_FORMAT = "Old database format detected.";
    private static final String OLD_STORE_FORMAT = "The write format 1 is smaller than the supported format";
    private static final Integer OLD_DATABASE_FORMAT_VERSION = 29062024;

    private MVStoreUtils() {
    }

    static MVStore openOrCreate(MVStoreConfig storeConfig) {
        MVStore store;
        block21: {
            MVStore.Builder builder = MVStoreUtils.createBuilder(storeConfig);
            store = null;
            File dbFile = !StringUtils.isNullOrEmpty((String)storeConfig.filePath()) ? new File(storeConfig.filePath()) : null;
            try {
                store = builder.open();
                if (dbFile != null) {
                    MVStoreUtils.testForMigration(store);
                }
            }
            catch (MVStoreException me) {
                if (me.getMessage().contains("file is locked")) {
                    throw new NitriteIOException("Database is already opened in other process");
                }
                if (dbFile != null) {
                    try {
                        if (dbFile.isDirectory()) {
                            throw new NitriteIOException(storeConfig.filePath() + " is a directory, must be a file");
                        }
                        if (dbFile.exists() && dbFile.isFile()) {
                            if (MVStoreUtils.isCompatibilityError((Exception)((Object)me))) {
                                if (store != null) {
                                    store.closeImmediately();
                                }
                                store = MVStoreUtils.tryUpgrade(dbFile, storeConfig);
                            } else {
                                log.error("Database corruption detected. Trying to repair", (Throwable)me);
                                Recovery.recover(storeConfig.filePath());
                                store = builder.open();
                            }
                            break block21;
                        }
                        if (storeConfig.isReadOnly().booleanValue()) {
                            throw new NitriteIOException("Cannot create readonly database", (Throwable)me);
                        }
                        throw new NitriteIOException("Cannot access database file", (Throwable)me);
                    }
                    catch (InvalidOperationException | NitriteIOException ex) {
                        throw ex;
                    }
                    catch (Exception e) {
                        throw new NitriteIOException("Database file is corrupted", (Throwable)e);
                    }
                }
                throw new NitriteIOException("Unable to create in-memory database", (Throwable)me);
            }
            catch (IllegalArgumentException iae) {
                if (dbFile != null && !dbFile.getParentFile().exists()) {
                    throw new NitriteIOException("Directory " + dbFile.getParent() + " does not exists", (Throwable)iae);
                }
                throw new NitriteIOException("Unable to create database file", (Throwable)iae);
            }
            finally {
                if (store != null) {
                    store.setRetentionTime(0);
                    store.setVersionsToKeep(0);
                }
            }
        }
        return store;
    }

    private static boolean isCompatibilityError(Exception e) {
        return e.getMessage().contains(OLD_DATABASE_FORMAT) || e.getMessage().contains(OLD_STORE_FORMAT);
    }

    private static MVStore.Builder createBuilder(MVStoreConfig mvStoreConfig) {
        MVStore.Builder builder = new MVStore.Builder();
        if (!StringUtils.isNullOrEmpty((String)mvStoreConfig.filePath())) {
            builder = builder.fileName(mvStoreConfig.filePath());
        }
        if (!mvStoreConfig.autoCommit()) {
            builder = builder.autoCommitDisabled();
        }
        if (mvStoreConfig.autoCommitBufferSize() > 0) {
            builder = builder.autoCommitBufferSize(mvStoreConfig.autoCommitBufferSize());
        }
        builder.autoCompactFillRate(0);
        if (mvStoreConfig.encryptionKey() != null) {
            builder = builder.encryptionKey(mvStoreConfig.encryptionKey());
        }
        if (mvStoreConfig.isReadOnly().booleanValue()) {
            if (StringUtils.isNullOrEmpty((String)mvStoreConfig.filePath())) {
                throw new InvalidOperationException("Unable create readonly in-memory database");
            }
            builder = builder.readOnly();
        }
        if (mvStoreConfig.recoveryMode()) {
            builder = builder.recoveryMode();
        }
        if (mvStoreConfig.cacheSize() > 0) {
            builder = builder.cacheSize(mvStoreConfig.cacheSize());
        }
        if (mvStoreConfig.cacheConcurrency() > 0) {
            builder = builder.cacheConcurrency(mvStoreConfig.cacheConcurrency());
        }
        if (mvStoreConfig.compress()) {
            builder = builder.compress();
        }
        if (mvStoreConfig.compressHigh()) {
            builder = builder.compressHigh();
        }
        if (mvStoreConfig.pageSplitSize() > 0) {
            builder = builder.pageSplitSize(mvStoreConfig.pageSplitSize());
        }
        if (StringUtils.isNullOrEmpty((String)mvStoreConfig.filePath()) && mvStoreConfig.fileStore() != null) {
            builder = builder.fileStore(mvStoreConfig.fileStore());
        }
        return builder;
    }

    private static MVStore tryUpgrade(File orgFile, MVStoreConfig storeConfig) {
        File newFile = new File(orgFile.getPath() + "_new");
        MVStoreConfig newStoreConfig = storeConfig.clone();
        newStoreConfig.filePath(newFile.getPath());
        MVStore.Builder newBuilder = MVStoreUtils.createBuilder(newStoreConfig);
        try {
            UpgradeUtil.tryUpgrade(newBuilder, storeConfig);
        }
        catch (Exception e) {
            if (newFile.exists() && !newFile.delete()) {
                throw new NitriteIOException("Could not upgrade the data file", (Throwable)e);
            }
            throw e;
        }
        MVStoreUtils.switchFiles(newFile, orgFile);
        return MVStoreUtils.openOrCreate(storeConfig);
    }

    private static void switchFiles(File newFile, File orgFile) {
        File backupFile = new File(orgFile.getPath() + "_old");
        if (orgFile.renameTo(backupFile)) {
            if (!newFile.renameTo(orgFile)) {
                throw new NitriteIOException("Could not rename new data file");
            }
            if (!backupFile.delete()) {
                throw new NitriteIOException("Could not delete backup data file");
            }
        } else {
            throw new NitriteIOException("Could not create backup copy of old data file");
        }
    }

    private static void testForMigration(MVStore store) {
        if (store != null) {
            int format;
            Object rawFormatValue;
            Map storeHeader = store.getStoreHeader();
            if (storeHeader == null || storeHeader.isEmpty()) {
                throw new MVStoreException(OLD_DATABASE_FORMAT_VERSION.intValue(), OLD_DATABASE_FORMAT);
            }
            if (storeHeader.containsKey("format") && ((rawFormatValue = storeHeader.get("format")) instanceof Integer ? (format = ((Integer)rawFormatValue).intValue()) < 3 : (format = Integer.parseInt((String)storeHeader.get("format"))) < 3)) {
                throw new MVStoreException(OLD_DATABASE_FORMAT_VERSION.intValue(), OLD_DATABASE_FORMAT);
            }
        }
    }
}

