/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.leveldb.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.iq80.leveldb.impl.InternalKey;
import org.iq80.leveldb.impl.MemTable;
import org.iq80.leveldb.impl.ReverseSeekingIterator;
import org.iq80.leveldb.util.AbstractReverseSeekingIterator;
import org.iq80.leveldb.util.InternalIterator;
import org.iq80.leveldb.util.InternalTableIterator;
import org.iq80.leveldb.util.LevelIterator;
import org.iq80.leveldb.util.Slice;

public final class DbIterator
extends AbstractReverseSeekingIterator<InternalKey, Slice>
implements InternalIterator {
    private final OrdinalIterator[] heap;
    private final Comparator<OrdinalIterator> smallerNext;
    private final Comparator<OrdinalIterator> largerPrev;
    private final Comparator<InternalKey> userComparator;

    public DbIterator(MemTable.MemTableIterator memTableIterator, MemTable.MemTableIterator immutableMemTableIterator, List<InternalTableIterator> level0Files, List<LevelIterator> levels, Comparator<InternalKey> userComparator) {
        this.userComparator = userComparator;
        ArrayList<OrdinalIterator> ordinalIterators = new ArrayList<OrdinalIterator>();
        int ordinal = 0;
        if (memTableIterator != null) {
            ordinalIterators.add(new OrdinalIterator(ordinal++, memTableIterator));
        }
        if (immutableMemTableIterator != null) {
            ordinalIterators.add(new OrdinalIterator(ordinal++, immutableMemTableIterator));
        }
        for (InternalTableIterator level0File : level0Files) {
            ordinalIterators.add(new OrdinalIterator(ordinal++, level0File));
        }
        for (LevelIterator level : levels) {
            ordinalIterators.add(new OrdinalIterator(ordinal++, level));
        }
        this.smallerNext = new SmallerNextElementComparator();
        this.largerPrev = new LargerPrevElementComparator();
        this.heap = ordinalIterators.toArray(new OrdinalIterator[ordinalIterators.size()]);
        this.resetHeap();
    }

    @Override
    protected void seekToFirstInternal() {
        for (OrdinalIterator ord : this.heap) {
            ord.iterator.seekToFirst();
        }
        this.resetHeap();
    }

    @Override
    protected void seekToLastInternal() {
        this.seekToEndInternal();
        this.getPrevElement();
    }

    @Override
    public void seekToEndInternal() {
        for (OrdinalIterator ord : this.heap) {
            ord.iterator.seekToEnd();
        }
        this.resetHeap();
    }

    @Override
    protected void seekInternal(InternalKey targetKey) {
        for (OrdinalIterator ord : this.heap) {
            ord.iterator.seek(targetKey);
        }
        this.resetHeap();
    }

    private Tuple<OrdinalIterator, Integer> getMaxAndIndex() {
        OrdinalIterator max = this.heap[0];
        int maxIndex = 0;
        for (int i = 1; i < this.heap.length; ++i) {
            OrdinalIterator ord = this.heap[i];
            if (this.largerPrev.compare(ord, max) <= 0) continue;
            max = ord;
            maxIndex = i;
        }
        return Tuple.of(max, maxIndex);
    }

    @Override
    protected boolean hasNextInternal() {
        return this.heap[0].iterator.hasNext();
    }

    @Override
    protected boolean hasPrevInternal() {
        for (OrdinalIterator ord : this.heap) {
            if (!ord.iterator.hasPrev()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected Map.Entry<InternalKey, Slice> getNextElement() {
        Map.Entry next = (Map.Entry)this.heap[0].iterator.next();
        DbIterator.siftDown(this.heap, this.smallerNext, 0, this.heap[0]);
        return next;
    }

    @Override
    protected Map.Entry<InternalKey, Slice> getPrevElement() {
        Tuple<OrdinalIterator, Integer> maxAndIndex = this.getMaxAndIndex();
        OrdinalIterator ord = (OrdinalIterator)maxAndIndex.item1;
        int index = (Integer)maxAndIndex.item2;
        Map.Entry prev = (Map.Entry)ord.iterator.prev();
        DbIterator.siftUp(this.heap, this.smallerNext, index, this.heap[index]);
        DbIterator.siftDown(this.heap, this.smallerNext, index, this.heap[index]);
        return prev;
    }

    @Override
    protected Map.Entry<InternalKey, Slice> peekInternal() {
        return (Map.Entry)this.heap[0].iterator.peek();
    }

    @Override
    protected Map.Entry<InternalKey, Slice> peekPrevInternal() {
        return (Map.Entry)((OrdinalIterator)this.getMaxAndIndex().item1).iterator.peekPrev();
    }

    private void resetHeap() {
        for (int i = (this.heap.length >>> 1) - 1; i >= 0; --i) {
            DbIterator.siftDown(this.heap, this.smallerNext, i, this.heap[i]);
        }
    }

    private static <E> void siftDown(E[] queue, Comparator<E> comparator, int k, E x) {
        int half = queue.length >>> 1;
        while (k < half) {
            int child = (k << 1) + 1;
            E c = queue[child];
            int right = child + 1;
            if (right < queue.length && comparator.compare(c, queue[right]) > 0) {
                child = right;
                c = queue[child];
            }
            if (comparator.compare(x, c) <= 0) break;
            queue[k] = c;
            k = child;
        }
        queue[k] = x;
    }

    private static <E> void siftUp(E[] queue, Comparator<E> comparator, int k, E x) {
        int parent;
        E e;
        while (k > 0 && comparator.compare(x, e = queue[parent = k - 1 >>> 1]) < 0) {
            queue[k] = e;
            k = parent;
        }
        queue[k] = x;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("DbIterator");
        sb.append("{iterators=").append(Arrays.asList(this.heap));
        sb.append(", userComparator=").append(this.userComparator);
        sb.append('}');
        return sb.toString();
    }

    private static class Tuple<T1, T2> {
        public final T1 item1;
        public final T2 item2;

        public Tuple(T1 item1, T2 item2) {
            this.item1 = item1;
            this.item2 = item2;
        }

        public static <A, B> Tuple<A, B> of(A a, B b) {
            return new Tuple<A, B>(a, b);
        }
    }

    protected class LargerPrevElementComparator
    implements Comparator<OrdinalIterator> {
        protected LargerPrevElementComparator() {
        }

        @Override
        public int compare(OrdinalIterator o1, OrdinalIterator o2) {
            if (o1.iterator.hasPrev()) {
                if (o2.iterator.hasPrev()) {
                    int result = DbIterator.this.userComparator.compare(((Map.Entry)o1.iterator.peekPrev()).getKey(), ((Map.Entry)o2.iterator.peekPrev()).getKey());
                    return result == 0 ? Integer.compare(o1.ordinal, o2.ordinal) : result;
                }
                return 1;
            }
            if (o2.iterator.hasPrev()) {
                return -1;
            }
            return 0;
        }
    }

    protected class SmallerNextElementComparator
    implements Comparator<OrdinalIterator> {
        protected SmallerNextElementComparator() {
        }

        @Override
        public int compare(OrdinalIterator o1, OrdinalIterator o2) {
            if (o1.iterator.hasNext()) {
                if (o2.iterator.hasNext()) {
                    int result = DbIterator.this.userComparator.compare(((Map.Entry)o1.iterator.peek()).getKey(), ((Map.Entry)o2.iterator.peek()).getKey());
                    return result == 0 ? Integer.compare(o1.ordinal, o2.ordinal) : result;
                }
                return -1;
            }
            if (o2.iterator.hasNext()) {
                return 1;
            }
            return 0;
        }
    }

    private class OrdinalIterator {
        public final ReverseSeekingIterator<InternalKey, Slice> iterator;
        public final int ordinal;

        public OrdinalIterator(int ordinal, ReverseSeekingIterator<InternalKey, Slice> iterator) {
            this.ordinal = ordinal;
            this.iterator = iterator;
        }
    }
}

