/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.leveldb.impl;

import com.google.common.collect.Maps;
import java.util.Comparator;
import java.util.Map;
import org.iq80.leveldb.impl.InternalKey;
import org.iq80.leveldb.impl.SnapshotImpl;
import org.iq80.leveldb.impl.ValueType;
import org.iq80.leveldb.util.AbstractReverseSeekingIterator;
import org.iq80.leveldb.util.DbIterator;
import org.iq80.leveldb.util.Slice;

public final class SnapshotSeekingIterator
extends AbstractReverseSeekingIterator<Slice, Slice> {
    private final DbIterator iterator;
    private final SnapshotImpl snapshot;
    private final Comparator<Slice> userComparator;
    private Direction direction;
    private Map.Entry<InternalKey, Slice> savedEntry;

    public SnapshotSeekingIterator(DbIterator iterator, SnapshotImpl snapshot, Comparator<Slice> userComparator) {
        this.iterator = iterator;
        this.snapshot = snapshot;
        this.userComparator = userComparator;
        this.snapshot.getVersion().retain();
        this.savedEntry = null;
        this.seekToFirst();
    }

    public void close() {
        this.snapshot.getVersion().release();
    }

    @Override
    protected void seekToFirstInternal() {
        this.iterator.seekToFirst();
        this.direction = Direction.FORWARD;
    }

    @Override
    protected void seekToLastInternal() {
        this.seekToEndInternal();
        this.getPrevElement();
    }

    @Override
    public void seekToEndInternal() {
        this.iterator.seekToEnd();
        this.savedEntry = null;
        this.direction = Direction.REVERSE;
    }

    @Override
    protected void seekInternal(Slice targetKey) {
        this.iterator.seek(new InternalKey(targetKey, this.snapshot.getLastSequence(), ValueType.VALUE));
        this.findNextUserEntry(false, null);
        this.direction = Direction.REVERSE;
    }

    @Override
    protected Map.Entry<Slice, Slice> getNextElement() {
        if (this.direction == Direction.REVERSE) {
            if (!this.iterator.hasNext()) {
                this.savedEntry = null;
                return null;
            }
            this.direction = Direction.FORWARD;
        } else {
            this.findNextUserEntry(true, this.savedEntry);
            if (!this.iterator.hasNext()) {
                return null;
            }
        }
        this.savedEntry = this.iterator.next();
        return Maps.immutableEntry((Object)this.savedEntry.getKey().getUserKey(), (Object)this.savedEntry.getValue());
    }

    @Override
    protected Map.Entry<Slice, Slice> getPrevElement() {
        if (this.direction == Direction.FORWARD) {
            if (!this.iterator.hasPrev()) {
                this.savedEntry = null;
                return null;
            }
            this.direction = Direction.REVERSE;
            this.savedEntry = this.iterator.prev();
        } else {
            this.findPrevUserEntry();
            if (this.savedEntry == null) {
                return null;
            }
        }
        return Maps.immutableEntry((Object)this.savedEntry.getKey().getUserKey(), (Object)this.savedEntry.getValue());
    }

    @Override
    protected Map.Entry<Slice, Slice> peekInternal() {
        if (this.hasNextInternal()) {
            Object peek = this.iterator.peek();
            return Maps.immutableEntry((Object)((InternalKey)peek.getKey()).getUserKey(), peek.getValue());
        }
        return null;
    }

    @Override
    protected Map.Entry<Slice, Slice> peekPrevInternal() {
        if (this.hasPrevInternal()) {
            Object peekPrev = this.iterator.peekPrev();
            return Maps.immutableEntry((Object)((InternalKey)peekPrev.getKey()).getUserKey(), peekPrev.getValue());
        }
        return null;
    }

    private void findNextUserEntry(boolean skipping, Map.Entry<InternalKey, Slice> skipEntry) {
        Slice skipKey;
        if (skipEntry == null) {
            skipping = false;
            skipKey = null;
        } else {
            skipKey = skipEntry.getKey().getUserKey();
        }
        while (this.iterator.hasNext()) {
            InternalKey internalKey = (InternalKey)this.iterator.peek().getKey();
            if (internalKey.getSequenceNumber() <= this.snapshot.getLastSequence()) {
                switch (internalKey.getValueType()) {
                    case DELETION: {
                        skipKey = internalKey.getUserKey();
                        skipping = true;
                        break;
                    }
                    case VALUE: {
                        if (skipping && this.userComparator.compare(internalKey.getUserKey(), skipKey) <= 0) break;
                        this.savedEntry = null;
                        return;
                    }
                }
            }
            this.iterator.next();
        }
        this.savedEntry = null;
    }

    private void findPrevUserEntry() {
        ValueType valueType = ValueType.DELETION;
        while (this.iterator.hasPrev()) {
            Object peekPrev = this.iterator.peekPrev();
            InternalKey internalKey = (InternalKey)peekPrev.getKey();
            if (internalKey.getSequenceNumber() <= this.snapshot.getLastSequence()) {
                if (valueType != ValueType.DELETION && (this.savedEntry == null || this.userComparator.compare(internalKey.getUserKey(), this.savedEntry.getKey().getUserKey()) < 0)) break;
                valueType = internalKey.getValueType();
                this.savedEntry = valueType == ValueType.DELETION ? null : peekPrev;
            } else if (valueType == ValueType.VALUE) {
                return;
            }
            this.iterator.prev();
        }
        if (valueType == ValueType.DELETION) {
            this.savedEntry = null;
            this.direction = Direction.FORWARD;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SnapshotSeekingIterator");
        sb.append("{snapshot=").append(this.snapshot);
        sb.append(", iterator=").append(this.iterator);
        sb.append('}');
        return sb.toString();
    }

    @Override
    protected boolean hasNextInternal() {
        if (this.direction == Direction.FORWARD) {
            this.findNextUserEntry(true, this.savedEntry);
            this.direction = Direction.REVERSE;
        }
        return this.iterator.hasNext();
    }

    @Override
    protected boolean hasPrevInternal() {
        if (this.direction == Direction.REVERSE) {
            this.findPrevUserEntry();
            if (this.savedEntry != null) {
                this.iterator.next();
                this.direction = Direction.FORWARD;
            }
        }
        return this.iterator.hasPrev();
    }

    protected static enum Direction {
        FORWARD,
        REVERSE;

    }
}

