/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.leveldb.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicLong;
import org.iq80.leveldb.impl.InternalKey;
import org.iq80.leveldb.impl.InternalKeyComparator;
import org.iq80.leveldb.impl.LookupKey;
import org.iq80.leveldb.impl.LookupResult;
import org.iq80.leveldb.impl.ReverseIterators;
import org.iq80.leveldb.impl.ReversePeekingIterator;
import org.iq80.leveldb.impl.ReverseSeekingIterator;
import org.iq80.leveldb.impl.SeekingIterable;
import org.iq80.leveldb.impl.ValueType;
import org.iq80.leveldb.util.InternalIterator;
import org.iq80.leveldb.util.Slice;

public class MemTable
implements SeekingIterable<InternalKey, Slice> {
    private final ConcurrentSkipListMap<InternalKey, Slice> table;
    private final AtomicLong approximateMemoryUsage = new AtomicLong();

    public MemTable(InternalKeyComparator internalKeyComparator) {
        this.table = new ConcurrentSkipListMap(internalKeyComparator);
    }

    public boolean isEmpty() {
        return this.table.isEmpty();
    }

    public long approximateMemoryUsage() {
        return this.approximateMemoryUsage.get();
    }

    public void add(long sequenceNumber, ValueType valueType, Slice key, Slice value) {
        Preconditions.checkNotNull((Object)((Object)valueType), (Object)"valueType is null");
        Preconditions.checkNotNull((Object)key, (Object)"key is null");
        Preconditions.checkNotNull((Object)((Object)valueType), (Object)"valueType is null");
        InternalKey internalKey = new InternalKey(key, sequenceNumber, valueType);
        this.table.put(internalKey, value);
        this.approximateMemoryUsage.addAndGet(key.length() + 8 + value.length());
    }

    public LookupResult get(LookupKey key) {
        Preconditions.checkNotNull((Object)key, (Object)"key is null");
        InternalKey internalKey = key.getInternalKey();
        Map.Entry<InternalKey, Slice> entry = this.table.ceilingEntry(internalKey);
        if (entry == null) {
            return null;
        }
        InternalKey entryKey = entry.getKey();
        if (entryKey.getUserKey().equals(key.getUserKey())) {
            if (entryKey.getValueType() == ValueType.DELETION) {
                return LookupResult.deleted(key);
            }
            return LookupResult.ok(key, entry.getValue());
        }
        return null;
    }

    public MemTableIterator iterator() {
        return new MemTableIterator();
    }

    public class MemTableIterator
    implements InternalIterator,
    ReverseSeekingIterator<InternalKey, Slice> {
        private ReversePeekingIterator<Map.Entry<InternalKey, Slice>> iterator;
        private final List<Map.Entry<InternalKey, Slice>> entryList;

        public MemTableIterator() {
            this.entryList = Lists.newArrayList(MemTable.this.table.entrySet());
            this.seekToFirst();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public void seekToFirst() {
            this.makeIteratorAtIndex(0);
        }

        @Override
        public void seek(InternalKey targetKey) {
            int index = Collections.binarySearch(this.entryList, Maps.immutableEntry((Object)targetKey, (Object)null), new Comparator<Map.Entry<InternalKey, Slice>>(){

                @Override
                public int compare(Map.Entry<InternalKey, Slice> o1, Map.Entry<InternalKey, Slice> o2) {
                    return MemTable.this.table.comparator().compare(o1.getKey(), o2.getKey());
                }
            });
            if (index < 0) {
                index = -(index + 1);
            }
            this.makeIteratorAtIndex(index);
        }

        public Map.Entry<InternalKey, Slice> peek() {
            return (Map.Entry)this.iterator.peek();
        }

        @Override
        public Map.Entry<InternalKey, Slice> next() {
            return (Map.Entry)this.iterator.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void seekToLast() {
            if (this.entryList.size() == 0) {
                this.seekToFirst();
                return;
            }
            this.makeIteratorAtIndex(this.entryList.size() - 1);
        }

        @Override
        public void seekToEnd() {
            this.makeIteratorAtIndex(this.entryList.size());
        }

        private void makeIteratorAtIndex(int index) {
            this.iterator = ReverseIterators.reversePeekingIterator(this.entryList.listIterator(index));
        }

        @Override
        public Map.Entry<InternalKey, Slice> peekPrev() {
            return this.iterator.peekPrev();
        }

        @Override
        public Map.Entry<InternalKey, Slice> prev() {
            return (Map.Entry)this.iterator.prev();
        }

        @Override
        public boolean hasPrev() {
            return this.iterator.hasPrev();
        }
    }
}

