/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.util.logging;

import java.text.MessageFormat;
import java.util.IllegalFormatException;
import org.slf4j.LoggerFactory;

public final class Logger {
    private final org.slf4j.Logger logger;

    public Logger(Class<?> clazz) {
        this.logger = LoggerFactory.getLogger((String)clazz.getName());
    }

    public Logger(String name) {
        this.logger = LoggerFactory.getLogger((String)name);
    }

    public Logger(org.slf4j.Logger logger) {
        this.logger = logger;
    }

    public org.slf4j.Logger getLogger() {
        return this.logger;
    }

    public Logger debug(String format, Object ... params) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(this.format(format, params));
        }
        return this;
    }

    public Logger debug(String format, Throwable error, Object ... params) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(this.format(format, params), error);
        }
        return this;
    }

    public Logger error(String format, Object ... params) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error(this.format(format, params));
        }
        return this;
    }

    public Logger error(String format, Throwable error, Object ... params) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error(this.format(format, params), error);
        }
        return this;
    }

    public Logger info(String format, Object ... params) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info(this.format(format, params));
        }
        return this;
    }

    public Logger info(String format, Throwable error, Object ... params) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info(this.format(format, params), error);
        }
        return this;
    }

    public Logger trace(String format, Object ... params) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(this.format(format, params));
        }
        return this;
    }

    public Logger trace(String format, Throwable error, Object ... params) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(this.format(format, params), error);
        }
        return this;
    }

    public Logger warn(String format, Object ... params) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn(this.format(format, params));
        }
        return this;
    }

    public Logger warn(String format, Throwable error, Object ... params) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn(this.format(format, params), error);
        }
        return this;
    }

    private String format(String format, Object[] params) {
        String out = format;
        if (params == null || params.length < 1) {
            return out;
        }
        try {
            out = String.format(out, params);
        }
        catch (IllegalFormatException e) {
            try {
                out = MessageFormat.format(out, params);
            }
            catch (IllegalArgumentException e1) {
                out = format;
            }
        }
        return out;
    }
}

