/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.util.logging;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.log4j.Appender;
import org.apache.log4j.Category;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.Configurator;
import org.apache.log4j.spi.LoggerRepository;

public class Log4jUtil {
    public static void configure(Level level) {
        Log4jUtil.configure(level, "%5p [%l] - %m%n");
    }

    public static void configure(final Level level, final String pattern) {
        Configurator log4jConfigurator = new Configurator(){

            public void doConfigure(URL notUsed, LoggerRepository repo) {
                PatternLayout layout = new PatternLayout(pattern);
                ConsoleAppender cAppender = new ConsoleAppender((Layout)layout);
                cAppender.setThreshold((Priority)Level.ALL);
                repo.setThreshold(level);
                repo.getRootLogger().removeAllAppenders();
                repo.getRootLogger().setLevel(level);
                repo.getRootLogger().addAppender((Appender)cAppender);
                ArrayList<Logger> loggers = Collections.list(repo.getCurrentLoggers());
                for (Logger logger : loggers) {
                    logger.setLevel(level);
                }
                ArrayList<Category> cats = Collections.list(repo.getCurrentCategories());
                for (Category cat : cats) {
                    cat.setLevel(level);
                }
            }
        };
        log4jConfigurator.doConfigure(null, LogManager.getLoggerRepository());
    }
}

