/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.api.java;

import org.apache.spark.sql.api.java.DataType;

public class StructField {
    private String name;
    private DataType dataType;
    private boolean nullable;

    protected StructField(String name, DataType dataType, boolean nullable) {
        this.name = name;
        this.dataType = dataType;
        this.nullable = nullable;
    }

    public String getName() {
        return this.name;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StructField that = (StructField)o;
        if (this.nullable != that.nullable) {
            return false;
        }
        if (!this.dataType.equals(that.dataType)) {
            return false;
        }
        return this.name.equals(that.name);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.dataType.hashCode();
        result = 31 * result + (this.nullable ? 1 : 0);
        return result;
    }
}

