/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.rdd;

import org.apache.spark.Partition;
import org.apache.spark.SparkContext;
import org.apache.spark.TaskContext;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.random.RandomDataGenerator;
import org.apache.spark.mllib.rdd.RandomRDD$;
import org.apache.spark.mllib.rdd.RandomRDDPartition;
import org.apache.spark.rdd.RDD;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005=e!B\u0001\u0003\u0001\u0011a!!\u0003*b]\u0012|WN\u0015#E\u0015\t\u0019A!A\u0002sI\u0012T!!\u0002\u0004\u0002\u000b5dG.\u001b2\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e,\"!D\u000b\u0014\u0005\u0001q\u0001cA\b\u0012'5\t\u0001C\u0003\u0002\u0004\r%\u0011!\u0003\u0005\u0002\u0004%\u0012#\u0005C\u0001\u000b\u0016\u0019\u0001!QA\u0006\u0001C\u0002a\u0011\u0011\u0001V\u0002\u0001#\tIr\u0004\u0005\u0002\u001b;5\t1DC\u0001\u001d\u0003\u0015\u00198-\u00197b\u0013\tq2DA\u0004O_RD\u0017N\\4\u0011\u0005i\u0001\u0013BA\u0011\u001c\u0005\r\te.\u001f\u0005\tG\u0001\u0011\t\u0011)A\u0005I\u0005\u00111o\u0019\t\u0003K\u0019j\u0011AB\u0005\u0003O\u0019\u0011Ab\u00159be.\u001cuN\u001c;fqRD#AI\u0015\u0011\u0005iQ\u0013BA\u0016\u001c\u0005%!(/\u00198tS\u0016tG\u000f\u0003\u0005.\u0001\t\u0005\t\u0015!\u0003/\u0003\u0011\u0019\u0018N_3\u0011\u0005iy\u0013B\u0001\u0019\u001c\u0005\u0011auN\\4\t\u0011I\u0002!\u0011!Q\u0001\nM\nQB\\;n!\u0006\u0014H/\u001b;j_:\u001c\bC\u0001\u000e5\u0013\t)4DA\u0002J]RD\u0001b\u000e\u0001\u0003\u0002\u0003\u0006I\u0001O\u0001\u0004e:<\u0007cA\u001d='5\t!H\u0003\u0002<\t\u00051!/\u00198e_6L!!\u0010\u001e\u0003'I\u000bg\u000eZ8n\t\u0006$\u0018mR3oKJ\fGo\u001c:)\u0005YJ\u0003\u0002\u0003!\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0018\u0002\tM,W\r\u001a\u0015\u0003\u007f%B\u0001b\u0011\u0001\u0003\u0004\u0003\u0006Y\u0001R\u0001\u000bKZLG-\u001a8dK\u0012\n\u0004cA#I'5\taI\u0003\u0002H7\u00059!/\u001a4mK\u000e$\u0018BA%G\u0005!\u0019E.Y:t)\u0006<\u0007\"B&\u0001\t\u0003a\u0015A\u0002\u001fj]&$h\b\u0006\u0004N#J\u001bF+\u0016\u000b\u0003\u001dB\u00032a\u0014\u0001\u0014\u001b\u0005\u0011\u0001\"B\"K\u0001\b!\u0005\"B\u0012K\u0001\u0004!\u0003\"B\u0017K\u0001\u0004q\u0003\"\u0002\u001aK\u0001\u0004\u0019\u0004\"B\u001cK\u0001\u0004A\u0004b\u0002!K!\u0003\u0005\rA\f\u0005\u0006/\u0002!\t\u0005W\u0001\bG>l\u0007/\u001e;f)\rIVM\u001b\t\u00045\n\u001cbBA.a\u001d\tav,D\u0001^\u0015\tqv#\u0001\u0004=e>|GOP\u0005\u00029%\u0011\u0011mG\u0001\ba\u0006\u001c7.Y4f\u0013\t\u0019GM\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0015\t\t7\u0004C\u0003g-\u0002\u0007q-A\u0004ta2LG/\u00138\u0011\u0005\u0015B\u0017BA5\u0007\u0005%\u0001\u0016M\u001d;ji&|g\u000eC\u0003l-\u0002\u0007A.A\u0004d_:$X\r\u001f;\u0011\u0005\u0015j\u0017B\u00018\u0007\u0005-!\u0016m]6D_:$X\r\u001f;\t\u000bA\u0004A\u0011I9\u0002\u001b\u001d,G\u000fU1si&$\u0018n\u001c8t+\u0005\u0011\bc\u0001\u000etO&\u0011Ao\u0007\u0002\u0006\u0003J\u0014\u0018-_\u0004\u0007m\nA\t\u0001B<\u0002\u0013I\u000bg\u000eZ8n%\u0012#\u0005CA(y\r\u0019\t!\u0001#\u0001\u0005sN\u0019\u0001P_?\u0011\u0005iY\u0018B\u0001?\u001c\u0005\u0019\te.\u001f*fMB\u0011!D`\u0005\u0003\u007fn\u0011AbU3sS\u0006d\u0017N_1cY\u0016Daa\u0013=\u0005\u0002\u0005\rA#A<\t\rADH\u0011AA\u0004+\u0011\tI!!\u0006\u0015\u0013I\fY!!\u0004\u0002\u0010\u0005]\u0001BB\u0017\u0002\u0006\u0001\u0007a\u0006\u0003\u00043\u0003\u000b\u0001\ra\r\u0005\bo\u0005\u0015\u0001\u0019AA\t!\u0011ID(a\u0005\u0011\u0007Q\t)\u0002\u0002\u0004\u0017\u0003\u000b\u0011\r\u0001\u0007\u0005\u0007\u0001\u0006\u0015\u0001\u0019\u0001\u0018\t\u000f\u0005m\u0001\u0010\"\u0001\u0002\u001e\u0005\u0001r-\u001a;Q_&tG/\u0013;fe\u0006$xN]\u000b\u0005\u0003?\t9\u0003\u0006\u0003\u0002\"\u0005=B\u0003BA\u0012\u0003S\u0001BA\u00172\u0002&A\u0019A#a\n\u0005\rY\tIB1\u0001\u0019\u0011)\tY#!\u0007\u0002\u0002\u0003\u000f\u0011QF\u0001\u000bKZLG-\u001a8dK\u0012\u0012\u0004\u0003B#I\u0003KA\u0001\"!\r\u0002\u001a\u0001\u0007\u00111G\u0001\na\u0006\u0014H/\u001b;j_:\u0004RaTA\u001b\u0003KI1!a\u000e\u0003\u0005I\u0011\u0016M\u001c3p[J#E\tU1si&$\u0018n\u001c8\t\u000f\u0005m\u0002\u0010\"\u0001\u0002>\u0005\tr-\u001a;WK\u000e$xN]%uKJ\fGo\u001c:\u0015\r\u0005}\u0012QJA,!\u0011Q&-!\u0011\u0011\t\u0005\r\u0013\u0011J\u0007\u0003\u0003\u000bR1!a\u0012\u0005\u0003\u0019a\u0017N\\1mO&!\u00111JA#\u0005\u00191Vm\u0019;pe\"A\u0011\u0011GA\u001d\u0001\u0004\ty\u0005E\u0003P\u0003k\t\t\u0006E\u0002\u001b\u0003'J1!!\u0016\u001c\u0005\u0019!u.\u001e2mK\"9\u0011\u0011LA\u001d\u0001\u0004\u0019\u0014A\u0003<fGR|'oU5{K\"I\u0011Q\f=\u0012\u0002\u0013\u0005\u0011qL\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001b\u0016\t\u0005\u0005\u0014qO\u000b\u0003\u0003GR3ALA3W\t\t9\u0007\u0005\u0003\u0002j\u0005MTBAA6\u0015\u0011\ti'a\u001c\u0002\u0013Ut7\r[3dW\u0016$'bAA97\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005U\u00141\u000e\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,GA\u0002\f\u0002\\\t\u0007\u0001\u0004C\u0005\u0002|a\f\t\u0011\"\u0003\u0002~\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\ty\b\u0005\u0003\u0002\u0002\u0006-UBAAB\u0015\u0011\t))a\"\u0002\t1\fgn\u001a\u0006\u0003\u0003\u0013\u000bAA[1wC&!\u0011QRAB\u0005\u0019y%M[3di\u0002")
public class RandomRDD<T>
extends RDD<T> {
    private final long size;
    private final int numPartitions;
    private final transient RandomDataGenerator<T> rng;
    private final transient long seed;
    private final ClassTag<T> evidence$1;

    public static <T> long $lessinit$greater$default$5() {
        return RandomRDD$.MODULE$.$lessinit$greater$default$5();
    }

    public static Iterator<Vector> getVectorIterator(RandomRDDPartition<Object> randomRDDPartition, int n) {
        return RandomRDD$.MODULE$.getVectorIterator(randomRDDPartition, n);
    }

    public static <T> Iterator<T> getPointIterator(RandomRDDPartition<T> randomRDDPartition, ClassTag<T> classTag) {
        return RandomRDD$.MODULE$.getPointIterator(randomRDDPartition, classTag);
    }

    public Iterator<T> compute(Partition splitIn, TaskContext context) {
        RandomRDDPartition split = (RandomRDDPartition)splitIn;
        return RandomRDD$.MODULE$.getPointIterator(split, this.evidence$1);
    }

    public Partition[] getPartitions() {
        return RandomRDD$.MODULE$.getPartitions(this.size, this.numPartitions, this.rng, this.seed);
    }

    public RandomRDD(SparkContext sc, long size, int numPartitions, RandomDataGenerator<T> rng, long seed, ClassTag<T> evidence$1) {
        this.size = size;
        this.numPartitions = numPartitions;
        this.rng = rng;
        this.seed = seed;
        this.evidence$1 = evidence$1;
        super(sc, (Seq)Nil$.MODULE$, evidence$1);
        Predef$.MODULE$.require(size > 0L, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Positive RDD size required.";
            }
        });
        Predef$.MODULE$.require(numPartitions > 0, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Positive number of partitions required";
            }
        });
        Predef$.MODULE$.require(package$.MODULE$.ceil((double)size / (double)numPartitions) <= (double)Integer.MAX_VALUE, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Partition size cannot exceed Int.MaxValue";
            }
        });
    }
}

