/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.api.python;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaRDD$;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.mllib.api.python.MultivariateStatisticalSummarySerialized;
import org.apache.spark.mllib.api.python.SerDe$;
import org.apache.spark.mllib.classification.LogisticRegressionModel;
import org.apache.spark.mllib.classification.LogisticRegressionWithSGD;
import org.apache.spark.mllib.classification.NaiveBayes$;
import org.apache.spark.mllib.classification.NaiveBayesModel;
import org.apache.spark.mllib.classification.SVMModel;
import org.apache.spark.mllib.classification.SVMWithSGD;
import org.apache.spark.mllib.clustering.KMeans$;
import org.apache.spark.mllib.clustering.KMeansModel;
import org.apache.spark.mllib.linalg.Matrix;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.optimization.GradientDescent;
import org.apache.spark.mllib.optimization.L1Updater;
import org.apache.spark.mllib.optimization.SquaredL2Updater;
import org.apache.spark.mllib.random.RandomRDDs$;
import org.apache.spark.mllib.recommendation.ALS$;
import org.apache.spark.mllib.recommendation.MatrixFactorizationModel;
import org.apache.spark.mllib.recommendation.Rating;
import org.apache.spark.mllib.regression.GeneralizedLinearModel;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.regression.LassoModel;
import org.apache.spark.mllib.regression.LassoWithSGD$;
import org.apache.spark.mllib.regression.LinearRegressionModel;
import org.apache.spark.mllib.regression.LinearRegressionWithSGD;
import org.apache.spark.mllib.regression.RidgeRegressionModel;
import org.apache.spark.mllib.regression.RidgeRegressionWithSGD$;
import org.apache.spark.mllib.stat.MultivariateStatisticalSummary;
import org.apache.spark.mllib.stat.Statistics$;
import org.apache.spark.mllib.stat.correlation.CorrelationNames$;
import org.apache.spark.mllib.tree.DecisionTree$;
import org.apache.spark.mllib.tree.configuration.Algo$;
import org.apache.spark.mllib.tree.configuration.Strategy;
import org.apache.spark.mllib.tree.configuration.Strategy$;
import org.apache.spark.mllib.tree.impurity.Impurities$;
import org.apache.spark.mllib.tree.impurity.Impurity;
import org.apache.spark.mllib.tree.model.DecisionTreeModel;
import org.apache.spark.mllib.util.MLUtils$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.util.Utils$;
import scala.Array$;
import scala.Enumeration;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.collection.JavaConverters$;
import scala.collection.TraversableOnce;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

@DeveloperApi
@ScalaSignature(bytes="\u0006\u0001\t]g\u0001B\u0001\u0003\u0001=\u0011a\u0002U=uQ>tW\n\u0014'jE\u0006\u0003\u0016J\u0003\u0002\u0004\t\u00051\u0001/\u001f;i_:T!!\u0002\u0004\u0002\u0007\u0005\u0004\u0018N\u0003\u0002\b\u0011\u0005)Q\u000e\u001c7jE*\u0011\u0011BC\u0001\u0006gB\f'o\u001b\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001\u0001b\u0003\u0005\u0002\u0012)5\t!CC\u0001\u0014\u0003\u0015\u00198-\u00197b\u0013\t)\"C\u0001\u0004B]f\u0014VM\u001a\t\u0003#]I!\u0001\u0007\n\u0003\u0019M+'/[1mSj\f'\r\\3\t\u000bi\u0001A\u0011A\u000e\u0002\rqJg.\u001b;?)\u0005a\u0002CA\u000f\u0001\u001b\u0005\u0011\u0001\"B\u0010\u0001\t\u0003\u0001\u0013!\u00057pC\u0012d\u0015MY3mK\u0012\u0004v.\u001b8ugR!\u0011EL\u001a=!\r\u0011c\u0005K\u0007\u0002G)\u0011A%J\u0001\u0005U\u00064\u0018M\u0003\u0002\u0006\u0011%\u0011qe\t\u0002\b\u0015\u00064\u0018M\u0015#E!\r\t\u0012fK\u0005\u0003UI\u0011Q!\u0011:sCf\u0004\"!\u0005\u0017\n\u00055\u0012\"\u0001\u0002\"zi\u0016DQa\f\u0010A\u0002A\n1A[:d!\t\u0011\u0013'\u0003\u00023G\t\u0001\"*\u0019<b'B\f'o[\"p]R,\u0007\u0010\u001e\u0005\u0006iy\u0001\r!N\u0001\u0005a\u0006$\b\u000e\u0005\u00027s9\u0011\u0011cN\u0005\u0003qI\ta\u0001\u0015:fI\u00164\u0017B\u0001\u001e<\u0005\u0019\u0019FO]5oO*\u0011\u0001H\u0005\u0005\u0006{y\u0001\rAP\u0001\u000e[&t\u0007+\u0019:uSRLwN\\:\u0011\u0005Ey\u0014B\u0001!\u0013\u0005\rIe\u000e\u001e\u0005\u0006\u0005\u0002!IaQ\u0001\u0015iJ\f\u0017N\u001c*fOJ,7o]5p]6{G-\u001a7\u0015\t\u0011\u000b6.\u001c\t\u0004\u000b&[U\"\u0001$\u000b\u0005\u001dC\u0015\u0001B;uS2T\u0011\u0001J\u0005\u0003\u0015\u001a\u0013!\u0002T5oW\u0016$G*[:u!\tau*D\u0001N\u0015\tq\u0005*\u0001\u0003mC:<\u0017B\u0001)N\u0005\u0019y%M[3di\")!+\u0011a\u0001'\u0006IAO]1j]\u001a+hn\u0019\t\u0006#Q3&\r[\u0005\u0003+J\u0011\u0011BR;oGRLwN\u001c\u001a\u0011\u0007]SF,D\u0001Y\u0015\tI\u0006\"A\u0002sI\u0012L!a\u0017-\u0003\u0007I#E\t\u0005\u0002^A6\taL\u0003\u0002`\r\u0005Q!/Z4sKN\u001c\u0018n\u001c8\n\u0005\u0005t&\u0001\u0004'bE\u0016dW\r\u001a)pS:$\bCA2g\u001b\u0005!'BA3\u0007\u0003\u0019a\u0017N\\1mO&\u0011q\r\u001a\u0002\u0007-\u0016\u001cGo\u001c:\u0011\u0005uK\u0017B\u00016_\u0005Y9UM\\3sC2L'0\u001a3MS:,\u0017M]'pI\u0016d\u0007\"\u00027B\u0001\u0004\t\u0013!\u00043bi\u0006\u0014\u0015\u0010^3t\u0015J#E\tC\u0003o\u0003\u0002\u0007\u0001&\u0001\tj]&$\u0018.\u00197XK&<\u0007\u000e^:C\u0003\")\u0001\u000f\u0001C\u0001c\u0006\tCO]1j]2Kg.Z1s%\u0016<'/Z:tS>tWj\u001c3fY^KG\u000f[*H\tRa!/\u001e<y{~\f\t!!\u0002\u0002\nA\u0019Qi]&\n\u0005Q4%\u0001\u0002'jgRDQ\u0001\\8A\u0002\u0005BQa^8A\u0002y\nQB\\;n\u0013R,'/\u0019;j_:\u001c\b\"B=p\u0001\u0004Q\u0018\u0001C:uKB\u001c\u0016N_3\u0011\u0005EY\u0018B\u0001?\u0013\u0005\u0019!u.\u001e2mK\")ap\u001ca\u0001u\u0006\tR.\u001b8j\u0005\u0006$8\r\u001b$sC\u000e$\u0018n\u001c8\t\u000b9|\u0007\u0019\u0001\u0015\t\r\u0005\rq\u000e1\u0001{\u0003!\u0011Xm\u001a)be\u0006l\u0007BBA\u0004_\u0002\u0007Q'A\u0004sK\u001e$\u0016\u0010]3\t\u000f\u0005-q\u000e1\u0001\u0002\u000e\u0005I\u0011N\u001c;fe\u000e,\u0007\u000f\u001e\t\u0004#\u0005=\u0011bAA\t%\t9!i\\8mK\u0006t\u0007bBA\u000b\u0001\u0011\u0005\u0011qC\u0001\u0017iJ\f\u0017N\u001c'bgN|Wj\u001c3fY^KG\u000f[*H\tRi!/!\u0007\u0002\u001c\u0005u\u0011qDA\u0011\u0003GAa\u0001\\A\n\u0001\u0004\t\u0003BB<\u0002\u0014\u0001\u0007a\b\u0003\u0004z\u0003'\u0001\rA\u001f\u0005\b\u0003\u0007\t\u0019\u00021\u0001{\u0011\u0019q\u00181\u0003a\u0001u\"1a.a\u0005A\u0002!Bq!a\n\u0001\t\u0003\tI#\u0001\fue\u0006LgNU5eO\u0016lu\u000eZ3m/&$\bnU$E)5\u0011\u00181FA\u0017\u0003_\t\t$a\r\u00026!1A.!\nA\u0002\u0005Baa^A\u0013\u0001\u0004q\u0004BB=\u0002&\u0001\u0007!\u0010C\u0004\u0002\u0004\u0005\u0015\u0002\u0019\u0001>\t\ry\f)\u00031\u0001{\u0011\u0019q\u0017Q\u0005a\u0001Q!9\u0011\u0011\b\u0001\u0005\u0002\u0005m\u0012\u0001\u0006;sC&t7KV'N_\u0012,GnV5uQN;E\tF\ts\u0003{\ty$!\u0011\u0002D\u0005\u0015\u0013qIA%\u0003\u0017Ba\u0001\\A\u001c\u0001\u0004\t\u0003BB<\u00028\u0001\u0007a\b\u0003\u0004z\u0003o\u0001\rA\u001f\u0005\b\u0003\u0007\t9\u00041\u0001{\u0011\u0019q\u0018q\u0007a\u0001u\"1a.a\u000eA\u0002!Bq!a\u0002\u00028\u0001\u0007Q\u0007\u0003\u0005\u0002\f\u0005]\u0002\u0019AA\u0007\u0011\u001d\ty\u0005\u0001C\u0001\u0003#\n1\u0005\u001e:bS:dunZ5ti&\u001c'+Z4sKN\u001c\u0018n\u001c8N_\u0012,GnV5uQN;E\tF\ts\u0003'\n)&a\u0016\u0002Z\u0005m\u0013QLA0\u0003CBa\u0001\\A'\u0001\u0004\t\u0003BB<\u0002N\u0001\u0007a\b\u0003\u0004z\u0003\u001b\u0002\rA\u001f\u0005\u0007}\u00065\u0003\u0019\u0001>\t\r9\fi\u00051\u0001)\u0011\u001d\t\u0019!!\u0014A\u0002iDq!a\u0002\u0002N\u0001\u0007Q\u0007\u0003\u0005\u0002\f\u00055\u0003\u0019AA\u0007\u0011\u001d\t)\u0007\u0001C\u0001\u0003O\nq\u0002\u001e:bS:t\u0015-\u001b<f\u0005\u0006LXm\u001d\u000b\u0006e\u0006%\u00141\u000e\u0005\u0007Y\u0006\r\u0004\u0019A\u0011\t\u000f\u00055\u00141\ra\u0001u\u00061A.Y7cI\u0006Dq!!\u001d\u0001\t\u0003\t\u0019(\u0001\tue\u0006LgnS'fC:\u001cXj\u001c3fYRY!/!\u001e\u0002x\u0005m\u0014qPAB\u0011\u0019a\u0017q\u000ea\u0001C!9\u0011\u0011PA8\u0001\u0004q\u0014!A6\t\u000f\u0005u\u0014q\u000ea\u0001}\u0005iQ.\u0019=Ji\u0016\u0014\u0018\r^5p]NDq!!!\u0002p\u0001\u0007a(\u0001\u0003sk:\u001c\bbBAC\u0003_\u0002\r!N\u0001\u0013S:LG/[1mSj\fG/[8o\u001b>$W\rC\u0004\u0002\n\u0002!\t!a#\u0002\u001bQ\u0014\u0018-\u001b8B\u0019Nku\u000eZ3m)1\ti)!'\u0002\u001e\u0006\u0005\u0016QUAT!\u0011\ty)!&\u000e\u0005\u0005E%bAAJ\r\u0005q!/Z2p[6,g\u000eZ1uS>t\u0017\u0002BAL\u0003#\u0013\u0001$T1ue&Dh)Y2u_JL'0\u0019;j_:lu\u000eZ3m\u0011\u001d\tY*a\"A\u0002\u0005\n\u0001C]1uS:<7OQ=uKNT%\u000b\u0012#\t\u000f\u0005}\u0015q\u0011a\u0001}\u0005!!/\u00198l\u0011\u001d\t\u0019+a\"A\u0002y\n!\"\u001b;fe\u0006$\u0018n\u001c8t\u0011\u001d\ti'a\"A\u0002iDq!!+\u0002\b\u0002\u0007a(\u0001\u0004cY>\u001c7n\u001d\u0005\b\u0003[\u0003A\u0011AAX\u0003U!(/Y5o\u00136\u0004H.[2ji\u0006c5+T8eK2$b\"!$\u00022\u0006M\u0016QWA\\\u0003s\u000bY\fC\u0004\u0002\u001c\u0006-\u0006\u0019A\u0011\t\u000f\u0005}\u00151\u0016a\u0001}!9\u00111UAV\u0001\u0004q\u0004bBA7\u0003W\u0003\rA\u001f\u0005\b\u0003S\u000bY\u000b1\u0001?\u0011\u001d\ti,a+A\u0002i\fQ!\u00197qQ\u0006Dq!!1\u0001\t\u0003\t\u0019-\u0001\fue\u0006Lg\u000eR3dSNLwN\u001c+sK\u0016lu\u000eZ3m)A\t)-!6\u0002X\u0006m\u0017q\\Au\u0003[\f\t\u0010\u0005\u0003\u0002H\u0006EWBAAe\u0015\u0011\tY-!4\u0002\u000b5|G-\u001a7\u000b\u0007\u0005=g!\u0001\u0003ue\u0016,\u0017\u0002BAj\u0003\u0013\u0014\u0011\u0003R3dSNLwN\u001c+sK\u0016lu\u000eZ3m\u0011\u0019a\u0017q\u0018a\u0001C!9\u0011\u0011\\A`\u0001\u0004)\u0014aB1mO>\u001cFO\u001d\u0005\b\u0003;\fy\f1\u0001?\u0003)qW/\\\"mCN\u001cXm\u001d\u0005\t\u0003C\fy\f1\u0001\u0002d\u0006Y2-\u0019;fO>\u0014\u0018nY1m\r\u0016\fG/\u001e:fg&sgm\u001c&NCB\u0004R!RAs}yJ1!a:G\u0005\ri\u0015\r\u001d\u0005\b\u0003W\fy\f1\u00016\u0003-IW\u000e];sSRL8\u000b\u001e:\t\u000f\u0005=\u0018q\u0018a\u0001}\u0005AQ.\u0019=EKB$\b\u000eC\u0004\u0002t\u0006}\u0006\u0019\u0001 \u0002\u000f5\f\u0007PQ5og\"9\u0011q\u001f\u0001\u0005\u0002\u0005e\u0018\u0001\u00079sK\u0012L7\r\u001e#fG&\u001c\u0018n\u001c8Ue\u0016,Wj\u001c3fYR)!0a?\u0002~\"A\u00111ZA{\u0001\u0004\t)\rC\u0004\u0002\u0000\u0006U\b\u0019\u0001\u0015\u0002\u001b\u0019,\u0017\r^;sKN\u0014\u0015\u0010^3t\u0011\u001d\t9\u0010\u0001C\u0001\u0005\u0007!R!\tB\u0003\u0005\u000fA\u0001\"a3\u0003\u0002\u0001\u0007\u0011Q\u0019\u0005\b\u0005\u0013\u0011\t\u00011\u0001\"\u0003!!\u0017\r^1K%\u0012#\u0005b\u0002B\u0007\u0001\u0011\u0005!qB\u0001\tG>d7\u000b^1ugR!!\u0011\u0003B\f!\ri\"1C\u0005\u0004\u0005+\u0011!\u0001K'vYRLg/\u0019:jCR,7\u000b^1uSN$\u0018nY1m'VlW.\u0019:z'\u0016\u0014\u0018.\u00197ju\u0016$\u0007b\u0002B\r\u0005\u0017\u0001\r!I\u0001\u00021\"9!Q\u0004\u0001\u0005\u0002\t}\u0011\u0001B2peJ$R\u0001\u000bB\u0011\u0005GAqA!\u0007\u0003\u001c\u0001\u0007\u0011\u0005C\u0004\u0003&\tm\u0001\u0019A\u001b\u0002\r5,G\u000f[8e\u0011\u001d\u0011i\u0002\u0001C\u0001\u0005S!rA\u001fB\u0016\u0005_\u0011\u0019\u0004C\u0004\u0003.\t\u001d\u0002\u0019A\u0011\u0002\u0003aDqA!\r\u0003(\u0001\u0007\u0011%A\u0001z\u0011\u001d\u0011)Ca\nA\u0002UBqAa\u000e\u0001\t\u0013\u0011I$\u0001\u000bhKR\u001cuN\u001d:OC6,wJ\u001d#fM\u0006,H\u000e\u001e\u000b\u0004k\tm\u0002b\u0002B\u0013\u0005k\u0001\r!\u000e\u0005\b\u0005\u007f\u0001A\u0011\u0002B!\u0003A9W\r^*fK\u0012|%\u000fR3gCVdG\u000f\u0006\u0003\u0003D\t%\u0003cA\t\u0003F%\u0019!q\t\n\u0003\t1{gn\u001a\u0005\t\u0005\u0017\u0012i\u00041\u0001\u0003N\u0005!1/Z3e!\ra%qJ\u0005\u0004\u0005\u000fj\u0005b\u0002B*\u0001\u0011%!QK\u0001\u001aO\u0016$h*^7QCJ$\u0018\u000e^5p]N|%\u000fR3gCVdG\u000fF\u0003?\u0005/\u0012\t\u0007\u0003\u0005\u0003Z\tE\u0003\u0019\u0001B.\u00035qW/\u001c)beRLG/[8ogB\u0019AJ!\u0018\n\u0007\t}SJA\u0004J]R,w-\u001a:\t\r=\u0012\t\u00061\u00011\u0011\u001d\u0011)\u0007\u0001C\u0001\u0005O\n!\"\u001e8jM>\u0014XN\u0015#E)%\t#\u0011\u000eB6\u0005_\u0012\t\b\u0003\u00040\u0005G\u0002\r\u0001\r\u0005\t\u0005[\u0012\u0019\u00071\u0001\u0003D\u0005!1/\u001b>f\u0011!\u0011IFa\u0019A\u0002\tm\u0003\u0002\u0003B&\u0005G\u0002\rA!\u0014\t\u000f\tU\u0004\u0001\"\u0001\u0003x\u0005Ian\u001c:nC2\u0014F\t\u0012\u000b\nC\te$1\u0010B?\u0005\u007fBaa\fB:\u0001\u0004\u0001\u0004\u0002\u0003B7\u0005g\u0002\rAa\u0011\t\u0011\te#1\u000fa\u0001\u00057B\u0001Ba\u0013\u0003t\u0001\u0007!Q\n\u0005\b\u0005\u0007\u0003A\u0011\u0001BC\u0003)\u0001x.[:t_:\u0014F\t\u0012\u000b\fC\t\u001d%\u0011\u0012BG\u0005\u001f\u0013\t\n\u0003\u00040\u0005\u0003\u0003\r\u0001\r\u0005\b\u0005\u0017\u0013\t\t1\u0001{\u0003\u0011iW-\u00198\t\u0011\t5$\u0011\u0011a\u0001\u0005\u0007B\u0001B!\u0017\u0003\u0002\u0002\u0007!1\f\u0005\t\u0005\u0017\u0012\t\t1\u0001\u0003N!9!Q\u0013\u0001\u0005\u0002\t]\u0015\u0001E;oS\u001a|'/\u001c,fGR|'O\u0015#E)-\t#\u0011\u0014BN\u0005?\u0013\u0019K!*\t\r=\u0012\u0019\n1\u00011\u0011!\u0011iJa%A\u0002\t\r\u0013a\u00028v[J{wo\u001d\u0005\b\u0005C\u0013\u0019\n1\u0001?\u0003\u001dqW/\\\"pYND\u0001B!\u0017\u0003\u0014\u0002\u0007!1\f\u0005\t\u0005\u0017\u0012\u0019\n1\u0001\u0003N!9!\u0011\u0016\u0001\u0005\u0002\t-\u0016a\u00048pe6\fGNV3di>\u0014(\u000b\u0012#\u0015\u0017\u0005\u0012iKa,\u00032\nM&Q\u0017\u0005\u0007_\t\u001d\u0006\u0019\u0001\u0019\t\u0011\tu%q\u0015a\u0001\u0005\u0007BqA!)\u0003(\u0002\u0007a\b\u0003\u0005\u0003Z\t\u001d\u0006\u0019\u0001B.\u0011!\u0011YEa*A\u0002\t5\u0003b\u0002B]\u0001\u0011\u0005!1X\u0001\u0011a>L7o]8o-\u0016\u001cGo\u001c:S\t\u0012#R\"\tB_\u0005\u007f\u0013\tMa1\u0003F\n\u001d\u0007BB\u0018\u00038\u0002\u0007\u0001\u0007C\u0004\u0003\f\n]\u0006\u0019\u0001>\t\u0011\tu%q\u0017a\u0001\u0005\u0007BqA!)\u00038\u0002\u0007a\b\u0003\u0005\u0003Z\t]\u0006\u0019\u0001B.\u0011!\u0011YEa.A\u0002\t5\u0003f\u0001\u0001\u0003LB!!Q\u001aBj\u001b\t\u0011yMC\u0002\u0003R\"\t!\"\u00198o_R\fG/[8o\u0013\u0011\u0011)Na4\u0003\u0019\u0011+g/\u001a7pa\u0016\u0014\u0018\t]5")
public class PythonMLLibAPI
implements Serializable {
    public JavaRDD<byte[]> loadLabeledPoints(JavaSparkContext jsc, String path, int minPartitions) {
        return JavaRDD$.MODULE$.fromRDD(MLUtils$.MODULE$.loadLabeledPoints(jsc.sc(), path, minPartitions).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final byte[] apply(LabeledPoint p) {
                return SerDe$.MODULE$.serializeLabeledPoint(p);
            }
        }, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE))), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
    }

    private LinkedList<Object> trainRegressionModel(Function2<RDD<LabeledPoint>, Vector, GeneralizedLinearModel> trainFunc, JavaRDD<byte[]> dataBytesJRDD, byte[] initialWeightsBA) {
        RDD data = dataBytesJRDD.rdd().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final LabeledPoint apply(byte[] bytes) {
                return SerDe$.MODULE$.deserializeLabeledPoint(bytes);
            }
        }, ClassTag$.MODULE$.apply(LabeledPoint.class));
        Vector initialWeights = SerDe$.MODULE$.deserializeDoubleVector(initialWeightsBA, SerDe$.MODULE$.deserializeDoubleVector$default$2());
        GeneralizedLinearModel model = (GeneralizedLinearModel)trainFunc.apply((Object)data, (Object)initialWeights);
        LinkedList<Object> ret = new LinkedList<Object>();
        ret.add(SerDe$.MODULE$.serializeDoubleVector(model.weights()));
        ret.add(Predef$.MODULE$.double2Double(model.intercept()));
        return ret;
    }

    public List<Object> trainLinearRegressionModelWithSGD(JavaRDD<byte[]> dataBytesJRDD, int numIterations, double stepSize, double miniBatchFraction, byte[] initialWeightsBA, double regParam, String regType, boolean intercept) {
        block5: {
            LinearRegressionWithSGD lrAlg;
            block3: {
                GradientDescent gradientDescent;
                block4: {
                    block2: {
                        lrAlg = new LinearRegressionWithSGD();
                        lrAlg.setIntercept(intercept);
                        lrAlg.optimizer().setNumIterations(numIterations).setRegParam(regParam).setStepSize(stepSize).setMiniBatchFraction(miniBatchFraction);
                        String string = regType;
                        String string2 = "l2";
                        if (string != null ? !string.equals(string2) : string2 != null) break block2;
                        gradientDescent = lrAlg.optimizer().setUpdater(new SquaredL2Updater());
                        break block3;
                    }
                    String string = regType;
                    String string3 = "l1";
                    if (string != null ? !string.equals(string3) : string3 != null) break block4;
                    gradientDescent = lrAlg.optimizer().setUpdater(new L1Updater());
                    break block3;
                }
                String string = regType;
                String string4 = "none";
                if (string != null ? !string.equals(string4) : string4 != null) break block5;
                gradientDescent = BoxedUnit.UNIT;
            }
            return this.trainRegressionModel((Function2<RDD<LabeledPoint>, Vector, GeneralizedLinearModel>)new Serializable(this, lrAlg){
                public static final long serialVersionUID = 0L;
                private final LinearRegressionWithSGD lrAlg$1;

                public final LinearRegressionModel apply(RDD<LabeledPoint> data, Vector initialWeights) {
                    return (LinearRegressionModel)this.lrAlg$1.run(data, initialWeights);
                }
                {
                    this.lrAlg$1 = lrAlg$1;
                }
            }, dataBytesJRDD, initialWeightsBA);
        }
        throw new IllegalArgumentException("Invalid value for 'regType' parameter. Can only be initialized using the following string values: [l1, l2, none].");
    }

    public List<Object> trainLassoModelWithSGD(JavaRDD<byte[]> dataBytesJRDD, int numIterations, double stepSize, double regParam, double miniBatchFraction, byte[] initialWeightsBA) {
        return this.trainRegressionModel((Function2<RDD<LabeledPoint>, Vector, GeneralizedLinearModel>)new Serializable(this, numIterations, stepSize, regParam, miniBatchFraction){
            public static final long serialVersionUID = 0L;
            private final int numIterations$1;
            private final double stepSize$1;
            private final double regParam$1;
            private final double miniBatchFraction$1;

            public final LassoModel apply(RDD<LabeledPoint> data, Vector initialWeights) {
                return LassoWithSGD$.MODULE$.train(data, this.numIterations$1, this.stepSize$1, this.regParam$1, this.miniBatchFraction$1, initialWeights);
            }
            {
                this.numIterations$1 = numIterations$1;
                this.stepSize$1 = stepSize$1;
                this.regParam$1 = regParam$1;
                this.miniBatchFraction$1 = miniBatchFraction$1;
            }
        }, dataBytesJRDD, initialWeightsBA);
    }

    public List<Object> trainRidgeModelWithSGD(JavaRDD<byte[]> dataBytesJRDD, int numIterations, double stepSize, double regParam, double miniBatchFraction, byte[] initialWeightsBA) {
        return this.trainRegressionModel((Function2<RDD<LabeledPoint>, Vector, GeneralizedLinearModel>)new Serializable(this, numIterations, stepSize, regParam, miniBatchFraction){
            public static final long serialVersionUID = 0L;
            private final int numIterations$2;
            private final double stepSize$2;
            private final double regParam$2;
            private final double miniBatchFraction$2;

            public final RidgeRegressionModel apply(RDD<LabeledPoint> data, Vector initialWeights) {
                return RidgeRegressionWithSGD$.MODULE$.train(data, this.numIterations$2, this.stepSize$2, this.regParam$2, this.miniBatchFraction$2, initialWeights);
            }
            {
                this.numIterations$2 = numIterations$2;
                this.stepSize$2 = stepSize$2;
                this.regParam$2 = regParam$2;
                this.miniBatchFraction$2 = miniBatchFraction$2;
            }
        }, dataBytesJRDD, initialWeightsBA);
    }

    public List<Object> trainSVMModelWithSGD(JavaRDD<byte[]> dataBytesJRDD, int numIterations, double stepSize, double regParam, double miniBatchFraction, byte[] initialWeightsBA, String regType, boolean intercept) {
        block5: {
            SVMWithSGD SVMAlg;
            block3: {
                GradientDescent gradientDescent;
                block4: {
                    block2: {
                        SVMAlg = new SVMWithSGD();
                        SVMAlg.setIntercept(intercept);
                        SVMAlg.optimizer().setNumIterations(numIterations).setRegParam(regParam).setStepSize(stepSize).setMiniBatchFraction(miniBatchFraction);
                        String string = regType;
                        String string2 = "l2";
                        if (string != null ? !string.equals(string2) : string2 != null) break block2;
                        gradientDescent = SVMAlg.optimizer().setUpdater(new SquaredL2Updater());
                        break block3;
                    }
                    String string = regType;
                    String string3 = "l1";
                    if (string != null ? !string.equals(string3) : string3 != null) break block4;
                    gradientDescent = SVMAlg.optimizer().setUpdater(new L1Updater());
                    break block3;
                }
                String string = regType;
                String string4 = "none";
                if (string != null ? !string.equals(string4) : string4 != null) break block5;
                gradientDescent = BoxedUnit.UNIT;
            }
            return this.trainRegressionModel((Function2<RDD<LabeledPoint>, Vector, GeneralizedLinearModel>)new Serializable(this, SVMAlg){
                public static final long serialVersionUID = 0L;
                private final SVMWithSGD SVMAlg$1;

                public final SVMModel apply(RDD<LabeledPoint> data, Vector initialWeights) {
                    return (SVMModel)this.SVMAlg$1.run(data, initialWeights);
                }
                {
                    this.SVMAlg$1 = SVMAlg$1;
                }
            }, dataBytesJRDD, initialWeightsBA);
        }
        throw new IllegalArgumentException("Invalid value for 'regType' parameter. Can only be initialized using the following string values: [l1, l2, none].");
    }

    public List<Object> trainLogisticRegressionModelWithSGD(JavaRDD<byte[]> dataBytesJRDD, int numIterations, double stepSize, double miniBatchFraction, byte[] initialWeightsBA, double regParam, String regType, boolean intercept) {
        block5: {
            LogisticRegressionWithSGD LogRegAlg;
            block3: {
                GradientDescent gradientDescent;
                block4: {
                    block2: {
                        LogRegAlg = new LogisticRegressionWithSGD();
                        LogRegAlg.setIntercept(intercept);
                        LogRegAlg.optimizer().setNumIterations(numIterations).setRegParam(regParam).setStepSize(stepSize).setMiniBatchFraction(miniBatchFraction);
                        String string = regType;
                        String string2 = "l2";
                        if (string != null ? !string.equals(string2) : string2 != null) break block2;
                        gradientDescent = LogRegAlg.optimizer().setUpdater(new SquaredL2Updater());
                        break block3;
                    }
                    String string = regType;
                    String string3 = "l1";
                    if (string != null ? !string.equals(string3) : string3 != null) break block4;
                    gradientDescent = LogRegAlg.optimizer().setUpdater(new L1Updater());
                    break block3;
                }
                String string = regType;
                String string4 = "none";
                if (string != null ? !string.equals(string4) : string4 != null) break block5;
                gradientDescent = BoxedUnit.UNIT;
            }
            return this.trainRegressionModel((Function2<RDD<LabeledPoint>, Vector, GeneralizedLinearModel>)new Serializable(this, LogRegAlg){
                public static final long serialVersionUID = 0L;
                private final LogisticRegressionWithSGD LogRegAlg$1;

                public final LogisticRegressionModel apply(RDD<LabeledPoint> data, Vector initialWeights) {
                    return (LogisticRegressionModel)this.LogRegAlg$1.run(data, initialWeights);
                }
                {
                    this.LogRegAlg$1 = LogRegAlg$1;
                }
            }, dataBytesJRDD, initialWeightsBA);
        }
        throw new IllegalArgumentException("Invalid value for 'regType' parameter. Can only be initialized using the following string values: [l1, l2, none].");
    }

    public List<Object> trainNaiveBayes(JavaRDD<byte[]> dataBytesJRDD, double lambda) {
        RDD data = dataBytesJRDD.rdd().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final LabeledPoint apply(byte[] bytes) {
                return SerDe$.MODULE$.deserializeLabeledPoint(bytes);
            }
        }, ClassTag$.MODULE$.apply(LabeledPoint.class));
        NaiveBayesModel model = NaiveBayes$.MODULE$.train((RDD<LabeledPoint>)data, lambda);
        LinkedList<Object> ret = new LinkedList<Object>();
        ret.add(SerDe$.MODULE$.serializeDoubleVector(Vectors$.MODULE$.dense(model.labels())));
        ret.add(SerDe$.MODULE$.serializeDoubleVector(Vectors$.MODULE$.dense(model.pi())));
        ret.add(SerDe$.MODULE$.serializeDoubleMatrix(model.theta()));
        return ret;
    }

    public List<Object> trainKMeansModel(JavaRDD<byte[]> dataBytesJRDD, int k, int maxIterations, int runs, String initializationMode) {
        RDD data = dataBytesJRDD.rdd().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Vector apply(byte[] bytes) {
                return SerDe$.MODULE$.deserializeDoubleVector(bytes, SerDe$.MODULE$.deserializeDoubleVector$default$2());
            }
        }, ClassTag$.MODULE$.apply(Vector.class));
        KMeansModel model = KMeans$.MODULE$.train((RDD<Vector>)data, k, maxIterations, runs, initializationMode);
        LinkedList<Object> ret = new LinkedList<Object>();
        ret.add(SerDe$.MODULE$.serializeDoubleMatrix((double[][])Predef$.MODULE$.refArrayOps((Object[])model.clusterCenters()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final double[] apply(Vector x$1) {
                return x$1.toArray();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE))))));
        return ret;
    }

    public MatrixFactorizationModel trainALSModel(JavaRDD<byte[]> ratingsBytesJRDD, int rank, int iterations, double lambda, int blocks) {
        RDD ratings = ratingsBytesJRDD.rdd().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Rating apply(byte[] ratingBytes) {
                return SerDe$.MODULE$.unpackRating(ratingBytes);
            }
        }, ClassTag$.MODULE$.apply(Rating.class));
        return ALS$.MODULE$.train((RDD<Rating>)ratings, rank, iterations, lambda, blocks);
    }

    public MatrixFactorizationModel trainImplicitALSModel(JavaRDD<byte[]> ratingsBytesJRDD, int rank, int iterations, double lambda, int blocks, double alpha) {
        RDD ratings = ratingsBytesJRDD.rdd().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Rating apply(byte[] ratingBytes) {
                return SerDe$.MODULE$.unpackRating(ratingBytes);
            }
        }, ClassTag$.MODULE$.apply(Rating.class));
        return ALS$.MODULE$.trainImplicit((RDD<Rating>)ratings, rank, iterations, lambda, blocks, alpha);
    }

    public DecisionTreeModel trainDecisionTreeModel(JavaRDD<byte[]> dataBytesJRDD, String algoStr, int numClasses, Map<Object, Object> categoricalFeaturesInfoJMap, String impurityStr, int maxDepth, int maxBins) {
        RDD data = dataBytesJRDD.rdd().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final LabeledPoint apply(byte[] bytes) {
                return SerDe$.MODULE$.deserializeLabeledPoint(bytes);
            }
        }, ClassTag$.MODULE$.apply(LabeledPoint.class));
        Enumeration.Value algo = Algo$.MODULE$.fromString(algoStr);
        Impurity impurity = Impurities$.MODULE$.fromString(impurityStr);
        Enumeration.Value x$6 = algo;
        Impurity x$7 = impurity;
        int x$8 = maxDepth;
        int x$9 = numClasses;
        int x$10 = maxBins;
        scala.collection.immutable.Map x$11 = ((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(categoricalFeaturesInfoJMap).asScala()).toMap(Predef$.MODULE$.conforms());
        Enumeration.Value x$12 = Strategy$.MODULE$.$lessinit$greater$default$6();
        int x$13 = Strategy$.MODULE$.$lessinit$greater$default$8();
        Strategy strategy = new Strategy(x$6, x$7, x$8, x$9, x$10, x$12, (scala.collection.immutable.Map<Object, Object>)x$11, x$13);
        return DecisionTree$.MODULE$.train((RDD<LabeledPoint>)data, strategy);
    }

    public double predictDecisionTreeModel(DecisionTreeModel model, byte[] featuresBytes) {
        Vector features = SerDe$.MODULE$.deserializeDoubleVector(featuresBytes, SerDe$.MODULE$.deserializeDoubleVector$default$2());
        return model.predict(features);
    }

    public JavaRDD<byte[]> predictDecisionTreeModel(DecisionTreeModel model, JavaRDD<byte[]> dataJRDD) {
        RDD data = dataJRDD.rdd().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Vector apply(byte[] xBytes) {
                return SerDe$.MODULE$.deserializeDoubleVector(xBytes, SerDe$.MODULE$.deserializeDoubleVector$default$2());
            }
        }, ClassTag$.MODULE$.apply(Vector.class));
        return JavaRDD$.MODULE$.fromRDD(model.predict((RDD<Vector>)data).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final byte[] apply(double d) {
                return SerDe$.MODULE$.serializeDouble(d);
            }
        }, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE))), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
    }

    public MultivariateStatisticalSummarySerialized colStats(JavaRDD<byte[]> X) {
        MultivariateStatisticalSummary cStats = Statistics$.MODULE$.colStats((RDD<Vector>)X.rdd().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Vector apply(byte[] x$2) {
                return SerDe$.MODULE$.deserializeDoubleVector(x$2, SerDe$.MODULE$.deserializeDoubleVector$default$2());
            }
        }, ClassTag$.MODULE$.apply(Vector.class)));
        return new MultivariateStatisticalSummarySerialized(cStats);
    }

    public byte[] corr(JavaRDD<byte[]> X, String method) {
        RDD inputMatrix = X.rdd().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Vector apply(byte[] x$3) {
                return SerDe$.MODULE$.deserializeDoubleVector(x$3, SerDe$.MODULE$.deserializeDoubleVector$default$2());
            }
        }, ClassTag$.MODULE$.apply(Vector.class));
        Matrix result = Statistics$.MODULE$.corr((RDD<Vector>)inputMatrix, this.getCorrNameOrDefault(method));
        return SerDe$.MODULE$.serializeDoubleMatrix(SerDe$.MODULE$.to2dArray(result));
    }

    public double corr(JavaRDD<byte[]> x, JavaRDD<byte[]> y, String method) {
        RDD xDeser = x.rdd().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final double apply(byte[] x$4) {
                return SerDe$.MODULE$.deserializeDouble(x$4, SerDe$.MODULE$.deserializeDouble$default$2());
            }
        }, ClassTag$.MODULE$.Double());
        RDD yDeser = y.rdd().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final double apply(byte[] x$5) {
                return SerDe$.MODULE$.deserializeDouble(x$5, SerDe$.MODULE$.deserializeDouble$default$2());
            }
        }, ClassTag$.MODULE$.Double());
        return Statistics$.MODULE$.corr((RDD<Object>)xDeser, (RDD<Object>)yDeser, this.getCorrNameOrDefault(method));
    }

    private String getCorrNameOrDefault(String method) {
        return method == null ? CorrelationNames$.MODULE$.defaultCorrName() : method;
    }

    private long getSeedOrDefault(Long seed) {
        return seed == null ? Utils$.MODULE$.random().nextLong() : Predef$.MODULE$.Long2long(seed);
    }

    private int getNumPartitionsOrDefault(Integer numPartitions, JavaSparkContext jsc) {
        return numPartitions == null ? jsc.sc().defaultParallelism() : Predef$.MODULE$.Integer2int(numPartitions);
    }

    public JavaRDD<byte[]> uniformRDD(JavaSparkContext jsc, long size, Integer numPartitions, Long seed) {
        int parts = this.getNumPartitionsOrDefault(numPartitions, jsc);
        long s = this.getSeedOrDefault(seed);
        return JavaRDD$.MODULE$.fromRDD(RandomRDDs$.MODULE$.uniformRDD(jsc.sc(), size, parts, s).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final byte[] apply(double d) {
                return SerDe$.MODULE$.serializeDouble(d);
            }
        }, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE))), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
    }

    public JavaRDD<byte[]> normalRDD(JavaSparkContext jsc, long size, Integer numPartitions, Long seed) {
        int parts = this.getNumPartitionsOrDefault(numPartitions, jsc);
        long s = this.getSeedOrDefault(seed);
        return JavaRDD$.MODULE$.fromRDD(RandomRDDs$.MODULE$.normalRDD(jsc.sc(), size, parts, s).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final byte[] apply(double d) {
                return SerDe$.MODULE$.serializeDouble(d);
            }
        }, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE))), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
    }

    public JavaRDD<byte[]> poissonRDD(JavaSparkContext jsc, double mean2, long size, Integer numPartitions, Long seed) {
        int parts = this.getNumPartitionsOrDefault(numPartitions, jsc);
        long s = this.getSeedOrDefault(seed);
        return JavaRDD$.MODULE$.fromRDD(RandomRDDs$.MODULE$.poissonRDD(jsc.sc(), mean2, size, parts, s).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final byte[] apply(double d) {
                return SerDe$.MODULE$.serializeDouble(d);
            }
        }, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE))), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
    }

    public JavaRDD<byte[]> uniformVectorRDD(JavaSparkContext jsc, long numRows2, int numCols, Integer numPartitions, Long seed) {
        int parts = this.getNumPartitionsOrDefault(numPartitions, jsc);
        long s = this.getSeedOrDefault(seed);
        return JavaRDD$.MODULE$.fromRDD(RandomRDDs$.MODULE$.uniformVectorRDD(jsc.sc(), numRows2, numCols, parts, s).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final byte[] apply(Vector vector) {
                return SerDe$.MODULE$.serializeDoubleVector(vector);
            }
        }, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE))), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
    }

    public JavaRDD<byte[]> normalVectorRDD(JavaSparkContext jsc, long numRows2, int numCols, Integer numPartitions, Long seed) {
        int parts = this.getNumPartitionsOrDefault(numPartitions, jsc);
        long s = this.getSeedOrDefault(seed);
        return JavaRDD$.MODULE$.fromRDD(RandomRDDs$.MODULE$.normalVectorRDD(jsc.sc(), numRows2, numCols, parts, s).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final byte[] apply(Vector vector) {
                return SerDe$.MODULE$.serializeDoubleVector(vector);
            }
        }, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE))), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
    }

    public JavaRDD<byte[]> poissonVectorRDD(JavaSparkContext jsc, double mean2, long numRows2, int numCols, Integer numPartitions, Long seed) {
        int parts = this.getNumPartitionsOrDefault(numPartitions, jsc);
        long s = this.getSeedOrDefault(seed);
        return JavaRDD$.MODULE$.fromRDD(RandomRDDs$.MODULE$.poissonVectorRDD(jsc.sc(), mean2, numRows2, numCols, parts, s).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final byte[] apply(Vector vector) {
                return SerDe$.MODULE$.serializeDoubleVector(vector);
            }
        }, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE))), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
    }
}

