/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.dependency.graph.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Exclusion;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.dependency.graph.DependencyCollectorBuilder;
import org.apache.maven.shared.dependency.graph.DependencyCollectorBuilderException;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.apache.maven.shared.dependency.graph.internal.ConflictData;
import org.apache.maven.shared.dependency.graph.internal.ExceptionHandler;
import org.apache.maven.shared.dependency.graph.internal.Invoker;
import org.apache.maven.shared.dependency.graph.internal.VerboseDependencyNode;
import org.apache.maven.shared.dependency.graph.internal.maven30.ConflictResolver;
import org.apache.maven.shared.dependency.graph.internal.maven30.JavaScopeDeriver;
import org.apache.maven.shared.dependency.graph.internal.maven30.Maven3DirectScopeDependencySelector;
import org.apache.maven.shared.dependency.graph.internal.maven30.NearestVersionSelector;
import org.apache.maven.shared.dependency.graph.internal.maven30.SimpleOptionalitySelector;
import org.apache.maven.shared.dependency.graph.internal.maven30.VerboseJavaScopeSelector;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.sonatype.aether.RepositorySystem;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.artifact.ArtifactTypeRegistry;
import org.sonatype.aether.collection.CollectRequest;
import org.sonatype.aether.collection.CollectResult;
import org.sonatype.aether.collection.DependencyCollectionException;
import org.sonatype.aether.collection.DependencyGraphTransformer;
import org.sonatype.aether.collection.DependencySelector;
import org.sonatype.aether.graph.DependencyVisitor;
import org.sonatype.aether.util.DefaultRepositorySystemSession;
import org.sonatype.aether.util.graph.TreeDependencyVisitor;
import org.sonatype.aether.util.graph.selector.AndDependencySelector;
import org.sonatype.aether.util.graph.selector.ExclusionDependencySelector;
import org.sonatype.aether.util.graph.selector.OptionalDependencySelector;
import org.sonatype.aether.version.VersionConstraint;
import org.sonatype.aether.version.VersionRange;

@Component(role=DependencyCollectorBuilder.class, hint="maven3")
public class Maven3DependencyCollectorBuilder
extends AbstractLogEnabled
implements DependencyCollectorBuilder {
    @Requirement
    private RepositorySystem repositorySystem;
    private final ExceptionHandler<DependencyCollectorBuilderException> exceptionHandler = DependencyCollectorBuilderException::new;

    @Override
    public DependencyNode collectDependencyGraph(ProjectBuildingRequest buildingRequest, ArtifactFilter filter) throws DependencyCollectorBuilderException {
        try {
            MavenProject project = buildingRequest.getProject();
            org.apache.maven.artifact.Artifact projectArtifact = project.getArtifact();
            List remoteArtifactRepositories = project.getRemoteArtifactRepositories();
            RepositorySystemSession repositorySystemSession = buildingRequest.getRepositorySession();
            DefaultRepositorySystemSession session = new DefaultRepositorySystemSession(repositorySystemSession);
            ConflictResolver transformer = new ConflictResolver(new NearestVersionSelector(), new VerboseJavaScopeSelector(), new SimpleOptionalitySelector(), new JavaScopeDeriver());
            session.setDependencyGraphTransformer((DependencyGraphTransformer)transformer);
            AndDependencySelector depFilter = new AndDependencySelector(new DependencySelector[]{new Maven3DirectScopeDependencySelector("test"), new OptionalDependencySelector(), new ExclusionDependencySelector()});
            session.setDependencySelector((DependencySelector)depFilter);
            session.setConfigProperty("aether.conflictResolver.verbose", (Object)true);
            session.setConfigProperty("aether.dependencyManager.verbose", (Object)true);
            Artifact aetherArtifact = (Artifact)Invoker.invoke(RepositoryUtils.class, "toArtifact", org.apache.maven.artifact.Artifact.class, projectArtifact, this.exceptionHandler);
            List aetherRepos = (List)Invoker.invoke(RepositoryUtils.class, "toRepos", List.class, remoteArtifactRepositories, this.exceptionHandler);
            CollectRequest collectRequest = new CollectRequest();
            collectRequest.setRoot(new org.sonatype.aether.graph.Dependency(aetherArtifact, ""));
            collectRequest.setRepositories(aetherRepos);
            ArtifactTypeRegistry stereotypes = session.getArtifactTypeRegistry();
            this.collectDependencyList(collectRequest, project, stereotypes);
            this.collectManagedDependencyList(collectRequest, project, stereotypes);
            CollectResult collectResult = this.repositorySystem.collectDependencies((RepositorySystemSession)session, collectRequest);
            org.sonatype.aether.graph.DependencyNode rootNode = collectResult.getRoot();
            if (this.getLogger().isDebugEnabled()) {
                this.logTree(rootNode);
            }
            return this.buildDependencyNode(null, rootNode, projectArtifact, filter);
        }
        catch (DependencyCollectionException e) {
            throw new DependencyCollectorBuilderException("Could not collect dependencies: " + e.getResult(), e);
        }
    }

    private void logTree(org.sonatype.aether.graph.DependencyNode rootNode) {
        rootNode.accept((DependencyVisitor)new TreeDependencyVisitor(new DependencyVisitor(){
            String indent = "";

            public boolean visitEnter(org.sonatype.aether.graph.DependencyNode dependencyNode) {
                StringBuilder sb = new StringBuilder();
                sb.append(this.indent).append("Aether node: ").append(dependencyNode);
                if (!dependencyNode.getData().isEmpty()) {
                    sb.append("data map: ").append(dependencyNode.getData());
                }
                if (dependencyNode.getPremanagedVersion() != null && !dependencyNode.getPremanagedVersion().isEmpty()) {
                    sb.append("Premanaged.version: ").append(dependencyNode.getPremanagedVersion());
                }
                if (dependencyNode.getPremanagedScope() != null && !dependencyNode.getPremanagedScope().isEmpty()) {
                    sb.append("Premanaged.scope: ").append(dependencyNode.getPremanagedScope());
                }
                Maven3DependencyCollectorBuilder.this.getLogger().debug(sb.toString());
                this.indent = this.indent + "    ";
                return true;
            }

            public boolean visitLeave(org.sonatype.aether.graph.DependencyNode dependencyNode) {
                this.indent = this.indent.substring(0, this.indent.length() - 4);
                return true;
            }
        }));
    }

    private void collectManagedDependencyList(CollectRequest collectRequest, MavenProject project, ArtifactTypeRegistry stereotypes) throws DependencyCollectorBuilderException {
        if (project.getDependencyManagement() != null) {
            for (Dependency dependency : project.getDependencyManagement().getDependencies()) {
                org.sonatype.aether.graph.Dependency aetherDep = this.toAetherDependency(stereotypes, dependency);
                collectRequest.addManagedDependency(aetherDep);
            }
        }
    }

    private void collectDependencyList(CollectRequest collectRequest, MavenProject project, ArtifactTypeRegistry stereotypes) throws DependencyCollectorBuilderException {
        for (Dependency dependency : project.getDependencies()) {
            org.sonatype.aether.graph.Dependency aetherDep = this.toAetherDependency(stereotypes, dependency);
            collectRequest.addDependency(aetherDep);
        }
    }

    private org.sonatype.aether.graph.Dependency toAetherDependency(ArtifactTypeRegistry stereotypes, Dependency dependency) throws DependencyCollectorBuilderException {
        return (org.sonatype.aether.graph.Dependency)Invoker.invoke(RepositoryUtils.class, "toDependency", Dependency.class, ArtifactTypeRegistry.class, dependency, stereotypes, this.exceptionHandler);
    }

    private org.apache.maven.artifact.Artifact getDependencyArtifact(org.sonatype.aether.graph.Dependency dep) {
        Artifact artifact = dep.getArtifact();
        try {
            org.apache.maven.artifact.Artifact mavenArtifact = (org.apache.maven.artifact.Artifact)Invoker.invoke(RepositoryUtils.class, "toArtifact", Artifact.class, artifact, this.exceptionHandler);
            mavenArtifact.setScope(dep.getScope());
            mavenArtifact.setOptional(dep.isOptional());
            return mavenArtifact;
        }
        catch (DependencyCollectorBuilderException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private DependencyNode buildDependencyNode(DependencyNode parent, org.sonatype.aether.graph.DependencyNode node, org.apache.maven.artifact.Artifact artifact, ArtifactFilter filter) {
        String premanagedVersion = node.getPremanagedVersion();
        String premanagedScope = node.getPremanagedScope();
        Boolean optional = null;
        if (node.getDependency() != null) {
            optional = node.getDependency().isOptional();
        }
        ArrayList<Exclusion> exclusions = null;
        if (node.getDependency() != null) {
            exclusions = new ArrayList<Exclusion>(node.getDependency().getExclusions().size());
            for (org.sonatype.aether.graph.Exclusion exclusion : node.getDependency().getExclusions()) {
                Exclusion modelExclusion = new Exclusion();
                modelExclusion.setGroupId(exclusion.getGroupId());
                modelExclusion.setArtifactId(exclusion.getArtifactId());
                exclusions.add(modelExclusion);
            }
        }
        org.sonatype.aether.graph.DependencyNode winner = (org.sonatype.aether.graph.DependencyNode)node.getData().get("conflict.winner");
        String winnerVersion = null;
        String ignoredScope = null;
        if (winner != null) {
            winnerVersion = winner.getVersion().toString();
        } else {
            ignoredScope = (String)node.getData().get("REDUCED_SCOPE");
        }
        ConflictData data = new ConflictData(winnerVersion, ignoredScope);
        VerboseDependencyNode current = new VerboseDependencyNode(parent, artifact, premanagedVersion, premanagedScope, this.getVersionSelectedFromRange(node.getVersionConstraint()), optional, exclusions, data);
        ArrayList<DependencyNode> nodes = new ArrayList<DependencyNode>(node.getChildren().size());
        for (org.sonatype.aether.graph.DependencyNode child : node.getChildren()) {
            org.apache.maven.artifact.Artifact childArtifact = this.getDependencyArtifact(child.getDependency());
            if (filter != null && !filter.include(childArtifact)) continue;
            nodes.add(this.buildDependencyNode(current, child, childArtifact, filter));
        }
        current.setChildren(Collections.unmodifiableList(nodes));
        return current;
    }

    private String getVersionSelectedFromRange(VersionConstraint constraint) {
        if (constraint == null || constraint.getVersion() != null || constraint.getRanges().isEmpty()) {
            return null;
        }
        return ((VersionRange)constraint.getRanges().iterator().next()).toString();
    }
}

