/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.model.InputLocation;
import org.apache.maven.api.model.InputLocationTracker;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class Exclusion
implements Serializable,
InputLocationTracker {
    final String groupId;
    final String artifactId;
    final Map<Object, InputLocation> locations;
    final InputLocation importedFrom;

    protected Exclusion(Builder builder) {
        String string = builder.groupId != null ? builder.groupId : (this.groupId = builder.base != null ? builder.base.groupId : null);
        this.artifactId = builder.artifactId != null ? builder.artifactId : (builder.base != null ? builder.base.artifactId : null);
        Map<Object, Object> newlocs = builder.locations != null ? builder.locations : Collections.emptyMap();
        Map oldlocs = builder.base != null && builder.base.locations != null ? builder.base.locations : Collections.emptyMap();
        HashMap<String, InputLocation> mutableLocations = new HashMap<String, InputLocation>();
        this.importedFrom = builder.importedFrom;
        mutableLocations.put("", newlocs.containsKey("") ? (InputLocation)newlocs.get("") : (InputLocation)oldlocs.get(""));
        mutableLocations.put("groupId", newlocs.containsKey("groupId") ? (InputLocation)newlocs.get("groupId") : (InputLocation)oldlocs.get("groupId"));
        mutableLocations.put("artifactId", newlocs.containsKey("artifactId") ? (InputLocation)newlocs.get("artifactId") : (InputLocation)oldlocs.get("artifactId"));
        this.locations = Collections.unmodifiableMap(mutableLocations);
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    @Override
    public InputLocation getLocation(Object key) {
        return this.locations != null ? this.locations.get(key) : null;
    }

    public Set<Object> getLocationKeys() {
        return this.locations != null ? this.locations.keySet() : null;
    }

    @Override
    public InputLocation getImportedFrom() {
        return this.importedFrom;
    }

    @Nonnull
    public Builder with() {
        return Exclusion.newBuilder(this);
    }

    @Nonnull
    public Exclusion withGroupId(String groupId) {
        return Exclusion.newBuilder(this, true).groupId(groupId).build();
    }

    @Nonnull
    public Exclusion withArtifactId(String artifactId) {
        return Exclusion.newBuilder(this, true).artifactId(artifactId).build();
    }

    @Nonnull
    public static Exclusion newInstance() {
        return Exclusion.newInstance(true);
    }

    @Nonnull
    public static Exclusion newInstance(boolean withDefaults) {
        return Exclusion.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return Exclusion.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(Exclusion from) {
        return Exclusion.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(Exclusion from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    @NotThreadSafe
    public static class Builder {
        Exclusion base;
        String groupId;
        String artifactId;
        Map<Object, InputLocation> locations;
        InputLocation importedFrom;

        protected Builder(boolean withDefaults) {
            if (withDefaults) {
                // empty if block
            }
        }

        protected Builder(Exclusion base, boolean forceCopy) {
            if (forceCopy) {
                this.groupId = base.groupId;
                this.artifactId = base.artifactId;
                this.locations = base.locations;
                this.importedFrom = base.importedFrom;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        @Nonnull
        public Builder artifactId(String artifactId) {
            this.artifactId = artifactId;
            return this;
        }

        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (!(this.locations instanceof HashMap)) {
                    this.locations = this.locations != null ? new HashMap<Object, InputLocation>(this.locations) : new HashMap();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Nonnull
        public Builder importedFrom(InputLocation importedFrom) {
            this.importedFrom = importedFrom;
            return this;
        }

        @Nonnull
        public Exclusion build() {
            if (!(this.base == null || this.groupId != null && this.groupId != this.base.groupId || this.artifactId != null && this.artifactId != this.base.artifactId)) {
                return this.base;
            }
            return new Exclusion(this);
        }
    }
}

