/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.model.ImmutableCollections;
import org.apache.maven.api.model.InputLocation;
import org.apache.maven.api.model.InputLocationTracker;
import org.apache.maven.api.model.Notifier;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class CiManagement
implements Serializable,
InputLocationTracker {
    final String system;
    final String url;
    final List<Notifier> notifiers;
    final Map<Object, InputLocation> locations;

    CiManagement(String system, String url, Collection<Notifier> notifiers, Map<Object, InputLocation> locations) {
        this.system = system;
        this.url = url;
        this.notifiers = ImmutableCollections.copy(notifiers);
        this.locations = ImmutableCollections.copy(locations);
    }

    public String getSystem() {
        return this.system;
    }

    public String getUrl() {
        return this.url;
    }

    @Nonnull
    public List<Notifier> getNotifiers() {
        return this.notifiers;
    }

    @Override
    public InputLocation getLocation(Object key) {
        return this.locations != null ? this.locations.get(key) : null;
    }

    @Nonnull
    public Builder with() {
        return CiManagement.newBuilder(this);
    }

    @Nonnull
    public CiManagement withSystem(String system) {
        return CiManagement.newBuilder(this, true).system(system).build();
    }

    @Nonnull
    public CiManagement withUrl(String url) {
        return CiManagement.newBuilder(this, true).url(url).build();
    }

    @Nonnull
    public CiManagement withNotifiers(Collection<Notifier> notifiers) {
        return CiManagement.newBuilder(this, true).notifiers(notifiers).build();
    }

    @Nonnull
    public static CiManagement newInstance() {
        return CiManagement.newInstance(true);
    }

    @Nonnull
    public static CiManagement newInstance(boolean withDefaults) {
        return CiManagement.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return CiManagement.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(CiManagement from) {
        return CiManagement.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(CiManagement from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    @NotThreadSafe
    public static class Builder {
        CiManagement base;
        String system;
        String url;
        Collection<Notifier> notifiers;
        Map<Object, InputLocation> locations;

        Builder(boolean withDefaults) {
            if (withDefaults) {
                // empty if block
            }
        }

        Builder(CiManagement base, boolean forceCopy) {
            if (forceCopy) {
                this.system = base.system;
                this.url = base.url;
                this.notifiers = base.notifiers;
                this.locations = base.locations;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder system(String system) {
            this.system = system;
            return this;
        }

        @Nonnull
        public Builder url(String url) {
            this.url = url;
            return this;
        }

        @Nonnull
        public Builder notifiers(Collection<Notifier> notifiers) {
            this.notifiers = notifiers;
            return this;
        }

        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (!(this.locations instanceof HashMap)) {
                    this.locations = this.locations != null ? new HashMap<Object, InputLocation>(this.locations) : new HashMap();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Nonnull
        public CiManagement build() {
            if (!(this.base == null || this.system != null && this.system != this.base.system || this.url != null && this.url != this.base.url || this.notifiers != null && this.notifiers != this.base.notifiers)) {
                return this.base;
            }
            Map<Object, Object> newlocs = this.locations != null ? this.locations : Collections.emptyMap();
            Map oldlocs = this.base != null && this.base.locations != null ? this.base.locations : Collections.emptyMap();
            HashMap<Object, InputLocation> locations = new HashMap<Object, InputLocation>();
            locations.put("", newlocs.containsKey("") ? (InputLocation)newlocs.get("") : (InputLocation)oldlocs.get(""));
            locations.put("system", newlocs.containsKey("system") ? (InputLocation)newlocs.get("system") : (InputLocation)oldlocs.get("system"));
            locations.put("url", newlocs.containsKey("url") ? (InputLocation)newlocs.get("url") : (InputLocation)oldlocs.get("url"));
            locations.put("notifiers", newlocs.containsKey("notifiers") ? (InputLocation)newlocs.get("notifiers") : (InputLocation)oldlocs.get("notifiers"));
            return new CiManagement(this.system != null ? this.system : (this.base != null ? this.base.system : null), this.url != null ? this.url : (this.base != null ? this.base.url : null), this.notifiers != null ? this.notifiers : (this.base != null ? this.base.notifiers : null), locations);
        }
    }
}

