// =================== DO NOT EDIT THIS FILE ====================
//  Generated by Modello Velocity from model.vm
//  template, any modifications will be overwritten.
// ==============================================================
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;

/**
 * Download policy.
 */
@Experimental
@Generated @ThreadSafe @Immutable
public class RepositoryPolicy
    implements Serializable, InputLocationTracker
{
    /**
     * Whether to use this repository for downloading this type of artifact. Note: While the type
     * of this field is {@code String} for technical reasons, the semantic type is actually
     * {@code Boolean}. Default value is {@code true}.
     */
    final String enabled;
    /**
     * The frequency for downloading updates - can be
     * {@code always,}
     * {@code daily}
     * (default),
     * {@code interval:XXX}
     * (in minutes) or
     * {@code never}
     * (only if it doesn't exist locally).
     */
    final String updatePolicy;
    /**
     * What to do when verification of an artifact checksum fails. Valid values are
     * {@code ignore},
     * {@code fail}
     * (default for Maven 4 and above) or
     * {@code warn}
     * (default for Maven 2 and 3)
     */
    final String checksumPolicy;
    /** Locations */
    final Map<Object, InputLocation> locations;

    /**
      * Constructor for this class, package protected.
      * @see Builder#build()
      */
    RepositoryPolicy(
        String enabled,
        String updatePolicy,
        String checksumPolicy,
        Map<Object, InputLocation> locations
    ) {
        this.enabled = enabled;
        this.updatePolicy = updatePolicy;
        this.checksumPolicy = checksumPolicy;
        this.locations = ImmutableCollections.copy(locations);
    }

    /**
     * Whether to use this repository for downloading this type of artifact. Note: While the type
     * of this field is {@code String} for technical reasons, the semantic type is actually
     * {@code Boolean}. Default value is {@code true}.
     *
     * @return a {@code String}
     */
    public String getEnabled() {
        return this.enabled;
    }

    /**
     * The frequency for downloading updates - can be
     * {@code always,}
     * {@code daily}
     * (default),
     * {@code interval:XXX}
     * (in minutes) or
     * {@code never}
     * (only if it doesn't exist locally).
     *
     * @return a {@code String}
     */
    public String getUpdatePolicy() {
        return this.updatePolicy;
    }

    /**
     * What to do when verification of an artifact checksum fails. Valid values are
     * {@code ignore},
     * {@code fail}
     * (default for Maven 4 and above) or
     * {@code warn}
     * (default for Maven 2 and 3)
     *
     * @return a {@code String}
     */
    public String getChecksumPolicy() {
        return this.checksumPolicy;
    }

    /**
     * Gets the location of the specified field in the input source.
     */
    public InputLocation getLocation(Object key) {
        return locations != null ? locations.get(key) : null;
    }

    /**
     * Creates a new builder with this object as the basis.
     *
     * @return a {@code Builder}
     */
    @Nonnull
    public Builder with() {
        return newBuilder(this);
    }
    /**
     * Creates a new {@code RepositoryPolicy} instance using the specified enabled.
     *
     * @param enabled the new {@code String} to use
     * @return a {@code RepositoryPolicy} with the specified enabled
     */
    @Nonnull
    public RepositoryPolicy withEnabled(String enabled) {
        return newBuilder(this, true).enabled(enabled).build();
    }
    /**
     * Creates a new {@code RepositoryPolicy} instance using the specified updatePolicy.
     *
     * @param updatePolicy the new {@code String} to use
     * @return a {@code RepositoryPolicy} with the specified updatePolicy
     */
    @Nonnull
    public RepositoryPolicy withUpdatePolicy(String updatePolicy) {
        return newBuilder(this, true).updatePolicy(updatePolicy).build();
    }
    /**
     * Creates a new {@code RepositoryPolicy} instance using the specified checksumPolicy.
     *
     * @param checksumPolicy the new {@code String} to use
     * @return a {@code RepositoryPolicy} with the specified checksumPolicy
     */
    @Nonnull
    public RepositoryPolicy withChecksumPolicy(String checksumPolicy) {
        return newBuilder(this, true).checksumPolicy(checksumPolicy).build();
    }

    /**
     * Creates a new {@code RepositoryPolicy} instance.
     * Equivalent to {@code newInstance(true)}.
     * @see #newInstance(boolean)
     *
     * @return a new {@code RepositoryPolicy}
     */
    @Nonnull
    public static RepositoryPolicy newInstance() {
        return newInstance(true);
    }

    /**
     * Creates a new {@code RepositoryPolicy} instance using default values or not.
     * Equivalent to {@code newBuilder(withDefaults).build()}.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code RepositoryPolicy}
     */
    @Nonnull
    public static RepositoryPolicy newInstance(boolean withDefaults) {
        return newBuilder(withDefaults).build();
    }

    /**
     * Creates a new {@code RepositoryPolicy} builder instance.
     * Equivalent to {@code newBuilder(true)}.
     * @see #newBuilder(boolean)
     *
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder() {
        return newBuilder(true);
    }

    /**
     * Creates a new {@code RepositoryPolicy} builder instance using default values or not.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    /**
     * Creates a new {@code RepositoryPolicy} builder instance using the specified object as a basis.
     * Equivalent to {@code newBuilder(from, false)}.
     *
     * @param from the {@code RepositoryPolicy} instance to use as a basis
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(RepositoryPolicy from) {
        return newBuilder(from, false);
    }

    /**
     * Creates a new {@code RepositoryPolicy} builder instance using the specified object as a basis.
     *
     * @param from the {@code RepositoryPolicy} instance to use as a basis
     * @param forceCopy the boolean indicating if a copy should be forced
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(RepositoryPolicy from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    /**
     * Builder class used to create RepositoryPolicy instances.
     * @see #with()
     * @see #newBuilder()
     */
    @NotThreadSafe
    public static class Builder
    {
        RepositoryPolicy base;
        String enabled;
        String updatePolicy;
        String checksumPolicy;
        Map<Object, InputLocation> locations;

        Builder(boolean withDefaults) {
            if (withDefaults) {
            }
        }

        Builder(RepositoryPolicy base, boolean forceCopy) {
            if (forceCopy) {
                this.enabled = base.enabled;
                this.updatePolicy = base.updatePolicy;
                this.checksumPolicy = base.checksumPolicy;
                this.locations = base.locations;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder enabled(String enabled) {
            this.enabled = enabled;
            return this;
        }

        @Nonnull
        public Builder updatePolicy(String updatePolicy) {
            this.updatePolicy = updatePolicy;
            return this;
        }

        @Nonnull
        public Builder checksumPolicy(String checksumPolicy) {
            this.checksumPolicy = checksumPolicy;
            return this;
        }


        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (!(this.locations instanceof HashMap)) {
                    this.locations = this.locations != null ? new HashMap<>(this.locations) : new HashMap<>();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Nonnull
        public RepositoryPolicy build() {
            if (base != null
                    && (enabled == null || enabled == base.enabled)
                    && (updatePolicy == null || updatePolicy == base.updatePolicy)
                    && (checksumPolicy == null || checksumPolicy == base.checksumPolicy)
            ) {
                return base;
            }
            Map<Object, InputLocation> newlocs = this.locations != null ? this.locations : Collections.emptyMap();
            Map<Object, InputLocation> oldlocs = this.base != null && this.base.locations != null ? this.base.locations : Collections.emptyMap();
            Map<Object, InputLocation> locations = new HashMap<>();
            locations.put("", newlocs.containsKey("") ? newlocs.get("") : oldlocs.get(""));
            locations.put("enabled", newlocs.containsKey("enabled") ? newlocs.get("enabled") : oldlocs.get("enabled"));
            locations.put("updatePolicy", newlocs.containsKey("updatePolicy") ? newlocs.get("updatePolicy") : oldlocs.get("updatePolicy"));
            locations.put("checksumPolicy", newlocs.containsKey("checksumPolicy") ? newlocs.get("checksumPolicy") : oldlocs.get("checksumPolicy"));
            return new RepositoryPolicy(
                enabled != null ? enabled : (base != null ? base.enabled : null),
                updatePolicy != null ? updatePolicy : (base != null ? base.updatePolicy : null),
                checksumPolicy != null ? checksumPolicy : (base != null ? base.checksumPolicy : null),
                locations
            );
        }
    }


            
    public boolean isEnabled()
    {
        return ( getEnabled() != null ) ? Boolean.parseBoolean( getEnabled() ) : true;
    }

            
          
}
