// =================== DO NOT EDIT THIS FILE ====================
//  Generated by Modello Velocity from model.vm
//  template, any modifications will be overwritten.
// ==============================================================
package org.apache.maven.api.model;

import java.io.Serializable;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;

/**
 * The {@code <project>} element is the root of the descriptor.
 * The following table lists all of the possible child elements.
 */
@Experimental
@Generated @ThreadSafe @Immutable
public class Model
    extends ModelBase
    implements Serializable, InputLocationTracker
{
    final String namespaceUri;
    final String modelEncoding;
    /**
     * Originating POM file
     */
    final Path pomFile;
    /**
     * Declares to which version of project descriptor this POM conforms.
     */
    final String modelVersion;
    /**
     * The location of the parent project, if one exists. Values from the parent
     * project will be the default for this project if they are left unspecified. The location
     * is given as a group ID, artifact ID and version.
     */
    final Parent parent;
    /**
     * A universally unique identifier for a project. It is normal to
     * use a fully-qualified package name to distinguish it from other
     * projects with a similar name (eg. {@code org.apache.maven}).
     */
    final String groupId;
    /**
     * The identifier for this artifact that is unique within the group given by the
     * group ID. An artifact is something that is either produced or used by a project.
     * Examples of artifacts produced by Maven for a project include: JARs, source and binary
     * distributions, and WARs.
     */
    final String artifactId;
    /**
     * The current version of the artifact produced by this project.
     */
    final String version;
    /**
     * The type of artifact this project produces, for example {@code jar}
     * {@code war}
     * {@code ear}
     * {@code pom}.
     * Plugins can create their own packaging, and
     * therefore their own packaging types,
     * so this list does not contain all possible types.
     */
    final String packaging;
    /**
     * The full name of the project.
     */
    final String name;
    /**
     * A detailed description of the project, used by Maven whenever it needs to
     * describe the project, such as on the web site. While this element can be specified as
     * CDATA to enable the use of HTML tags within the description, it is discouraged to allow
     * plain text representation. If you need to modify the index page of the generated web
     * site, you are able to specify your own instead of adjusting this text.
     */
    final String description;
    /**
     * The URL to the project's homepage.
     * <br><b>Default value is</b>: parent value [+ path adjustment] + (artifactId or project.directory property), or just parent value if
     * project's {@code child.project.url.inherit.append.path="false"}
     */
    final String url;
    /**
     * When children inherit from project's url, append path or not? Note: While the type
     * of this field is {@code String} for technical reasons, the semantic type is actually
     * {@code Boolean}
     * <br><b>Default value is</b>: {@code true}
     * <br><b>Since</b>: Maven 3.6.1
     */
    final String childProjectUrlInheritAppendPath;
    /**
     * Indicates that this project is the root project, located in the upper directory of the source tree.
     * This is the directory which may contain the .mvn directory.
     * <br><b>Since</b>: Maven 4.0.0
     */
    final boolean root;
    /**
     * Indicates if the build POM for this project should be preserved or downgraded to the lowest
     * compatible version.
     * <br><b>Since</b>: Maven 4.0.0
     */
    final boolean preserveModelVersion;
    /**
     * The year of the project's inception, specified with 4 digits. This value is
     * used when generating copyright notices as well as being informational.
     */
    final String inceptionYear;
    /**
     * This element describes various attributes of the organization to which the
     * project belongs. These attributes are utilized when documentation is created (for
     * copyright notices and links).
     */
    final Organization organization;
    /**
     * This element describes all of the licenses for this project.
     * Each license is described by a {@code license} element, which
     * is then described by additional elements.
     * Projects should only list the license(s) that applies to the project
     * and not the licenses that apply to dependencies.
     * If multiple licenses are listed, it is assumed that the user can select
     * any of them, not that they must accept all.
     */
    final List<License> licenses;
    /**
     * Describes the committers of a project.
     */
    final List<Developer> developers;
    /**
     * Describes the contributors to a project that are not yet committers.
     */
    final List<Contributor> contributors;
    /**
     * Contains information about a project's mailing lists.
     */
    final List<MailingList> mailingLists;
    /**
     * Describes the prerequisites in the build environment for this project.
     */
    final Prerequisites prerequisites;
    /**
     * Specification for the SCM used by the project, such as CVS, Subversion, etc.
     */
    final Scm scm;
    /**
     * The project's issue management system information.
     */
    final IssueManagement issueManagement;
    /**
     * The project's continuous integration information.
     */
    final CiManagement ciManagement;
    /**
     * Information required to build the project.
     */
    final Build build;
    /**
     * A listing of project-local build profiles which will modify the build process
     * when activated.
     */
    final List<Profile> profiles;

    /**
      * Constructor for this class, package protected.
      * @see Builder#build()
      */
    Model(
        String namespaceUri,
        String modelEncoding,
        Collection<String> modules,
        DistributionManagement distributionManagement,
        Map<String, String> properties,
        DependencyManagement dependencyManagement,
        Collection<Dependency> dependencies,
        Collection<Repository> repositories,
        Collection<Repository> pluginRepositories,
        Reporting reporting,
        Path pomFile,
        String modelVersion,
        Parent parent,
        String groupId,
        String artifactId,
        String version,
        String packaging,
        String name,
        String description,
        String url,
        String childProjectUrlInheritAppendPath,
        boolean root,
        boolean preserveModelVersion,
        String inceptionYear,
        Organization organization,
        Collection<License> licenses,
        Collection<Developer> developers,
        Collection<Contributor> contributors,
        Collection<MailingList> mailingLists,
        Prerequisites prerequisites,
        Scm scm,
        IssueManagement issueManagement,
        CiManagement ciManagement,
        Build build,
        Collection<Profile> profiles,
        Map<Object, InputLocation> locations
    ) {
        super(
            modules,
            distributionManagement,
            properties,
            dependencyManagement,
            dependencies,
            repositories,
            pluginRepositories,
            reporting,
            locations
        );
        this.namespaceUri = namespaceUri;
        this.modelEncoding = modelEncoding;
        this.pomFile = pomFile;
        this.modelVersion = modelVersion;
        this.parent = parent;
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.packaging = packaging;
        this.name = name;
        this.description = description;
        this.url = url;
        this.childProjectUrlInheritAppendPath = childProjectUrlInheritAppendPath;
        this.root = root;
        this.preserveModelVersion = preserveModelVersion;
        this.inceptionYear = inceptionYear;
        this.organization = organization;
        this.licenses = ImmutableCollections.copy(licenses);
        this.developers = ImmutableCollections.copy(developers);
        this.contributors = ImmutableCollections.copy(contributors);
        this.mailingLists = ImmutableCollections.copy(mailingLists);
        this.prerequisites = prerequisites;
        this.scm = scm;
        this.issueManagement = issueManagement;
        this.ciManagement = ciManagement;
        this.build = build;
        this.profiles = ImmutableCollections.copy(profiles);
    }

    public String getNamespaceUri() {
        return namespaceUri;
    }

    public String getModelEncoding() {
        return modelEncoding;
    }

    /**
     * Originating POM file
     *
     * @return a {@code Path}
     */
    public Path getPomFile() {
        return this.pomFile;
    }

    /**
     * Declares to which version of project descriptor this POM conforms.
     *
     * @return a {@code String}
     */
    public String getModelVersion() {
        return this.modelVersion;
    }

    /**
     * The location of the parent project, if one exists. Values from the parent
     * project will be the default for this project if they are left unspecified. The location
     * is given as a group ID, artifact ID and version.
     *
     * @return a {@code Parent}
     */
    public Parent getParent() {
        return this.parent;
    }

    /**
     * A universally unique identifier for a project. It is normal to
     * use a fully-qualified package name to distinguish it from other
     * projects with a similar name (eg. {@code org.apache.maven}).
     *
     * @return a {@code String}
     */
    public String getGroupId() {
        return this.groupId;
    }

    /**
     * The identifier for this artifact that is unique within the group given by the
     * group ID. An artifact is something that is either produced or used by a project.
     * Examples of artifacts produced by Maven for a project include: JARs, source and binary
     * distributions, and WARs.
     *
     * @return a {@code String}
     */
    public String getArtifactId() {
        return this.artifactId;
    }

    /**
     * The current version of the artifact produced by this project.
     *
     * @return a {@code String}
     */
    public String getVersion() {
        return this.version;
    }

    /**
     * The type of artifact this project produces, for example {@code jar}
     * {@code war}
     * {@code ear}
     * {@code pom}.
     * Plugins can create their own packaging, and
     * therefore their own packaging types,
     * so this list does not contain all possible types.
     *
     * @return a {@code String}
     */
    public String getPackaging() {
        return this.packaging;
    }

    /**
     * The full name of the project.
     *
     * @return a {@code String}
     */
    public String getName() {
        return this.name;
    }

    /**
     * A detailed description of the project, used by Maven whenever it needs to
     * describe the project, such as on the web site. While this element can be specified as
     * CDATA to enable the use of HTML tags within the description, it is discouraged to allow
     * plain text representation. If you need to modify the index page of the generated web
     * site, you are able to specify your own instead of adjusting this text.
     *
     * @return a {@code String}
     */
    public String getDescription() {
        return this.description;
    }

    /**
     * The URL to the project's homepage.
     * <br><b>Default value is</b>: parent value [+ path adjustment] + (artifactId or project.directory property), or just parent value if
     * project's {@code child.project.url.inherit.append.path="false"}
     *
     * @return a {@code String}
     */
    public String getUrl() {
        return this.url;
    }

    /**
     * When children inherit from project's url, append path or not? Note: While the type
     * of this field is {@code String} for technical reasons, the semantic type is actually
     * {@code Boolean}
     * <br><b>Default value is</b>: {@code true}
     * <br><b>Since</b>: Maven 3.6.1
     *
     * @return a {@code String}
     */
    public String getChildProjectUrlInheritAppendPath() {
        return this.childProjectUrlInheritAppendPath;
    }

    /**
     * Indicates that this project is the root project, located in the upper directory of the source tree.
     * This is the directory which may contain the .mvn directory.
     * <br><b>Since</b>: Maven 4.0.0
     *
     * @return a {@code boolean}
     */
    public boolean isRoot() {
        return this.root;
    }

    /**
     * Indicates if the build POM for this project should be preserved or downgraded to the lowest
     * compatible version.
     * <br><b>Since</b>: Maven 4.0.0
     *
     * @return a {@code boolean}
     */
    public boolean isPreserveModelVersion() {
        return this.preserveModelVersion;
    }

    /**
     * The year of the project's inception, specified with 4 digits. This value is
     * used when generating copyright notices as well as being informational.
     *
     * @return a {@code String}
     */
    public String getInceptionYear() {
        return this.inceptionYear;
    }

    /**
     * This element describes various attributes of the organization to which the
     * project belongs. These attributes are utilized when documentation is created (for
     * copyright notices and links).
     *
     * @return a {@code Organization}
     */
    public Organization getOrganization() {
        return this.organization;
    }

    /**
     * This element describes all of the licenses for this project.
     * Each license is described by a {@code license} element, which
     * is then described by additional elements.
     * Projects should only list the license(s) that applies to the project
     * and not the licenses that apply to dependencies.
     * If multiple licenses are listed, it is assumed that the user can select
     * any of them, not that they must accept all.
     *
     * @return a {@code List<License>}
     */
    @Nonnull
    public List<License> getLicenses() {
        return this.licenses;
    }

    /**
     * Describes the committers of a project.
     *
     * @return a {@code List<Developer>}
     */
    @Nonnull
    public List<Developer> getDevelopers() {
        return this.developers;
    }

    /**
     * Describes the contributors to a project that are not yet committers.
     *
     * @return a {@code List<Contributor>}
     */
    @Nonnull
    public List<Contributor> getContributors() {
        return this.contributors;
    }

    /**
     * Contains information about a project's mailing lists.
     *
     * @return a {@code List<MailingList>}
     */
    @Nonnull
    public List<MailingList> getMailingLists() {
        return this.mailingLists;
    }

    /**
     * Describes the prerequisites in the build environment for this project.
     *
     * @return a {@code Prerequisites}
     */
    public Prerequisites getPrerequisites() {
        return this.prerequisites;
    }

    /**
     * Specification for the SCM used by the project, such as CVS, Subversion, etc.
     *
     * @return a {@code Scm}
     */
    public Scm getScm() {
        return this.scm;
    }

    /**
     * The project's issue management system information.
     *
     * @return a {@code IssueManagement}
     */
    public IssueManagement getIssueManagement() {
        return this.issueManagement;
    }

    /**
     * The project's continuous integration information.
     *
     * @return a {@code CiManagement}
     */
    public CiManagement getCiManagement() {
        return this.ciManagement;
    }

    /**
     * Information required to build the project.
     *
     * @return a {@code Build}
     */
    public Build getBuild() {
        return this.build;
    }

    /**
     * A listing of project-local build profiles which will modify the build process
     * when activated.
     *
     * @return a {@code List<Profile>}
     */
    @Nonnull
    public List<Profile> getProfiles() {
        return this.profiles;
    }

    /**
     * Creates a new builder with this object as the basis.
     *
     * @return a {@code Builder}
     */
    @Nonnull
    public Builder with() {
        return newBuilder(this);
    }
    /**
     * Creates a new {@code Model} instance using the specified modules.
     *
     * @param modules the new {@code Collection<String>} to use
     * @return a {@code Model} with the specified modules
     */
    @Nonnull
    public Model withModules(Collection<String> modules) {
        return newBuilder(this, true).modules(modules).build();
    }
    /**
     * Creates a new {@code Model} instance using the specified distributionManagement.
     *
     * @param distributionManagement the new {@code DistributionManagement} to use
     * @return a {@code Model} with the specified distributionManagement
     */
    @Nonnull
    public Model withDistributionManagement(DistributionManagement distributionManagement) {
        return newBuilder(this, true).distributionManagement(distributionManagement).build();
    }
    /**
     * Creates a new {@code Model} instance using the specified properties.
     *
     * @param properties the new {@code Map<String, String>} to use
     * @return a {@code Model} with the specified properties
     */
    @Nonnull
    public Model withProperties(Map<String, String> properties) {
        return newBuilder(this, true).properties(properties).build();
    }
    /**
     * Creates a new {@code Model} instance using the specified dependencyManagement.
     *
     * @param dependencyManagement the new {@code DependencyManagement} to use
     * @return a {@code Model} with the specified dependencyManagement
     */
    @Nonnull
    public Model withDependencyManagement(DependencyManagement dependencyManagement) {
        return newBuilder(this, true).dependencyManagement(dependencyManagement).build();
    }
    /**
     * Creates a new {@code Model} instance using the specified dependencies.
     *
     * @param dependencies the new {@code Collection<Dependency>} to use
     * @return a {@code Model} with the specified dependencies
     */
    @Nonnull
    public Model withDependencies(Collection<Dependency> dependencies) {
        return newBuilder(this, true).dependencies(dependencies).build();
    }
    /**
     * Creates a new {@code Model} instance using the specified repositories.
     *
     * @param repositories the new {@code Collection<Repository>} to use
     * @return a {@code Model} with the specified repositories
     */
    @Nonnull
    public Model withRepositories(Collection<Repository> repositories) {
        return newBuilder(this, true).repositories(repositories).build();
    }
    /**
     * Creates a new {@code Model} instance using the specified pluginRepositories.
     *
     * @param pluginRepositories the new {@code Collection<Repository>} to use
     * @return a {@code Model} with the specified pluginRepositories
     */
    @Nonnull
    public Model withPluginRepositories(Collection<Repository> pluginRepositories) {
        return newBuilder(this, true).pluginRepositories(pluginRepositories).build();
    }
    /**
     * Creates a new {@code Model} instance using the specified reporting.
     *
     * @param reporting the new {@code Reporting} to use
     * @return a {@code Model} with the specified reporting
     */
    @Nonnull
    public Model withReporting(Reporting reporting) {
        return newBuilder(this, true).reporting(reporting).build();
    }
    /**
     * Creates a new {@code Model} instance using the specified pomFile.
     *
     * @param pomFile the new {@code Path} to use
     * @return a {@code Model} with the specified pomFile
     */
    @Nonnull
    public Model withPomFile(Path pomFile) {
        return newBuilder(this, true).pomFile(pomFile).build();
    }
    /**
     * Creates a new {@code Model} instance using the specified modelVersion.
     *
     * @param modelVersion the new {@code String} to use
     * @return a {@code Model} with the specified modelVersion
     */
    @Nonnull
    public Model withModelVersion(String modelVersion) {
        return newBuilder(this, true).modelVersion(modelVersion).build();
    }
    /**
     * Creates a new {@code Model} instance using the specified parent.
     *
     * @param parent the new {@code Parent} to use
     * @return a {@code Model} with the specified parent
     */
    @Nonnull
    public Model withParent(Parent parent) {
        return newBuilder(this, true).parent(parent).build();
    }
    /**
     * Creates a new {@code Model} instance using the specified groupId.
     *
     * @param groupId the new {@code String} to use
     * @return a {@code Model} with the specified groupId
     */
    @Nonnull
    public Model withGroupId(String groupId) {
        return newBuilder(this, true).groupId(groupId).build();
    }
    /**
     * Creates a new {@code Model} instance using the specified artifactId.
     *
     * @param artifactId the new {@code String} to use
     * @return a {@code Model} with the specified artifactId
     */
    @Nonnull
    public Model withArtifactId(String artifactId) {
        return newBuilder(this, true).artifactId(artifactId).build();
    }
    /**
     * Creates a new {@code Model} instance using the specified version.
     *
     * @param version the new {@code String} to use
     * @return a {@code Model} with the specified version
     */
    @Nonnull
    public Model withVersion(String version) {
        return newBuilder(this, true).version(version).build();
    }
    /**
     * Creates a new {@code Model} instance using the specified packaging.
     *
     * @param packaging the new {@code String} to use
     * @return a {@code Model} with the specified packaging
     */
    @Nonnull
    public Model withPackaging(String packaging) {
        return newBuilder(this, true).packaging(packaging).build();
    }
    /**
     * Creates a new {@code Model} instance using the specified name.
     *
     * @param name the new {@code String} to use
     * @return a {@code Model} with the specified name
     */
    @Nonnull
    public Model withName(String name) {
        return newBuilder(this, true).name(name).build();
    }
    /**
     * Creates a new {@code Model} instance using the specified description.
     *
     * @param description the new {@code String} to use
     * @return a {@code Model} with the specified description
     */
    @Nonnull
    public Model withDescription(String description) {
        return newBuilder(this, true).description(description).build();
    }
    /**
     * Creates a new {@code Model} instance using the specified url.
     *
     * @param url the new {@code String} to use
     * @return a {@code Model} with the specified url
     */
    @Nonnull
    public Model withUrl(String url) {
        return newBuilder(this, true).url(url).build();
    }
    /**
     * Creates a new {@code Model} instance using the specified childProjectUrlInheritAppendPath.
     *
     * @param childProjectUrlInheritAppendPath the new {@code String} to use
     * @return a {@code Model} with the specified childProjectUrlInheritAppendPath
     */
    @Nonnull
    public Model withChildProjectUrlInheritAppendPath(String childProjectUrlInheritAppendPath) {
        return newBuilder(this, true).childProjectUrlInheritAppendPath(childProjectUrlInheritAppendPath).build();
    }
    /**
     * Creates a new {@code Model} instance using the specified root.
     *
     * @param root the new {@code boolean} to use
     * @return a {@code Model} with the specified root
     */
    @Nonnull
    public Model withRoot(boolean root) {
        return newBuilder(this, true).root(root).build();
    }
    /**
     * Creates a new {@code Model} instance using the specified preserveModelVersion.
     *
     * @param preserveModelVersion the new {@code boolean} to use
     * @return a {@code Model} with the specified preserveModelVersion
     */
    @Nonnull
    public Model withPreserveModelVersion(boolean preserveModelVersion) {
        return newBuilder(this, true).preserveModelVersion(preserveModelVersion).build();
    }
    /**
     * Creates a new {@code Model} instance using the specified inceptionYear.
     *
     * @param inceptionYear the new {@code String} to use
     * @return a {@code Model} with the specified inceptionYear
     */
    @Nonnull
    public Model withInceptionYear(String inceptionYear) {
        return newBuilder(this, true).inceptionYear(inceptionYear).build();
    }
    /**
     * Creates a new {@code Model} instance using the specified organization.
     *
     * @param organization the new {@code Organization} to use
     * @return a {@code Model} with the specified organization
     */
    @Nonnull
    public Model withOrganization(Organization organization) {
        return newBuilder(this, true).organization(organization).build();
    }
    /**
     * Creates a new {@code Model} instance using the specified licenses.
     *
     * @param licenses the new {@code Collection<License>} to use
     * @return a {@code Model} with the specified licenses
     */
    @Nonnull
    public Model withLicenses(Collection<License> licenses) {
        return newBuilder(this, true).licenses(licenses).build();
    }
    /**
     * Creates a new {@code Model} instance using the specified developers.
     *
     * @param developers the new {@code Collection<Developer>} to use
     * @return a {@code Model} with the specified developers
     */
    @Nonnull
    public Model withDevelopers(Collection<Developer> developers) {
        return newBuilder(this, true).developers(developers).build();
    }
    /**
     * Creates a new {@code Model} instance using the specified contributors.
     *
     * @param contributors the new {@code Collection<Contributor>} to use
     * @return a {@code Model} with the specified contributors
     */
    @Nonnull
    public Model withContributors(Collection<Contributor> contributors) {
        return newBuilder(this, true).contributors(contributors).build();
    }
    /**
     * Creates a new {@code Model} instance using the specified mailingLists.
     *
     * @param mailingLists the new {@code Collection<MailingList>} to use
     * @return a {@code Model} with the specified mailingLists
     */
    @Nonnull
    public Model withMailingLists(Collection<MailingList> mailingLists) {
        return newBuilder(this, true).mailingLists(mailingLists).build();
    }
    /**
     * Creates a new {@code Model} instance using the specified prerequisites.
     *
     * @param prerequisites the new {@code Prerequisites} to use
     * @return a {@code Model} with the specified prerequisites
     */
    @Nonnull
    public Model withPrerequisites(Prerequisites prerequisites) {
        return newBuilder(this, true).prerequisites(prerequisites).build();
    }
    /**
     * Creates a new {@code Model} instance using the specified scm.
     *
     * @param scm the new {@code Scm} to use
     * @return a {@code Model} with the specified scm
     */
    @Nonnull
    public Model withScm(Scm scm) {
        return newBuilder(this, true).scm(scm).build();
    }
    /**
     * Creates a new {@code Model} instance using the specified issueManagement.
     *
     * @param issueManagement the new {@code IssueManagement} to use
     * @return a {@code Model} with the specified issueManagement
     */
    @Nonnull
    public Model withIssueManagement(IssueManagement issueManagement) {
        return newBuilder(this, true).issueManagement(issueManagement).build();
    }
    /**
     * Creates a new {@code Model} instance using the specified ciManagement.
     *
     * @param ciManagement the new {@code CiManagement} to use
     * @return a {@code Model} with the specified ciManagement
     */
    @Nonnull
    public Model withCiManagement(CiManagement ciManagement) {
        return newBuilder(this, true).ciManagement(ciManagement).build();
    }
    /**
     * Creates a new {@code Model} instance using the specified build.
     *
     * @param build the new {@code Build} to use
     * @return a {@code Model} with the specified build
     */
    @Nonnull
    public Model withBuild(Build build) {
        return newBuilder(this, true).build(build).build();
    }
    /**
     * Creates a new {@code Model} instance using the specified profiles.
     *
     * @param profiles the new {@code Collection<Profile>} to use
     * @return a {@code Model} with the specified profiles
     */
    @Nonnull
    public Model withProfiles(Collection<Profile> profiles) {
        return newBuilder(this, true).profiles(profiles).build();
    }

    /**
     * Creates a new {@code Model} instance.
     * Equivalent to {@code newInstance(true)}.
     * @see #newInstance(boolean)
     *
     * @return a new {@code Model}
     */
    @Nonnull
    public static Model newInstance() {
        return newInstance(true);
    }

    /**
     * Creates a new {@code Model} instance using default values or not.
     * Equivalent to {@code newBuilder(withDefaults).build()}.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Model}
     */
    @Nonnull
    public static Model newInstance(boolean withDefaults) {
        return newBuilder(withDefaults).build();
    }

    /**
     * Creates a new {@code Model} builder instance.
     * Equivalent to {@code newBuilder(true)}.
     * @see #newBuilder(boolean)
     *
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder() {
        return newBuilder(true);
    }

    /**
     * Creates a new {@code Model} builder instance using default values or not.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    /**
     * Creates a new {@code Model} builder instance using the specified object as a basis.
     * Equivalent to {@code newBuilder(from, false)}.
     *
     * @param from the {@code Model} instance to use as a basis
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(Model from) {
        return newBuilder(from, false);
    }

    /**
     * Creates a new {@code Model} builder instance using the specified object as a basis.
     *
     * @param from the {@code Model} instance to use as a basis
     * @param forceCopy the boolean indicating if a copy should be forced
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(Model from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    /**
     * Builder class used to create Model instances.
     * @see #with()
     * @see #newBuilder()
     */
    @NotThreadSafe
    public static class Builder
        extends ModelBase.Builder
    {
        Model base;
        String namespaceUri;
        String modelEncoding;
        Path pomFile;
        String modelVersion;
        Parent parent;
        String groupId;
        String artifactId;
        String version;
        String packaging;
        String name;
        String description;
        String url;
        String childProjectUrlInheritAppendPath;
        Boolean root;
        Boolean preserveModelVersion;
        String inceptionYear;
        Organization organization;
        Collection<License> licenses;
        Collection<Developer> developers;
        Collection<Contributor> contributors;
        Collection<MailingList> mailingLists;
        Prerequisites prerequisites;
        Scm scm;
        IssueManagement issueManagement;
        CiManagement ciManagement;
        Build build;
        Collection<Profile> profiles;

        Builder(boolean withDefaults) {
            super(withDefaults);
            if (withDefaults) {
                this.packaging = "jar";
                this.root = false;
                this.preserveModelVersion = false;
            }
        }

        Builder(Model base, boolean forceCopy) {
            super(base, forceCopy);
            this.namespaceUri = base.namespaceUri;
            this.modelEncoding = base.modelEncoding;
            if (forceCopy) {
                this.pomFile = base.pomFile;
                this.modelVersion = base.modelVersion;
                this.parent = base.parent;
                this.groupId = base.groupId;
                this.artifactId = base.artifactId;
                this.version = base.version;
                this.packaging = base.packaging;
                this.name = base.name;
                this.description = base.description;
                this.url = base.url;
                this.childProjectUrlInheritAppendPath = base.childProjectUrlInheritAppendPath;
                this.root = base.root;
                this.preserveModelVersion = base.preserveModelVersion;
                this.inceptionYear = base.inceptionYear;
                this.organization = base.organization;
                this.licenses = base.licenses;
                this.developers = base.developers;
                this.contributors = base.contributors;
                this.mailingLists = base.mailingLists;
                this.prerequisites = base.prerequisites;
                this.scm = base.scm;
                this.issueManagement = base.issueManagement;
                this.ciManagement = base.ciManagement;
                this.build = base.build;
                this.profiles = base.profiles;
                this.locations = base.locations;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder namespaceUri(String namespaceUri) {
            this.namespaceUri = namespaceUri;
            return this;
        }

        @Nonnull
        public Builder modelEncoding(String modelEncoding) {
            this.modelEncoding = modelEncoding;
            return this;
        }

        @Nonnull
        public Builder modules(Collection<String> modules) {
            this.modules = modules;
            return this;
        }

        @Nonnull
        public Builder distributionManagement(DistributionManagement distributionManagement) {
            this.distributionManagement = distributionManagement;
            return this;
        }

        @Nonnull
        public Builder properties(Map<String, String> properties) {
            this.properties = properties;
            return this;
        }

        @Nonnull
        public Builder dependencyManagement(DependencyManagement dependencyManagement) {
            this.dependencyManagement = dependencyManagement;
            return this;
        }

        @Nonnull
        public Builder dependencies(Collection<Dependency> dependencies) {
            this.dependencies = dependencies;
            return this;
        }

        @Nonnull
        public Builder repositories(Collection<Repository> repositories) {
            this.repositories = repositories;
            return this;
        }

        @Nonnull
        public Builder pluginRepositories(Collection<Repository> pluginRepositories) {
            this.pluginRepositories = pluginRepositories;
            return this;
        }

        @Nonnull
        public Builder reporting(Reporting reporting) {
            this.reporting = reporting;
            return this;
        }

        @Nonnull
        public Builder pomFile(Path pomFile) {
            this.pomFile = pomFile;
            return this;
        }

        @Nonnull
        public Builder modelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
            return this;
        }

        @Nonnull
        public Builder parent(Parent parent) {
            this.parent = parent;
            return this;
        }

        @Nonnull
        public Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        @Nonnull
        public Builder artifactId(String artifactId) {
            this.artifactId = artifactId;
            return this;
        }

        @Nonnull
        public Builder version(String version) {
            this.version = version;
            return this;
        }

        @Nonnull
        public Builder packaging(String packaging) {
            this.packaging = packaging;
            return this;
        }

        @Nonnull
        public Builder name(String name) {
            this.name = name;
            return this;
        }

        @Nonnull
        public Builder description(String description) {
            this.description = description;
            return this;
        }

        @Nonnull
        public Builder url(String url) {
            this.url = url;
            return this;
        }

        @Nonnull
        public Builder childProjectUrlInheritAppendPath(String childProjectUrlInheritAppendPath) {
            this.childProjectUrlInheritAppendPath = childProjectUrlInheritAppendPath;
            return this;
        }

        @Nonnull
        public Builder root(boolean root) {
            this.root = root;
            return this;
        }

        @Nonnull
        public Builder preserveModelVersion(boolean preserveModelVersion) {
            this.preserveModelVersion = preserveModelVersion;
            return this;
        }

        @Nonnull
        public Builder inceptionYear(String inceptionYear) {
            this.inceptionYear = inceptionYear;
            return this;
        }

        @Nonnull
        public Builder organization(Organization organization) {
            this.organization = organization;
            return this;
        }

        @Nonnull
        public Builder licenses(Collection<License> licenses) {
            this.licenses = licenses;
            return this;
        }

        @Nonnull
        public Builder developers(Collection<Developer> developers) {
            this.developers = developers;
            return this;
        }

        @Nonnull
        public Builder contributors(Collection<Contributor> contributors) {
            this.contributors = contributors;
            return this;
        }

        @Nonnull
        public Builder mailingLists(Collection<MailingList> mailingLists) {
            this.mailingLists = mailingLists;
            return this;
        }

        @Nonnull
        public Builder prerequisites(Prerequisites prerequisites) {
            this.prerequisites = prerequisites;
            return this;
        }

        @Nonnull
        public Builder scm(Scm scm) {
            this.scm = scm;
            return this;
        }

        @Nonnull
        public Builder issueManagement(IssueManagement issueManagement) {
            this.issueManagement = issueManagement;
            return this;
        }

        @Nonnull
        public Builder ciManagement(CiManagement ciManagement) {
            this.ciManagement = ciManagement;
            return this;
        }

        @Nonnull
        public Builder build(Build build) {
            this.build = build;
            return this;
        }

        @Nonnull
        public Builder profiles(Collection<Profile> profiles) {
            this.profiles = profiles;
            return this;
        }


        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (!(this.locations instanceof HashMap)) {
                    this.locations = this.locations != null ? new HashMap<>(this.locations) : new HashMap<>();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Nonnull
        public Model build() {
            if (base != null
                    && (modules == null || modules == base.modules)
                    && (distributionManagement == null || distributionManagement == base.distributionManagement)
                    && (properties == null || properties == base.properties)
                    && (dependencyManagement == null || dependencyManagement == base.dependencyManagement)
                    && (dependencies == null || dependencies == base.dependencies)
                    && (repositories == null || repositories == base.repositories)
                    && (pluginRepositories == null || pluginRepositories == base.pluginRepositories)
                    && (reporting == null || reporting == base.reporting)
                    && (pomFile == null || pomFile == base.pomFile)
                    && (modelVersion == null || modelVersion == base.modelVersion)
                    && (parent == null || parent == base.parent)
                    && (groupId == null || groupId == base.groupId)
                    && (artifactId == null || artifactId == base.artifactId)
                    && (version == null || version == base.version)
                    && (packaging == null || packaging == base.packaging)
                    && (name == null || name == base.name)
                    && (description == null || description == base.description)
                    && (url == null || url == base.url)
                    && (childProjectUrlInheritAppendPath == null || childProjectUrlInheritAppendPath == base.childProjectUrlInheritAppendPath)
                    && (root == null || root == base.root)
                    && (preserveModelVersion == null || preserveModelVersion == base.preserveModelVersion)
                    && (inceptionYear == null || inceptionYear == base.inceptionYear)
                    && (organization == null || organization == base.organization)
                    && (licenses == null || licenses == base.licenses)
                    && (developers == null || developers == base.developers)
                    && (contributors == null || contributors == base.contributors)
                    && (mailingLists == null || mailingLists == base.mailingLists)
                    && (prerequisites == null || prerequisites == base.prerequisites)
                    && (scm == null || scm == base.scm)
                    && (issueManagement == null || issueManagement == base.issueManagement)
                    && (ciManagement == null || ciManagement == base.ciManagement)
                    && (build == null || build == base.build)
                    && (profiles == null || profiles == base.profiles)
            ) {
                return base;
            }
            Map<Object, InputLocation> newlocs = this.locations != null ? this.locations : Collections.emptyMap();
            Map<Object, InputLocation> oldlocs = this.base != null && this.base.locations != null ? this.base.locations : Collections.emptyMap();
            Map<Object, InputLocation> locations = new HashMap<>();
            locations.put("", newlocs.containsKey("") ? newlocs.get("") : oldlocs.get(""));
            locations.put("modules", newlocs.containsKey("modules") ? newlocs.get("modules") : oldlocs.get("modules"));
            locations.put("distributionManagement", newlocs.containsKey("distributionManagement") ? newlocs.get("distributionManagement") : oldlocs.get("distributionManagement"));
            locations.put("properties", newlocs.containsKey("properties") ? newlocs.get("properties") : oldlocs.get("properties"));
            locations.put("dependencyManagement", newlocs.containsKey("dependencyManagement") ? newlocs.get("dependencyManagement") : oldlocs.get("dependencyManagement"));
            locations.put("dependencies", newlocs.containsKey("dependencies") ? newlocs.get("dependencies") : oldlocs.get("dependencies"));
            locations.put("repositories", newlocs.containsKey("repositories") ? newlocs.get("repositories") : oldlocs.get("repositories"));
            locations.put("pluginRepositories", newlocs.containsKey("pluginRepositories") ? newlocs.get("pluginRepositories") : oldlocs.get("pluginRepositories"));
            locations.put("reporting", newlocs.containsKey("reporting") ? newlocs.get("reporting") : oldlocs.get("reporting"));
            locations.put("pomFile", newlocs.containsKey("pomFile") ? newlocs.get("pomFile") : oldlocs.get("pomFile"));
            locations.put("modelVersion", newlocs.containsKey("modelVersion") ? newlocs.get("modelVersion") : oldlocs.get("modelVersion"));
            locations.put("parent", newlocs.containsKey("parent") ? newlocs.get("parent") : oldlocs.get("parent"));
            locations.put("groupId", newlocs.containsKey("groupId") ? newlocs.get("groupId") : oldlocs.get("groupId"));
            locations.put("artifactId", newlocs.containsKey("artifactId") ? newlocs.get("artifactId") : oldlocs.get("artifactId"));
            locations.put("version", newlocs.containsKey("version") ? newlocs.get("version") : oldlocs.get("version"));
            locations.put("packaging", newlocs.containsKey("packaging") ? newlocs.get("packaging") : oldlocs.get("packaging"));
            locations.put("name", newlocs.containsKey("name") ? newlocs.get("name") : oldlocs.get("name"));
            locations.put("description", newlocs.containsKey("description") ? newlocs.get("description") : oldlocs.get("description"));
            locations.put("url", newlocs.containsKey("url") ? newlocs.get("url") : oldlocs.get("url"));
            locations.put("childProjectUrlInheritAppendPath", newlocs.containsKey("childProjectUrlInheritAppendPath") ? newlocs.get("childProjectUrlInheritAppendPath") : oldlocs.get("childProjectUrlInheritAppendPath"));
            locations.put("root", newlocs.containsKey("root") ? newlocs.get("root") : oldlocs.get("root"));
            locations.put("preserveModelVersion", newlocs.containsKey("preserveModelVersion") ? newlocs.get("preserveModelVersion") : oldlocs.get("preserveModelVersion"));
            locations.put("inceptionYear", newlocs.containsKey("inceptionYear") ? newlocs.get("inceptionYear") : oldlocs.get("inceptionYear"));
            locations.put("organization", newlocs.containsKey("organization") ? newlocs.get("organization") : oldlocs.get("organization"));
            locations.put("licenses", newlocs.containsKey("licenses") ? newlocs.get("licenses") : oldlocs.get("licenses"));
            locations.put("developers", newlocs.containsKey("developers") ? newlocs.get("developers") : oldlocs.get("developers"));
            locations.put("contributors", newlocs.containsKey("contributors") ? newlocs.get("contributors") : oldlocs.get("contributors"));
            locations.put("mailingLists", newlocs.containsKey("mailingLists") ? newlocs.get("mailingLists") : oldlocs.get("mailingLists"));
            locations.put("prerequisites", newlocs.containsKey("prerequisites") ? newlocs.get("prerequisites") : oldlocs.get("prerequisites"));
            locations.put("scm", newlocs.containsKey("scm") ? newlocs.get("scm") : oldlocs.get("scm"));
            locations.put("issueManagement", newlocs.containsKey("issueManagement") ? newlocs.get("issueManagement") : oldlocs.get("issueManagement"));
            locations.put("ciManagement", newlocs.containsKey("ciManagement") ? newlocs.get("ciManagement") : oldlocs.get("ciManagement"));
            locations.put("build", newlocs.containsKey("build") ? newlocs.get("build") : oldlocs.get("build"));
            locations.put("profiles", newlocs.containsKey("profiles") ? newlocs.get("profiles") : oldlocs.get("profiles"));
            return new Model(
                namespaceUri != null ? namespaceUri : (base != null ? base.namespaceUri : ""),
                modelEncoding != null ? modelEncoding : (base != null ? base.modelEncoding : "UTF-8"),
                modules != null ? modules : (base != null ? base.modules : null),
                distributionManagement != null ? distributionManagement : (base != null ? base.distributionManagement : null),
                properties != null ? properties : (base != null ? base.properties : null),
                dependencyManagement != null ? dependencyManagement : (base != null ? base.dependencyManagement : null),
                dependencies != null ? dependencies : (base != null ? base.dependencies : null),
                repositories != null ? repositories : (base != null ? base.repositories : null),
                pluginRepositories != null ? pluginRepositories : (base != null ? base.pluginRepositories : null),
                reporting != null ? reporting : (base != null ? base.reporting : null),
                pomFile != null ? pomFile : (base != null ? base.pomFile : null),
                modelVersion != null ? modelVersion : (base != null ? base.modelVersion : null),
                parent != null ? parent : (base != null ? base.parent : null),
                groupId != null ? groupId : (base != null ? base.groupId : null),
                artifactId != null ? artifactId : (base != null ? base.artifactId : null),
                version != null ? version : (base != null ? base.version : null),
                packaging != null ? packaging : (base != null ? base.packaging : null),
                name != null ? name : (base != null ? base.name : null),
                description != null ? description : (base != null ? base.description : null),
                url != null ? url : (base != null ? base.url : null),
                childProjectUrlInheritAppendPath != null ? childProjectUrlInheritAppendPath : (base != null ? base.childProjectUrlInheritAppendPath : null),
                root != null ? root : (base != null ? base.root : false),
                preserveModelVersion != null ? preserveModelVersion : (base != null ? base.preserveModelVersion : false),
                inceptionYear != null ? inceptionYear : (base != null ? base.inceptionYear : null),
                organization != null ? organization : (base != null ? base.organization : null),
                licenses != null ? licenses : (base != null ? base.licenses : null),
                developers != null ? developers : (base != null ? base.developers : null),
                contributors != null ? contributors : (base != null ? base.contributors : null),
                mailingLists != null ? mailingLists : (base != null ? base.mailingLists : null),
                prerequisites != null ? prerequisites : (base != null ? base.prerequisites : null),
                scm != null ? scm : (base != null ? base.scm : null),
                issueManagement != null ? issueManagement : (base != null ? base.issueManagement : null),
                ciManagement != null ? ciManagement : (base != null ? base.ciManagement : null),
                build != null ? build : (base != null ? base.build : null),
                profiles != null ? profiles : (base != null ? base.profiles : null),
                locations
            );
        }
    }


            
    /**
     * Gets the base directory for the corresponding project (if any).
     *
     * @return The base directory for the corresponding project or {@code null} if this model does not belong to a local
     *         project (e.g. describes the metadata of some artifact from the repository).
     */
    public Path getProjectDirectory()
    {
        return ( pomFile != null ) ? pomFile.getParent() : null;
    }

    /**
     * @return the model id as {@code groupId:artifactId:packaging:version}
     */
    public String getId()
    {
        StringBuilder id = new StringBuilder( 64 );

        id.append( ( getGroupId() == null ) ? "[inherited]" : getGroupId() );
        id.append( ":" );
        id.append( getArtifactId() );
        id.append( ":" );
        id.append( getPackaging() );
        id.append( ":" );
        id.append( ( getVersion() == null ) ? "[inherited]" : getVersion() );

        return id.toString();
    }

    @Override
    public String toString()
    {
        return getId();
    }

    public boolean isChildProjectUrlInheritAppendPath()
    {
        return ( getChildProjectUrlInheritAppendPath() != null ) ? Boolean.parseBoolean( getChildProjectUrlInheritAppendPath() ) : true;
    }

            
          
}
