// =================== DO NOT EDIT THIS FILE ====================
//  Generated by Modello Velocity from model.vm
//  template, any modifications will be overwritten.
// ==============================================================
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;

/**
 * Description of a person who has contributed to the project, but who does not have
 * commit privileges. Usually, these contributions come in the form of patches submitted.
 */
@Experimental
@Generated @ThreadSafe @Immutable
public class Contributor
    implements Serializable, InputLocationTracker
{
    /**
     * The full name of the contributor.
     */
    final String name;
    /**
     * The email address of the contributor.
     */
    final String email;
    /**
     * The URL for the homepage of the contributor.
     */
    final String url;
    /**
     * The organization to which the contributor belongs.
     */
    final String organization;
    /**
     * The URL of the organization.
     */
    final String organizationUrl;
    /**
     * The roles the contributor plays in the project. Each role is described by a
     * {@code role} element, the body of which is a role name. This can also be used to
     * describe the contribution.
     */
    final List<String> roles;
    /**
     * The timezone the contributor is in. Typically, this is a number in the range
     * <a href="http://en.wikipedia.org/wiki/UTC%E2%88%9212:00">-12</a> to <a href="http://en.wikipedia.org/wiki/UTC%2B14:00">+14</a>
     * or a valid time zone id like "America/Montreal" (UTC-05:00) or "Europe/Paris" (UTC+01:00).
     */
    final String timezone;
    /**
     * Properties about the contributor, such as an instant messenger handle.
     */
    final Map<String, String> properties;
    /** Locations */
    final Map<Object, InputLocation> locations;

    /**
      * Constructor for this class, package protected.
      * @see Builder#build()
      */
    Contributor(
        String name,
        String email,
        String url,
        String organization,
        String organizationUrl,
        Collection<String> roles,
        String timezone,
        Map<String, String> properties,
        Map<Object, InputLocation> locations
    ) {
        this.name = name;
        this.email = email;
        this.url = url;
        this.organization = organization;
        this.organizationUrl = organizationUrl;
        this.roles = ImmutableCollections.copy(roles);
        this.timezone = timezone;
        this.properties = ImmutableCollections.copy(properties);
        this.locations = ImmutableCollections.copy(locations);
    }

    /**
     * The full name of the contributor.
     *
     * @return a {@code String}
     */
    public String getName() {
        return this.name;
    }

    /**
     * The email address of the contributor.
     *
     * @return a {@code String}
     */
    public String getEmail() {
        return this.email;
    }

    /**
     * The URL for the homepage of the contributor.
     *
     * @return a {@code String}
     */
    public String getUrl() {
        return this.url;
    }

    /**
     * The organization to which the contributor belongs.
     *
     * @return a {@code String}
     */
    public String getOrganization() {
        return this.organization;
    }

    /**
     * The URL of the organization.
     *
     * @return a {@code String}
     */
    public String getOrganizationUrl() {
        return this.organizationUrl;
    }

    /**
     * The roles the contributor plays in the project. Each role is described by a
     * {@code role} element, the body of which is a role name. This can also be used to
     * describe the contribution.
     *
     * @return a {@code List<String>}
     */
    @Nonnull
    public List<String> getRoles() {
        return this.roles;
    }

    /**
     * The timezone the contributor is in. Typically, this is a number in the range
     * <a href="http://en.wikipedia.org/wiki/UTC%E2%88%9212:00">-12</a> to <a href="http://en.wikipedia.org/wiki/UTC%2B14:00">+14</a>
     * or a valid time zone id like "America/Montreal" (UTC-05:00) or "Europe/Paris" (UTC+01:00).
     *
     * @return a {@code String}
     */
    public String getTimezone() {
        return this.timezone;
    }

    /**
     * Properties about the contributor, such as an instant messenger handle.
     *
     * @return a {@code Map<String, String>}
     */
    @Nonnull
    public Map<String, String> getProperties() {
        return this.properties;
    }

    /**
     * Gets the location of the specified field in the input source.
     */
    public InputLocation getLocation(Object key) {
        return locations != null ? locations.get(key) : null;
    }

    /**
     * Creates a new builder with this object as the basis.
     *
     * @return a {@code Builder}
     */
    @Nonnull
    public Builder with() {
        return newBuilder(this);
    }
    /**
     * Creates a new {@code Contributor} instance using the specified name.
     *
     * @param name the new {@code String} to use
     * @return a {@code Contributor} with the specified name
     */
    @Nonnull
    public Contributor withName(String name) {
        return newBuilder(this, true).name(name).build();
    }
    /**
     * Creates a new {@code Contributor} instance using the specified email.
     *
     * @param email the new {@code String} to use
     * @return a {@code Contributor} with the specified email
     */
    @Nonnull
    public Contributor withEmail(String email) {
        return newBuilder(this, true).email(email).build();
    }
    /**
     * Creates a new {@code Contributor} instance using the specified url.
     *
     * @param url the new {@code String} to use
     * @return a {@code Contributor} with the specified url
     */
    @Nonnull
    public Contributor withUrl(String url) {
        return newBuilder(this, true).url(url).build();
    }
    /**
     * Creates a new {@code Contributor} instance using the specified organization.
     *
     * @param organization the new {@code String} to use
     * @return a {@code Contributor} with the specified organization
     */
    @Nonnull
    public Contributor withOrganization(String organization) {
        return newBuilder(this, true).organization(organization).build();
    }
    /**
     * Creates a new {@code Contributor} instance using the specified organizationUrl.
     *
     * @param organizationUrl the new {@code String} to use
     * @return a {@code Contributor} with the specified organizationUrl
     */
    @Nonnull
    public Contributor withOrganizationUrl(String organizationUrl) {
        return newBuilder(this, true).organizationUrl(organizationUrl).build();
    }
    /**
     * Creates a new {@code Contributor} instance using the specified roles.
     *
     * @param roles the new {@code Collection<String>} to use
     * @return a {@code Contributor} with the specified roles
     */
    @Nonnull
    public Contributor withRoles(Collection<String> roles) {
        return newBuilder(this, true).roles(roles).build();
    }
    /**
     * Creates a new {@code Contributor} instance using the specified timezone.
     *
     * @param timezone the new {@code String} to use
     * @return a {@code Contributor} with the specified timezone
     */
    @Nonnull
    public Contributor withTimezone(String timezone) {
        return newBuilder(this, true).timezone(timezone).build();
    }
    /**
     * Creates a new {@code Contributor} instance using the specified properties.
     *
     * @param properties the new {@code Map<String, String>} to use
     * @return a {@code Contributor} with the specified properties
     */
    @Nonnull
    public Contributor withProperties(Map<String, String> properties) {
        return newBuilder(this, true).properties(properties).build();
    }

    /**
     * Creates a new {@code Contributor} instance.
     * Equivalent to {@code newInstance(true)}.
     * @see #newInstance(boolean)
     *
     * @return a new {@code Contributor}
     */
    @Nonnull
    public static Contributor newInstance() {
        return newInstance(true);
    }

    /**
     * Creates a new {@code Contributor} instance using default values or not.
     * Equivalent to {@code newBuilder(withDefaults).build()}.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Contributor}
     */
    @Nonnull
    public static Contributor newInstance(boolean withDefaults) {
        return newBuilder(withDefaults).build();
    }

    /**
     * Creates a new {@code Contributor} builder instance.
     * Equivalent to {@code newBuilder(true)}.
     * @see #newBuilder(boolean)
     *
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder() {
        return newBuilder(true);
    }

    /**
     * Creates a new {@code Contributor} builder instance using default values or not.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    /**
     * Creates a new {@code Contributor} builder instance using the specified object as a basis.
     * Equivalent to {@code newBuilder(from, false)}.
     *
     * @param from the {@code Contributor} instance to use as a basis
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(Contributor from) {
        return newBuilder(from, false);
    }

    /**
     * Creates a new {@code Contributor} builder instance using the specified object as a basis.
     *
     * @param from the {@code Contributor} instance to use as a basis
     * @param forceCopy the boolean indicating if a copy should be forced
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(Contributor from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    /**
     * Builder class used to create Contributor instances.
     * @see #with()
     * @see #newBuilder()
     */
    @NotThreadSafe
    public static class Builder
    {
        Contributor base;
        String name;
        String email;
        String url;
        String organization;
        String organizationUrl;
        Collection<String> roles;
        String timezone;
        Map<String, String> properties;
        Map<Object, InputLocation> locations;

        Builder(boolean withDefaults) {
            if (withDefaults) {
            }
        }

        Builder(Contributor base, boolean forceCopy) {
            if (forceCopy) {
                this.name = base.name;
                this.email = base.email;
                this.url = base.url;
                this.organization = base.organization;
                this.organizationUrl = base.organizationUrl;
                this.roles = base.roles;
                this.timezone = base.timezone;
                this.properties = base.properties;
                this.locations = base.locations;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder name(String name) {
            this.name = name;
            return this;
        }

        @Nonnull
        public Builder email(String email) {
            this.email = email;
            return this;
        }

        @Nonnull
        public Builder url(String url) {
            this.url = url;
            return this;
        }

        @Nonnull
        public Builder organization(String organization) {
            this.organization = organization;
            return this;
        }

        @Nonnull
        public Builder organizationUrl(String organizationUrl) {
            this.organizationUrl = organizationUrl;
            return this;
        }

        @Nonnull
        public Builder roles(Collection<String> roles) {
            this.roles = roles;
            return this;
        }

        @Nonnull
        public Builder timezone(String timezone) {
            this.timezone = timezone;
            return this;
        }

        @Nonnull
        public Builder properties(Map<String, String> properties) {
            this.properties = properties;
            return this;
        }


        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (!(this.locations instanceof HashMap)) {
                    this.locations = this.locations != null ? new HashMap<>(this.locations) : new HashMap<>();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Nonnull
        public Contributor build() {
            if (base != null
                    && (name == null || name == base.name)
                    && (email == null || email == base.email)
                    && (url == null || url == base.url)
                    && (organization == null || organization == base.organization)
                    && (organizationUrl == null || organizationUrl == base.organizationUrl)
                    && (roles == null || roles == base.roles)
                    && (timezone == null || timezone == base.timezone)
                    && (properties == null || properties == base.properties)
            ) {
                return base;
            }
            Map<Object, InputLocation> newlocs = this.locations != null ? this.locations : Collections.emptyMap();
            Map<Object, InputLocation> oldlocs = this.base != null && this.base.locations != null ? this.base.locations : Collections.emptyMap();
            Map<Object, InputLocation> locations = new HashMap<>();
            locations.put("", newlocs.containsKey("") ? newlocs.get("") : oldlocs.get(""));
            locations.put("name", newlocs.containsKey("name") ? newlocs.get("name") : oldlocs.get("name"));
            locations.put("email", newlocs.containsKey("email") ? newlocs.get("email") : oldlocs.get("email"));
            locations.put("url", newlocs.containsKey("url") ? newlocs.get("url") : oldlocs.get("url"));
            locations.put("organization", newlocs.containsKey("organization") ? newlocs.get("organization") : oldlocs.get("organization"));
            locations.put("organizationUrl", newlocs.containsKey("organizationUrl") ? newlocs.get("organizationUrl") : oldlocs.get("organizationUrl"));
            locations.put("roles", newlocs.containsKey("roles") ? newlocs.get("roles") : oldlocs.get("roles"));
            locations.put("timezone", newlocs.containsKey("timezone") ? newlocs.get("timezone") : oldlocs.get("timezone"));
            locations.put("properties", newlocs.containsKey("properties") ? newlocs.get("properties") : oldlocs.get("properties"));
            return new Contributor(
                name != null ? name : (base != null ? base.name : null),
                email != null ? email : (base != null ? base.email : null),
                url != null ? url : (base != null ? base.url : null),
                organization != null ? organization : (base != null ? base.organization : null),
                organizationUrl != null ? organizationUrl : (base != null ? base.organizationUrl : null),
                roles != null ? roles : (base != null ? base.roles : null),
                timezone != null ? timezone : (base != null ? base.timezone : null),
                properties != null ? properties : (base != null ? base.properties : null),
                locations
            );
        }
    }


            
    /**
     * @see java.lang.Object#toString()
     */
    public String toString()
    {
        return "Contributor {name=" + getName() + ", email=" + getEmail() + "}";
    }
            
          
}
