// =================== DO NOT EDIT THIS FILE ====================
//  Generated by Modello Velocity from model.vm
//  template, any modifications will be overwritten.
// ==============================================================
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;

/**
 * The {@code <build>} element contains informations required to build the project.
 * Default values are defined in Super POM.
 */
@Experimental
@Generated @ThreadSafe @Immutable
public class Build
    extends BuildBase
    implements Serializable, InputLocationTracker
{
    /**
     * This element specifies a directory containing the source of the project. The
     * generated build system will compile the sources from this directory when the project is
     * built. The path given is relative to the project descriptor.
     * The default value is {@code src/main/java}.
     */
    final String sourceDirectory;
    /**
     * This element specifies a directory containing the script sources of the
     * project. This directory is meant to be different from the sourceDirectory, in that its
     * contents will be copied to the output directory in most cases (since scripts are
     * interpreted rather than compiled).
     * The default value is {@code src/main/scripts}.
     */
    final String scriptSourceDirectory;
    /**
     * This element specifies a directory containing the unit test source of the
     * project. The generated build system will compile these directories when the project is
     * being tested. The path given is relative to the project descriptor.
     * The default value is {@code src/test/java}.
     */
    final String testSourceDirectory;
    /**
     * The directory where compiled application classes are placed.
     * The default value is {@code target/classes}.
     */
    final String outputDirectory;
    /**
     * The directory where compiled test classes are placed.
     * The default value is {@code target/test-classes}.
     */
    final String testOutputDirectory;
    /**
     * A set of build extensions to use from this project.
     */
    final List<Extension> extensions;

    /**
      * Constructor for this class, package protected.
      * @see Builder#build()
      */
    Build(
        Collection<Plugin> plugins,
        PluginManagement pluginManagement,
        String defaultGoal,
        Collection<Resource> resources,
        Collection<Resource> testResources,
        String directory,
        String finalName,
        Collection<String> filters,
        String sourceDirectory,
        String scriptSourceDirectory,
        String testSourceDirectory,
        String outputDirectory,
        String testOutputDirectory,
        Collection<Extension> extensions,
        Map<Object, InputLocation> locations
    ) {
        super(
            plugins,
            pluginManagement,
            defaultGoal,
            resources,
            testResources,
            directory,
            finalName,
            filters,
            locations
        );
        this.sourceDirectory = sourceDirectory;
        this.scriptSourceDirectory = scriptSourceDirectory;
        this.testSourceDirectory = testSourceDirectory;
        this.outputDirectory = outputDirectory;
        this.testOutputDirectory = testOutputDirectory;
        this.extensions = ImmutableCollections.copy(extensions);
    }

    /**
     * This element specifies a directory containing the source of the project. The
     * generated build system will compile the sources from this directory when the project is
     * built. The path given is relative to the project descriptor.
     * The default value is {@code src/main/java}.
     *
     * @return a {@code String}
     */
    public String getSourceDirectory() {
        return this.sourceDirectory;
    }

    /**
     * This element specifies a directory containing the script sources of the
     * project. This directory is meant to be different from the sourceDirectory, in that its
     * contents will be copied to the output directory in most cases (since scripts are
     * interpreted rather than compiled).
     * The default value is {@code src/main/scripts}.
     *
     * @return a {@code String}
     */
    public String getScriptSourceDirectory() {
        return this.scriptSourceDirectory;
    }

    /**
     * This element specifies a directory containing the unit test source of the
     * project. The generated build system will compile these directories when the project is
     * being tested. The path given is relative to the project descriptor.
     * The default value is {@code src/test/java}.
     *
     * @return a {@code String}
     */
    public String getTestSourceDirectory() {
        return this.testSourceDirectory;
    }

    /**
     * The directory where compiled application classes are placed.
     * The default value is {@code target/classes}.
     *
     * @return a {@code String}
     */
    public String getOutputDirectory() {
        return this.outputDirectory;
    }

    /**
     * The directory where compiled test classes are placed.
     * The default value is {@code target/test-classes}.
     *
     * @return a {@code String}
     */
    public String getTestOutputDirectory() {
        return this.testOutputDirectory;
    }

    /**
     * A set of build extensions to use from this project.
     *
     * @return a {@code List<Extension>}
     */
    @Nonnull
    public List<Extension> getExtensions() {
        return this.extensions;
    }

    /**
     * Creates a new builder with this object as the basis.
     *
     * @return a {@code Builder}
     */
    @Nonnull
    public Builder with() {
        return newBuilder(this);
    }
    /**
     * Creates a new {@code Build} instance using the specified plugins.
     *
     * @param plugins the new {@code Collection<Plugin>} to use
     * @return a {@code Build} with the specified plugins
     */
    @Nonnull
    public Build withPlugins(Collection<Plugin> plugins) {
        return newBuilder(this, true).plugins(plugins).build();
    }
    /**
     * Creates a new {@code Build} instance using the specified pluginManagement.
     *
     * @param pluginManagement the new {@code PluginManagement} to use
     * @return a {@code Build} with the specified pluginManagement
     */
    @Nonnull
    public Build withPluginManagement(PluginManagement pluginManagement) {
        return newBuilder(this, true).pluginManagement(pluginManagement).build();
    }
    /**
     * Creates a new {@code Build} instance using the specified defaultGoal.
     *
     * @param defaultGoal the new {@code String} to use
     * @return a {@code Build} with the specified defaultGoal
     */
    @Nonnull
    public Build withDefaultGoal(String defaultGoal) {
        return newBuilder(this, true).defaultGoal(defaultGoal).build();
    }
    /**
     * Creates a new {@code Build} instance using the specified resources.
     *
     * @param resources the new {@code Collection<Resource>} to use
     * @return a {@code Build} with the specified resources
     */
    @Nonnull
    public Build withResources(Collection<Resource> resources) {
        return newBuilder(this, true).resources(resources).build();
    }
    /**
     * Creates a new {@code Build} instance using the specified testResources.
     *
     * @param testResources the new {@code Collection<Resource>} to use
     * @return a {@code Build} with the specified testResources
     */
    @Nonnull
    public Build withTestResources(Collection<Resource> testResources) {
        return newBuilder(this, true).testResources(testResources).build();
    }
    /**
     * Creates a new {@code Build} instance using the specified directory.
     *
     * @param directory the new {@code String} to use
     * @return a {@code Build} with the specified directory
     */
    @Nonnull
    public Build withDirectory(String directory) {
        return newBuilder(this, true).directory(directory).build();
    }
    /**
     * Creates a new {@code Build} instance using the specified finalName.
     *
     * @param finalName the new {@code String} to use
     * @return a {@code Build} with the specified finalName
     */
    @Nonnull
    public Build withFinalName(String finalName) {
        return newBuilder(this, true).finalName(finalName).build();
    }
    /**
     * Creates a new {@code Build} instance using the specified filters.
     *
     * @param filters the new {@code Collection<String>} to use
     * @return a {@code Build} with the specified filters
     */
    @Nonnull
    public Build withFilters(Collection<String> filters) {
        return newBuilder(this, true).filters(filters).build();
    }
    /**
     * Creates a new {@code Build} instance using the specified sourceDirectory.
     *
     * @param sourceDirectory the new {@code String} to use
     * @return a {@code Build} with the specified sourceDirectory
     */
    @Nonnull
    public Build withSourceDirectory(String sourceDirectory) {
        return newBuilder(this, true).sourceDirectory(sourceDirectory).build();
    }
    /**
     * Creates a new {@code Build} instance using the specified scriptSourceDirectory.
     *
     * @param scriptSourceDirectory the new {@code String} to use
     * @return a {@code Build} with the specified scriptSourceDirectory
     */
    @Nonnull
    public Build withScriptSourceDirectory(String scriptSourceDirectory) {
        return newBuilder(this, true).scriptSourceDirectory(scriptSourceDirectory).build();
    }
    /**
     * Creates a new {@code Build} instance using the specified testSourceDirectory.
     *
     * @param testSourceDirectory the new {@code String} to use
     * @return a {@code Build} with the specified testSourceDirectory
     */
    @Nonnull
    public Build withTestSourceDirectory(String testSourceDirectory) {
        return newBuilder(this, true).testSourceDirectory(testSourceDirectory).build();
    }
    /**
     * Creates a new {@code Build} instance using the specified outputDirectory.
     *
     * @param outputDirectory the new {@code String} to use
     * @return a {@code Build} with the specified outputDirectory
     */
    @Nonnull
    public Build withOutputDirectory(String outputDirectory) {
        return newBuilder(this, true).outputDirectory(outputDirectory).build();
    }
    /**
     * Creates a new {@code Build} instance using the specified testOutputDirectory.
     *
     * @param testOutputDirectory the new {@code String} to use
     * @return a {@code Build} with the specified testOutputDirectory
     */
    @Nonnull
    public Build withTestOutputDirectory(String testOutputDirectory) {
        return newBuilder(this, true).testOutputDirectory(testOutputDirectory).build();
    }
    /**
     * Creates a new {@code Build} instance using the specified extensions.
     *
     * @param extensions the new {@code Collection<Extension>} to use
     * @return a {@code Build} with the specified extensions
     */
    @Nonnull
    public Build withExtensions(Collection<Extension> extensions) {
        return newBuilder(this, true).extensions(extensions).build();
    }

    /**
     * Creates a new {@code Build} instance.
     * Equivalent to {@code newInstance(true)}.
     * @see #newInstance(boolean)
     *
     * @return a new {@code Build}
     */
    @Nonnull
    public static Build newInstance() {
        return newInstance(true);
    }

    /**
     * Creates a new {@code Build} instance using default values or not.
     * Equivalent to {@code newBuilder(withDefaults).build()}.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Build}
     */
    @Nonnull
    public static Build newInstance(boolean withDefaults) {
        return newBuilder(withDefaults).build();
    }

    /**
     * Creates a new {@code Build} builder instance.
     * Equivalent to {@code newBuilder(true)}.
     * @see #newBuilder(boolean)
     *
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder() {
        return newBuilder(true);
    }

    /**
     * Creates a new {@code Build} builder instance using default values or not.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    /**
     * Creates a new {@code Build} builder instance using the specified object as a basis.
     * Equivalent to {@code newBuilder(from, false)}.
     *
     * @param from the {@code Build} instance to use as a basis
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(Build from) {
        return newBuilder(from, false);
    }

    /**
     * Creates a new {@code Build} builder instance using the specified object as a basis.
     *
     * @param from the {@code Build} instance to use as a basis
     * @param forceCopy the boolean indicating if a copy should be forced
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(Build from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    /**
     * Builder class used to create Build instances.
     * @see #with()
     * @see #newBuilder()
     */
    @NotThreadSafe
    public static class Builder
        extends BuildBase.Builder
    {
        Build base;
        String sourceDirectory;
        String scriptSourceDirectory;
        String testSourceDirectory;
        String outputDirectory;
        String testOutputDirectory;
        Collection<Extension> extensions;

        Builder(boolean withDefaults) {
            super(withDefaults);
            if (withDefaults) {
            }
        }

        Builder(Build base, boolean forceCopy) {
            super(base, forceCopy);
            if (forceCopy) {
                this.sourceDirectory = base.sourceDirectory;
                this.scriptSourceDirectory = base.scriptSourceDirectory;
                this.testSourceDirectory = base.testSourceDirectory;
                this.outputDirectory = base.outputDirectory;
                this.testOutputDirectory = base.testOutputDirectory;
                this.extensions = base.extensions;
                this.locations = base.locations;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder plugins(Collection<Plugin> plugins) {
            this.plugins = plugins;
            return this;
        }

        @Nonnull
        public Builder pluginManagement(PluginManagement pluginManagement) {
            this.pluginManagement = pluginManagement;
            return this;
        }

        @Nonnull
        public Builder defaultGoal(String defaultGoal) {
            this.defaultGoal = defaultGoal;
            return this;
        }

        @Nonnull
        public Builder resources(Collection<Resource> resources) {
            this.resources = resources;
            return this;
        }

        @Nonnull
        public Builder testResources(Collection<Resource> testResources) {
            this.testResources = testResources;
            return this;
        }

        @Nonnull
        public Builder directory(String directory) {
            this.directory = directory;
            return this;
        }

        @Nonnull
        public Builder finalName(String finalName) {
            this.finalName = finalName;
            return this;
        }

        @Nonnull
        public Builder filters(Collection<String> filters) {
            this.filters = filters;
            return this;
        }

        @Nonnull
        public Builder sourceDirectory(String sourceDirectory) {
            this.sourceDirectory = sourceDirectory;
            return this;
        }

        @Nonnull
        public Builder scriptSourceDirectory(String scriptSourceDirectory) {
            this.scriptSourceDirectory = scriptSourceDirectory;
            return this;
        }

        @Nonnull
        public Builder testSourceDirectory(String testSourceDirectory) {
            this.testSourceDirectory = testSourceDirectory;
            return this;
        }

        @Nonnull
        public Builder outputDirectory(String outputDirectory) {
            this.outputDirectory = outputDirectory;
            return this;
        }

        @Nonnull
        public Builder testOutputDirectory(String testOutputDirectory) {
            this.testOutputDirectory = testOutputDirectory;
            return this;
        }

        @Nonnull
        public Builder extensions(Collection<Extension> extensions) {
            this.extensions = extensions;
            return this;
        }


        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (!(this.locations instanceof HashMap)) {
                    this.locations = this.locations != null ? new HashMap<>(this.locations) : new HashMap<>();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Nonnull
        public Build build() {
            if (base != null
                    && (plugins == null || plugins == base.plugins)
                    && (pluginManagement == null || pluginManagement == base.pluginManagement)
                    && (defaultGoal == null || defaultGoal == base.defaultGoal)
                    && (resources == null || resources == base.resources)
                    && (testResources == null || testResources == base.testResources)
                    && (directory == null || directory == base.directory)
                    && (finalName == null || finalName == base.finalName)
                    && (filters == null || filters == base.filters)
                    && (sourceDirectory == null || sourceDirectory == base.sourceDirectory)
                    && (scriptSourceDirectory == null || scriptSourceDirectory == base.scriptSourceDirectory)
                    && (testSourceDirectory == null || testSourceDirectory == base.testSourceDirectory)
                    && (outputDirectory == null || outputDirectory == base.outputDirectory)
                    && (testOutputDirectory == null || testOutputDirectory == base.testOutputDirectory)
                    && (extensions == null || extensions == base.extensions)
            ) {
                return base;
            }
            Map<Object, InputLocation> newlocs = this.locations != null ? this.locations : Collections.emptyMap();
            Map<Object, InputLocation> oldlocs = this.base != null && this.base.locations != null ? this.base.locations : Collections.emptyMap();
            Map<Object, InputLocation> locations = new HashMap<>();
            locations.put("", newlocs.containsKey("") ? newlocs.get("") : oldlocs.get(""));
            locations.put("plugins", newlocs.containsKey("plugins") ? newlocs.get("plugins") : oldlocs.get("plugins"));
            locations.put("pluginManagement", newlocs.containsKey("pluginManagement") ? newlocs.get("pluginManagement") : oldlocs.get("pluginManagement"));
            locations.put("defaultGoal", newlocs.containsKey("defaultGoal") ? newlocs.get("defaultGoal") : oldlocs.get("defaultGoal"));
            locations.put("resources", newlocs.containsKey("resources") ? newlocs.get("resources") : oldlocs.get("resources"));
            locations.put("testResources", newlocs.containsKey("testResources") ? newlocs.get("testResources") : oldlocs.get("testResources"));
            locations.put("directory", newlocs.containsKey("directory") ? newlocs.get("directory") : oldlocs.get("directory"));
            locations.put("finalName", newlocs.containsKey("finalName") ? newlocs.get("finalName") : oldlocs.get("finalName"));
            locations.put("filters", newlocs.containsKey("filters") ? newlocs.get("filters") : oldlocs.get("filters"));
            locations.put("sourceDirectory", newlocs.containsKey("sourceDirectory") ? newlocs.get("sourceDirectory") : oldlocs.get("sourceDirectory"));
            locations.put("scriptSourceDirectory", newlocs.containsKey("scriptSourceDirectory") ? newlocs.get("scriptSourceDirectory") : oldlocs.get("scriptSourceDirectory"));
            locations.put("testSourceDirectory", newlocs.containsKey("testSourceDirectory") ? newlocs.get("testSourceDirectory") : oldlocs.get("testSourceDirectory"));
            locations.put("outputDirectory", newlocs.containsKey("outputDirectory") ? newlocs.get("outputDirectory") : oldlocs.get("outputDirectory"));
            locations.put("testOutputDirectory", newlocs.containsKey("testOutputDirectory") ? newlocs.get("testOutputDirectory") : oldlocs.get("testOutputDirectory"));
            locations.put("extensions", newlocs.containsKey("extensions") ? newlocs.get("extensions") : oldlocs.get("extensions"));
            return new Build(
                plugins != null ? plugins : (base != null ? base.plugins : null),
                pluginManagement != null ? pluginManagement : (base != null ? base.pluginManagement : null),
                defaultGoal != null ? defaultGoal : (base != null ? base.defaultGoal : null),
                resources != null ? resources : (base != null ? base.resources : null),
                testResources != null ? testResources : (base != null ? base.testResources : null),
                directory != null ? directory : (base != null ? base.directory : null),
                finalName != null ? finalName : (base != null ? base.finalName : null),
                filters != null ? filters : (base != null ? base.filters : null),
                sourceDirectory != null ? sourceDirectory : (base != null ? base.sourceDirectory : null),
                scriptSourceDirectory != null ? scriptSourceDirectory : (base != null ? base.scriptSourceDirectory : null),
                testSourceDirectory != null ? testSourceDirectory : (base != null ? base.testSourceDirectory : null),
                outputDirectory != null ? outputDirectory : (base != null ? base.outputDirectory : null),
                testOutputDirectory != null ? testOutputDirectory : (base != null ? base.testOutputDirectory : null),
                extensions != null ? extensions : (base != null ? base.extensions : null),
                locations
            );
        }
    }


            
    /**
     * @see java.lang.Object#toString()
     */
    public String toString()
    {
        return "Build {" + super.toString() + "}";
    }
            
          
}
