// =================== DO NOT EDIT THIS FILE ====================
//  Generated by Modello Velocity from model.vm
//  template, any modifications will be overwritten.
// ==============================================================
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;

/**
 * The {@code <scm>} element contains informations required to the SCM
 * (Source Control Management) of the project.
 */
@Experimental
@Generated @ThreadSafe @Immutable
public class Scm
    implements Serializable, InputLocationTracker
{
    /**
     * The source control management system URL
     * that describes the repository and how to connect to the
     * repository. For more information, see the
     * <a href="https://maven.apache.org/scm/scm-url-format.html">URL format</a>
     * and <a href="https://maven.apache.org/scm/scms-overview.html">list of supported SCMs</a>.
     * This connection is read-only.
     * <br><b>Default value is</b>: parent value [+ path adjustment] + (artifactId or project.directory property), or just parent value if
     * scm's {@code child.scm.connection.inherit.append.path="false"}
     */
    final String connection;
    /**
     * Just like {@code connection}, but for developers, i.e. this scm connection
     * will not be read only.
     * <br><b>Default value is</b>: parent value [+ path adjustment] + (artifactId or project.directory property), or just parent value if
     * scm's {@code child.scm.developerConnection.inherit.append.path="false"}
     */
    final String developerConnection;
    /**
     * The tag of current code. By default, it's set to HEAD during development.
     */
    final String tag;
    /**
     * The URL to the project's browsable SCM repository, such as ViewVC or Fisheye.
     * <br><b>Default value is</b>: parent value [+ path adjustment] + (artifactId or project.directory property), or just parent value if
     * scm's {@code child.scm.url.inherit.append.path="false"}
     */
    final String url;
    /**
     * When children inherit from scm connection, append path or not? Note: While the type
     * of this field is {@code String} for technical reasons, the semantic type is actually
     * {@code Boolean}
     * <br><b>Default value is</b>: {@code true}
     * <br><b>Since</b>: Maven 3.6.1
     */
    final String childScmConnectionInheritAppendPath;
    /**
     * When children inherit from scm developer connection, append path or not? Note: While the type
     * of this field is {@code String} for technical reasons, the semantic type is actually
     * {@code Boolean}
     * <br><b>Default value is</b>: {@code true}
     * <br><b>Since</b>: Maven 3.6.1
     */
    final String childScmDeveloperConnectionInheritAppendPath;
    /**
     * When children inherit from scm url, append path or not? Note: While the type
     * of this field is {@code String} for technical reasons, the semantic type is actually
     * {@code Boolean}
     * <br><b>Default value is</b>: {@code true}
     * <br><b>Since</b>: Maven 3.6.1
     */
    final String childScmUrlInheritAppendPath;
    /** Locations */
    final Map<Object, InputLocation> locations;

    /**
      * Constructor for this class, package protected.
      * @see Builder#build()
      */
    Scm(
        String connection,
        String developerConnection,
        String tag,
        String url,
        String childScmConnectionInheritAppendPath,
        String childScmDeveloperConnectionInheritAppendPath,
        String childScmUrlInheritAppendPath,
        Map<Object, InputLocation> locations
    ) {
        this.connection = connection;
        this.developerConnection = developerConnection;
        this.tag = tag;
        this.url = url;
        this.childScmConnectionInheritAppendPath = childScmConnectionInheritAppendPath;
        this.childScmDeveloperConnectionInheritAppendPath = childScmDeveloperConnectionInheritAppendPath;
        this.childScmUrlInheritAppendPath = childScmUrlInheritAppendPath;
        this.locations = ImmutableCollections.copy(locations);
    }

    /**
     * The source control management system URL
     * that describes the repository and how to connect to the
     * repository. For more information, see the
     * <a href="https://maven.apache.org/scm/scm-url-format.html">URL format</a>
     * and <a href="https://maven.apache.org/scm/scms-overview.html">list of supported SCMs</a>.
     * This connection is read-only.
     * <br><b>Default value is</b>: parent value [+ path adjustment] + (artifactId or project.directory property), or just parent value if
     * scm's {@code child.scm.connection.inherit.append.path="false"}
     *
     * @return a {@code String}
     */
    public String getConnection() {
        return this.connection;
    }

    /**
     * Just like {@code connection}, but for developers, i.e. this scm connection
     * will not be read only.
     * <br><b>Default value is</b>: parent value [+ path adjustment] + (artifactId or project.directory property), or just parent value if
     * scm's {@code child.scm.developerConnection.inherit.append.path="false"}
     *
     * @return a {@code String}
     */
    public String getDeveloperConnection() {
        return this.developerConnection;
    }

    /**
     * The tag of current code. By default, it's set to HEAD during development.
     *
     * @return a {@code String}
     */
    public String getTag() {
        return this.tag;
    }

    /**
     * The URL to the project's browsable SCM repository, such as ViewVC or Fisheye.
     * <br><b>Default value is</b>: parent value [+ path adjustment] + (artifactId or project.directory property), or just parent value if
     * scm's {@code child.scm.url.inherit.append.path="false"}
     *
     * @return a {@code String}
     */
    public String getUrl() {
        return this.url;
    }

    /**
     * When children inherit from scm connection, append path or not? Note: While the type
     * of this field is {@code String} for technical reasons, the semantic type is actually
     * {@code Boolean}
     * <br><b>Default value is</b>: {@code true}
     * <br><b>Since</b>: Maven 3.6.1
     *
     * @return a {@code String}
     */
    public String getChildScmConnectionInheritAppendPath() {
        return this.childScmConnectionInheritAppendPath;
    }

    /**
     * When children inherit from scm developer connection, append path or not? Note: While the type
     * of this field is {@code String} for technical reasons, the semantic type is actually
     * {@code Boolean}
     * <br><b>Default value is</b>: {@code true}
     * <br><b>Since</b>: Maven 3.6.1
     *
     * @return a {@code String}
     */
    public String getChildScmDeveloperConnectionInheritAppendPath() {
        return this.childScmDeveloperConnectionInheritAppendPath;
    }

    /**
     * When children inherit from scm url, append path or not? Note: While the type
     * of this field is {@code String} for technical reasons, the semantic type is actually
     * {@code Boolean}
     * <br><b>Default value is</b>: {@code true}
     * <br><b>Since</b>: Maven 3.6.1
     *
     * @return a {@code String}
     */
    public String getChildScmUrlInheritAppendPath() {
        return this.childScmUrlInheritAppendPath;
    }

    /**
     * Gets the location of the specified field in the input source.
     */
    public InputLocation getLocation(Object key) {
        return locations != null ? locations.get(key) : null;
    }

    /**
     * Creates a new builder with this object as the basis.
     *
     * @return a {@code Builder}
     */
    @Nonnull
    public Builder with() {
        return newBuilder(this);
    }
    /**
     * Creates a new {@code Scm} instance using the specified connection.
     *
     * @param connection the new {@code String} to use
     * @return a {@code Scm} with the specified connection
     */
    @Nonnull
    public Scm withConnection(String connection) {
        return newBuilder(this, true).connection(connection).build();
    }
    /**
     * Creates a new {@code Scm} instance using the specified developerConnection.
     *
     * @param developerConnection the new {@code String} to use
     * @return a {@code Scm} with the specified developerConnection
     */
    @Nonnull
    public Scm withDeveloperConnection(String developerConnection) {
        return newBuilder(this, true).developerConnection(developerConnection).build();
    }
    /**
     * Creates a new {@code Scm} instance using the specified tag.
     *
     * @param tag the new {@code String} to use
     * @return a {@code Scm} with the specified tag
     */
    @Nonnull
    public Scm withTag(String tag) {
        return newBuilder(this, true).tag(tag).build();
    }
    /**
     * Creates a new {@code Scm} instance using the specified url.
     *
     * @param url the new {@code String} to use
     * @return a {@code Scm} with the specified url
     */
    @Nonnull
    public Scm withUrl(String url) {
        return newBuilder(this, true).url(url).build();
    }
    /**
     * Creates a new {@code Scm} instance using the specified childScmConnectionInheritAppendPath.
     *
     * @param childScmConnectionInheritAppendPath the new {@code String} to use
     * @return a {@code Scm} with the specified childScmConnectionInheritAppendPath
     */
    @Nonnull
    public Scm withChildScmConnectionInheritAppendPath(String childScmConnectionInheritAppendPath) {
        return newBuilder(this, true).childScmConnectionInheritAppendPath(childScmConnectionInheritAppendPath).build();
    }
    /**
     * Creates a new {@code Scm} instance using the specified childScmDeveloperConnectionInheritAppendPath.
     *
     * @param childScmDeveloperConnectionInheritAppendPath the new {@code String} to use
     * @return a {@code Scm} with the specified childScmDeveloperConnectionInheritAppendPath
     */
    @Nonnull
    public Scm withChildScmDeveloperConnectionInheritAppendPath(String childScmDeveloperConnectionInheritAppendPath) {
        return newBuilder(this, true).childScmDeveloperConnectionInheritAppendPath(childScmDeveloperConnectionInheritAppendPath).build();
    }
    /**
     * Creates a new {@code Scm} instance using the specified childScmUrlInheritAppendPath.
     *
     * @param childScmUrlInheritAppendPath the new {@code String} to use
     * @return a {@code Scm} with the specified childScmUrlInheritAppendPath
     */
    @Nonnull
    public Scm withChildScmUrlInheritAppendPath(String childScmUrlInheritAppendPath) {
        return newBuilder(this, true).childScmUrlInheritAppendPath(childScmUrlInheritAppendPath).build();
    }

    /**
     * Creates a new {@code Scm} instance.
     * Equivalent to {@code newInstance(true)}.
     * @see #newInstance(boolean)
     *
     * @return a new {@code Scm}
     */
    @Nonnull
    public static Scm newInstance() {
        return newInstance(true);
    }

    /**
     * Creates a new {@code Scm} instance using default values or not.
     * Equivalent to {@code newBuilder(withDefaults).build()}.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Scm}
     */
    @Nonnull
    public static Scm newInstance(boolean withDefaults) {
        return newBuilder(withDefaults).build();
    }

    /**
     * Creates a new {@code Scm} builder instance.
     * Equivalent to {@code newBuilder(true)}.
     * @see #newBuilder(boolean)
     *
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder() {
        return newBuilder(true);
    }

    /**
     * Creates a new {@code Scm} builder instance using default values or not.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    /**
     * Creates a new {@code Scm} builder instance using the specified object as a basis.
     * Equivalent to {@code newBuilder(from, false)}.
     *
     * @param from the {@code Scm} instance to use as a basis
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(Scm from) {
        return newBuilder(from, false);
    }

    /**
     * Creates a new {@code Scm} builder instance using the specified object as a basis.
     *
     * @param from the {@code Scm} instance to use as a basis
     * @param forceCopy the boolean indicating if a copy should be forced
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(Scm from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    /**
     * Builder class used to create Scm instances.
     * @see #with()
     * @see #newBuilder()
     */
    @NotThreadSafe
    public static class Builder
    {
        Scm base;
        String connection;
        String developerConnection;
        String tag;
        String url;
        String childScmConnectionInheritAppendPath;
        String childScmDeveloperConnectionInheritAppendPath;
        String childScmUrlInheritAppendPath;
        Map<Object, InputLocation> locations;

        Builder(boolean withDefaults) {
            if (withDefaults) {
                this.tag = "HEAD";
            }
        }

        Builder(Scm base, boolean forceCopy) {
            if (forceCopy) {
                this.connection = base.connection;
                this.developerConnection = base.developerConnection;
                this.tag = base.tag;
                this.url = base.url;
                this.childScmConnectionInheritAppendPath = base.childScmConnectionInheritAppendPath;
                this.childScmDeveloperConnectionInheritAppendPath = base.childScmDeveloperConnectionInheritAppendPath;
                this.childScmUrlInheritAppendPath = base.childScmUrlInheritAppendPath;
                this.locations = base.locations;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder connection(String connection) {
            this.connection = connection;
            return this;
        }

        @Nonnull
        public Builder developerConnection(String developerConnection) {
            this.developerConnection = developerConnection;
            return this;
        }

        @Nonnull
        public Builder tag(String tag) {
            this.tag = tag;
            return this;
        }

        @Nonnull
        public Builder url(String url) {
            this.url = url;
            return this;
        }

        @Nonnull
        public Builder childScmConnectionInheritAppendPath(String childScmConnectionInheritAppendPath) {
            this.childScmConnectionInheritAppendPath = childScmConnectionInheritAppendPath;
            return this;
        }

        @Nonnull
        public Builder childScmDeveloperConnectionInheritAppendPath(String childScmDeveloperConnectionInheritAppendPath) {
            this.childScmDeveloperConnectionInheritAppendPath = childScmDeveloperConnectionInheritAppendPath;
            return this;
        }

        @Nonnull
        public Builder childScmUrlInheritAppendPath(String childScmUrlInheritAppendPath) {
            this.childScmUrlInheritAppendPath = childScmUrlInheritAppendPath;
            return this;
        }


        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (!(this.locations instanceof HashMap)) {
                    this.locations = this.locations != null ? new HashMap<>(this.locations) : new HashMap<>();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Nonnull
        public Scm build() {
            if (base != null
                    && (connection == null || connection == base.connection)
                    && (developerConnection == null || developerConnection == base.developerConnection)
                    && (tag == null || tag == base.tag)
                    && (url == null || url == base.url)
                    && (childScmConnectionInheritAppendPath == null || childScmConnectionInheritAppendPath == base.childScmConnectionInheritAppendPath)
                    && (childScmDeveloperConnectionInheritAppendPath == null || childScmDeveloperConnectionInheritAppendPath == base.childScmDeveloperConnectionInheritAppendPath)
                    && (childScmUrlInheritAppendPath == null || childScmUrlInheritAppendPath == base.childScmUrlInheritAppendPath)
            ) {
                return base;
            }
            Map<Object, InputLocation> locations = null;
            InputLocation location = null;
            InputLocation connectionLocation = null;
            InputLocation developerConnectionLocation = null;
            InputLocation tagLocation = null;
            InputLocation urlLocation = null;
            InputLocation childScmConnectionInheritAppendPathLocation = null;
            InputLocation childScmDeveloperConnectionInheritAppendPathLocation = null;
            InputLocation childScmUrlInheritAppendPathLocation = null;
            if (this.locations != null) {
                locations = this.locations;
            }
            return new Scm(
                connection != null ? connection : (base != null ? base.connection : null),
                developerConnection != null ? developerConnection : (base != null ? base.developerConnection : null),
                tag != null ? tag : (base != null ? base.tag : null),
                url != null ? url : (base != null ? base.url : null),
                childScmConnectionInheritAppendPath != null ? childScmConnectionInheritAppendPath : (base != null ? base.childScmConnectionInheritAppendPath : null),
                childScmDeveloperConnectionInheritAppendPath != null ? childScmDeveloperConnectionInheritAppendPath : (base != null ? base.childScmDeveloperConnectionInheritAppendPath : null),
                childScmUrlInheritAppendPath != null ? childScmUrlInheritAppendPath : (base != null ? base.childScmUrlInheritAppendPath : null),
                locations != null ? locations : (base != null ? base.locations : null)
            );
        }
    }


            

    public boolean isChildScmConnectionInheritAppendPath()
    {
        return ( getChildScmConnectionInheritAppendPath() != null ) ? Boolean.parseBoolean( getChildScmConnectionInheritAppendPath() ) : true;
    }

    public boolean isChildScmDeveloperConnectionInheritAppendPath()
    {
        return ( getChildScmDeveloperConnectionInheritAppendPath() != null ) ? Boolean.parseBoolean( getChildScmDeveloperConnectionInheritAppendPath() ) : true;
    }

    public boolean isChildScmUrlInheritAppendPath()
    {
        return ( getChildScmUrlInheritAppendPath() != null ) ? Boolean.parseBoolean( getChildScmUrlInheritAppendPath() ) : true;
    }

            
          

            
    /**
     * @see java.lang.Object#toString()
     */
    public String toString()
    {
        return "Scm {connection=" + getConnection() + "}";
    }
            
          
}
