// =================== DO NOT EDIT THIS FILE ====================
//  Generated by Modello Velocity from model.vm
//  template, any modifications will be overwritten.
// ==============================================================
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;

/**
 * This element describes all of the classpath resources associated with a project
 * or unit tests.
 */
@Experimental
@Generated @ThreadSafe @Immutable
public class Resource
    extends FileSet
    implements Serializable, InputLocationTracker
{
    /**
     * Describe the resource target path. The path is relative to the target/classes
     * directory (i.e. {@code ${project.build.outputDirectory}}).
     * For example, if you want that resource to appear in a specific package
     * ({@code org.apache.maven.messages}), you must specify this
     * element with this value: {@code org/apache/maven/messages}.
     * This is not required if you simply put the resources in that directory
     * structure at the source, however.
     */
    final String targetPath;
    /**
     * Whether resources are filtered to replace tokens with parameterised values or not.
     * The values are taken from the {@code properties} element and from the
     * properties in the files listed in the {@code filters} element. Note: While the type
     * of this field is {@code String} for technical reasons, the semantic type is actually
     * {@code Boolean}. Default value is {@code false}.
     */
    final String filtering;
    /**
     * FOR INTERNAL USE ONLY. This is a unique identifier assigned to each
     * resource to allow Maven to merge changes to this resource that take
     * place during the execution of a plugin. This field must be managed
     * by the generated parser and formatter classes in order to allow it
     * to survive model interpolation.
     */
    final String mergeId;

    /**
      * Constructor for this class, package protected.
      * @see Builder#build()
      */
    Resource(
        Collection<String> includes,
        Collection<String> excludes,
        String directory,
        String targetPath,
        String filtering,
        String mergeId,
        Map<Object, InputLocation> locations
    ) {
        super(
            includes,
            excludes,
            directory,
            locations
        );
        this.targetPath = targetPath;
        this.filtering = filtering;
        this.mergeId = mergeId;
    }

    /**
     * Describe the resource target path. The path is relative to the target/classes
     * directory (i.e. {@code ${project.build.outputDirectory}}).
     * For example, if you want that resource to appear in a specific package
     * ({@code org.apache.maven.messages}), you must specify this
     * element with this value: {@code org/apache/maven/messages}.
     * This is not required if you simply put the resources in that directory
     * structure at the source, however.
     *
     * @return a {@code String}
     */
    public String getTargetPath() {
        return this.targetPath;
    }

    /**
     * Whether resources are filtered to replace tokens with parameterised values or not.
     * The values are taken from the {@code properties} element and from the
     * properties in the files listed in the {@code filters} element. Note: While the type
     * of this field is {@code String} for technical reasons, the semantic type is actually
     * {@code Boolean}. Default value is {@code false}.
     *
     * @return a {@code String}
     */
    public String getFiltering() {
        return this.filtering;
    }

    /**
     * FOR INTERNAL USE ONLY. This is a unique identifier assigned to each
     * resource to allow Maven to merge changes to this resource that take
     * place during the execution of a plugin. This field must be managed
     * by the generated parser and formatter classes in order to allow it
     * to survive model interpolation.
     *
     * @return a {@code String}
     */
    public String getMergeId() {
        return this.mergeId;
    }

    /**
     * Creates a new builder with this object as the basis.
     *
     * @return a {@code Builder}
     */
    @Nonnull
    public Builder with() {
        return newBuilder(this);
    }
    /**
     * Creates a new {@code Resource} instance using the specified includes.
     *
     * @param includes the new {@code Collection<String>} to use
     * @return a {@code Resource} with the specified includes
     */
    @Nonnull
    public Resource withIncludes(Collection<String> includes) {
        return newBuilder(this, true).includes(includes).build();
    }
    /**
     * Creates a new {@code Resource} instance using the specified excludes.
     *
     * @param excludes the new {@code Collection<String>} to use
     * @return a {@code Resource} with the specified excludes
     */
    @Nonnull
    public Resource withExcludes(Collection<String> excludes) {
        return newBuilder(this, true).excludes(excludes).build();
    }
    /**
     * Creates a new {@code Resource} instance using the specified directory.
     *
     * @param directory the new {@code String} to use
     * @return a {@code Resource} with the specified directory
     */
    @Nonnull
    public Resource withDirectory(String directory) {
        return newBuilder(this, true).directory(directory).build();
    }
    /**
     * Creates a new {@code Resource} instance using the specified targetPath.
     *
     * @param targetPath the new {@code String} to use
     * @return a {@code Resource} with the specified targetPath
     */
    @Nonnull
    public Resource withTargetPath(String targetPath) {
        return newBuilder(this, true).targetPath(targetPath).build();
    }
    /**
     * Creates a new {@code Resource} instance using the specified filtering.
     *
     * @param filtering the new {@code String} to use
     * @return a {@code Resource} with the specified filtering
     */
    @Nonnull
    public Resource withFiltering(String filtering) {
        return newBuilder(this, true).filtering(filtering).build();
    }
    /**
     * Creates a new {@code Resource} instance using the specified mergeId.
     *
     * @param mergeId the new {@code String} to use
     * @return a {@code Resource} with the specified mergeId
     */
    @Nonnull
    public Resource withMergeId(String mergeId) {
        return newBuilder(this, true).mergeId(mergeId).build();
    }

    /**
     * Creates a new {@code Resource} instance.
     * Equivalent to {@code newInstance(true)}.
     * @see #newInstance(boolean)
     *
     * @return a new {@code Resource}
     */
    @Nonnull
    public static Resource newInstance() {
        return newInstance(true);
    }

    /**
     * Creates a new {@code Resource} instance using default values or not.
     * Equivalent to {@code newBuilder(withDefaults).build()}.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Resource}
     */
    @Nonnull
    public static Resource newInstance(boolean withDefaults) {
        return newBuilder(withDefaults).build();
    }

    /**
     * Creates a new {@code Resource} builder instance.
     * Equivalent to {@code newBuilder(true)}.
     * @see #newBuilder(boolean)
     *
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder() {
        return newBuilder(true);
    }

    /**
     * Creates a new {@code Resource} builder instance using default values or not.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    /**
     * Creates a new {@code Resource} builder instance using the specified object as a basis.
     * Equivalent to {@code newBuilder(from, false)}.
     *
     * @param from the {@code Resource} instance to use as a basis
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(Resource from) {
        return newBuilder(from, false);
    }

    /**
     * Creates a new {@code Resource} builder instance using the specified object as a basis.
     *
     * @param from the {@code Resource} instance to use as a basis
     * @param forceCopy the boolean indicating if a copy should be forced
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(Resource from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    /**
     * Builder class used to create Resource instances.
     * @see #with()
     * @see #newBuilder()
     */
    @NotThreadSafe
    public static class Builder
        extends FileSet.Builder
    {
        Resource base;
        String targetPath;
        String filtering;
        String mergeId;

        Builder(boolean withDefaults) {
            super(withDefaults);
            if (withDefaults) {
            }
        }

        Builder(Resource base, boolean forceCopy) {
            super(base, forceCopy);
            if (forceCopy) {
                this.targetPath = base.targetPath;
                this.filtering = base.filtering;
                this.mergeId = base.mergeId;
                this.locations = base.locations;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder includes(Collection<String> includes) {
            this.includes = includes;
            return this;
        }

        @Nonnull
        public Builder excludes(Collection<String> excludes) {
            this.excludes = excludes;
            return this;
        }

        @Nonnull
        public Builder directory(String directory) {
            this.directory = directory;
            return this;
        }

        @Nonnull
        public Builder targetPath(String targetPath) {
            this.targetPath = targetPath;
            return this;
        }

        @Nonnull
        public Builder filtering(String filtering) {
            this.filtering = filtering;
            return this;
        }

        @Nonnull
        public Builder mergeId(String mergeId) {
            this.mergeId = mergeId;
            return this;
        }


        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (!(this.locations instanceof HashMap)) {
                    this.locations = this.locations != null ? new HashMap<>(this.locations) : new HashMap<>();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Nonnull
        public Resource build() {
            if (base != null
                    && (includes == null || includes == base.includes)
                    && (excludes == null || excludes == base.excludes)
                    && (directory == null || directory == base.directory)
                    && (targetPath == null || targetPath == base.targetPath)
                    && (filtering == null || filtering == base.filtering)
                    && (mergeId == null || mergeId == base.mergeId)
            ) {
                return base;
            }
            Map<Object, InputLocation> locations = null;
            InputLocation location = null;
            InputLocation includesLocation = null;
            InputLocation excludesLocation = null;
            InputLocation directoryLocation = null;
            InputLocation targetPathLocation = null;
            InputLocation filteringLocation = null;
            InputLocation mergeIdLocation = null;
            if (this.locations != null) {
                locations = this.locations;
            }
            return new Resource(
                includes != null ? includes : (base != null ? base.includes : null),
                excludes != null ? excludes : (base != null ? base.excludes : null),
                directory != null ? directory : (base != null ? base.directory : null),
                targetPath != null ? targetPath : (base != null ? base.targetPath : null),
                filtering != null ? filtering : (base != null ? base.filtering : null),
                mergeId != null ? mergeId : (base != null ? base.mergeId : null),
                locations != null ? locations : (base != null ? base.locations : null)
            );
        }
    }


            
    public boolean isFiltering()
    {
        return ( getFiltering() != null ) ? Boolean.parseBoolean( getFiltering() ) : false;
    }
            
          

            
    /**
     * @see java.lang.Object#toString()
     */
    public String toString()
    {
        return "Resource {targetPath: " + getTargetPath() + ", filtering: " + isFiltering() + ", " + super.toString() + "}";
    }
            
          
}
