// =================== DO NOT EDIT THIS FILE ====================
//  Generated by Modello Velocity from model.vm
//  template, any modifications will be overwritten.
// ==============================================================
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;

/**
 * The {@code <parent>} element contains information required to locate the parent project from which
 * this project will inherit from.
 * <strong>Note:</strong> The children of this element are not interpolated and must be given as literal values.
 */
@Experimental
@Generated @ThreadSafe @Immutable
public class Parent
    implements Serializable, InputLocationTracker
{
    /**
     * The group id of the parent project to inherit from.
     */
    final String groupId;
    /**
     * The artifact id of the parent project to inherit from.
     */
    final String artifactId;
    /**
     * The version of the parent project to inherit.
     */
    final String version;
    /**
     * The relative path of the parent {@code pom.xml} file within the check out.
     * If not specified, it defaults to {@code ../pom.xml}.
     * Maven looks for the parent POM first in this location on
     * the filesystem, then the local repository, and lastly in the remote repo.
     * {@code relativePath} allows you to select a different location,
     * for example when your structure is flat, or deeper without an intermediate parent POM.
     * However, the group ID, artifact ID and version are still required,
     * and must match the file in the location given or it will revert to the repository for the POM.
     * This feature is only for enhancing the development in a local checkout of that project.
     * Set the value to an empty string in case you want to disable the feature and always resolve
     * the parent POM from the repositories.
     */
    final String relativePath;
    /** Locations */
    final Map<Object, InputLocation> locations;

    /**
      * Constructor for this class, package protected.
      * @see Builder#build()
      */
    Parent(
        String groupId,
        String artifactId,
        String version,
        String relativePath,
        Map<Object, InputLocation> locations
    ) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.relativePath = relativePath;
        this.locations = ImmutableCollections.copy(locations);
    }

    /**
     * The group id of the parent project to inherit from.
     *
     * @return a {@code String}
     */
    public String getGroupId() {
        return this.groupId;
    }

    /**
     * The artifact id of the parent project to inherit from.
     *
     * @return a {@code String}
     */
    public String getArtifactId() {
        return this.artifactId;
    }

    /**
     * The version of the parent project to inherit.
     *
     * @return a {@code String}
     */
    public String getVersion() {
        return this.version;
    }

    /**
     * The relative path of the parent {@code pom.xml} file within the check out.
     * If not specified, it defaults to {@code ../pom.xml}.
     * Maven looks for the parent POM first in this location on
     * the filesystem, then the local repository, and lastly in the remote repo.
     * {@code relativePath} allows you to select a different location,
     * for example when your structure is flat, or deeper without an intermediate parent POM.
     * However, the group ID, artifact ID and version are still required,
     * and must match the file in the location given or it will revert to the repository for the POM.
     * This feature is only for enhancing the development in a local checkout of that project.
     * Set the value to an empty string in case you want to disable the feature and always resolve
     * the parent POM from the repositories.
     *
     * @return a {@code String}
     */
    public String getRelativePath() {
        return this.relativePath;
    }

    /**
     * Gets the location of the specified field in the input source.
     */
    public InputLocation getLocation(Object key) {
        return locations != null ? locations.get(key) : null;
    }

    /**
     * Creates a new builder with this object as the basis.
     *
     * @return a {@code Builder}
     */
    @Nonnull
    public Builder with() {
        return newBuilder(this);
    }
    /**
     * Creates a new {@code Parent} instance using the specified groupId.
     *
     * @param groupId the new {@code String} to use
     * @return a {@code Parent} with the specified groupId
     */
    @Nonnull
    public Parent withGroupId(String groupId) {
        return newBuilder(this, true).groupId(groupId).build();
    }
    /**
     * Creates a new {@code Parent} instance using the specified artifactId.
     *
     * @param artifactId the new {@code String} to use
     * @return a {@code Parent} with the specified artifactId
     */
    @Nonnull
    public Parent withArtifactId(String artifactId) {
        return newBuilder(this, true).artifactId(artifactId).build();
    }
    /**
     * Creates a new {@code Parent} instance using the specified version.
     *
     * @param version the new {@code String} to use
     * @return a {@code Parent} with the specified version
     */
    @Nonnull
    public Parent withVersion(String version) {
        return newBuilder(this, true).version(version).build();
    }
    /**
     * Creates a new {@code Parent} instance using the specified relativePath.
     *
     * @param relativePath the new {@code String} to use
     * @return a {@code Parent} with the specified relativePath
     */
    @Nonnull
    public Parent withRelativePath(String relativePath) {
        return newBuilder(this, true).relativePath(relativePath).build();
    }

    /**
     * Creates a new {@code Parent} instance.
     * Equivalent to {@code newInstance(true)}.
     * @see #newInstance(boolean)
     *
     * @return a new {@code Parent}
     */
    @Nonnull
    public static Parent newInstance() {
        return newInstance(true);
    }

    /**
     * Creates a new {@code Parent} instance using default values or not.
     * Equivalent to {@code newBuilder(withDefaults).build()}.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Parent}
     */
    @Nonnull
    public static Parent newInstance(boolean withDefaults) {
        return newBuilder(withDefaults).build();
    }

    /**
     * Creates a new {@code Parent} builder instance.
     * Equivalent to {@code newBuilder(true)}.
     * @see #newBuilder(boolean)
     *
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder() {
        return newBuilder(true);
    }

    /**
     * Creates a new {@code Parent} builder instance using default values or not.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    /**
     * Creates a new {@code Parent} builder instance using the specified object as a basis.
     * Equivalent to {@code newBuilder(from, false)}.
     *
     * @param from the {@code Parent} instance to use as a basis
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(Parent from) {
        return newBuilder(from, false);
    }

    /**
     * Creates a new {@code Parent} builder instance using the specified object as a basis.
     *
     * @param from the {@code Parent} instance to use as a basis
     * @param forceCopy the boolean indicating if a copy should be forced
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(Parent from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    /**
     * Builder class used to create Parent instances.
     * @see #with()
     * @see #newBuilder()
     */
    @NotThreadSafe
    public static class Builder
    {
        Parent base;
        String groupId;
        String artifactId;
        String version;
        String relativePath;
        Map<Object, InputLocation> locations;

        Builder(boolean withDefaults) {
            if (withDefaults) {
                this.relativePath = "../pom.xml";
            }
        }

        Builder(Parent base, boolean forceCopy) {
            if (forceCopy) {
                this.groupId = base.groupId;
                this.artifactId = base.artifactId;
                this.version = base.version;
                this.relativePath = base.relativePath;
                this.locations = base.locations;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        @Nonnull
        public Builder artifactId(String artifactId) {
            this.artifactId = artifactId;
            return this;
        }

        @Nonnull
        public Builder version(String version) {
            this.version = version;
            return this;
        }

        @Nonnull
        public Builder relativePath(String relativePath) {
            this.relativePath = relativePath;
            return this;
        }


        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (!(this.locations instanceof HashMap)) {
                    this.locations = this.locations != null ? new HashMap<>(this.locations) : new HashMap<>();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Nonnull
        public Parent build() {
            if (base != null
                    && (groupId == null || groupId == base.groupId)
                    && (artifactId == null || artifactId == base.artifactId)
                    && (version == null || version == base.version)
                    && (relativePath == null || relativePath == base.relativePath)
            ) {
                return base;
            }
            Map<Object, InputLocation> locations = null;
            InputLocation location = null;
            InputLocation groupIdLocation = null;
            InputLocation artifactIdLocation = null;
            InputLocation versionLocation = null;
            InputLocation relativePathLocation = null;
            if (this.locations != null) {
                locations = this.locations;
            }
            return new Parent(
                groupId != null ? groupId : (base != null ? base.groupId : null),
                artifactId != null ? artifactId : (base != null ? base.artifactId : null),
                version != null ? version : (base != null ? base.version : null),
                relativePath != null ? relativePath : (base != null ? base.relativePath : null),
                locations != null ? locations : (base != null ? base.locations : null)
            );
        }
    }


            
    /**
     * @return the id as {@code groupId:artifactId:version}
     */
    public String getId()
    {
        StringBuilder id = new StringBuilder( 64 );

        id.append( getGroupId() );
        id.append( ":" );
        id.append( getArtifactId() );
        id.append( ":" );
        id.append( "pom" );
        id.append( ":" );
        id.append( getVersion() );

        return id.toString();
    }

    @Override
    public String toString()
    {
        return getId();
    }
            
          
}
