// =================== DO NOT EDIT THIS FILE ====================
//  Generated by Modello Velocity from model.vm
//  template, any modifications will be overwritten.
// ==============================================================
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;

/**
 * This element describes all of the mailing lists associated with a project. The
 * auto-generated site references this information.
 */
@Experimental
@Generated @ThreadSafe @Immutable
public class MailingList
    implements Serializable, InputLocationTracker
{
    /**
     * The name of the mailing list.
     */
    final String name;
    /**
     * The email address or link that can be used to subscribe to
     * the mailing list.  If this is an email address, a
     * {@code mailto:} link will automatically be created
     * when the documentation is created.
     */
    final String subscribe;
    /**
     * The email address or link that can be used to unsubscribe to
     * the mailing list.  If this is an email address, a
     * {@code mailto:} link will automatically be created
     * when the documentation is created.
     */
    final String unsubscribe;
    /**
     * The email address or link that can be used to post to
     * the mailing list.  If this is an email address, a
     * {@code mailto:} link will automatically be created
     * when the documentation is created.
     */
    final String post;
    /**
     * The link to a URL where you can browse the mailing list archive.
     */
    final String archive;
    /**
     * The link to alternate URLs where you can browse the list archive.
     */
    final List<String> otherArchives;
    /** Locations */
    final Map<Object, InputLocation> locations;

    /**
      * Constructor for this class, package protected.
      * @see Builder#build()
      */
    MailingList(
        String name,
        String subscribe,
        String unsubscribe,
        String post,
        String archive,
        Collection<String> otherArchives,
        Map<Object, InputLocation> locations
    ) {
        this.name = name;
        this.subscribe = subscribe;
        this.unsubscribe = unsubscribe;
        this.post = post;
        this.archive = archive;
        this.otherArchives = ImmutableCollections.copy(otherArchives);
        this.locations = ImmutableCollections.copy(locations);
    }

    /**
     * The name of the mailing list.
     *
     * @return a {@code String}
     */
    public String getName() {
        return this.name;
    }

    /**
     * The email address or link that can be used to subscribe to
     * the mailing list.  If this is an email address, a
     * {@code mailto:} link will automatically be created
     * when the documentation is created.
     *
     * @return a {@code String}
     */
    public String getSubscribe() {
        return this.subscribe;
    }

    /**
     * The email address or link that can be used to unsubscribe to
     * the mailing list.  If this is an email address, a
     * {@code mailto:} link will automatically be created
     * when the documentation is created.
     *
     * @return a {@code String}
     */
    public String getUnsubscribe() {
        return this.unsubscribe;
    }

    /**
     * The email address or link that can be used to post to
     * the mailing list.  If this is an email address, a
     * {@code mailto:} link will automatically be created
     * when the documentation is created.
     *
     * @return a {@code String}
     */
    public String getPost() {
        return this.post;
    }

    /**
     * The link to a URL where you can browse the mailing list archive.
     *
     * @return a {@code String}
     */
    public String getArchive() {
        return this.archive;
    }

    /**
     * The link to alternate URLs where you can browse the list archive.
     *
     * @return a {@code List<String>}
     */
    @Nonnull
    public List<String> getOtherArchives() {
        return this.otherArchives;
    }

    /**
     * Gets the location of the specified field in the input source.
     */
    public InputLocation getLocation(Object key) {
        return locations != null ? locations.get(key) : null;
    }

    /**
     * Creates a new builder with this object as the basis.
     *
     * @return a {@code Builder}
     */
    @Nonnull
    public Builder with() {
        return newBuilder(this);
    }
    /**
     * Creates a new {@code MailingList} instance using the specified name.
     *
     * @param name the new {@code String} to use
     * @return a {@code MailingList} with the specified name
     */
    @Nonnull
    public MailingList withName(String name) {
        return newBuilder(this, true).name(name).build();
    }
    /**
     * Creates a new {@code MailingList} instance using the specified subscribe.
     *
     * @param subscribe the new {@code String} to use
     * @return a {@code MailingList} with the specified subscribe
     */
    @Nonnull
    public MailingList withSubscribe(String subscribe) {
        return newBuilder(this, true).subscribe(subscribe).build();
    }
    /**
     * Creates a new {@code MailingList} instance using the specified unsubscribe.
     *
     * @param unsubscribe the new {@code String} to use
     * @return a {@code MailingList} with the specified unsubscribe
     */
    @Nonnull
    public MailingList withUnsubscribe(String unsubscribe) {
        return newBuilder(this, true).unsubscribe(unsubscribe).build();
    }
    /**
     * Creates a new {@code MailingList} instance using the specified post.
     *
     * @param post the new {@code String} to use
     * @return a {@code MailingList} with the specified post
     */
    @Nonnull
    public MailingList withPost(String post) {
        return newBuilder(this, true).post(post).build();
    }
    /**
     * Creates a new {@code MailingList} instance using the specified archive.
     *
     * @param archive the new {@code String} to use
     * @return a {@code MailingList} with the specified archive
     */
    @Nonnull
    public MailingList withArchive(String archive) {
        return newBuilder(this, true).archive(archive).build();
    }
    /**
     * Creates a new {@code MailingList} instance using the specified otherArchives.
     *
     * @param otherArchives the new {@code Collection<String>} to use
     * @return a {@code MailingList} with the specified otherArchives
     */
    @Nonnull
    public MailingList withOtherArchives(Collection<String> otherArchives) {
        return newBuilder(this, true).otherArchives(otherArchives).build();
    }

    /**
     * Creates a new {@code MailingList} instance.
     * Equivalent to {@code newInstance(true)}.
     * @see #newInstance(boolean)
     *
     * @return a new {@code MailingList}
     */
    @Nonnull
    public static MailingList newInstance() {
        return newInstance(true);
    }

    /**
     * Creates a new {@code MailingList} instance using default values or not.
     * Equivalent to {@code newBuilder(withDefaults).build()}.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code MailingList}
     */
    @Nonnull
    public static MailingList newInstance(boolean withDefaults) {
        return newBuilder(withDefaults).build();
    }

    /**
     * Creates a new {@code MailingList} builder instance.
     * Equivalent to {@code newBuilder(true)}.
     * @see #newBuilder(boolean)
     *
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder() {
        return newBuilder(true);
    }

    /**
     * Creates a new {@code MailingList} builder instance using default values or not.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    /**
     * Creates a new {@code MailingList} builder instance using the specified object as a basis.
     * Equivalent to {@code newBuilder(from, false)}.
     *
     * @param from the {@code MailingList} instance to use as a basis
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(MailingList from) {
        return newBuilder(from, false);
    }

    /**
     * Creates a new {@code MailingList} builder instance using the specified object as a basis.
     *
     * @param from the {@code MailingList} instance to use as a basis
     * @param forceCopy the boolean indicating if a copy should be forced
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(MailingList from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    /**
     * Builder class used to create MailingList instances.
     * @see #with()
     * @see #newBuilder()
     */
    @NotThreadSafe
    public static class Builder
    {
        MailingList base;
        String name;
        String subscribe;
        String unsubscribe;
        String post;
        String archive;
        Collection<String> otherArchives;
        Map<Object, InputLocation> locations;

        Builder(boolean withDefaults) {
            if (withDefaults) {
            }
        }

        Builder(MailingList base, boolean forceCopy) {
            if (forceCopy) {
                this.name = base.name;
                this.subscribe = base.subscribe;
                this.unsubscribe = base.unsubscribe;
                this.post = base.post;
                this.archive = base.archive;
                this.otherArchives = base.otherArchives;
                this.locations = base.locations;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder name(String name) {
            this.name = name;
            return this;
        }

        @Nonnull
        public Builder subscribe(String subscribe) {
            this.subscribe = subscribe;
            return this;
        }

        @Nonnull
        public Builder unsubscribe(String unsubscribe) {
            this.unsubscribe = unsubscribe;
            return this;
        }

        @Nonnull
        public Builder post(String post) {
            this.post = post;
            return this;
        }

        @Nonnull
        public Builder archive(String archive) {
            this.archive = archive;
            return this;
        }

        @Nonnull
        public Builder otherArchives(Collection<String> otherArchives) {
            this.otherArchives = otherArchives;
            return this;
        }


        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (!(this.locations instanceof HashMap)) {
                    this.locations = this.locations != null ? new HashMap<>(this.locations) : new HashMap<>();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Nonnull
        public MailingList build() {
            if (base != null
                    && (name == null || name == base.name)
                    && (subscribe == null || subscribe == base.subscribe)
                    && (unsubscribe == null || unsubscribe == base.unsubscribe)
                    && (post == null || post == base.post)
                    && (archive == null || archive == base.archive)
                    && (otherArchives == null || otherArchives == base.otherArchives)
            ) {
                return base;
            }
            Map<Object, InputLocation> locations = null;
            InputLocation location = null;
            InputLocation nameLocation = null;
            InputLocation subscribeLocation = null;
            InputLocation unsubscribeLocation = null;
            InputLocation postLocation = null;
            InputLocation archiveLocation = null;
            InputLocation otherArchivesLocation = null;
            if (this.locations != null) {
                locations = this.locations;
            }
            return new MailingList(
                name != null ? name : (base != null ? base.name : null),
                subscribe != null ? subscribe : (base != null ? base.subscribe : null),
                unsubscribe != null ? unsubscribe : (base != null ? base.unsubscribe : null),
                post != null ? post : (base != null ? base.post : null),
                archive != null ? archive : (base != null ? base.archive : null),
                otherArchives != null ? otherArchives : (base != null ? base.otherArchives : null),
                locations != null ? locations : (base != null ? base.locations : null)
            );
        }
    }


            
    /**
     * @see java.lang.Object#toString()
     */
    public String toString()
    {
        return "MailingList {name=" + getName() + ", archive=" + getArchive() + "}";
    }
            
          
}
