// =================== DO NOT EDIT THIS FILE ====================
//  Generated by Modello Velocity from model.vm
//  template, any modifications will be overwritten.
// ==============================================================
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;

/**
 * Describes the licenses for this project. This is used to generate the license
 * page of the project's web site, as well as being taken into consideration in other reporting
 * and validation. The licenses listed for the project are that of the project itself, and not
 * of dependencies.
 */
@Experimental
@Generated @ThreadSafe @Immutable
public class License
    implements Serializable, InputLocationTracker
{
    /**
     * The full legal name of the license.
     */
    final String name;
    /**
     * The official url for the license text.
     */
    final String url;
    /**
     * The primary method by which this project may be distributed.
     * <dl>
     * <dt>repo</dt>
     * <dd>may be downloaded from the Maven repository</dd>
     * <dt>manual</dt>
     * <dd>user must manually download and install the dependency.</dd>
     * </dl>
     */
    final String distribution;
    /**
     * Addendum information pertaining to this license.
     */
    final String comments;
    /** Locations */
    final Map<Object, InputLocation> locations;

    /**
      * Constructor for this class, package protected.
      * @see Builder#build()
      */
    License(
        String name,
        String url,
        String distribution,
        String comments,
        Map<Object, InputLocation> locations
    ) {
        this.name = name;
        this.url = url;
        this.distribution = distribution;
        this.comments = comments;
        this.locations = ImmutableCollections.copy(locations);
    }

    /**
     * The full legal name of the license.
     *
     * @return a {@code String}
     */
    public String getName() {
        return this.name;
    }

    /**
     * The official url for the license text.
     *
     * @return a {@code String}
     */
    public String getUrl() {
        return this.url;
    }

    /**
     * The primary method by which this project may be distributed.
     * <dl>
     * <dt>repo</dt>
     * <dd>may be downloaded from the Maven repository</dd>
     * <dt>manual</dt>
     * <dd>user must manually download and install the dependency.</dd>
     * </dl>
     *
     * @return a {@code String}
     */
    public String getDistribution() {
        return this.distribution;
    }

    /**
     * Addendum information pertaining to this license.
     *
     * @return a {@code String}
     */
    public String getComments() {
        return this.comments;
    }

    /**
     * Gets the location of the specified field in the input source.
     */
    public InputLocation getLocation(Object key) {
        return locations != null ? locations.get(key) : null;
    }

    /**
     * Creates a new builder with this object as the basis.
     *
     * @return a {@code Builder}
     */
    @Nonnull
    public Builder with() {
        return newBuilder(this);
    }
    /**
     * Creates a new {@code License} instance using the specified name.
     *
     * @param name the new {@code String} to use
     * @return a {@code License} with the specified name
     */
    @Nonnull
    public License withName(String name) {
        return newBuilder(this, true).name(name).build();
    }
    /**
     * Creates a new {@code License} instance using the specified url.
     *
     * @param url the new {@code String} to use
     * @return a {@code License} with the specified url
     */
    @Nonnull
    public License withUrl(String url) {
        return newBuilder(this, true).url(url).build();
    }
    /**
     * Creates a new {@code License} instance using the specified distribution.
     *
     * @param distribution the new {@code String} to use
     * @return a {@code License} with the specified distribution
     */
    @Nonnull
    public License withDistribution(String distribution) {
        return newBuilder(this, true).distribution(distribution).build();
    }
    /**
     * Creates a new {@code License} instance using the specified comments.
     *
     * @param comments the new {@code String} to use
     * @return a {@code License} with the specified comments
     */
    @Nonnull
    public License withComments(String comments) {
        return newBuilder(this, true).comments(comments).build();
    }

    /**
     * Creates a new {@code License} instance.
     * Equivalent to {@code newInstance(true)}.
     * @see #newInstance(boolean)
     *
     * @return a new {@code License}
     */
    @Nonnull
    public static License newInstance() {
        return newInstance(true);
    }

    /**
     * Creates a new {@code License} instance using default values or not.
     * Equivalent to {@code newBuilder(withDefaults).build()}.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code License}
     */
    @Nonnull
    public static License newInstance(boolean withDefaults) {
        return newBuilder(withDefaults).build();
    }

    /**
     * Creates a new {@code License} builder instance.
     * Equivalent to {@code newBuilder(true)}.
     * @see #newBuilder(boolean)
     *
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder() {
        return newBuilder(true);
    }

    /**
     * Creates a new {@code License} builder instance using default values or not.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    /**
     * Creates a new {@code License} builder instance using the specified object as a basis.
     * Equivalent to {@code newBuilder(from, false)}.
     *
     * @param from the {@code License} instance to use as a basis
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(License from) {
        return newBuilder(from, false);
    }

    /**
     * Creates a new {@code License} builder instance using the specified object as a basis.
     *
     * @param from the {@code License} instance to use as a basis
     * @param forceCopy the boolean indicating if a copy should be forced
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(License from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    /**
     * Builder class used to create License instances.
     * @see #with()
     * @see #newBuilder()
     */
    @NotThreadSafe
    public static class Builder
    {
        License base;
        String name;
        String url;
        String distribution;
        String comments;
        Map<Object, InputLocation> locations;

        Builder(boolean withDefaults) {
            if (withDefaults) {
            }
        }

        Builder(License base, boolean forceCopy) {
            if (forceCopy) {
                this.name = base.name;
                this.url = base.url;
                this.distribution = base.distribution;
                this.comments = base.comments;
                this.locations = base.locations;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder name(String name) {
            this.name = name;
            return this;
        }

        @Nonnull
        public Builder url(String url) {
            this.url = url;
            return this;
        }

        @Nonnull
        public Builder distribution(String distribution) {
            this.distribution = distribution;
            return this;
        }

        @Nonnull
        public Builder comments(String comments) {
            this.comments = comments;
            return this;
        }


        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (!(this.locations instanceof HashMap)) {
                    this.locations = this.locations != null ? new HashMap<>(this.locations) : new HashMap<>();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Nonnull
        public License build() {
            if (base != null
                    && (name == null || name == base.name)
                    && (url == null || url == base.url)
                    && (distribution == null || distribution == base.distribution)
                    && (comments == null || comments == base.comments)
            ) {
                return base;
            }
            Map<Object, InputLocation> locations = null;
            InputLocation location = null;
            InputLocation nameLocation = null;
            InputLocation urlLocation = null;
            InputLocation distributionLocation = null;
            InputLocation commentsLocation = null;
            if (this.locations != null) {
                locations = this.locations;
            }
            return new License(
                name != null ? name : (base != null ? base.name : null),
                url != null ? url : (base != null ? base.url : null),
                distribution != null ? distribution : (base != null ? base.distribution : null),
                comments != null ? comments : (base != null ? base.comments : null),
                locations != null ? locations : (base != null ? base.locations : null)
            );
        }
    }


            
    /**
     * @see java.lang.Object#toString()
     */
    public String toString()
    {
        return "License {name=" + getName() + ", url=" + getUrl() + "}";
    }
            
          
}
