// =================== DO NOT EDIT THIS FILE ====================
//  Generated by Modello Velocity from model.vm
//  template, any modifications will be overwritten.
// ==============================================================
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;

/**
 * The {@code <exclusion>} element contains informations required to exclude
 * an artifact to the project.
 */
@Experimental
@Generated @ThreadSafe @Immutable
public class Exclusion
    implements Serializable, InputLocationTracker
{
    /**
     * The group ID of the project to exclude.
     */
    final String groupId;
    /**
     * The artifact ID of the project to exclude.
     */
    final String artifactId;
    /** Locations */
    final Map<Object, InputLocation> locations;

    /**
      * Constructor for this class, package protected.
      * @see Builder#build()
      */
    Exclusion(
        String groupId,
        String artifactId,
        Map<Object, InputLocation> locations
    ) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.locations = ImmutableCollections.copy(locations);
    }

    /**
     * The group ID of the project to exclude.
     *
     * @return a {@code String}
     */
    public String getGroupId() {
        return this.groupId;
    }

    /**
     * The artifact ID of the project to exclude.
     *
     * @return a {@code String}
     */
    public String getArtifactId() {
        return this.artifactId;
    }

    /**
     * Gets the location of the specified field in the input source.
     */
    public InputLocation getLocation(Object key) {
        return locations != null ? locations.get(key) : null;
    }

    /**
     * Creates a new builder with this object as the basis.
     *
     * @return a {@code Builder}
     */
    @Nonnull
    public Builder with() {
        return newBuilder(this);
    }
    /**
     * Creates a new {@code Exclusion} instance using the specified groupId.
     *
     * @param groupId the new {@code String} to use
     * @return a {@code Exclusion} with the specified groupId
     */
    @Nonnull
    public Exclusion withGroupId(String groupId) {
        return newBuilder(this, true).groupId(groupId).build();
    }
    /**
     * Creates a new {@code Exclusion} instance using the specified artifactId.
     *
     * @param artifactId the new {@code String} to use
     * @return a {@code Exclusion} with the specified artifactId
     */
    @Nonnull
    public Exclusion withArtifactId(String artifactId) {
        return newBuilder(this, true).artifactId(artifactId).build();
    }

    /**
     * Creates a new {@code Exclusion} instance.
     * Equivalent to {@code newInstance(true)}.
     * @see #newInstance(boolean)
     *
     * @return a new {@code Exclusion}
     */
    @Nonnull
    public static Exclusion newInstance() {
        return newInstance(true);
    }

    /**
     * Creates a new {@code Exclusion} instance using default values or not.
     * Equivalent to {@code newBuilder(withDefaults).build()}.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Exclusion}
     */
    @Nonnull
    public static Exclusion newInstance(boolean withDefaults) {
        return newBuilder(withDefaults).build();
    }

    /**
     * Creates a new {@code Exclusion} builder instance.
     * Equivalent to {@code newBuilder(true)}.
     * @see #newBuilder(boolean)
     *
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder() {
        return newBuilder(true);
    }

    /**
     * Creates a new {@code Exclusion} builder instance using default values or not.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    /**
     * Creates a new {@code Exclusion} builder instance using the specified object as a basis.
     * Equivalent to {@code newBuilder(from, false)}.
     *
     * @param from the {@code Exclusion} instance to use as a basis
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(Exclusion from) {
        return newBuilder(from, false);
    }

    /**
     * Creates a new {@code Exclusion} builder instance using the specified object as a basis.
     *
     * @param from the {@code Exclusion} instance to use as a basis
     * @param forceCopy the boolean indicating if a copy should be forced
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(Exclusion from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    /**
     * Builder class used to create Exclusion instances.
     * @see #with()
     * @see #newBuilder()
     */
    @NotThreadSafe
    public static class Builder
    {
        Exclusion base;
        String groupId;
        String artifactId;
        Map<Object, InputLocation> locations;

        Builder(boolean withDefaults) {
            if (withDefaults) {
            }
        }

        Builder(Exclusion base, boolean forceCopy) {
            if (forceCopy) {
                this.groupId = base.groupId;
                this.artifactId = base.artifactId;
                this.locations = base.locations;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        @Nonnull
        public Builder artifactId(String artifactId) {
            this.artifactId = artifactId;
            return this;
        }


        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (!(this.locations instanceof HashMap)) {
                    this.locations = this.locations != null ? new HashMap<>(this.locations) : new HashMap<>();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Nonnull
        public Exclusion build() {
            if (base != null
                    && (groupId == null || groupId == base.groupId)
                    && (artifactId == null || artifactId == base.artifactId)
            ) {
                return base;
            }
            Map<Object, InputLocation> locations = null;
            InputLocation location = null;
            InputLocation groupIdLocation = null;
            InputLocation artifactIdLocation = null;
            if (this.locations != null) {
                locations = this.locations;
            }
            return new Exclusion(
                groupId != null ? groupId : (base != null ? base.groupId : null),
                artifactId != null ? artifactId : (base != null ? base.artifactId : null),
                locations != null ? locations : (base != null ? base.locations : null)
            );
        }
    }

}
